/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezbanners;

import com.skyblockexp.ezbanners.command.LinkCommand;
import com.skyblockexp.ezbanners.config.EzBannersConfig;
import com.skyblockexp.ezbanners.metrics.ServerDataCollector;
import com.skyblockexp.ezbanners.sync.SyncService;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.command.PluginCommand;
import org.bukkit.plugin.java.JavaPlugin;

public class EzBannersPlugin
extends JavaPlugin {
    private EzBannersConfig config;
    private ServerDataCollector dataCollector;
    private SyncService syncService;
    private long serverStartMillis;

    public void onEnable() {
        this.saveDefaultConfig();
        this.serverStartMillis = System.currentTimeMillis();
        this.ensureServerUuid();
        this.config = new EzBannersConfig(this);
        this.dataCollector = new ServerDataCollector(this, this.config, this.serverStartMillis);
        this.syncService = new SyncService(this, this.config, this.dataCollector);
        PluginCommand command = this.getCommand("ezbanners");
        if (command != null) {
            command.setExecutor((sender, cmd, label, args) -> {
                if (args.length > 0 && args[0].equalsIgnoreCase("reload")) {
                    if (!sender.hasPermission("ezbanners.reload")) {
                        sender.sendMessage("\u00a7cYou do not have permission to reload EzBanners.");
                        return true;
                    }
                    this.reloadEzBannersConfig();
                    sender.sendMessage("\u00a7aEzBanners configuration reloaded.");
                    return true;
                }
                return new LinkCommand(this).onCommand(sender, cmd, label, args);
            });
        } else {
            this.getLogger().warning("[EzBanners] Command not registered. Check plugin.yml.");
        }
        this.getLogger().info("[EzBanners] Starting async sync service.");
        this.syncService.start();
    }

    public void onDisable() {
        if (this.syncService != null) {
            this.syncService.stop();
        }
        this.getLogger().info("[EzBanners] Disabled cleanly.");
    }

    public EzBannersConfig getEzBannersConfig() {
        return this.config;
    }

    public void reloadEzBannersConfig() {
        this.reloadConfig();
        this.ensureServerUuid();
        this.config = new EzBannersConfig(this);
        if (this.dataCollector != null) {
            this.dataCollector.refreshConfig(this.config, this.serverStartMillis);
        }
        if (this.syncService != null) {
            this.syncService.reload(this.config, this.dataCollector);
        }
    }

    private void ensureServerUuid() {
        String uuid = this.getConfig().getString("server.uuid", "");
        if (uuid == null || uuid.trim().isEmpty()) {
            String generated = UUID.randomUUID().toString();
            this.getConfig().set("server.uuid", (Object)generated);
            this.saveConfig();
            this.getLogger().info("[EzBanners] Generated server UUID: " + generated);
        }
    }

    public void debug(String message) {
        if (this.config != null && this.config.isDebugEnabled()) {
            this.getLogger().log(Level.INFO, "[EzBanners][Debug] " + message);
        }
    }
}

