/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.util;

import com.skyblockexp.ezauction.config.AuctionValueConfiguration;
import com.skyblockexp.ezauction.util.ItemValueProvider;
import java.util.Objects;
import java.util.OptionalDouble;
import org.bukkit.inventory.ItemStack;

public final class ConfiguredItemValueProvider
implements ItemValueProvider {
    private final AuctionValueConfiguration configuration;

    public ConfiguredItemValueProvider(AuctionValueConfiguration configuration) {
        this.configuration = configuration != null ? configuration : AuctionValueConfiguration.defaults();
    }

    @Override
    public OptionalDouble estimate(ItemStack itemStack) {
        if (this.configuration == null) {
            return OptionalDouble.empty();
        }
        return this.configuration.estimate(itemStack);
    }

    public AuctionValueConfiguration configuration() {
        return this.configuration;
    }

    public String toString() {
        return "ConfiguredItemValueProvider{configuration=" + String.valueOf(this.configuration) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfiguredItemValueProvider)) {
            return false;
        }
        ConfiguredItemValueProvider that = (ConfiguredItemValueProvider)o;
        return Objects.equals(this.configuration, that.configuration);
    }

    public int hashCode() {
        return Objects.hash(this.configuration);
    }
}

