/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.transaction;

import com.skyblockexp.ezauction.AuctionOperationResult;
import com.skyblockexp.ezauction.config.AuctionBackendMessages;
import com.skyblockexp.ezauction.util.EconomyUtils;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class AuctionTransactionService {
    private static final NumberFormat CURRENCY_FORMAT = NumberFormat.getCurrencyInstance(Locale.US);
    private final JavaPlugin plugin;
    private final Economy economy;
    private final AuctionBackendMessages.EconomyMessages messages;
    private final AuctionBackendMessages.FallbackMessages fallbackMessages;

    public AuctionTransactionService(JavaPlugin plugin, Economy economy, AuctionBackendMessages.EconomyMessages messages, AuctionBackendMessages.FallbackMessages fallbackMessages) {
        this.plugin = plugin;
        this.economy = economy;
        this.messages = messages != null ? messages : AuctionBackendMessages.EconomyMessages.defaults();
        this.fallbackMessages = fallbackMessages != null ? fallbackMessages : AuctionBackendMessages.FallbackMessages.defaults();
    }

    public AuctionOperationResult chargeListingDeposit(Player seller, double deposit) {
        double normalized = EconomyUtils.normalizeCurrency(deposit);
        if (normalized <= 0.0 || this.economy == null) {
            if (this.economy == null && normalized > 0.0) {
                return AuctionOperationResult.failure(this.formatMessage(this.messages.noProvider(), new String[0]));
            }
            return AuctionOperationResult.success("");
        }
        if (this.economy.getBalance((OfflinePlayer)seller) < normalized) {
            return AuctionOperationResult.failure(this.formatMessage(this.messages.depositInsufficient(), "amount", this.formatCurrency(normalized)));
        }
        EconomyResponse response = this.economy.withdrawPlayer((OfflinePlayer)seller, normalized);
        if (!response.transactionSuccess()) {
            return AuctionOperationResult.failure(this.formatMessage(this.messages.transactionFailed(), "error", this.normalizeError(response.errorMessage)));
        }
        return AuctionOperationResult.success("");
    }

    public AuctionOperationResult withdrawBuyer(Player buyer, double amount) {
        double normalized = EconomyUtils.normalizeCurrency(amount);
        if (normalized <= 0.0) {
            return AuctionOperationResult.failure(this.formatMessage(this.messages.invalidPrice(), new String[0]));
        }
        if (this.economy == null) {
            return AuctionOperationResult.failure(this.formatMessage(this.messages.noProvider(), new String[0]));
        }
        if (this.economy.getBalance((OfflinePlayer)buyer) < normalized) {
            return AuctionOperationResult.failure(this.formatMessage(this.messages.purchaseInsufficient(), new String[0]));
        }
        EconomyResponse response = this.economy.withdrawPlayer((OfflinePlayer)buyer, normalized);
        if (!response.transactionSuccess()) {
            return AuctionOperationResult.failure(this.formatMessage(this.messages.transactionFailed(), "error", this.normalizeError(response.errorMessage)));
        }
        return AuctionOperationResult.success("");
    }

    public AuctionOperationResult creditSeller(UUID sellerId, double amount) {
        double normalized = EconomyUtils.normalizeCurrency(amount);
        if (normalized <= 0.0) {
            return AuctionOperationResult.success("");
        }
        if (this.economy == null) {
            return AuctionOperationResult.failure(this.formatMessage(this.messages.noProvider(), new String[0]));
        }
        OfflinePlayer seller = this.plugin.getServer().getOfflinePlayer(sellerId);
        EconomyResponse response = this.economy.depositPlayer(seller, normalized);
        if (!response.transactionSuccess()) {
            return AuctionOperationResult.failure(this.formatMessage(this.messages.transactionFailed(), "error", this.normalizeError(response.errorMessage)));
        }
        return AuctionOperationResult.success("");
    }

    public AuctionOperationResult reserveOrderFunds(Player buyer, double amount) {
        double normalized = EconomyUtils.normalizeCurrency(amount);
        if (normalized <= 0.0) {
            return AuctionOperationResult.failure(this.formatMessage(this.messages.reservePositive(), new String[0]));
        }
        if (this.economy == null) {
            return AuctionOperationResult.failure(this.formatMessage(this.messages.noProvider(), new String[0]));
        }
        if (this.economy.getBalance((OfflinePlayer)buyer) < normalized) {
            return AuctionOperationResult.failure(this.formatMessage(this.messages.reserveInsufficient(), new String[0]));
        }
        EconomyResponse response = this.economy.withdrawPlayer((OfflinePlayer)buyer, normalized);
        if (!response.transactionSuccess()) {
            return AuctionOperationResult.failure(this.formatMessage(this.messages.transactionFailed(), "error", this.normalizeError(response.errorMessage)));
        }
        return AuctionOperationResult.success("");
    }

    public void refundOrderBuyer(UUID buyerId, double amount) {
        double normalized = EconomyUtils.normalizeCurrency(amount);
        if (this.economy == null || normalized <= 0.0 || buyerId == null) {
            return;
        }
        OfflinePlayer buyer = this.plugin.getServer().getOfflinePlayer(buyerId);
        EconomyResponse response = this.economy.depositPlayer(buyer, normalized);
        if (!response.transactionSuccess()) {
            this.plugin.getLogger().warning("Failed to refund buy order funds: " + response.errorMessage);
        }
    }

    public AuctionOperationResult payOrderSeller(UUID sellerId, double amount) {
        double normalized = EconomyUtils.normalizeCurrency(amount);
        if (normalized <= 0.0) {
            return AuctionOperationResult.success("");
        }
        if (this.economy == null) {
            return AuctionOperationResult.failure(this.formatMessage(this.messages.noProvider(), new String[0]));
        }
        OfflinePlayer seller = this.plugin.getServer().getOfflinePlayer(sellerId);
        EconomyResponse response = this.economy.depositPlayer(seller, normalized);
        if (!response.transactionSuccess()) {
            return AuctionOperationResult.failure(this.formatMessage(this.messages.transactionFailed(), "error", this.normalizeError(response.errorMessage)));
        }
        return AuctionOperationResult.success("");
    }

    public void refundBuyer(Player buyer, double amount) {
        double normalized = EconomyUtils.normalizeCurrency(amount);
        if (this.economy == null || normalized <= 0.0) {
            return;
        }
        EconomyResponse response = this.economy.depositPlayer((OfflinePlayer)buyer, normalized);
        if (!response.transactionSuccess()) {
            this.plugin.getLogger().warning("Failed to refund buyer after unsuccessful auction purchase: " + response.errorMessage);
        }
    }

    public void refundListingDeposit(UUID sellerId, double deposit) {
        double normalized = EconomyUtils.normalizeCurrency(deposit);
        if (this.economy == null || normalized <= 0.0) {
            return;
        }
        OfflinePlayer seller = this.plugin.getServer().getOfflinePlayer(sellerId);
        EconomyResponse response = this.economy.depositPlayer(seller, normalized);
        if (!response.transactionSuccess()) {
            this.plugin.getLogger().warning("Failed to refund auction listing deposit: " + response.errorMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String formatCurrency(double amount) {
        double normalized = EconomyUtils.normalizeCurrency(amount);
        if (this.economy != null) {
            return this.economy.format(normalized);
        }
        NumberFormat numberFormat = CURRENCY_FORMAT;
        synchronized (numberFormat) {
            return CURRENCY_FORMAT.format(normalized);
        }
    }

    private String formatMessage(String template, String ... replacements) {
        if (template == null || template.isEmpty()) {
            return "";
        }
        String formatted = template;
        int i = 0;
        while (i + 1 < replacements.length) {
            String key = replacements[i];
            String value = replacements[i + 1];
            formatted = formatted.replace("{" + key + "}", value != null ? value : "");
            i += 2;
        }
        return this.colorize(formatted);
    }

    private String colorize(String message) {
        if (message == null || message.isEmpty()) {
            return "";
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    private String normalizeError(String error) {
        if (error == null || error.isBlank()) {
            return this.fallbackMessages.unknownError();
        }
        return error;
    }
}

