/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.service;

import com.skyblockexp.ezauction.AuctionOperationResult;
import com.skyblockexp.ezauction.config.AuctionBackendMessages;
import com.skyblockexp.ezauction.persistence.AuctionPersistenceManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class AuctionReturnService {
    private final Map<UUID, List<ItemStack>> pendingReturns;
    private final AuctionPersistenceManager persistenceManager;
    private final AuctionBackendMessages backendMessages;
    private final String CLAIM_COMMAND = "/auction claim";

    public AuctionReturnService(Map<UUID, List<ItemStack>> pendingReturns, AuctionPersistenceManager persistenceManager, AuctionBackendMessages backendMessages) {
        this.pendingReturns = pendingReturns;
        this.persistenceManager = persistenceManager;
        this.backendMessages = backendMessages;
    }

    public int countPendingReturnItems(UUID playerId) {
        if (playerId == null) {
            return 0;
        }
        List<ItemStack> stored = this.pendingReturns.get(playerId);
        return this.countItemAmount(stored);
    }

    public void handlePlayerLogin(Player player) {
        if (player == null) {
            return;
        }
        UUID playerId = player.getUniqueId();
        List<ItemStack> stored = this.pendingReturns.get(playerId);
        if (stored == null || stored.isEmpty()) {
            return;
        }
        int totalItems = this.countItemAmount(stored);
        if (totalItems <= 0) {
            this.pendingReturns.remove(playerId);
            this.persistenceManager.saveReturns(this.pendingReturns);
            return;
        }
        player.sendMessage(this.formatMessage(this.backendMessages.claim().reminder(), "total", String.valueOf(totalItems), "returned-suffix", this.pluralSuffix(totalItems), "command", "/auction claim"));
    }

    public AuctionOperationResult claimReturnItems(Player player) {
        String message;
        if (player == null) {
            return AuctionOperationResult.failure(this.formatMessage(this.backendMessages.claim().playersOnly(), new String[0]));
        }
        UUID playerId = player.getUniqueId();
        List<ItemStack> stored = this.pendingReturns.get(playerId);
        if (stored == null || stored.isEmpty()) {
            return AuctionOperationResult.failure(this.formatMessage(this.backendMessages.claim().noneAvailable(), new String[0]));
        }
        ArrayList<ItemStack> remaining = new ArrayList<ItemStack>();
        int claimedAmount = 0;
        int availableAmount = 0;
        for (ItemStack storedItem : stored) {
            if (storedItem == null || storedItem.getType() == Material.AIR || storedItem.getAmount() <= 0) continue;
            ItemStack toGive = storedItem.clone();
            availableAmount += toGive.getAmount();
            HashMap leftover = player.getInventory().addItem(new ItemStack[]{toGive});
            if (leftover.isEmpty()) {
                claimedAmount += toGive.getAmount();
                continue;
            }
            int leftoverAmount = 0;
            for (ItemStack remainder : leftover.values()) {
                if (remainder == null || remainder.getType() == Material.AIR || remainder.getAmount() <= 0) continue;
                leftoverAmount += remainder.getAmount();
                remaining.add(remainder.clone());
            }
            claimedAmount += Math.max(0, toGive.getAmount() - leftoverAmount);
        }
        if (availableAmount <= 0) {
            this.pendingReturns.remove(playerId);
            this.persistenceManager.saveReturns(this.pendingReturns);
            return AuctionOperationResult.failure(this.formatMessage(this.backendMessages.claim().noneAvailable(), new String[0]));
        }
        if (remaining.isEmpty()) {
            this.pendingReturns.remove(playerId);
        } else {
            this.pendingReturns.put(playerId, remaining);
        }
        this.persistenceManager.saveReturns(this.pendingReturns);
        if (claimedAmount <= 0) {
            return AuctionOperationResult.failure(this.formatMessage(this.backendMessages.claim().inventoryFull(), new String[0]));
        }
        int remainingAmount = this.countItemAmount(remaining);
        if (remainingAmount > 0) {
            message = this.formatMessage(this.backendMessages.claim().partial(), "claimed", String.valueOf(claimedAmount), "claimed-suffix", this.pluralSuffix(claimedAmount), "remaining", String.valueOf(remainingAmount), "remaining-suffix", this.pluralSuffix(remainingAmount));
            return AuctionOperationResult.success(message);
        }
        message = this.formatMessage(this.backendMessages.claim().complete(), "claimed", String.valueOf(claimedAmount), "claimed-suffix", this.pluralSuffix(claimedAmount));
        return AuctionOperationResult.success(message);
    }

    private int countItemAmount(List<ItemStack> items) {
        if (items == null || items.isEmpty()) {
            return 0;
        }
        int total = 0;
        for (ItemStack stack : items) {
            if (stack == null || stack.getType() == Material.AIR) continue;
            total += Math.max(0, stack.getAmount());
        }
        return total;
    }

    private String formatMessage(String template, String ... replacements) {
        if (template == null || template.isEmpty()) {
            return "";
        }
        String formatted = template;
        int i = 0;
        while (i + 1 < replacements.length) {
            String key = replacements[i];
            String value = replacements[i + 1];
            formatted = formatted.replace("{" + key + "}", value != null ? value : "");
            i += 2;
        }
        return this.colorize(formatted);
    }

    private String colorize(String message) {
        if (message == null || message.isEmpty()) {
            return "";
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    private String pluralSuffix(int amount) {
        return amount == 1 ? "" : "s";
    }
}

