/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.service;

import com.skyblockexp.ezauction.AuctionListing;
import com.skyblockexp.ezauction.AuctionOrder;
import com.skyblockexp.ezauction.config.AuctionConfiguration;
import com.skyblockexp.ezauction.live.LiveAuctionEntry;
import com.skyblockexp.ezauction.live.LiveAuctionService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class AuctionQueryService {
    private final Map<String, AuctionListing> listings;
    private final Map<String, AuctionOrder> orders;
    private final LiveAuctionService liveAuctionService;
    private final AuctionConfiguration configuration;

    public AuctionQueryService(Map<String, AuctionListing> listings, Map<String, AuctionOrder> orders, LiveAuctionService liveAuctionService, AuctionConfiguration configuration) {
        this.listings = listings;
        this.orders = orders;
        this.liveAuctionService = liveAuctionService;
        this.configuration = configuration;
    }

    public List<AuctionListing> listActiveListings() {
        ArrayList<AuctionListing> active = new ArrayList<AuctionListing>(this.listings.values());
        long now = System.currentTimeMillis();
        active.removeIf(l -> l.expiryEpochMillis() <= now);
        active.sort(Comparator.comparingLong(AuctionListing::expiryEpochMillis));
        if (this.configuration != null && this.configuration.debug()) {
            System.out.println("[EzAuction][DEBUG] listActiveListings: " + active.size() + " listings: " + String.valueOf(active));
        }
        return Collections.unmodifiableList(active);
    }

    public List<AuctionOrder> listActiveOrders() {
        ArrayList<AuctionOrder> active = new ArrayList<AuctionOrder>(this.orders.values());
        long now = System.currentTimeMillis();
        active.removeIf(o -> o.expiryEpochMillis() <= now);
        active.sort(Comparator.comparingLong(AuctionOrder::expiryEpochMillis));
        return Collections.unmodifiableList(active);
    }

    public long countActiveListings(UUID sellerId) {
        if (sellerId == null) {
            return 0L;
        }
        long now = System.currentTimeMillis();
        return this.listings.values().stream().filter(listing -> sellerId.equals(listing.sellerId())).filter(listing -> listing.expiryEpochMillis() > now).count();
    }

    public long countActiveOrders(UUID buyerId) {
        if (buyerId == null) {
            return 0L;
        }
        long now = System.currentTimeMillis();
        return this.orders.values().stream().filter(order -> buyerId.equals(order.buyerId())).filter(order -> order.expiryEpochMillis() > now).count();
    }

    public long countAllActiveListings() {
        long now = System.currentTimeMillis();
        return this.listings.values().stream().filter(listing -> listing.expiryEpochMillis() > now).count();
    }

    public long countAllActiveOrders() {
        long now = System.currentTimeMillis();
        return this.orders.values().stream().filter(order -> order.expiryEpochMillis() > now).count();
    }

    public AuctionListing findHighestPricedListing() {
        long now = System.currentTimeMillis();
        return this.listings.values().stream().filter(l -> l.expiryEpochMillis() > now).max(Comparator.comparingDouble(AuctionListing::price)).orElse(null);
    }

    public AuctionOrder findHighestPricedOrder() {
        long now = System.currentTimeMillis();
        return this.orders.values().stream().filter(o -> o.expiryEpochMillis() > now).max(Comparator.comparingDouble(AuctionOrder::offeredPrice)).orElse(null);
    }

    public AuctionListing findNextExpiringListing() {
        long now = System.currentTimeMillis();
        return this.listings.values().stream().filter(l -> l.expiryEpochMillis() > now).min(Comparator.comparingLong(AuctionListing::expiryEpochMillis)).orElse(null);
    }

    public boolean liveAuctionsEnabled() {
        return this.configuration != null && this.configuration.liveAuctionConfiguration() != null && this.configuration.liveAuctionConfiguration().enabled();
    }

    public List<LiveAuctionEntry> listQueuedLiveAuctions() {
        if (this.liveAuctionService == null) {
            return Collections.emptyList();
        }
        return this.liveAuctionService.snapshotQueue();
    }

    public long countActiveListings() {
        long now = System.currentTimeMillis();
        return this.listings.values().stream().filter(listing -> listing.expiryEpochMillis() > now).count();
    }

    public long countActiveOrders() {
        long now = System.currentTimeMillis();
        return this.orders.values().stream().filter(order -> order.expiryEpochMillis() > now).count();
    }
}

