/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.service;

import com.skyblockexp.ezauction.AuctionListing;
import com.skyblockexp.ezauction.AuctionOperationResult;
import com.skyblockexp.ezauction.AuctionOrder;
import com.skyblockexp.ezauction.api.AuctionListingLimitResolver;
import com.skyblockexp.ezauction.claim.AuctionClaimService;
import com.skyblockexp.ezauction.config.AuctionConfiguration;
import com.skyblockexp.ezauction.config.AuctionListingRules;
import com.skyblockexp.ezauction.event.AuctionListingCreateEvent;
import com.skyblockexp.ezauction.event.AuctionListingSellEvent;
import com.skyblockexp.ezauction.event.AuctionListingSoldEvent;
import com.skyblockexp.ezauction.history.AuctionTransactionHistoryService;
import com.skyblockexp.ezauction.live.LiveAuctionService;
import com.skyblockexp.ezauction.notification.AuctionNotificationService;
import com.skyblockexp.ezauction.persistence.AuctionPersistenceManager;
import com.skyblockexp.ezauction.transaction.AuctionTransactionService;
import com.skyblockexp.ezauction.util.AuctionValidationUtils;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class AuctionListingService {
    private final Map<String, AuctionListing> listings;
    private final AuctionTransactionService transactionService;
    private final AuctionListingLimitResolver listingLimitResolver;
    private final AuctionConfiguration configuration;
    private final AuctionListingRules listingRules;
    private final LiveAuctionService liveAuctionService;
    private final AuctionPersistenceManager persistenceManager;
    private final AuctionNotificationService notificationService;
    private final AuctionClaimService claimService;
    private final AuctionTransactionHistoryService transactionHistoryService;
    private final Map<UUID, List<ItemStack>> pendingReturns;
    private final Map<String, AuctionOrder> orders;

    public AuctionListingService(AuctionTransactionService transactionService, AuctionListingLimitResolver listingLimitResolver, AuctionConfiguration configuration, AuctionListingRules listingRules, LiveAuctionService liveAuctionService, AuctionPersistenceManager persistenceManager, AuctionNotificationService notificationService, AuctionClaimService claimService, AuctionTransactionHistoryService transactionHistoryService, Map<UUID, List<ItemStack>> pendingReturns, Map<String, AuctionListing> listings, Map<String, AuctionOrder> orders) {
        this.listings = listings;
        this.transactionService = transactionService;
        this.listingLimitResolver = listingLimitResolver;
        this.configuration = configuration;
        this.listingRules = listingRules;
        this.liveAuctionService = liveAuctionService;
        this.persistenceManager = persistenceManager;
        this.notificationService = notificationService;
        this.claimService = claimService;
        this.transactionHistoryService = transactionHistoryService;
        this.pendingReturns = pendingReturns;
        this.orders = orders;
    }

    public AuctionOperationResult createListing(Player seller, ItemStack item, double price, Duration duration) {
        AuctionOperationResult depositResult;
        long activeListings;
        UUID sellerId;
        int listingLimit;
        if (this.configuration.debug()) {
            System.out.println("[EzAuction][DEBUG] createListing called: seller=" + (seller != null ? seller.getName() : "null") + ", item=" + String.valueOf(item != null ? item.getType() : "null") + ", price=" + price + ", duration=" + String.valueOf(duration));
        }
        if (seller == null) {
            return AuctionOperationResult.failure("Only players can create listings.");
        }
        if (item == null || item.getType() == Material.AIR || item.getAmount() <= 0) {
            return AuctionOperationResult.failure("You must provide a valid item to list.");
        }
        AuctionListingCreateEvent event = new AuctionListingCreateEvent(seller, item, price);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return AuctionOperationResult.failure("Auction listing creation was cancelled by another plugin.");
        }
        seller = event.getPlayer();
        item = event.getItem();
        price = event.getPrice();
        Duration sanitizedDuration = this.listingRules.clampDuration(duration);
        if (sanitizedDuration == null || sanitizedDuration.isZero() || sanitizedDuration.isNegative()) {
            return AuctionOperationResult.failure("Listing duration must be positive.");
        }
        double normalizedPrice = price;
        if (normalizedPrice <= 0.0) {
            return AuctionOperationResult.failure("Listing price must be positive.");
        }
        double minimumPrice = this.listingRules.minimumPrice();
        if (normalizedPrice < minimumPrice) {
            return AuctionOperationResult.failure("Listing price must be at least " + this.transactionService.formatCurrency(minimumPrice) + ".");
        }
        double normalizedDeposit = this.listingRules.depositAmount(normalizedPrice);
        if (normalizedDeposit < 0.0) {
            normalizedDeposit = 0.0;
        }
        if ((listingLimit = AuctionValidationUtils.resolveListingLimit(sellerId = seller.getUniqueId(), this.configuration, this.listingLimitResolver)) > 0 && (activeListings = this.listings.values().stream().filter(l -> sellerId.equals(l.sellerId())).count()) >= (long)listingLimit) {
            return AuctionOperationResult.failure("You have reached your listing limit (" + listingLimit + ").");
        }
        ItemStack listingItem = item.clone();
        if (this.configuration.debug()) {
            System.out.println("[EzAuction][DEBUG] Cloned item: " + String.valueOf(listingItem) + ", amount=" + listingItem.getAmount());
        }
        if (!seller.getInventory().containsAtLeast(listingItem, listingItem.getAmount())) {
            return AuctionOperationResult.failure("You do not have enough of the item in your inventory.");
        }
        if (normalizedDeposit > 0.0 && !(depositResult = this.transactionService.chargeListingDeposit(seller, normalizedDeposit)).success()) {
            return depositResult;
        }
        HashMap leftover = seller.getInventory().removeItem(new ItemStack[]{listingItem});
        if (this.configuration.debug()) {
            System.out.println("[EzAuction][DEBUG] Attempted to remove item from inventory. Leftover: " + String.valueOf(leftover));
        }
        if (!leftover.isEmpty()) {
            if (normalizedDeposit > 0.0) {
                this.transactionService.refundListingDeposit(seller.getUniqueId(), normalizedDeposit);
            }
            return AuctionOperationResult.failure("Failed to remove item from your inventory.");
        }
        String id = UUID.randomUUID().toString();
        long expiry = System.currentTimeMillis() + sanitizedDuration.toMillis();
        AuctionListing listing = new AuctionListing(id, seller.getUniqueId(), normalizedPrice, expiry, listingItem, normalizedDeposit);
        this.listings.put(id, listing);
        if (this.configuration.debug()) {
            System.out.println("[EzAuction][DEBUG] Listing added to map: id=" + id + ", listing=" + String.valueOf(listing));
        }
        this.persistenceManager.saveListings(new ArrayList<AuctionListing>(this.listings.values()), new ArrayList<AuctionOrder>(this.orders.values()));
        if (this.liveAuctionService != null) {
            this.liveAuctionService.enqueue(listing, seller.getUniqueId(), seller.getName());
        }
        this.notificationService.notifySellerSale(listing);
        this.transactionHistoryService.recordListingTransactionHistory(listing, seller);
        return AuctionOperationResult.success("Your item has been listed for auction!");
    }

    public AuctionOperationResult purchaseListing(Player buyer, String listingId) {
        if (buyer == null || listingId == null || listingId.isEmpty()) {
            return AuctionOperationResult.failure("Invalid buyer or listingId.");
        }
        AuctionListing listing = this.listings.get(listingId);
        if (listing == null) {
            return AuctionOperationResult.failure("Listing not found or already purchased.");
        }
        long now = System.currentTimeMillis();
        if (listing.expiryEpochMillis() < now) {
            this.listings.remove(listingId);
            this.persistenceManager.saveListings(new ArrayList<AuctionListing>(this.listings.values()), new ArrayList<AuctionOrder>(this.orders.values()));
            this.notificationService.notifySellerExpiry(listing);
            this.claimService.returnListingItem(listing, this.pendingReturns);
            return AuctionOperationResult.failure("This listing has expired.");
        }
        if (listing.sellerId().equals(buyer.getUniqueId())) {
            return AuctionOperationResult.failure("You cannot purchase your own listing.");
        }
        AuctionListingSellEvent sellEvent = new AuctionListingSellEvent(listing);
        Bukkit.getPluginManager().callEvent((Event)sellEvent);
        if (sellEvent.isCancelled()) {
            return AuctionOperationResult.failure("This listing cannot be purchased right now.");
        }
        ItemStack itemToGive = listing.item();
        if (!this.claimService.hasInventorySpace(buyer, itemToGive)) {
            return AuctionOperationResult.failure("You do not have enough inventory space.");
        }
        AuctionOperationResult withdrawResult = this.transactionService.withdrawBuyer(buyer, listing.price());
        if (!withdrawResult.success()) {
            return withdrawResult;
        }
        boolean claimSuccess = this.claimService.claimListing(listingId, this.listings, this.pendingReturns);
        if (!claimSuccess) {
            this.transactionService.refundBuyer(buyer, listing.price());
            return AuctionOperationResult.failure("Failed to claim the listing. You have not been charged.");
        }
        HashMap leftover = buyer.getInventory().addItem(new ItemStack[]{itemToGive});
        if (!leftover.isEmpty()) {
            this.claimService.storeReturnItem(buyer.getUniqueId(), itemToGive, this.pendingReturns);
            this.transactionService.refundBuyer(buyer, listing.price());
            return AuctionOperationResult.failure("Could not add item to your inventory. You have not been charged.");
        }
        AuctionOperationResult creditResult = this.transactionService.creditSeller(listing.sellerId(), listing.price());
        if (!creditResult.success()) {
            buyer.getInventory().removeItem(new ItemStack[]{itemToGive});
            this.claimService.storeReturnItem(buyer.getUniqueId(), itemToGive, this.pendingReturns);
            this.transactionService.refundBuyer(buyer, listing.price());
            return AuctionOperationResult.failure("Failed to credit the seller. Transaction cancelled.");
        }
        if (listing.deposit() > 0.0) {
            this.transactionService.refundListingDeposit(listing.sellerId(), listing.deposit());
        }
        this.listings.remove(listingId);
        this.persistenceManager.saveListings(new ArrayList<AuctionListing>(this.listings.values()), new ArrayList<AuctionOrder>(this.orders.values()));
        this.notificationService.notifySellerSale(listing);
        this.transactionHistoryService.recordListingTransactionHistory(listing, buyer);
        AuctionListingSoldEvent soldEvent = new AuctionListingSoldEvent(listing);
        Bukkit.getPluginManager().callEvent((Event)soldEvent);
        return AuctionOperationResult.success("You have successfully purchased the listing!");
    }

    public AuctionOperationResult cancelListing(UUID sellerId, String listingId) {
        if (sellerId == null || listingId == null || listingId.isEmpty()) {
            return AuctionOperationResult.failure("Invalid sellerId or listingId.");
        }
        AuctionListing listing = this.listings.get(listingId);
        if (listing == null) {
            return AuctionOperationResult.failure("Listing not found or already removed.");
        }
        if (!sellerId.equals(listing.sellerId())) {
            return AuctionOperationResult.failure("You do not own this listing.");
        }
        this.listings.remove(listingId);
        this.claimService.returnListingItem(listing, this.pendingReturns);
        if (listing.deposit() > 0.0) {
            this.transactionService.refundListingDeposit(sellerId, listing.deposit());
        }
        this.persistenceManager.saveListings(new ArrayList<AuctionListing>(this.listings.values()), new ArrayList<AuctionOrder>(this.orders.values()));
        this.notificationService.notifySellerCancelled(listing);
        this.transactionHistoryService.recordListingTransactionHistory(listing, null);
        return AuctionOperationResult.success("Your listing has been cancelled and the item returned.");
    }

    public Map<String, AuctionListing> getListings() {
        return this.listings;
    }
}

