/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.service;

import com.skyblockexp.ezauction.AuctionListing;
import com.skyblockexp.ezauction.AuctionOrder;
import com.skyblockexp.ezauction.claim.AuctionClaimService;
import com.skyblockexp.ezauction.history.AuctionTransactionHistoryService;
import com.skyblockexp.ezauction.notification.AuctionNotificationService;
import com.skyblockexp.ezauction.persistence.AuctionPersistenceManager;
import com.skyblockexp.ezauction.transaction.AuctionTransactionService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public class AuctionExpiryService {
    private final JavaPlugin plugin;
    private final Map<String, AuctionListing> listings;
    private final Map<String, AuctionOrder> orders;
    private final AuctionPersistenceManager persistenceManager;
    private final AuctionNotificationService notificationService;
    private final AuctionTransactionHistoryService transactionHistoryService;
    private final AuctionClaimService claimService;
    private final AuctionTransactionService transactionService;
    private final Map<UUID, List<ItemStack>> pendingReturns;
    private BukkitTask expiryTask;

    public AuctionExpiryService(JavaPlugin plugin, Map<String, AuctionListing> listings, Map<String, AuctionOrder> orders, AuctionPersistenceManager persistenceManager, AuctionNotificationService notificationService, AuctionTransactionHistoryService transactionHistoryService, AuctionClaimService claimService, AuctionTransactionService transactionService, Map<UUID, List<ItemStack>> pendingReturns) {
        this.plugin = plugin;
        this.listings = listings;
        this.orders = orders;
        this.persistenceManager = persistenceManager;
        this.notificationService = notificationService;
        this.transactionHistoryService = transactionHistoryService;
        this.claimService = claimService;
        this.transactionService = transactionService;
        this.pendingReturns = pendingReturns;
    }

    public void enable() {
        this.startExpiryTask();
    }

    public void disable() {
        if (this.expiryTask != null) {
            this.expiryTask.cancel();
            this.expiryTask = null;
        }
        if (this.persistenceManager != null) {
            this.persistenceManager.saveListings(new ArrayList<AuctionListing>(this.listings.values()), new ArrayList<AuctionOrder>(this.orders.values()));
            this.persistenceManager.saveReturns(this.pendingReturns);
            this.persistenceManager.awaitPersistenceCompletion();
            this.persistenceManager.setStorageReady(false);
        }
    }

    private void startExpiryTask() {
        if (this.expiryTask != null) {
            this.expiryTask.cancel();
        }
        this.expiryTask = this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, this::purgeExpiredEntries, 20L, 1200L);
    }

    public void purgeExpiredEntries() {
        long now = System.currentTimeMillis();
        boolean changed = false;
        Iterator<Map.Entry<String, AuctionListing>> listingIterator = this.listings.entrySet().iterator();
        while (listingIterator.hasNext()) {
            Map.Entry<String, AuctionListing> entry = listingIterator.next();
            AuctionListing listing = entry.getValue();
            if (listing.expiryEpochMillis() >= now) continue;
            listingIterator.remove();
            this.claimService.returnListingItem(listing, this.pendingReturns);
            this.notificationService.notifySellerExpiry(listing);
            this.transactionHistoryService.recordListingTransactionHistory(listing, null);
            changed = true;
        }
        Iterator<Map.Entry<String, AuctionOrder>> orderIterator = this.orders.entrySet().iterator();
        while (orderIterator.hasNext()) {
            Map.Entry<String, AuctionOrder> entry = orderIterator.next();
            AuctionOrder order = entry.getValue();
            if (order.expiryEpochMillis() >= now) continue;
            orderIterator.remove();
            this.transactionService.refundOrderBuyer(order.buyerId(), order.reservedAmount());
            this.notificationService.notifyOrderExpiry(order);
            this.transactionHistoryService.recordOrderTransactionHistory(order, order.buyerId(), null, null);
            changed = true;
        }
        if (changed) {
            this.persistenceManager.saveListings(new ArrayList<AuctionListing>(this.listings.values()), new ArrayList<AuctionOrder>(this.orders.values()));
        }
    }
}

