/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.persistence;

import com.skyblockexp.ezauction.AuctionListing;
import com.skyblockexp.ezauction.AuctionOrder;
import com.skyblockexp.ezauction.storage.AuctionStorage;
import com.skyblockexp.ezauction.storage.AuctionStorageSnapshot;
import com.skyblockexp.ezauction.storage.DistributedAuctionListingStorage;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.bukkit.inventory.ItemStack;

public class AuctionPersistenceManager {
    private final AuctionStorage storage;
    private final DistributedAuctionListingStorage distributedStorage;
    private final ExecutorService executor;
    private volatile boolean storageReady = false;
    private final Object persistenceLock = new Object();
    private CompletableFuture<Void> persistenceChain = CompletableFuture.completedFuture(null);

    public AuctionPersistenceManager(AuctionStorage storage, DistributedAuctionListingStorage distributedStorage, ExecutorService executor) {
        this.storage = storage;
        this.distributedStorage = distributedStorage;
        this.executor = executor;
    }

    public boolean isStorageReady() {
        return this.storageReady;
    }

    public void setStorageReady(boolean ready) {
        this.storageReady = ready;
    }

    public AuctionStorageSnapshot loadFromStorage() {
        if (!this.storageReady) {
            return null;
        }
        return this.storage.load();
    }

    public void saveListings(List<AuctionListing> listings, List<AuctionOrder> orders) {
        if (!this.storageReady) {
            return;
        }
        this.schedulePersistenceTask(() -> this.storage.saveListings(listings, orders));
    }

    public void saveReturns(Map<UUID, List<ItemStack>> returnsByPlayer) {
        if (!this.storageReady) {
            return;
        }
        this.schedulePersistenceTask(() -> this.storage.saveReturns(returnsByPlayer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitPersistenceCompletion() {
        CompletableFuture<Void> chain;
        Object object = this.persistenceLock;
        synchronized (object) {
            chain = this.persistenceChain;
        }
        try {
            chain.get();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedulePersistenceTask(Runnable task) {
        Object object = this.persistenceLock;
        synchronized (object) {
            this.persistenceChain = this.persistenceChain.thenRunAsync(task, this.executor);
        }
    }

    public void insertListing(AuctionListing listing) {
        if (!this.storageReady || this.distributedStorage == null || listing == null) {
            return;
        }
        this.schedulePersistenceTask(() -> this.distributedStorage.insertListing(listing));
    }

    public void deleteListing(String listingId) {
        if (!this.storageReady || this.distributedStorage == null || listingId == null || listingId.isEmpty()) {
            return;
        }
        this.schedulePersistenceTask(() -> this.distributedStorage.deleteListing(listingId));
    }

    public boolean tryClaimListing(String listingId) {
        if (!this.storageReady || this.distributedStorage == null || listingId == null || listingId.isEmpty()) {
            return false;
        }
        try {
            return this.distributedStorage.tryClaimListing(listingId);
        }
        catch (RuntimeException ex) {
            return false;
        }
    }
}

