/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.live;

import com.skyblockexp.ezauction.AuctionManager;
import com.skyblockexp.ezauction.config.AuctionCommandMessageConfiguration;
import com.skyblockexp.ezauction.gui.AuctionSellMenu;
import com.skyblockexp.ezauction.gui.LiveAuctionMenu;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class LiveAuctionCommand
implements CommandExecutor,
TabCompleter {
    private final AuctionManager auctionManager;
    private final LiveAuctionMenu liveAuctionMenu;
    private final AuctionSellMenu auctionSellMenu;
    private final AuctionCommandMessageConfiguration messages;

    public LiveAuctionCommand(AuctionManager auctionManager, LiveAuctionMenu liveAuctionMenu, AuctionSellMenu auctionSellMenu, AuctionCommandMessageConfiguration messages) {
        this.auctionManager = auctionManager;
        this.liveAuctionMenu = liveAuctionMenu;
        this.auctionSellMenu = auctionSellMenu;
        this.messages = messages;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.liveAuctionMenu.open(player);
            return true;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("sell")) {
            this.auctionSellMenu.openLive(player);
            return true;
        }
        player.sendMessage(String.valueOf(ChatColor.RED) + this.messages.usage().live());
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            if ("sell".startsWith(args[0].toLowerCase())) {
                completions.add("sell");
            }
            return completions;
        }
        return Collections.emptyList();
    }
}

