/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.gui;

import com.skyblockexp.ezauction.AuctionManager;
import com.skyblockexp.ezauction.AuctionOperationResult;
import com.skyblockexp.ezauction.compat.ItemTagStorage;
import com.skyblockexp.ezauction.config.AuctionListingRules;
import com.skyblockexp.ezauction.config.AuctionMenuInteractionConfiguration;
import com.skyblockexp.ezauction.config.AuctionMessageConfiguration;
import com.skyblockexp.ezauction.transaction.AuctionTransactionService;
import com.skyblockexp.ezauction.util.EconomyUtils;
import com.skyblockexp.ezauction.util.ItemValueProvider;
import com.skyblockexp.ezauction.util.NumberShortcutParser;
import java.lang.invoke.CallSite;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class AuctionOrderMenu
implements Listener {
    private static final String ACTION_PRICE_ADJUST = "price_adjust";
    private static final String ACTION_PRICE_CUSTOM = "price_custom";
    private static final String ACTION_QUANTITY_ADJUST = "quantity_adjust";
    private static final String ACTION_QUANTITY_CUSTOM = "quantity_custom";
    private static final String ACTION_DURATION_NEXT = "duration_next";
    private static final String ACTION_CONFIRM = "confirm";
    private static final String ACTION_CANCEL = "cancel";
    private final JavaPlugin plugin;
    private final AuctionManager auctionManager;
    private final AuctionTransactionService transactionService;
    private final AuctionListingRules listingRules;
    private final ItemValueProvider itemValueProvider;
    private final String actionKey;
    private final String priceAdjustKey;
    private final String quantityAdjustKey;
    private final ItemTagStorage itemTagStorage;
    private final AuctionMenuInteractionConfiguration.OrderMenuLayoutConfiguration layout;
    private final ItemStack fillerPane;
    private final ConcurrentMap<UUID, OrderMenuState> pendingPriceInputs;
    private final ConcurrentMap<UUID, OrderMenuState> pendingQuantityInputs;
    private final Duration[] durationOptions;
    private final int defaultDurationIndex;
    private final double minimumPricePerItem;
    private final Duration longestDurationOption;
    private final double defaultPricePerItem;
    private final double[] priceAdjustments;
    private final int[] quantityAdjustments;
    private final AuctionMessageConfiguration.OrderMessages messages;

    public AuctionOrderMenu(JavaPlugin plugin, AuctionManager auctionManager, AuctionTransactionService transactionService, AuctionListingRules listingRules, List<Duration> configuredDurationOptions, AuctionMenuInteractionConfiguration.OrderMenuInteractionConfiguration orderConfiguration, ItemValueProvider itemValueProvider, AuctionMessageConfiguration.OrderMessages messages, ItemTagStorage itemTagStorage) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
        this.auctionManager = Objects.requireNonNull(auctionManager, "auctionManager");
        this.transactionService = Objects.requireNonNull(transactionService, "transactionService");
        this.listingRules = Objects.requireNonNull(listingRules, "listingRules");
        this.itemValueProvider = itemValueProvider != null ? itemValueProvider : ItemValueProvider.none();
        this.messages = messages != null ? messages : AuctionMessageConfiguration.OrderMessages.defaults();
        this.actionKey = "auction_order_action";
        this.priceAdjustKey = "auction_order_price_adjust";
        this.quantityAdjustKey = "auction_order_quantity_adjust";
        this.itemTagStorage = Objects.requireNonNull(itemTagStorage, "itemTagStorage");
        this.pendingPriceInputs = new ConcurrentHashMap<UUID, OrderMenuState>();
        this.pendingQuantityInputs = new ConcurrentHashMap<UUID, OrderMenuState>();
        this.durationOptions = this.buildDurationOptions(listingRules, configuredDurationOptions);
        this.defaultDurationIndex = this.resolveDefaultDurationIndex(this.durationOptions, listingRules.defaultDuration());
        this.minimumPricePerItem = Math.max(0.0, listingRules.minimumPrice());
        this.longestDurationOption = this.resolveLongestDuration(this.durationOptions, listingRules);
        AuctionMenuInteractionConfiguration.OrderMenuInteractionConfiguration interactions = orderConfiguration != null ? orderConfiguration : AuctionMenuInteractionConfiguration.defaults().orderMenu();
        this.layout = interactions.layout();
        this.fillerPane = this.createBaseItem(this.layout.filler());
        this.defaultPricePerItem = Math.max(0.0, interactions.defaultPricePerItem());
        List<Double> priceAdjustmentValues = interactions.priceAdjustments();
        this.priceAdjustments = new double[priceAdjustmentValues.size()];
        for (int i = 0; i < priceAdjustmentValues.size(); ++i) {
            Double value = priceAdjustmentValues.get(i);
            this.priceAdjustments[i] = value != null ? value : 0.0;
        }
        List<Integer> quantityAdjustmentValues = interactions.quantityAdjustments();
        this.quantityAdjustments = new int[quantityAdjustmentValues.size()];
        for (int i = 0; i < quantityAdjustmentValues.size(); ++i) {
            Integer value = quantityAdjustmentValues.get(i);
            this.quantityAdjustments[i] = value != null ? value : 0;
        }
    }

    public void openOrderMenu(Player player) {
        double normalized;
        double perItem;
        if (player == null) {
            return;
        }
        if (!player.hasPermission("ezauction.auction.order")) {
            this.sendMessage(player, this.messages.noPermission());
            return;
        }
        ItemStack template = player.getInventory().getItemInMainHand();
        if (template == null || template.getType() == Material.AIR) {
            this.sendMessage(player, this.messages.itemRequired());
            return;
        }
        ItemStack base = template.clone();
        base.setAmount(Math.max(1, Math.min(template.getAmount(), base.getMaxStackSize())));
        double startingPrice = Math.max(this.minimumPricePerItem, this.defaultPricePerItem);
        Double recommendedPricePerItem = null;
        OptionalDouble estimate = this.itemValueProvider.estimate(base);
        int baseAmount = Math.max(1, base.getAmount());
        if (estimate.isPresent() && estimate.getAsDouble() > 0.0 && (perItem = estimate.getAsDouble() / (double)baseAmount) > 0.0 && (normalized = EconomyUtils.normalizeCurrency(Math.max(this.minimumPricePerItem, perItem))) > 0.0) {
            recommendedPricePerItem = normalized;
            startingPrice = normalized;
        }
        OrderMenuState state = new OrderMenuState(base, startingPrice, base.getAmount(), this.defaultDurationIndex, recommendedPricePerItem);
        this.openOrderMenu(player, state);
    }

    private void openOrderMenu(Player player, OrderMenuState state) {
        if (player == null || state == null) {
            return;
        }
        OrderMenuHolder holder = new OrderMenuHolder(player.getUniqueId(), state);
        Inventory inventory = Bukkit.createInventory((InventoryHolder)holder, (int)this.layout.size(), (String)this.colorize(this.layout.title()));
        holder.setInventory(inventory);
        this.refreshMenu(holder);
        player.openInventory(inventory);
    }

    private void refreshMenu(OrderMenuHolder holder) {
        Inventory inventory = holder.getInventory();
        if (inventory == null) {
            return;
        }
        inventory.clear();
        this.applyFiller(inventory);
        this.placePriceAdjustmentButtons(inventory);
        this.placeQuantityAdjustmentButtons(inventory);
        ItemStack requested = holder.state().item();
        ItemMeta meta = requested.getItemMeta();
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(String.valueOf(ChatColor.GRAY) + "Price per Item: " + String.valueOf(ChatColor.GOLD) + this.formatPrice(holder.state().pricePerItem()));
        Double recommended = holder.state().recommendedPricePerItem();
        if (recommended != null) {
            lore.add(String.valueOf(ChatColor.GRAY) + "Recommended per Item: " + String.valueOf(ChatColor.GOLD) + this.formatPrice(recommended));
            double recommendedTotal = EconomyUtils.normalizeCurrency(recommended * (double)holder.state().quantity());
            lore.add(String.valueOf(ChatColor.GRAY) + "Recommended Total: " + String.valueOf(ChatColor.GOLD) + this.formatPrice(recommendedTotal));
        }
        lore.add(String.valueOf(ChatColor.GRAY) + "Requested Quantity: " + String.valueOf(ChatColor.AQUA) + holder.state().quantity());
        lore.add(String.valueOf(ChatColor.GRAY) + "Total Offer: " + String.valueOf(ChatColor.GOLD) + this.formatPrice(holder.state().totalPrice()));
        lore.add(String.valueOf(ChatColor.GRAY) + "Duration: " + String.valueOf(ChatColor.YELLOW) + this.formatDuration(holder.state().duration()));
        lore.add(" ");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Confirm below to create the buy order.");
        if (meta != null) {
            List existingLore = meta.hasLore() ? meta.getLore() : List.of();
            ArrayList<Object> combined = new ArrayList<Object>(existingLore);
            if (!combined.isEmpty()) {
                combined.add(" ");
            }
            combined.addAll(lore);
            meta.setLore(combined);
            requested.setItemMeta(meta);
        }
        inventory.setItem(this.layout.itemSlot(), requested);
        ItemStack priceDisplay = this.createPriceDisplay(holder);
        inventory.setItem(this.layout.priceDisplay().slot(), priceDisplay);
        ItemStack quantityDisplay = this.createQuantityDisplay(holder);
        this.setPersistent(quantityDisplay, this.actionKey, ACTION_QUANTITY_CUSTOM);
        inventory.setItem(this.layout.quantityDisplay().slot(), quantityDisplay);
        ItemStack durationDisplay = this.createDurationDisplay(holder);
        this.setPersistent(durationDisplay, this.actionKey, ACTION_DURATION_NEXT);
        inventory.setItem(this.layout.durationDisplay().slot(), durationDisplay);
        ItemStack customPrice = this.createCustomPriceButton();
        this.setPersistent(customPrice, this.actionKey, ACTION_PRICE_CUSTOM);
        inventory.setItem(this.layout.customPrice().slot(), customPrice);
        ItemStack confirm = this.createConfirmButton(holder);
        this.setPersistent(confirm, this.actionKey, ACTION_CONFIRM);
        inventory.setItem(this.layout.confirmButton().slot(), confirm);
        ItemStack cancel = this.createCancelButton();
        this.setPersistent(cancel, this.actionKey, ACTION_CANCEL);
        inventory.setItem(this.layout.cancelButton().slot(), cancel);
    }

    private void placePriceAdjustmentButtons(Inventory inventory) {
        double[] adjustments = this.priceAdjustments;
        int[] slots = this.layout.priceAdjustmentSlots();
        for (int i = 0; i < adjustments.length && i < slots.length; ++i) {
            double amount = adjustments[i];
            if (amount == 0.0) continue;
            ItemStack button = this.createPriceAdjustButton(amount);
            this.setPersistent(button, this.actionKey, ACTION_PRICE_ADJUST);
            this.setPersistent(button, this.priceAdjustKey, amount);
            inventory.setItem(slots[i], button);
        }
    }

    private void placeQuantityAdjustmentButtons(Inventory inventory) {
        int[] adjustments = this.quantityAdjustments;
        int[] slots = this.layout.quantityAdjustmentSlots();
        for (int i = 0; i < adjustments.length && i < slots.length; ++i) {
            int amount = adjustments[i];
            if (amount == 0) continue;
            ItemStack button = this.createQuantityAdjustButton(amount);
            this.setPersistent(button, this.actionKey, ACTION_QUANTITY_ADJUST);
            this.setPersistent(button, this.quantityAdjustKey, amount);
            inventory.setItem(slots[i], button);
        }
    }

    private ItemStack createBaseItem(AuctionMenuInteractionConfiguration.MenuButtonDefinition definition) {
        ItemMeta meta;
        ItemStack item;
        Material material = Material.GRAY_STAINED_GLASS_PANE;
        String displayName = null;
        if (definition != null) {
            Material configured = definition.material();
            if (configured != null) {
                material = configured;
            }
            displayName = definition.displayName();
        }
        ItemStack itemStack = item = material != null ? new ItemStack(material) : null;
        if (item == null) {
            item = new ItemStack(Material.STONE);
        }
        if ((meta = item.getItemMeta()) != null) {
            if (displayName != null && !displayName.isEmpty()) {
                meta.setDisplayName(this.colorize(displayName));
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createPriceDisplay(OrderMenuHolder holder) {
        AuctionMenuInteractionConfiguration.ButtonLayoutConfiguration definition = this.layout.priceDisplay();
        ItemStack item = this.createBaseItem(definition.button());
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            String displayName = definition.button().displayName();
            if (displayName != null && !displayName.isEmpty()) {
                meta.setDisplayName(this.colorize(displayName));
            }
            ArrayList<CallSite> lore = new ArrayList<CallSite>();
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Price per Item: " + String.valueOf(ChatColor.GOLD) + this.formatPrice(holder.state().pricePerItem()))));
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Total Offer: " + String.valueOf(ChatColor.GOLD) + this.formatPrice(holder.state().totalPrice()))));
            Double recommended = holder.state().recommendedPricePerItem();
            if (recommended != null) {
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Recommended per Item: " + String.valueOf(ChatColor.GOLD) + this.formatPrice(recommended))));
                double recommendedTotal = EconomyUtils.normalizeCurrency(recommended * (double)holder.state().quantity());
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Recommended Total: " + String.valueOf(ChatColor.GOLD) + this.formatPrice(recommendedTotal))));
            }
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Use the buttons above to adjust.")));
            if (this.minimumPricePerItem > 0.0) {
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Minimum Price: " + String.valueOf(ChatColor.GOLD) + this.formatPrice(this.minimumPricePerItem))));
            }
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createQuantityDisplay(OrderMenuHolder holder) {
        AuctionMenuInteractionConfiguration.ButtonLayoutConfiguration definition = this.layout.quantityDisplay();
        ItemStack item = this.createBaseItem(definition.button());
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            String displayName = definition.button().displayName();
            if (displayName != null && !displayName.isEmpty()) {
                meta.setDisplayName(this.colorize(displayName));
            }
            ArrayList<CallSite> lore = new ArrayList<CallSite>();
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Current Quantity: " + String.valueOf(ChatColor.AQUA) + holder.state().quantity())));
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Max Stack Size: " + String.valueOf(ChatColor.AQUA) + holder.state().maxQuantity())));
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Use the buttons around to adjust.")));
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Click to enter a custom amount.")));
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createDurationDisplay(OrderMenuHolder holder) {
        AuctionMenuInteractionConfiguration.ButtonLayoutConfiguration definition = this.layout.durationDisplay();
        ItemStack item = this.createBaseItem(definition.button());
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            String displayName = definition.button().displayName();
            if (displayName != null && !displayName.isEmpty()) {
                meta.setDisplayName(this.colorize(displayName));
            }
            ArrayList<CallSite> lore = new ArrayList<CallSite>();
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Current Duration: " + String.valueOf(ChatColor.YELLOW) + this.formatDuration(holder.state().duration()))));
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Click to cycle through available durations.")));
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Longest Option: " + String.valueOf(ChatColor.YELLOW) + this.formatDuration(this.longestDurationOption))));
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createPriceAdjustButton(double amount) {
        ItemMeta meta;
        ItemStack item;
        boolean positive = amount > 0.0;
        Material material = positive ? Material.LIME_CONCRETE : Material.RED_CONCRETE;
        String prefix = positive ? String.valueOf(ChatColor.GREEN) + "+" : String.valueOf(ChatColor.RED);
        ItemStack itemStack = item = material != null ? new ItemStack(material) : null;
        if (item == null) {
            item = new ItemStack(Material.STONE);
        }
        if ((meta = item.getItemMeta()) != null) {
            String label = prefix + this.formatPrice(Math.abs(amount));
            meta.setDisplayName(label);
            ArrayList<CallSite> lore = new ArrayList<CallSite>();
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Adjust the price per item by this amount.")));
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createQuantityAdjustButton(int amount) {
        ItemMeta meta;
        ItemStack item;
        boolean positive = amount > 0;
        Material material = positive ? Material.LIME_STAINED_GLASS_PANE : Material.RED_STAINED_GLASS_PANE;
        ItemStack itemStack = item = material != null ? new ItemStack(material) : null;
        if (item == null) {
            item = new ItemStack(Material.STONE);
        }
        if ((meta = item.getItemMeta()) != null) {
            String label = (positive ? String.valueOf(ChatColor.GREEN) + "+" : String.valueOf(ChatColor.RED)) + Math.abs(amount);
            meta.setDisplayName(label + String.valueOf(ChatColor.GRAY) + " quantity");
            ArrayList<CallSite> lore = new ArrayList<CallSite>();
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Adjust the requested quantity by this amount.")));
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createCustomPriceButton() {
        AuctionMenuInteractionConfiguration.ButtonLayoutConfiguration definition = this.layout.customPrice();
        ItemStack item = this.createBaseItem(definition.button());
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            String displayName = definition.button().displayName();
            if (displayName != null && !displayName.isEmpty()) {
                meta.setDisplayName(this.colorize(displayName));
            }
            meta.setLore(List.of(String.valueOf(ChatColor.GRAY) + "Enter a custom price per item."));
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createConfirmButton(OrderMenuHolder holder) {
        AuctionMenuInteractionConfiguration.ButtonLayoutConfiguration definition = this.layout.confirmButton();
        ItemStack item = this.createBaseItem(definition.button());
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            String displayName = definition.button().displayName();
            if (displayName != null && !displayName.isEmpty()) {
                meta.setDisplayName(this.colorize(displayName));
            }
            ArrayList<CallSite> lore = new ArrayList<CallSite>();
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Request: " + String.valueOf(ChatColor.AQUA) + this.describeItem(holder.state().item()))));
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Quantity: " + String.valueOf(ChatColor.AQUA) + holder.state().quantity())));
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Total Offer: " + String.valueOf(ChatColor.GOLD) + this.formatPrice(holder.state().totalPrice()))));
            Double recommended = holder.state().recommendedPricePerItem();
            if (recommended != null) {
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Recommended per Item: " + String.valueOf(ChatColor.GOLD) + this.formatPrice(recommended))));
                double recommendedTotal = EconomyUtils.normalizeCurrency(recommended * (double)holder.state().quantity());
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Recommended Total: " + String.valueOf(ChatColor.GOLD) + this.formatPrice(recommendedTotal))));
            }
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Duration: " + String.valueOf(ChatColor.YELLOW) + this.formatDuration(holder.state().duration()))));
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createCancelButton() {
        AuctionMenuInteractionConfiguration.ButtonLayoutConfiguration definition = this.layout.cancelButton();
        ItemStack item = this.createBaseItem(definition.button());
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            String displayName = definition.button().displayName();
            if (displayName != null && !displayName.isEmpty()) {
                meta.setDisplayName(this.colorize(displayName));
            }
            meta.setLore(List.of(String.valueOf(ChatColor.GRAY) + "Return to the previous menu."));
            item.setItemMeta(meta);
        }
        return item;
    }

    private void applyFiller(Inventory inventory) {
        if (this.fillerPane == null) {
            return;
        }
        for (int i = 0; i < inventory.getSize(); ++i) {
            if (inventory.getItem(i) != null) continue;
            inventory.setItem(i, this.fillerPane.clone());
        }
    }

    private String colorize(String input) {
        if (input == null) {
            return "";
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)input);
    }

    private void sendMessage(Player player, String message) {
        if (player == null || message == null || message.isEmpty()) {
            return;
        }
        player.sendMessage(this.colorize(message));
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        Inventory topInventory = event.getView().getTopInventory();
        InventoryHolder inventoryHolder = topInventory.getHolder();
        if (!(inventoryHolder instanceof OrderMenuHolder)) {
            return;
        }
        OrderMenuHolder holder = (OrderMenuHolder)inventoryHolder;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!holder.owner().equals(player.getUniqueId())) {
            return;
        }
        int topSize = topInventory.getSize();
        boolean affectsTop = event.getRawSlots().stream().anyMatch(slot -> slot < topSize);
        if (affectsTop) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (!(inventoryHolder instanceof OrderMenuHolder)) {
            return;
        }
        OrderMenuHolder holder = (OrderMenuHolder)inventoryHolder;
        if (!Objects.equals(holder.owner(), event.getWhoClicked().getUniqueId())) {
            return;
        }
        event.setCancelled(true);
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        String action = this.itemTagStorage.getString(clicked, this.actionKey);
        if (action == null) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        switch (action) {
            case "price_adjust": {
                this.handlePriceAdjust(player, holder, clicked);
                break;
            }
            case "price_custom": {
                this.startCustomPriceInput(player, holder);
                break;
            }
            case "quantity_adjust": {
                this.handleQuantityAdjust(player, holder, clicked);
                break;
            }
            case "quantity_custom": {
                this.startCustomQuantityInput(player, holder);
                break;
            }
            case "duration_next": {
                holder.state().cycleDuration();
                this.refreshMenu(holder);
                break;
            }
            case "confirm": {
                this.handleConfirm(player, holder);
                break;
            }
            case "cancel": {
                player.closeInventory();
                break;
            }
        }
    }

    private void handlePriceAdjust(Player player, OrderMenuHolder holder, ItemStack clicked) {
        Double amount = this.itemTagStorage.getDouble(clicked, this.priceAdjustKey);
        if (amount == null) {
            return;
        }
        double newPrice = EconomyUtils.normalizeCurrency(holder.state().pricePerItem() + amount);
        if (newPrice < this.minimumPricePerItem) {
            newPrice = this.minimumPricePerItem;
        }
        holder.state().setPricePerItem(newPrice);
        this.refreshMenu(holder);
    }

    private void handleQuantityAdjust(Player player, OrderMenuHolder holder, ItemStack clicked) {
        Integer amount = this.itemTagStorage.getInt(clicked, this.quantityAdjustKey);
        if (amount == null) {
            return;
        }
        holder.state().adjustQuantity(amount);
        this.refreshMenu(holder);
    }

    private void startCustomPriceInput(Player player, OrderMenuHolder holder) {
        UUID playerId = player.getUniqueId();
        this.pendingPriceInputs.put(playerId, holder.state());
        this.pendingQuantityInputs.remove(playerId);
        player.closeInventory();
        this.sendMessage(player, this.messages.pricePrompt());
    }

    private void startCustomQuantityInput(Player player, OrderMenuHolder holder) {
        UUID playerId = player.getUniqueId();
        this.pendingQuantityInputs.put(playerId, holder.state());
        this.pendingPriceInputs.remove(playerId);
        player.closeInventory();
        this.sendMessage(player, this.messages.quantityPrompt());
    }

    private void handleConfirm(Player player, OrderMenuHolder holder) {
        if (!player.hasPermission("ezauction.auction.order")) {
            this.sendMessage(player, this.messages.noPermission());
            player.closeInventory();
            return;
        }
        OrderMenuState state = holder.state();
        if (state.quantity() <= 0) {
            this.sendMessage(player, this.messages.quantityMinimum());
            this.refreshMenu(holder);
            return;
        }
        if (state.pricePerItem() < this.minimumPricePerItem) {
            this.sendMessage(player, this.messages.priceMinimum().replace("{minimum}", this.formatPrice(this.minimumPricePerItem)));
            this.refreshMenu(holder);
            return;
        }
        double total = EconomyUtils.normalizeCurrency(state.totalPrice());
        if (total <= 0.0) {
            this.sendMessage(player, this.messages.totalMustBePositive());
            this.refreshMenu(holder);
            return;
        }
        AuctionOperationResult result = this.auctionManager.createOrder(player, state.item(), total, state.duration(), total);
        if (result.message() != null && !result.message().isEmpty()) {
            player.sendMessage(result.message());
        }
        if (result.success()) {
            player.closeInventory();
        } else {
            this.refreshMenu(holder);
        }
    }

    @EventHandler
    public void onAsyncPlayerChat(AsyncPlayerChatEvent event) {
        UUID playerId = event.getPlayer().getUniqueId();
        OrderMenuState priceState = (OrderMenuState)this.pendingPriceInputs.get(playerId);
        OrderMenuState quantityState = (OrderMenuState)this.pendingQuantityInputs.get(playerId);
        if (priceState == null && quantityState == null) {
            return;
        }
        event.setCancelled(true);
        this.pendingPriceInputs.remove(playerId);
        this.pendingQuantityInputs.remove(playerId);
        OrderMenuState targetState = priceState != null ? priceState : quantityState;
        boolean updatingPrice = priceState != null;
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.handleChatInput(event.getPlayer(), targetState, event.getMessage(), updatingPrice));
    }

    private void handleChatInput(Player player, OrderMenuState state, String message, boolean updatingPrice) {
        String input;
        if (player == null || state == null) {
            return;
        }
        String string = input = message == null ? "" : message.trim();
        if (input.equalsIgnoreCase(ACTION_CANCEL)) {
            this.sendMessage(player, this.messages.entryCancelled());
            this.openOrderMenu(player, state);
            return;
        }
        if (updatingPrice) {
            double value;
            try {
                value = NumberShortcutParser.parse(input);
            }
            catch (IllegalArgumentException ex) {
                this.sendMessage(player, this.messages.invalidNumber());
                this.openOrderMenu(player, state);
                return;
            }
            if (value <= 0.0) {
                this.sendMessage(player, this.messages.priceMustBePositive());
                this.openOrderMenu(player, state);
                return;
            }
            double normalized = EconomyUtils.normalizeCurrency(value);
            if (normalized < this.minimumPricePerItem) {
                normalized = this.minimumPricePerItem;
            }
            state.setPricePerItem(normalized);
            this.sendMessage(player, this.messages.priceUpdated().replace("{price}", this.formatPrice(normalized)));
            this.openOrderMenu(player, state);
        } else {
            int quantity;
            try {
                quantity = (int)NumberShortcutParser.parse(input);
            }
            catch (IllegalArgumentException ex) {
                this.sendMessage(player, this.messages.wholeNumberRequired());
                this.openOrderMenu(player, state);
                return;
            }
            if (quantity <= 0) {
                this.sendMessage(player, this.messages.quantityMinimum());
                this.openOrderMenu(player, state);
                return;
            }
            state.setQuantity(quantity);
            this.sendMessage(player, this.messages.quantityUpdated().replace("{quantity}", String.valueOf(state.quantity())));
            this.openOrderMenu(player, state);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        UUID playerId = event.getPlayer().getUniqueId();
        this.pendingPriceInputs.remove(playerId);
        this.pendingQuantityInputs.remove(playerId);
    }

    private Duration[] buildDurationOptions(AuctionListingRules rules, List<Duration> configuredOptions) {
        Objects.requireNonNull(rules, "rules");
        TreeSet<Long> minutes = new TreeSet<Long>();
        boolean usedConfigured = false;
        if (configuredOptions != null) {
            for (Duration duration : configuredOptions) {
                Duration sanitized;
                if (duration == null || duration.isNegative() || duration.isZero() || (sanitized = rules.clampDuration(duration)) == null || sanitized.isNegative() || sanitized.isZero()) continue;
                minutes.add(Math.max(1L, sanitized.toMinutes()));
                usedConfigured = true;
            }
        }
        if (!usedConfigured) {
            Duration maxDuration;
            Duration[] defaults;
            for (Duration candidate : defaults = new Duration[]{Duration.ofHours(6L), Duration.ofHours(12L), Duration.ofHours(24L), Duration.ofHours(48L)}) {
                Duration sanitized = rules.clampDuration(candidate);
                if (sanitized == null || sanitized.isNegative() || sanitized.isZero()) continue;
                minutes.add(Math.max(1L, sanitized.toMinutes()));
            }
            Duration duration = rules.clampDuration(rules.defaultDuration());
            if (duration != null && !duration.isNegative() && !duration.isZero()) {
                minutes.add(Math.max(1L, duration.toMinutes()));
            }
            if ((maxDuration = rules.maxDuration()) != null && !maxDuration.isNegative() && !maxDuration.isZero()) {
                minutes.add(Math.max(1L, maxDuration.toMinutes()));
            }
        }
        if (minutes.isEmpty()) {
            minutes.add(Math.max(1L, Duration.ofHours(24L).toMinutes()));
        }
        Duration[] options = new Duration[minutes.size()];
        boolean bl = false;
        for (Long minute : minutes) {
            options[++var6_11] = Duration.ofMinutes(Math.max(1L, minute));
        }
        return options;
    }

    private Duration resolveLongestDuration(Duration[] options, AuctionListingRules rules) {
        Duration fallback;
        if (options != null && options.length > 0) {
            return options[options.length - 1];
        }
        Duration duration = fallback = rules != null ? rules.maxDuration() : null;
        if (fallback == null || fallback.isNegative() || fallback.isZero()) {
            Duration duration2 = fallback = rules != null ? rules.defaultDuration() : null;
        }
        if (fallback == null || fallback.isNegative() || fallback.isZero()) {
            fallback = Duration.ofHours(24L);
        }
        return fallback;
    }

    private int resolveDefaultDurationIndex(Duration[] options, Duration defaultDuration) {
        if (options == null || options.length == 0 || defaultDuration == null) {
            return 0;
        }
        long targetMinutes = Math.max(1L, defaultDuration.toMinutes());
        for (int i = 0; i < options.length; ++i) {
            if (options[i] == null || Math.max(1L, options[i].toMinutes()) != targetMinutes) continue;
            return i;
        }
        return 0;
    }

    private void setPersistent(ItemStack item, String key, String value) {
        if (item == null || key == null || value == null) {
            return;
        }
        this.itemTagStorage.setString(item, key, value);
    }

    private void setPersistent(ItemStack item, String key, double value) {
        if (item == null || key == null) {
            return;
        }
        this.itemTagStorage.setDouble(item, key, value);
    }

    private void setPersistent(ItemStack item, String key, int value) {
        if (item == null || key == null) {
            return;
        }
        this.itemTagStorage.setInt(item, key, value);
    }

    private String formatPrice(double price) {
        return this.transactionService.formatCurrency(price);
    }

    private String formatDuration(Duration duration) {
        long totalMinutes = duration.toMinutes();
        long days = totalMinutes / 1440L;
        long hours = (totalMinutes %= 1440L) / 60L;
        long minutes = totalMinutes % 60L;
        ArrayList<Object> parts = new ArrayList<Object>();
        if (days > 0L) {
            parts.add(days + "d");
        }
        if (hours > 0L) {
            parts.add(hours + "h");
        }
        if (minutes > 0L && days == 0L) {
            parts.add(minutes + "m");
        }
        if (parts.isEmpty()) {
            parts.add("0m");
        }
        return String.join((CharSequence)" ", parts);
    }

    private String describeItem(ItemStack item) {
        if (item == null) {
            return "Unknown";
        }
        ItemMeta meta = item.getItemMeta();
        if (meta != null && meta.hasDisplayName()) {
            return ChatColor.stripColor((String)meta.getDisplayName());
        }
        return this.formatMaterialName(item.getType());
    }

    private String formatMaterialName(Material material) {
        if (material == null) {
            return "Unknown";
        }
        String[] parts = material.name().toLowerCase(Locale.ENGLISH).split("_");
        StringBuilder builder = new StringBuilder();
        for (String part : parts) {
            if (part.isEmpty()) continue;
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append(Character.toUpperCase(part.charAt(0))).append(part.substring(1));
        }
        return builder.toString();
    }

    private final class OrderMenuState {
        private final ItemStack template;
        private final int maxQuantity;
        private double pricePerItem;
        private int quantity;
        private int durationIndex;
        private final Double recommendedPricePerItem;

        private OrderMenuState(ItemStack template, double pricePerItem, int quantity, int durationIndex, Double recommendedPricePerItem) {
            this.template = template.clone();
            this.template.setAmount(1);
            this.maxQuantity = Math.max(1, template.getMaxStackSize());
            this.pricePerItem = pricePerItem;
            this.setQuantity(quantity);
            this.durationIndex = this.normalizeIndex(durationIndex);
            this.recommendedPricePerItem = recommendedPricePerItem;
        }

        public ItemStack item() {
            ItemStack clone = this.template.clone();
            clone.setAmount(this.quantity);
            return clone;
        }

        public double pricePerItem() {
            return this.pricePerItem;
        }

        public void setPricePerItem(double pricePerItem) {
            this.pricePerItem = pricePerItem;
        }

        public Double recommendedPricePerItem() {
            return this.recommendedPricePerItem;
        }

        public int quantity() {
            return this.quantity;
        }

        public void setQuantity(int quantity) {
            int clamped;
            this.quantity = clamped = Math.max(1, Math.min(quantity, this.maxQuantity));
        }

        public void adjustQuantity(int delta) {
            this.setQuantity(this.quantity + delta);
        }

        public int maxQuantity() {
            return this.maxQuantity;
        }

        public double totalPrice() {
            return this.pricePerItem * (double)this.quantity;
        }

        public Duration duration() {
            if (AuctionOrderMenu.this.durationOptions.length == 0) {
                return AuctionOrderMenu.this.listingRules.defaultDuration();
            }
            return AuctionOrderMenu.this.durationOptions[this.durationIndex];
        }

        public void cycleDuration() {
            if (AuctionOrderMenu.this.durationOptions.length == 0) {
                return;
            }
            this.durationIndex = (this.durationIndex + 1) % AuctionOrderMenu.this.durationOptions.length;
        }

        private int normalizeIndex(int requested) {
            if (AuctionOrderMenu.this.durationOptions.length == 0) {
                return 0;
            }
            if (requested < 0 || requested >= AuctionOrderMenu.this.durationOptions.length) {
                return Math.min(AuctionOrderMenu.this.defaultDurationIndex, AuctionOrderMenu.this.durationOptions.length - 1);
            }
            return requested;
        }
    }

    private static final class OrderMenuHolder
    extends AbstractOrderHolder {
        private final OrderMenuState state;

        private OrderMenuHolder(UUID owner, OrderMenuState state) {
            super(owner);
            this.state = state;
        }

        public OrderMenuState state() {
            return this.state;
        }
    }

    private static abstract class AbstractOrderHolder
    implements InventoryHolder {
        private final UUID owner;
        private Inventory inventory;

        protected AbstractOrderHolder(UUID owner) {
            this.owner = owner;
        }

        public UUID owner() {
            return this.owner;
        }

        public void setInventory(Inventory inventory) {
            this.inventory = inventory;
        }

        public Inventory getInventory() {
            return this.inventory;
        }
    }
}

