/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.gui;

import com.skyblockexp.ezauction.gui.AuctionHistoryGUI;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;

public class AuctionHistoryListener
implements Listener {
    private final Map<UUID, AuctionHistoryGUI> guiMap = new ConcurrentHashMap<UUID, AuctionHistoryGUI>();

    public void registerGUI(Player player, AuctionHistoryGUI gui) {
        this.guiMap.put(player.getUniqueId(), gui);
    }

    public void unregisterGUI(Player player) {
        this.guiMap.remove(player.getUniqueId());
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Inventory inv = event.getInventory();
        if (inv == null || inv.getHolder() != null) {
            return;
        }
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        String title = event.getView().getTitle();
        if (!title.startsWith("Auction History")) {
            return;
        }
        int slot = event.getRawSlot();
        event.setCancelled(true);
        AuctionHistoryGUI gui = this.guiMap.get(player.getUniqueId());
        if (gui == null) {
            return;
        }
        if (slot == 48) {
            gui.open(AuctionHistoryGUI.Tab.SALES);
        } else if (slot == 50) {
            gui.open(AuctionHistoryGUI.Tab.PURCHASES);
        } else if (slot == 49) {
            player.closeInventory();
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Inventory inv = event.getInventory();
        if (inv == null || inv.getHolder() != null) {
            return;
        }
        String title = event.getView().getTitle();
        if (!title.startsWith("Auction History")) {
            return;
        }
        this.unregisterGUI(player);
    }
}

