/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.gui;

import com.skyblockexp.ezauction.transaction.AuctionTransactionHistory;
import com.skyblockexp.ezauction.transaction.AuctionTransactionHistoryEntry;
import com.skyblockexp.ezauction.transaction.AuctionTransactionType;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AuctionHistoryGUI {
    private final Player viewer;
    private final Player target;
    private final boolean canViewOthers;
    private final AuctionTransactionHistory historyService;
    private Inventory gui;
    private Tab currentTab = Tab.SALES;

    public AuctionHistoryGUI(Player viewer, Player target, boolean canViewOthers, AuctionTransactionHistory historyService) {
        this.viewer = viewer;
        this.target = target;
        this.canViewOthers = canViewOthers;
        this.historyService = historyService;
        this.createGUI(Tab.SALES);
    }

    private void createGUI(Tab tab) {
        ItemStack salesTab;
        ItemMeta salesMeta;
        String title = tab == Tab.SALES ? "Auction History - Sales" : "Auction History - Purchases";
        this.gui = Bukkit.createInventory(null, (int)54, (String)title);
        this.currentTab = tab;
        List<AuctionTransactionHistoryEntry> entries = this.historyService.getHistory(this.target.getUniqueId());
        AuctionTransactionType filterType = tab == Tab.SALES ? AuctionTransactionType.SELL : AuctionTransactionType.BUY;
        int slot = 0;
        for (AuctionTransactionHistoryEntry entry : entries) {
            if (entry.type() != filterType) continue;
            if (slot >= 45) break;
            ItemStack item = entry.item() != null ? entry.item().clone() : new ItemStack(Material.PAPER);
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                meta.setDisplayName((tab == Tab.SALES ? "Sold to " : "Bought from ") + entry.counterpartName());
                meta.setLore(List.of("Price: " + entry.price(), "Date: " + new SimpleDateFormat("MMM d, h:mm a").format(new Date(entry.timestamp()))));
                item.setItemMeta(meta);
            }
            this.gui.setItem(slot++, item);
        }
        if ((salesMeta = (salesTab = new ItemStack(Material.CHEST)).getItemMeta()) != null) {
            salesMeta.setDisplayName("\u00a7eSales");
            salesTab.setItemMeta(salesMeta);
        }
        this.gui.setItem(48, salesTab);
        ItemStack purchasesTab = new ItemStack(Material.EMERALD);
        ItemMeta purchasesMeta = purchasesTab.getItemMeta();
        if (purchasesMeta != null) {
            purchasesMeta.setDisplayName("\u00a7aPurchases");
            purchasesTab.setItemMeta(purchasesMeta);
        }
        this.gui.setItem(50, purchasesTab);
        ItemStack close = new ItemStack(Material.BARRIER);
        ItemMeta closeMeta = close.getItemMeta();
        if (closeMeta != null) {
            closeMeta.setDisplayName("\u00a7cClose");
            close.setItemMeta(closeMeta);
        }
        this.gui.setItem(49, close);
    }

    public void open(Tab tab) {
        this.createGUI(tab);
        this.viewer.openInventory(this.gui);
    }

    public static enum Tab {
        SALES,
        PURCHASES;

    }
}

