/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.config;

import java.util.Objects;
import org.bukkit.configuration.ConfigurationSection;

public final class LiveAuctionConfiguration {
    private final boolean enabled;
    private final boolean queueEnabled;
    private final boolean displayInChat;
    private final long announcementIntervalTicks;

    public LiveAuctionConfiguration(boolean enabled, boolean queueEnabled, boolean displayInChat, long announcementIntervalTicks) {
        this.enabled = enabled;
        this.queueEnabled = queueEnabled;
        this.displayInChat = displayInChat;
        this.announcementIntervalTicks = Math.max(0L, announcementIntervalTicks);
    }

    public boolean enabled() {
        return this.enabled;
    }

    public boolean queueEnabled() {
        return this.queueEnabled;
    }

    public boolean displayInChat() {
        return this.displayInChat;
    }

    public long announcementIntervalTicks() {
        return this.announcementIntervalTicks;
    }

    public static LiveAuctionConfiguration defaults() {
        return new LiveAuctionConfiguration(false, true, true, 200L);
    }

    public static LiveAuctionConfiguration from(ConfigurationSection section) {
        if (section == null) {
            return LiveAuctionConfiguration.defaults();
        }
        boolean enabled = section.getBoolean("enabled", false);
        boolean queueEnabled = section.getBoolean("queue-enabled", true);
        boolean displayInChat = section.getBoolean("display-in-chat", true);
        long interval = section.getLong("announcement-interval-ticks", 200L);
        return new LiveAuctionConfiguration(enabled, queueEnabled, displayInChat, interval);
    }

    public String toString() {
        return "LiveAuctionConfiguration{enabled=" + this.enabled + ", queueEnabled=" + this.queueEnabled + ", displayInChat=" + this.displayInChat + ", announcementIntervalTicks=" + this.announcementIntervalTicks + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LiveAuctionConfiguration)) {
            return false;
        }
        LiveAuctionConfiguration that = (LiveAuctionConfiguration)o;
        return this.enabled == that.enabled && this.queueEnabled == that.queueEnabled && this.displayInChat == that.displayInChat && this.announcementIntervalTicks == that.announcementIntervalTicks;
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.queueEnabled, this.displayInChat, this.announcementIntervalTicks);
    }
}

