/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.config;

import com.skyblockexp.ezauction.config.AuctionBackendMessages;
import com.skyblockexp.ezauction.config.AuctionCommandMessageConfiguration;
import com.skyblockexp.ezauction.config.AuctionHologramConfiguration;
import com.skyblockexp.ezauction.config.AuctionListingRules;
import com.skyblockexp.ezauction.config.AuctionMenuConfiguration;
import com.skyblockexp.ezauction.config.AuctionMenuInteractionConfiguration;
import com.skyblockexp.ezauction.config.AuctionMessageConfiguration;
import com.skyblockexp.ezauction.config.AuctionStorageConfiguration;
import com.skyblockexp.ezauction.config.AuctionValueConfiguration;
import com.skyblockexp.ezauction.config.LiveAuctionConfiguration;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class AuctionConfiguration {
    private final boolean debug;
    private final int baseListingLimit;
    private final AuctionStorageConfiguration storageConfiguration;
    private final AuctionListingRules listingRules;
    private final AuctionMenuConfiguration menuConfiguration;
    private final AuctionMenuInteractionConfiguration menuInteractionConfiguration;
    private final AuctionValueConfiguration valueConfiguration;
    private final AuctionMessageConfiguration messageConfiguration;
    private final AuctionBackendMessages backendMessages;
    private final AuctionCommandMessageConfiguration commandMessageConfiguration;
    private final AuctionHologramConfiguration hologramConfiguration;
    private final LiveAuctionConfiguration liveAuctionConfiguration;
    private final List<Duration> durationOptions;

    public AuctionConfiguration(int baseListingLimit, AuctionStorageConfiguration storageConfiguration, AuctionListingRules listingRules, AuctionMenuConfiguration menuConfiguration, AuctionMenuInteractionConfiguration menuInteractionConfiguration, AuctionValueConfiguration valueConfiguration, AuctionMessageConfiguration messageConfiguration, AuctionBackendMessages backendMessages, AuctionCommandMessageConfiguration commandMessageConfiguration, AuctionHologramConfiguration hologramConfiguration, LiveAuctionConfiguration liveAuctionConfiguration, List<Duration> durationOptions, boolean debug) {
        this.baseListingLimit = Math.max(0, baseListingLimit);
        this.storageConfiguration = storageConfiguration != null ? storageConfiguration : AuctionStorageConfiguration.yaml();
        this.listingRules = listingRules != null ? listingRules : AuctionListingRules.defaults();
        this.menuConfiguration = menuConfiguration != null ? menuConfiguration : AuctionMenuConfiguration.defaults();
        this.menuInteractionConfiguration = menuInteractionConfiguration != null ? menuInteractionConfiguration : AuctionMenuInteractionConfiguration.defaults();
        this.valueConfiguration = valueConfiguration != null ? valueConfiguration : AuctionValueConfiguration.defaults();
        this.messageConfiguration = messageConfiguration != null ? messageConfiguration : AuctionMessageConfiguration.defaults();
        this.backendMessages = backendMessages != null ? backendMessages : AuctionBackendMessages.defaults();
        this.commandMessageConfiguration = commandMessageConfiguration != null ? commandMessageConfiguration : AuctionCommandMessageConfiguration.defaults();
        this.hologramConfiguration = hologramConfiguration != null ? hologramConfiguration : AuctionHologramConfiguration.defaults();
        this.liveAuctionConfiguration = liveAuctionConfiguration != null ? liveAuctionConfiguration : LiveAuctionConfiguration.defaults();
        this.durationOptions = AuctionConfiguration.sanitizeDurationOptions(durationOptions);
        this.debug = debug;
    }

    public boolean debug() {
        return this.debug;
    }

    public int baseListingLimit() {
        return this.baseListingLimit;
    }

    public AuctionStorageConfiguration storageConfiguration() {
        return this.storageConfiguration;
    }

    public AuctionListingRules listingRules() {
        return this.listingRules;
    }

    public AuctionMenuConfiguration menuConfiguration() {
        return this.menuConfiguration;
    }

    public AuctionMenuInteractionConfiguration menuInteractionConfiguration() {
        return this.menuInteractionConfiguration;
    }

    public AuctionValueConfiguration valueConfiguration() {
        return this.valueConfiguration;
    }

    public AuctionMessageConfiguration messageConfiguration() {
        return this.messageConfiguration;
    }

    public AuctionBackendMessages backendMessages() {
        return this.backendMessages;
    }

    public AuctionCommandMessageConfiguration commandMessageConfiguration() {
        return this.commandMessageConfiguration;
    }

    public AuctionHologramConfiguration hologramConfiguration() {
        return this.hologramConfiguration;
    }

    public LiveAuctionConfiguration liveAuctionConfiguration() {
        return this.liveAuctionConfiguration;
    }

    public List<Duration> durationOptions() {
        return this.durationOptions;
    }

    public static AuctionConfiguration defaultConfiguration() {
        return new AuctionConfiguration(0, AuctionStorageConfiguration.yaml(), AuctionListingRules.defaults(), AuctionMenuConfiguration.defaults(), AuctionMenuInteractionConfiguration.defaults(), AuctionValueConfiguration.defaults(), AuctionMessageConfiguration.defaults(), AuctionBackendMessages.defaults(), AuctionCommandMessageConfiguration.defaults(), AuctionHologramConfiguration.defaults(), LiveAuctionConfiguration.defaults(), List.of(), false);
    }

    public boolean isHistoryGuiEnabled() {
        if (this.menuConfiguration != null) {
            return this.menuConfiguration.historyGuiEnabled();
        }
        return true;
    }

    public String toString() {
        return "AuctionConfiguration{baseListingLimit=" + this.baseListingLimit + ", storageConfiguration=" + String.valueOf(this.storageConfiguration) + ", listingRules=" + String.valueOf(this.listingRules) + ", menuConfiguration=" + String.valueOf(this.menuConfiguration) + ", menuInteractionConfiguration=" + String.valueOf(this.menuInteractionConfiguration) + ", valueConfiguration=" + String.valueOf(this.valueConfiguration) + ", messageConfiguration=" + String.valueOf(this.messageConfiguration) + ", backendMessages=" + String.valueOf(this.backendMessages) + ", commandMessageConfiguration=" + String.valueOf(this.commandMessageConfiguration) + ", hologramConfiguration=" + String.valueOf(this.hologramConfiguration) + ", liveAuctionConfiguration=" + String.valueOf(this.liveAuctionConfiguration) + ", durationOptions=" + String.valueOf(this.durationOptions) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuctionConfiguration)) {
            return false;
        }
        AuctionConfiguration that = (AuctionConfiguration)o;
        return this.baseListingLimit == that.baseListingLimit && Objects.equals(this.storageConfiguration, that.storageConfiguration) && Objects.equals(this.listingRules, that.listingRules) && Objects.equals(this.menuConfiguration, that.menuConfiguration) && Objects.equals(this.menuInteractionConfiguration, that.menuInteractionConfiguration) && Objects.equals(this.valueConfiguration, that.valueConfiguration) && Objects.equals(this.messageConfiguration, that.messageConfiguration) && Objects.equals(this.backendMessages, that.backendMessages) && Objects.equals(this.commandMessageConfiguration, that.commandMessageConfiguration) && Objects.equals(this.hologramConfiguration, that.hologramConfiguration) && Objects.equals(this.liveAuctionConfiguration, that.liveAuctionConfiguration) && Objects.equals(this.durationOptions, that.durationOptions);
    }

    public int hashCode() {
        return Objects.hash(this.baseListingLimit, this.storageConfiguration, this.listingRules, this.menuConfiguration, this.menuInteractionConfiguration, this.valueConfiguration, this.messageConfiguration, this.backendMessages, this.commandMessageConfiguration, this.hologramConfiguration, this.liveAuctionConfiguration, this.durationOptions);
    }

    private static List<Duration> sanitizeDurationOptions(List<Duration> options) {
        if (options == null || options.isEmpty()) {
            return List.of();
        }
        ArrayList<Duration> sanitized = new ArrayList<Duration>();
        for (Duration option : options) {
            if (option == null || option.isZero() || option.isNegative()) continue;
            sanitized.add(option);
        }
        if (sanitized.isEmpty()) {
            return List.of();
        }
        return List.copyOf(sanitized);
    }
}

