/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.compat;

import com.skyblockexp.ezauction.compat.HologramDisplay;
import com.skyblockexp.ezauction.compat.HologramPlatform;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.java.JavaPlugin;

public final class TextDisplayHologramPlatform
implements HologramPlatform {
    private final JavaPlugin plugin;

    public TextDisplayHologramPlatform(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean isSupported() {
        try {
            Class<?> textDisplayClass = Class.forName("org.bukkit.entity.TextDisplay");
            textDisplayClass.getMethod("text", Component.class);
            return true;
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            try {
                Class<?> textDisplayClass = Class.forName("org.bukkit.entity.TextDisplay");
                textDisplayClass.getMethod("setText", String.class);
                return true;
            }
            catch (Exception exception) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public HologramDisplay spawn(Location location) {
        if (location == null) {
            return null;
        }
        World world = location.getWorld();
        if (world == null) {
            return null;
        }
        try {
            Class<?> textDisplayClass = Class.forName("org.bukkit.entity.TextDisplay");
            Entity entity = world.spawn(location, textDisplayClass);
            if (textDisplayClass.isInstance(entity)) {
                return new TextDisplayWrapper(entity);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Collection<HologramDisplay> findDisplays(World world) {
        if (world == null) {
            return List.of();
        }
        try {
            Class<?> textDisplayClass = Class.forName("org.bukkit.entity.TextDisplay");
            return world.getEntitiesByClass(textDisplayClass).stream().map(entity -> textDisplayClass.isInstance(entity) ? new TextDisplayWrapper((Entity)entity) : null).filter(e -> e != null).map(HologramDisplay.class::cast).toList();
        }
        catch (Exception exception) {
            return List.of();
        }
    }

    @Override
    public Collection<HologramDisplay> findNearby(Location location, double radius) {
        if (location == null) {
            return List.of();
        }
        World world = location.getWorld();
        if (world == null) {
            return List.of();
        }
        try {
            Class<?> textDisplayClass = Class.forName("org.bukkit.entity.TextDisplay");
            return world.getNearbyEntities(location, radius, radius, radius, entity -> textDisplayClass.isInstance(entity)).stream().map(entity -> textDisplayClass.isInstance(entity) ? new TextDisplayWrapper((Entity)entity) : null).filter(e -> e != null).map(HologramDisplay.class::cast).toList();
        }
        catch (Exception exception) {
            return List.of();
        }
    }

    @Override
    public boolean isDisplayEntity(Entity entity) {
        try {
            Class<?> textDisplayClass = Class.forName("org.bukkit.entity.TextDisplay");
            return textDisplayClass.isInstance(entity);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public HologramDisplay wrap(Entity entity) {
        try {
            Class<?> textDisplayClass;
            if (entity != null && (textDisplayClass = Class.forName("org.bukkit.entity.TextDisplay")).isInstance(entity)) {
                return new TextDisplayWrapper(entity);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void configureBase(HologramDisplay display) {
        if (!(display instanceof TextDisplayWrapper)) {
            return;
        }
        TextDisplayWrapper wrapper = (TextDisplayWrapper)display;
        Entity handle = wrapper.handle();
        if (handle == null) {
            return;
        }
        try {
            Class displayClass = handle.getClass();
            Method setBillboard = displayClass.getMethod("setBillboard", displayClass.getClass().getClassLoader().loadClass("org.bukkit.entity.Display$Billboard"));
            Object centerBillboard = displayClass.getClass().getClassLoader().loadClass("org.bukkit.entity.Display$Billboard").getField("CENTER").get(null);
            setBillboard.invoke((Object)handle, centerBillboard);
            Method setPersistent = displayClass.getMethod("setPersistent", Boolean.TYPE);
            setPersistent.invoke((Object)handle, true);
            Method setShadowed = displayClass.getMethod("setShadowed", Boolean.TYPE);
            setShadowed.invoke((Object)handle, false);
            Method setSeeThrough = displayClass.getMethod("setSeeThrough", Boolean.TYPE);
            setSeeThrough.invoke((Object)handle, true);
            Method setAlignment = displayClass.getMethod("setAlignment", displayClass.getClass().getClassLoader().loadClass("org.bukkit.entity.TextDisplay$TextAlignment"));
            Object centerAlignment = displayClass.getClass().getClassLoader().loadClass("org.bukkit.entity.TextDisplay$TextAlignment").getField("CENTER").get(null);
            setAlignment.invoke((Object)handle, centerAlignment);
            Method setViewRange = displayClass.getMethod("setViewRange", Float.TYPE);
            setViewRange.invoke((Object)handle, Float.valueOf(48.0f));
            Method setLineWidth = displayClass.getMethod("setLineWidth", Integer.TYPE);
            setLineWidth.invoke((Object)handle, 160);
            Method setBackgroundColor = displayClass.getMethod("setBackgroundColor", Integer.TYPE);
            setBackgroundColor.invoke((Object)handle, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setMarker(HologramDisplay display, String key, String value) {
        TextDisplayWrapper wrapper;
        block7: {
            block6: {
                if (!(display instanceof TextDisplayWrapper)) break block6;
                wrapper = (TextDisplayWrapper)display;
                if (key != null && value != null) break block7;
            }
            return;
        }
        Entity handle = wrapper.handle();
        if (handle == null) {
            return;
        }
        try {
            Method getPDC = handle.getClass().getMethod("getPersistentDataContainer", new Class[0]);
            Object container = getPDC.invoke((Object)handle, new Object[0]);
            Class<?> namespacedKeyClass = Class.forName("org.bukkit.NamespacedKey");
            Object namespacedKey = namespacedKeyClass.getConstructor(JavaPlugin.class, String.class).newInstance(this.plugin, key);
            Class<?> persistentDataTypeClass = Class.forName("org.bukkit.persistence.PersistentDataType");
            Object stringType = persistentDataTypeClass.getField("STRING").get(null);
            Method setMethod = container.getClass().getMethod("set", namespacedKeyClass, persistentDataTypeClass, Object.class);
            setMethod.invoke(container, namespacedKey, stringType, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getMarker(HologramDisplay display, String key) {
        TextDisplayWrapper wrapper;
        block7: {
            block6: {
                if (!(display instanceof TextDisplayWrapper)) break block6;
                wrapper = (TextDisplayWrapper)display;
                if (key != null) break block7;
            }
            return null;
        }
        Entity handle = wrapper.handle();
        if (handle == null) {
            return null;
        }
        try {
            Method getPDC = handle.getClass().getMethod("getPersistentDataContainer", new Class[0]);
            Object container = getPDC.invoke((Object)handle, new Object[0]);
            Class<?> namespacedKeyClass = Class.forName("org.bukkit.NamespacedKey");
            Object namespacedKey = namespacedKeyClass.getConstructor(JavaPlugin.class, String.class).newInstance(this.plugin, key);
            Class<?> persistentDataTypeClass = Class.forName("org.bukkit.persistence.PersistentDataType");
            Object stringType = persistentDataTypeClass.getField("STRING").get(null);
            Method getMethod = container.getClass().getMethod("get", namespacedKeyClass, persistentDataTypeClass);
            Object result = getMethod.invoke(container, namespacedKey, stringType);
            return result != null ? result.toString() : null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final class TextDisplayWrapper
    implements HologramDisplay {
        private final Entity display;

        private TextDisplayWrapper(Entity display) {
            this.display = display;
        }

        private Entity handle() {
            return this.display;
        }

        @Override
        public UUID uniqueId() {
            try {
                Method getUniqueId = this.display.getClass().getMethod("getUniqueId", new Class[0]);
                return (UUID)getUniqueId.invoke((Object)this.display, new Object[0]);
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public Location location() {
            try {
                Method getLocation = this.display.getClass().getMethod("getLocation", new Class[0]);
                return (Location)getLocation.invoke((Object)this.display, new Object[0]);
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public boolean isValid() {
            try {
                Method isValid = this.display.getClass().getMethod("isValid", new Class[0]);
                Method isDead = this.display.getClass().getMethod("isDead", new Class[0]);
                return (Boolean)isValid.invoke((Object)this.display, new Object[0]) != false && (Boolean)isDead.invoke((Object)this.display, new Object[0]) == false;
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public void remove() {
            try {
                Method remove = this.display.getClass().getMethod("remove", new Class[0]);
                remove.invoke((Object)this.display, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void setText(Component text) {
            if (text == null) {
                return;
            }
            try {
                Method textMethod = this.display.getClass().getMethod("text", Component.class);
                textMethod.invoke((Object)this.display, text);
            }
            catch (NoSuchMethodException ex) {
                try {
                    Method setTextMethod = this.display.getClass().getMethod("setText", String.class);
                    String legacy = LegacyComponentSerializer.legacySection().serialize(text);
                    setTextMethod.invoke((Object)this.display, legacy);
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

