/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.compat;

import com.skyblockexp.ezauction.compat.ItemTagStorage;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public final class LoreItemTagStorage
implements ItemTagStorage {
    private static final String PREFIX = String.valueOf(ChatColor.DARK_GRAY) + "[EA]";

    @Override
    public void setString(ItemStack item, String key, String value) {
        if (item == null || key == null || key.isEmpty()) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        ArrayList<CallSite> lore = meta.hasLore() ? new ArrayList<CallSite>(meta.getLore()) : new ArrayList();
        String tagPrefix = PREFIX + key + "=";
        Iterator iterator = lore.iterator();
        while (iterator.hasNext()) {
            String line = (String)iterator.next();
            if (line == null || !line.startsWith(tagPrefix)) continue;
            iterator.remove();
        }
        if (value != null) {
            lore.add((CallSite)((Object)(tagPrefix + value)));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
    }

    @Override
    public String getString(ItemStack item, String key) {
        if (item == null || key == null || key.isEmpty()) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null || !meta.hasLore()) {
            return null;
        }
        List lore = meta.getLore();
        if (lore == null) {
            return null;
        }
        String tagPrefix = PREFIX + key + "=";
        for (String line : lore) {
            if (line == null || !line.startsWith(tagPrefix)) continue;
            return line.substring(tagPrefix.length());
        }
        return null;
    }

    @Override
    public void setDouble(ItemStack item, String key, double value) {
        this.setString(item, key, Double.toString(value));
    }

    @Override
    public Double getDouble(ItemStack item, String key) {
        String value = this.getString(item, key);
        if (value == null) {
            return null;
        }
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    @Override
    public void setInt(ItemStack item, String key, int value) {
        this.setString(item, key, Integer.toString(value));
    }

    @Override
    public Integer getInt(ItemStack item, String key) {
        String value = this.getString(item, key);
        if (value == null) {
            return null;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }
}

