/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.compat;

import com.skyblockexp.ezauction.compat.HologramPlatform;
import com.skyblockexp.ezauction.compat.ItemTagStorage;
import com.skyblockexp.ezauction.compat.LoreItemTagStorage;
import com.skyblockexp.ezauction.compat.NoopHologramPlatform;
import com.skyblockexp.ezauction.compat.PdcItemTagStorage;
import com.skyblockexp.ezauction.compat.TextDisplayHologramPlatform;
import java.lang.reflect.Method;
import org.bukkit.plugin.java.JavaPlugin;

public final class CompatibilityFacade {
    private final ItemTagStorage itemTagStorage;
    private final HologramPlatform hologramPlatform;

    private CompatibilityFacade(JavaPlugin plugin) {
        ClassLoader loader;
        try {
            Method method = JavaPlugin.class.getDeclaredMethod("getClassLoader", new Class[0]);
            method.setAccessible(true);
            loader = (ClassLoader)method.invoke((Object)plugin, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to access plugin classloader", e);
        }
        boolean pdcAvailable = CompatibilityFacade.isClassPresent("org.bukkit.persistence.PersistentDataContainer", loader) && CompatibilityFacade.isClassPresent("org.bukkit.NamespacedKey", loader);
        this.itemTagStorage = pdcAvailable ? new PdcItemTagStorage(plugin) : new LoreItemTagStorage();
        boolean textDisplayAvailable = CompatibilityFacade.isClassPresent("org.bukkit.entity.TextDisplay", loader) && CompatibilityFacade.isClassPresent("org.bukkit.entity.Display", loader);
        this.hologramPlatform = textDisplayAvailable ? new TextDisplayHologramPlatform(plugin) : new NoopHologramPlatform();
    }

    public static CompatibilityFacade create(JavaPlugin plugin) {
        return new CompatibilityFacade(plugin);
    }

    public ItemTagStorage itemTagStorage() {
        return this.itemTagStorage;
    }

    public HologramPlatform hologramPlatform() {
        return this.hologramPlatform;
    }

    private static boolean isClassPresent(String className, ClassLoader loader) {
        try {
            Class.forName(className, false, loader);
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }
}

