/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.command;

import com.skyblockexp.ezauction.AuctionManager;
import com.skyblockexp.ezauction.config.AuctionCommandMessageConfiguration;
import com.skyblockexp.ezauction.gui.AuctionSellMenu;
import com.skyblockexp.ezauction.gui.LiveAuctionMenu;
import com.skyblockexp.ezauction.gui.SellMenuHolder;
import com.skyblockexp.ezauction.live.LiveSellContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class LiveAuctionCommand
implements CommandExecutor,
TabCompleter {
    private final AuctionManager auctionManager;
    private final LiveAuctionMenu liveAuctionMenu;
    private final AuctionSellMenu auctionSellMenu;
    private final AuctionCommandMessageConfiguration messages;

    public LiveAuctionCommand(AuctionManager auctionManager, LiveAuctionMenu liveAuctionMenu, AuctionSellMenu auctionSellMenu, AuctionCommandMessageConfiguration messages) {
        this.auctionManager = Objects.requireNonNull(auctionManager, "auctionManager");
        this.liveAuctionMenu = Objects.requireNonNull(liveAuctionMenu, "liveAuctionMenu");
        this.auctionSellMenu = Objects.requireNonNull(auctionSellMenu, "auctionSellMenu");
        this.messages = messages != null ? messages : AuctionCommandMessageConfiguration.defaults();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String sub;
        if (!(sender instanceof Player)) {
            this.sendMessage(sender, this.messages.general().consoleOnly());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("ezauction.auction.live")) {
            this.sendMessage((CommandSender)player, this.messages.live().noPermission());
            return true;
        }
        if (!this.auctionManager.liveAuctionsEnabled()) {
            this.sendMessage((CommandSender)player, this.messages.live().disabled());
            return true;
        }
        if (args.length == 0) {
            this.liveAuctionMenu.open(player);
            return true;
        }
        switch (sub = args[0].toLowerCase(Locale.ENGLISH)) {
            case "sell": {
                if (!player.hasPermission("ezauction.auction.live.sell")) {
                    this.sendMessage((CommandSender)player, this.messages.sell().noPermission());
                    return true;
                }
                LiveSellContext.mark(player.getUniqueId());
                this.auctionSellMenu.openSellMenu(player, SellMenuHolder.Target.LIVE);
                return true;
            }
        }
        this.sendMessage((CommandSender)player, this.messages.usage().live().replace("{label}", label.toLowerCase(Locale.ENGLISH)));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            return Arrays.asList("sell");
        }
        return Collections.emptyList();
    }

    private void sendMessage(CommandSender sender, String message) {
        if (sender == null || message == null || message.isEmpty()) {
            return;
        }
        sender.sendMessage(this.colorize(message));
    }

    private String colorize(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }
}

