/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction;

import java.util.Objects;
import java.util.UUID;
import org.bukkit.inventory.ItemStack;

public record AuctionOrder(String id, UUID buyerId, double offeredPrice, long expiryEpochMillis, ItemStack requestedItem, double reservedAmount) {
    private final ItemStack requestedItem;

    public AuctionOrder {
        Objects.requireNonNull(id, "id");
        buyerId = Objects.requireNonNull(buyerId, "buyerId");
        requestedItem = requestedItem != null ? requestedItem.clone() : null;
        reservedAmount = Math.max(0.0, reservedAmount);
    }

    public ItemStack requestedItem() {
        return this.requestedItem != null ? this.requestedItem.clone() : null;
    }

    public boolean isExpired() {
        return this.isExpired(System.currentTimeMillis());
    }

    public boolean isExpired(long currentTimeMillis) {
        return currentTimeMillis >= this.expiryEpochMillis;
    }
}

