/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.util;

public class NumberShortcutParser {
    public static double parse(String input) {
        if (input == null || input.trim().isEmpty()) {
            throw new IllegalArgumentException("Input cannot be null or empty");
        }
        String trimmed = input.trim().toLowerCase();
        double multiplier = 1.0;
        if (trimmed.endsWith("k")) {
            multiplier = 1000.0;
            trimmed = trimmed.substring(0, trimmed.length() - 1);
        } else if (trimmed.endsWith("m")) {
            multiplier = 1000000.0;
            trimmed = trimmed.substring(0, trimmed.length() - 1);
        } else if (trimmed.endsWith("b")) {
            multiplier = 1.0E9;
            trimmed = trimmed.substring(0, trimmed.length() - 1);
        } else if (trimmed.endsWith("t")) {
            multiplier = 1.0E12;
            trimmed = trimmed.substring(0, trimmed.length() - 1);
        }
        try {
            double value = Double.parseDouble(trimmed);
            return value * multiplier;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid number format: " + input);
        }
    }
}

