/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;

public final class ItemStackSerialization {
    private ItemStackSerialization() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String serialize(ItemStack item, Logger logger) {
        if (item == null) {
            return null;
        }
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            String string;
            try (BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);){
                dataOutput.writeObject((Object)item.clone());
                dataOutput.flush();
                string = Base64.getEncoder().encodeToString(outputStream.toByteArray());
            }
            return string;
        }
        catch (IOException ex) {
            if (logger != null) {
                logger.log(Level.SEVERE, "Failed to serialize ItemStack for EzAuction storage.", ex);
            }
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ItemStack deserialize(String data, Logger logger) {
        byte[] bytes;
        if (data == null) return null;
        if (data.isEmpty()) {
            return null;
        }
        try {
            bytes = Base64.getDecoder().decode(data);
        }
        catch (IllegalArgumentException ex) {
            if (logger == null) return null;
            logger.log(Level.WARNING, "Failed to decode base64 ItemStack data for EzAuction storage.", ex);
            return null;
        }
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
             BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);){
            Object object = dataInput.readObject();
            if (!(object instanceof ItemStack)) return null;
            ItemStack stack = (ItemStack)object;
            ItemStack itemStack = stack.clone();
            return itemStack;
        }
        catch (IOException | ClassNotFoundException ex) {
            if (logger == null) return null;
            logger.log(Level.SEVERE, "Failed to deserialize ItemStack for EzAuction storage.", ex);
        }
        return null;
    }
}

