/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.transaction;

import com.skyblockexp.ezauction.HistorySaveDispatcher;
import com.skyblockexp.ezauction.storage.AuctionHistoryStorage;
import com.skyblockexp.ezauction.transaction.AuctionTransactionHistoryEntry;
import com.skyblockexp.ezauction.transaction.AuctionTransactionType;
import com.skyblockexp.ezauction.util.EconomyUtils;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class AuctionTransactionHistory {
    private static final int MAX_ENTRIES_PER_PLAYER = 25;
    private final JavaPlugin plugin;
    private final AuctionHistoryStorage storage;
    private final Map<UUID, Deque<AuctionTransactionHistoryEntry>> entriesByPlayer = new ConcurrentHashMap<UUID, Deque<AuctionTransactionHistoryEntry>>();
    private HistorySaveDispatcher historySaveDispatcher;
    private boolean storageReady;

    public AuctionTransactionHistory(JavaPlugin plugin, AuctionHistoryStorage storage) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
        this.storage = Objects.requireNonNull(storage, "storage");
    }

    public void enable() {
        HistorySaveDispatcher dispatcher = this.historySaveDispatcher;
        if (dispatcher != null) {
            dispatcher.flushAndShutdown();
            this.historySaveDispatcher = null;
        }
        this.storageReady = this.storage.initialize();
        if (!this.storageReady) {
            this.plugin.getLogger().severe("Failed to initialize auction history storage. History will not be persisted.");
            this.entriesByPlayer.clear();
            return;
        }
        this.entriesByPlayer.clear();
        Map<UUID, Deque<AuctionTransactionHistoryEntry>> loaded = this.storage.loadAll();
        if (loaded != null && !loaded.isEmpty()) {
            this.entriesByPlayer.putAll(loaded);
        }
        this.historySaveDispatcher = new HistorySaveDispatcher(this.plugin, this.storage);
    }

    public void disable() {
        HistorySaveDispatcher dispatcher = this.historySaveDispatcher;
        this.historySaveDispatcher = null;
        if (dispatcher != null) {
            dispatcher.flushAndShutdown();
        }
        if (this.storageReady) {
            try {
                this.storage.saveAll(this.entriesByPlayer);
            }
            catch (RuntimeException ex) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to persist EzAuction transaction history to storage.", ex);
            }
        }
        this.entriesByPlayer.clear();
        this.storageReady = false;
    }

    public void recordTransaction(AuctionTransactionType type, UUID ownerId, UUID counterpartId, String counterpartName, double price, ItemStack item, long timestamp) {
        if (type == null || ownerId == null) {
            return;
        }
        double normalizedPrice = EconomyUtils.normalizeCurrency(price);
        AuctionTransactionHistoryEntry entry = new AuctionTransactionHistoryEntry(type, counterpartId, counterpartName, normalizedPrice, Math.max(0L, timestamp), item);
        Deque history = this.entriesByPlayer.computeIfAbsent(ownerId, key -> new ArrayDeque());
        history.addFirst(entry);
        while (history.size() > 25) {
            history.removeLast();
        }
        this.persistPlayerHistory(ownerId, history);
    }

    public void recordOrderFulfillment(UUID buyerId, UUID sellerId, String sellerName, String buyerName, double price, ItemStack item, long timestamp) {
        if (buyerId == null || sellerId == null) {
            return;
        }
        ItemStack clonedItem = item != null ? item.clone() : null;
        this.recordTransaction(AuctionTransactionType.BUY, buyerId, sellerId, sellerName, price, clonedItem, timestamp);
        this.recordTransaction(AuctionTransactionType.SELL, sellerId, buyerId, buyerName, price, clonedItem, timestamp);
    }

    public List<AuctionTransactionHistoryEntry> getHistory(UUID playerId) {
        if (playerId == null) {
            return List.of();
        }
        Deque<AuctionTransactionHistoryEntry> history = this.entriesByPlayer.get(playerId);
        if (history == null || history.isEmpty()) {
            return List.of();
        }
        return List.copyOf(history);
    }

    private void persistPlayerHistory(UUID ownerId, Deque<AuctionTransactionHistoryEntry> history) {
        if (!this.storageReady || ownerId == null) {
            return;
        }
        HistorySaveDispatcher dispatcher = this.historySaveDispatcher;
        if (dispatcher == null) {
            return;
        }
        dispatcher.enqueue(ownerId, history);
    }
}

