/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.storage.yaml;

import com.skyblockexp.ezauction.AuctionListing;
import com.skyblockexp.ezauction.AuctionOrder;
import com.skyblockexp.ezauction.storage.AuctionStorage;
import com.skyblockexp.ezauction.storage.AuctionStorageSnapshot;
import com.skyblockexp.ezauction.util.EconomyUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public final class YamlAuctionStorage
implements AuctionStorage {
    private final JavaPlugin plugin;
    private File listingsFile;
    private File returnsFile;

    public YamlAuctionStorage(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean initialize() {
        if (this.plugin == null) {
            return false;
        }
        File dataFolder = this.plugin.getDataFolder();
        if (!dataFolder.exists() && !dataFolder.mkdirs()) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to create EzAuction data folder at {0}.", dataFolder);
        }
        this.listingsFile = new File(dataFolder, "auction-listings.yml");
        this.returnsFile = new File(dataFolder, "auction-returns.yml");
        try {
            this.ensureFile(this.listingsFile);
            this.ensureFile(this.returnsFile);
        }
        catch (IOException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to initialize YAML storage for EzAuction.", ex);
            return false;
        }
        return true;
    }

    @Override
    public AuctionStorageSnapshot load() {
        ConfigurationSection section;
        YamlConfiguration configuration;
        HashMap<String, AuctionListing> listings = new HashMap<String, AuctionListing>();
        HashMap<String, AuctionOrder> orders = new HashMap<String, AuctionOrder>();
        HashMap<UUID, List<ItemStack>> returns = new HashMap<UUID, List<ItemStack>>();
        if (this.listingsFile != null && this.listingsFile.exists()) {
            ConfigurationSection ordersSection;
            configuration = YamlConfiguration.loadConfiguration((File)this.listingsFile);
            ConfigurationSection listingsSection = configuration.getConfigurationSection("listings");
            if (listingsSection != null) {
                for (Object id : listingsSection.getKeys(false)) {
                    AuctionListing listing;
                    ConfigurationSection listingSection = listingsSection.getConfigurationSection((String)id);
                    if (listingSection == null || (listing = this.loadListing((String)id, listingSection)) == null) continue;
                    listings.put((String)id, listing);
                }
            }
            if ((ordersSection = configuration.getConfigurationSection("orders")) != null) {
                for (String id : ordersSection.getKeys(false)) {
                    AuctionOrder order;
                    ConfigurationSection orderSection = ordersSection.getConfigurationSection(id);
                    if (orderSection == null || (order = this.loadOrder(id, orderSection)) == null) continue;
                    orders.put(id, order);
                }
            }
        }
        if (this.returnsFile != null && this.returnsFile.exists() && (section = (configuration = YamlConfiguration.loadConfiguration((File)this.returnsFile)).getConfigurationSection("returns")) != null) {
            for (String key : section.getKeys(false)) {
                UUID playerId;
                try {
                    playerId = UUID.fromString(key);
                }
                catch (IllegalArgumentException ex) {
                    this.plugin.getLogger().log(Level.WARNING, "Ignoring auction returns entry for invalid player id " + key, ex);
                    continue;
                }
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                List serializedItems = section.getList(key);
                if (serializedItems != null) {
                    for (Object object : serializedItems) {
                        ItemStack stack;
                        if (!(object instanceof ItemStack) || (stack = (ItemStack)object).getType() == Material.AIR || stack.getAmount() <= 0) continue;
                        items.add(stack.clone());
                    }
                }
                if (items.isEmpty()) continue;
                returns.put(playerId, items);
            }
        }
        return new AuctionStorageSnapshot(listings, orders, returns);
    }

    @Override
    public void saveListings(Collection<AuctionListing> listings, Collection<AuctionOrder> orders) {
        if (this.listingsFile == null) {
            return;
        }
        YamlConfiguration configuration = new YamlConfiguration();
        ConfigurationSection listingsSection = configuration.createSection("listings");
        for (AuctionListing auctionListing : listings) {
            ConfigurationSection listingSection = listingsSection.createSection(auctionListing.id());
            listingSection.set("seller", (Object)auctionListing.sellerId().toString());
            listingSection.set("price", (Object)auctionListing.price());
            listingSection.set("expiry", (Object)auctionListing.expiryEpochMillis());
            listingSection.set("deposit", (Object)auctionListing.deposit());
            listingSection.set("item", (Object)auctionListing.item());
        }
        ConfigurationSection ordersSection = configuration.createSection("orders");
        for (AuctionOrder order : orders) {
            ConfigurationSection orderSection = ordersSection.createSection(order.id());
            orderSection.set("buyer", (Object)order.buyerId().toString());
            orderSection.set("price", (Object)order.offeredPrice());
            orderSection.set("expiry", (Object)order.expiryEpochMillis());
            orderSection.set("reserved", (Object)order.reservedAmount());
            orderSection.set("item", (Object)order.requestedItem());
        }
        try {
            configuration.save(this.listingsFile);
        }
        catch (IOException iOException) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to save EzAuction listings file.", iOException);
        }
    }

    @Override
    public void saveReturns(Map<UUID, List<ItemStack>> returnsByPlayer) {
        if (this.returnsFile == null) {
            return;
        }
        YamlConfiguration configuration = new YamlConfiguration();
        ConfigurationSection section = configuration.createSection("returns");
        for (Map.Entry<UUID, List<ItemStack>> entry : returnsByPlayer.entrySet()) {
            ArrayList<ItemStack> serialized = new ArrayList<ItemStack>();
            for (ItemStack stack : entry.getValue()) {
                if (stack == null || stack.getType() == Material.AIR || stack.getAmount() <= 0) continue;
                serialized.add(stack.clone());
            }
            if (serialized.isEmpty()) continue;
            section.set(entry.getKey().toString(), serialized);
        }
        try {
            configuration.save(this.returnsFile);
        }
        catch (IOException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to save EzAuction returns file.", ex);
        }
    }

    @Override
    public void close() {
    }

    private AuctionListing loadListing(String id, ConfigurationSection section) {
        UUID sellerId;
        String sellerRaw = section.getString("seller");
        if (sellerRaw == null || sellerRaw.isEmpty()) {
            this.plugin.getLogger().warning("Ignoring auction listing " + id + " because the seller id is missing.");
            return null;
        }
        try {
            sellerId = UUID.fromString(sellerRaw);
        }
        catch (IllegalArgumentException ex) {
            this.plugin.getLogger().log(Level.WARNING, "Ignoring auction listing " + id + " because the seller id is invalid.", ex);
            return null;
        }
        double price = EconomyUtils.normalizeCurrency(section.getDouble("price"));
        if (price <= 0.0) {
            this.plugin.getLogger().warning("Ignoring auction listing " + id + " because the price is invalid.");
            return null;
        }
        long expiry = section.getLong("expiry");
        double deposit = EconomyUtils.normalizeCurrency(section.getDouble("deposit", 0.0));
        ItemStack item = section.getItemStack("item");
        if (item == null || item.getType() == Material.AIR || item.getAmount() <= 0) {
            this.plugin.getLogger().warning("Ignoring auction listing " + id + " because the item is invalid.");
            return null;
        }
        return new AuctionListing(id, sellerId, price, expiry, item.clone(), deposit);
    }

    private AuctionOrder loadOrder(String id, ConfigurationSection section) {
        UUID buyerId;
        String buyerRaw = section.getString("buyer");
        if (buyerRaw == null || buyerRaw.isEmpty()) {
            this.plugin.getLogger().warning("Ignoring auction order " + id + " because the buyer id is missing.");
            return null;
        }
        try {
            buyerId = UUID.fromString(buyerRaw);
        }
        catch (IllegalArgumentException ex) {
            this.plugin.getLogger().log(Level.WARNING, "Ignoring auction order " + id + " because the buyer id is invalid.", ex);
            return null;
        }
        double price = EconomyUtils.normalizeCurrency(section.getDouble("price"));
        if (price <= 0.0) {
            this.plugin.getLogger().warning("Ignoring auction order " + id + " because the price is invalid.");
            return null;
        }
        double reserved = EconomyUtils.normalizeCurrency(section.getDouble("reserved", price));
        if (reserved < price) {
            reserved = price;
        }
        long expiry = section.getLong("expiry");
        ItemStack template = section.getItemStack("item");
        if (template == null || template.getType() == Material.AIR || template.getAmount() <= 0) {
            this.plugin.getLogger().warning("Ignoring auction order " + id + " because the item template is invalid.");
            return null;
        }
        return new AuctionOrder(id, buyerId, price, expiry, template.clone(), reserved);
    }

    private void ensureFile(File file) throws IOException {
        if (file.exists()) {
            return;
        }
        File parent = file.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to create directory for {0}.", file);
        }
        if (!file.exists() && !file.createNewFile()) {
            throw new IOException("Unable to create file " + String.valueOf(file));
        }
    }
}

