/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.storage.mysql;

import com.skyblockexp.ezauction.AuctionListing;
import com.skyblockexp.ezauction.AuctionOrder;
import com.skyblockexp.ezauction.config.AuctionStorageConfiguration;
import com.skyblockexp.ezauction.storage.AuctionStorage;
import com.skyblockexp.ezauction.storage.AuctionStorageSnapshot;
import com.skyblockexp.ezauction.storage.DistributedAuctionListingStorage;
import com.skyblockexp.ezauction.util.EconomyUtils;
import com.skyblockexp.ezauction.util.ItemStackSerialization;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class MysqlAuctionListingStorage
implements AuctionStorage,
DistributedAuctionListingStorage {
    private final JavaPlugin plugin;
    private final Logger logger;
    private final AuctionStorageConfiguration.Mysql mysql;
    private final String jdbcUrl;
    private final String listingsTable;
    private final String ordersTable;
    private final String returnsTable;
    private boolean driverLoaded = false;

    public MysqlAuctionListingStorage(JavaPlugin plugin, AuctionStorageConfiguration.Mysql mysql) {
        this.plugin = plugin;
        this.logger = plugin != null ? plugin.getLogger() : Logger.getLogger(MysqlAuctionListingStorage.class.getName());
        this.mysql = mysql;
        this.jdbcUrl = "jdbc:mysql://" + mysql.host() + ":" + mysql.port() + "/" + mysql.database();
        String prefix = mysql.tablePrefix();
        this.listingsTable = this.sanitize(prefix + "listings");
        this.ordersTable = this.sanitize(prefix + "orders");
        this.returnsTable = this.sanitize(prefix + "returns");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean initialize() {
        if (this.driverLoaded) {
            return true;
        }
        try {
            Class.forName("com.skyblockexp.ezauction.libs.com.mysql.cj.jdbc.Driver");
            this.driverLoaded = true;
        }
        catch (ClassNotFoundException ex) {
            this.logger.log(Level.SEVERE, "MySQL JDBC driver not found.", ex);
            return false;
        }
        try (Connection connection = this.getConnection();){
            boolean bl;
            block17: {
                Statement statement = connection.createStatement();
                try {
                    statement.executeUpdate("CREATE TABLE IF NOT EXISTS `" + this.listingsTable + "` (id VARCHAR(36) NOT NULL PRIMARY KEY,seller_uuid CHAR(36) NOT NULL,price DOUBLE NOT NULL,expiry BIGINT NOT NULL,deposit DOUBLE NOT NULL,item LONGTEXT NOT NULL) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");
                    statement.executeUpdate("CREATE TABLE IF NOT EXISTS `" + this.ordersTable + "` (id VARCHAR(36) NOT NULL PRIMARY KEY,buyer_uuid CHAR(36) NOT NULL,price DOUBLE NOT NULL,reserved DOUBLE NOT NULL,expiry BIGINT NOT NULL,item LONGTEXT NOT NULL) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");
                    statement.executeUpdate("CREATE TABLE IF NOT EXISTS `" + this.returnsTable + "` (player_uuid CHAR(36) NOT NULL,slot INT NOT NULL,item LONGTEXT NOT NULL,PRIMARY KEY (player_uuid, slot)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");
                    bl = true;
                    if (statement == null) break block17;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (SQLException ex) {
            this.logger.log(Level.SEVERE, "Failed to create EzAuction MySQL tables.", ex);
            return false;
        }
    }

    @Override
    public AuctionStorageSnapshot load() {
        ItemStack item;
        double price;
        HashMap<String, AuctionListing> listings = new HashMap<String, AuctionListing>();
        HashMap<String, AuctionOrder> orders = new HashMap<String, AuctionOrder>();
        HashMap<UUID, List<ItemStack>> returns = new HashMap<UUID, List<ItemStack>>();
        if (!this.isReady()) {
            return AuctionStorageSnapshot.empty();
        }
        String listingsQuery = "SELECT id, seller_uuid, price, expiry, deposit, item FROM `" + this.listingsTable + "`";
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(listingsQuery);
             ResultSet resultSet = statement.executeQuery();){
            while (resultSet.next()) {
                String id = resultSet.getString("id");
                String sellerRaw = resultSet.getString("seller_uuid");
                UUID sellerId = this.parseUuid(sellerRaw);
                if (sellerId == null || (price = EconomyUtils.normalizeCurrency(resultSet.getDouble("price"))) <= 0.0) continue;
                long expiry = resultSet.getLong("expiry");
                double deposit = EconomyUtils.normalizeCurrency(resultSet.getDouble("deposit"));
                item = ItemStackSerialization.deserialize(resultSet.getString("item"), this.logger);
                if (item == null || item.getType() == Material.AIR || item.getAmount() <= 0) continue;
                listings.put(id, new AuctionListing(id, sellerId, price, expiry, item, deposit));
            }
        }
        catch (SQLException ex) {
            this.logger.log(Level.SEVERE, "Failed to load EzAuction listings from MySQL.", ex);
        }
        String ordersQuery = "SELECT id, buyer_uuid, price, reserved, expiry, item FROM `" + this.ordersTable + "`";
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(ordersQuery);
             ResultSet resultSet = statement.executeQuery();){
            while (resultSet.next()) {
                String id = resultSet.getString("id");
                UUID buyerId = this.parseUuid(resultSet.getString("buyer_uuid"));
                if (buyerId == null || (price = EconomyUtils.normalizeCurrency(resultSet.getDouble("price"))) <= 0.0) continue;
                double reserved = EconomyUtils.normalizeCurrency(resultSet.getDouble("reserved"));
                if (reserved < price) {
                    reserved = price;
                }
                long expiry = resultSet.getLong("expiry");
                item = ItemStackSerialization.deserialize(resultSet.getString("item"), this.logger);
                if (item == null || item.getType() == Material.AIR || item.getAmount() <= 0) continue;
                orders.put(id, new AuctionOrder(id, buyerId, price, expiry, item, reserved));
            }
        }
        catch (SQLException ex) {
            this.logger.log(Level.SEVERE, "Failed to load EzAuction orders from MySQL.", ex);
        }
        String returnsQuery = "SELECT player_uuid, slot, item FROM `" + this.returnsTable + "` ORDER BY player_uuid, slot";
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(returnsQuery);
             ResultSet resultSet = statement.executeQuery();){
            while (resultSet.next()) {
                ItemStack item2;
                UUID playerId = this.parseUuid(resultSet.getString("player_uuid"));
                if (playerId == null || (item2 = ItemStackSerialization.deserialize(resultSet.getString("item"), this.logger)) == null || item2.getType() == Material.AIR || item2.getAmount() <= 0) continue;
                returns.computeIfAbsent(playerId, key -> new ArrayList()).add(item2);
            }
        }
        catch (SQLException ex) {
            this.logger.log(Level.SEVERE, "Failed to load EzAuction returns from MySQL.", ex);
        }
        return new AuctionStorageSnapshot(listings, orders, returns);
    }

    @Override
    public void saveListings(Collection<AuctionListing> listings, Collection<AuctionOrder> orders) {
        if (!this.isReady()) {
            return;
        }
        String deleteOrders = "DELETE FROM `" + this.ordersTable + "`";
        String insertOrder = "INSERT INTO `" + this.ordersTable + "` (id, buyer_uuid, price, reserved, expiry, item) VALUES (?, ?, ?, ?, ?, ?)";
        try (Connection connection = this.getConnection();){
            connection.setAutoCommit(false);
            try (Statement deleteStatement = connection.createStatement();){
                deleteStatement.executeUpdate(deleteOrders);
            }
            try (PreparedStatement insertStatement = connection.prepareStatement(insertOrder);){
                for (AuctionOrder order : orders) {
                    insertStatement.setString(1, order.id());
                    insertStatement.setString(2, order.buyerId().toString());
                    insertStatement.setDouble(3, order.offeredPrice());
                    insertStatement.setDouble(4, order.reservedAmount());
                    insertStatement.setLong(5, order.expiryEpochMillis());
                    insertStatement.setString(6, ItemStackSerialization.serialize(order.requestedItem(), this.logger));
                    insertStatement.addBatch();
                }
                insertStatement.executeBatch();
            }
            connection.commit();
        }
        catch (SQLException ex) {
            this.logger.log(Level.SEVERE, "Failed to save EzAuction orders to MySQL.", ex);
        }
    }

    @Override
    public void insertListing(AuctionListing listing) {
        if (!this.isReady() || listing == null) {
            return;
        }
        String insert = "INSERT INTO `" + this.listingsTable + "` (id, seller_uuid, price, expiry, deposit, item) VALUES (?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE seller_uuid = VALUES(seller_uuid), price = VALUES(price), expiry = VALUES(expiry), deposit = VALUES(deposit), item = VALUES(item)";
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(insert);){
            statement.setString(1, listing.id());
            statement.setString(2, listing.sellerId().toString());
            statement.setDouble(3, listing.price());
            statement.setLong(4, listing.expiryEpochMillis());
            statement.setDouble(5, listing.deposit());
            statement.setString(6, ItemStackSerialization.serialize(listing.item(), this.logger));
            statement.executeUpdate();
        }
        catch (SQLException ex) {
            this.logger.log(Level.SEVERE, String.format("Failed to persist %s listing %s to MySQL.", "EzAuction", listing.id()), ex);
        }
    }

    @Override
    public boolean tryClaimListing(String listingId) {
        if (!this.isReady() || listingId == null || listingId.isEmpty()) {
            return false;
        }
        return this.deleteListingInternal(listingId, true);
    }

    @Override
    public void deleteListing(String listingId) {
        if (!this.isReady() || listingId == null || listingId.isEmpty()) {
            return;
        }
        this.deleteListingInternal(listingId, false);
    }

    @Override
    public void saveReturns(Map<UUID, List<ItemStack>> returnsByPlayer) {
        if (!this.isReady()) {
            return;
        }
        String deleteReturns = "DELETE FROM `" + this.returnsTable + "`";
        String insertReturn = "INSERT INTO `" + this.returnsTable + "` (player_uuid, slot, item) VALUES (?, ?, ?)";
        try (Connection connection = this.getConnection();){
            connection.setAutoCommit(false);
            try (Statement deleteStatement = connection.createStatement();){
                deleteStatement.executeUpdate(deleteReturns);
            }
            try (PreparedStatement insertStatement = connection.prepareStatement(insertReturn);){
                for (Map.Entry<UUID, List<ItemStack>> entry : returnsByPlayer.entrySet()) {
                    List<ItemStack> items = entry.getValue();
                    if (items == null || items.isEmpty()) continue;
                    int slot = 0;
                    for (ItemStack stack : items) {
                        if (stack == null || stack.getType() == Material.AIR || stack.getAmount() <= 0) continue;
                        insertStatement.setString(1, entry.getKey().toString());
                        insertStatement.setInt(2, slot++);
                        insertStatement.setString(3, ItemStackSerialization.serialize(stack, this.logger));
                        insertStatement.addBatch();
                    }
                }
                insertStatement.executeBatch();
            }
            connection.commit();
        }
        catch (SQLException ex) {
            this.logger.log(Level.SEVERE, "Failed to save EzAuction returns to MySQL.", ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean deleteListingInternal(String listingId, boolean returnResult) {
        String delete = "DELETE FROM `" + this.listingsTable + "` WHERE id = ?";
        try (Connection connection = this.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement statement = connection.prepareStatement(delete);
                try {
                    statement.setString(1, listingId);
                    int affected = statement.executeUpdate();
                    boolean bl2 = returnResult ? affected > 0 : (bl = true);
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (SQLException ex) {
            this.logger.log(Level.SEVERE, String.format("Failed to delete %s listing %s from MySQL.", "EzAuction", listingId), ex);
            return false;
        }
    }

    private Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this.jdbcUrl, this.mysql.username(), this.mysql.password());
    }

    private boolean isReady() {
        return this.driverLoaded;
    }

    private UUID parseUuid(String raw) {
        if (raw == null || raw.isEmpty()) {
            return null;
        }
        try {
            return UUID.fromString(raw);
        }
        catch (IllegalArgumentException ex) {
            this.logger.log(Level.WARNING, "Invalid UUID encountered in EzAuction MySQL storage: {0}", raw);
            return null;
        }
    }

    private String sanitize(String input) {
        if (input == null || input.isBlank()) {
            return "ezauction_table";
        }
        String sanitized = input.replaceAll("[^a-zA-Z0-9_]+", "_");
        if (sanitized.isBlank()) {
            sanitized = "ezauction_table";
        }
        if (sanitized.length() > 64) {
            sanitized = sanitized.substring(0, 64);
        }
        return sanitized;
    }

    @Override
    public void close() {
    }
}

