/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.storage;

import com.skyblockexp.ezauction.config.AuctionConfiguration;
import com.skyblockexp.ezauction.config.AuctionStorageConfiguration;
import com.skyblockexp.ezauction.storage.AuctionStorageBundle;
import com.skyblockexp.ezauction.storage.mysql.MysqlAuctionHistoryStorage;
import com.skyblockexp.ezauction.storage.mysql.MysqlAuctionListingStorage;
import com.skyblockexp.ezauction.storage.yaml.YamlAuctionHistoryStorage;
import com.skyblockexp.ezauction.storage.yaml.YamlAuctionStorage;
import org.bukkit.plugin.java.JavaPlugin;

public final class AuctionStorageFactory {
    private AuctionStorageFactory() {
    }

    public static AuctionStorageBundle create(JavaPlugin plugin, AuctionConfiguration configuration) {
        AuctionStorageConfiguration.Mysql mysql;
        AuctionStorageConfiguration storageConfiguration;
        if (configuration == null) {
            configuration = AuctionConfiguration.defaultConfiguration();
        }
        if ((storageConfiguration = configuration.storageConfiguration()).type() == AuctionStorageConfiguration.StorageType.MYSQL && (mysql = storageConfiguration.mysql()) != null) {
            MysqlAuctionListingStorage listingStorage = new MysqlAuctionListingStorage(plugin, mysql);
            MysqlAuctionHistoryStorage historyStorage = new MysqlAuctionHistoryStorage(plugin != null ? plugin.getLogger() : null, mysql);
            boolean listingOk = listingStorage.initialize();
            boolean historyOk = historyStorage.initialize();
            if (listingOk && historyOk) {
                return new AuctionStorageBundle(listingStorage, historyStorage);
            }
            plugin.getLogger().warning("Failed to initialize MySQL storage for EzAuction. Falling back to YAML data files.");
            try {
                listingStorage.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                historyStorage.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        YamlAuctionStorage listingStorage = new YamlAuctionStorage(plugin);
        listingStorage.initialize();
        YamlAuctionHistoryStorage historyStorage = new YamlAuctionHistoryStorage(plugin);
        historyStorage.initialize();
        return new AuctionStorageBundle(listingStorage, historyStorage);
    }
}

