/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.live;

import com.skyblockexp.ezauction.AuctionListing;
import com.skyblockexp.ezauction.config.AuctionBackendMessages;
import com.skyblockexp.ezauction.config.LiveAuctionConfiguration;
import com.skyblockexp.ezauction.live.LiveAuctionEntry;
import com.skyblockexp.ezauction.transaction.AuctionTransactionService;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public final class LiveAuctionService {
    private final JavaPlugin plugin;
    private final AuctionTransactionService transactionService;
    private final LiveAuctionConfiguration configuration;
    private final AuctionBackendMessages.LiveMessages messages;
    private final AuctionBackendMessages.FallbackMessages fallbackMessages;
    private final Queue<LiveAuctionEntry> queue = new ConcurrentLinkedQueue<LiveAuctionEntry>();
    private BukkitTask announcementTask;
    private boolean enabled = false;

    public LiveAuctionService(JavaPlugin plugin, AuctionTransactionService transactionService, LiveAuctionConfiguration configuration, AuctionBackendMessages.LiveMessages messages, AuctionBackendMessages.FallbackMessages fallbackMessages) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
        this.transactionService = Objects.requireNonNull(transactionService, "transactionService");
        this.configuration = configuration != null ? configuration : LiveAuctionConfiguration.defaults();
        this.messages = messages != null ? messages : AuctionBackendMessages.LiveMessages.defaults();
        this.fallbackMessages = fallbackMessages != null ? fallbackMessages : AuctionBackendMessages.FallbackMessages.defaults();
    }

    public void enable() {
        if (!this.configuration.enabled()) {
            return;
        }
        if (!this.configuration.queueEnabled() || !this.configuration.displayInChat()) {
            return;
        }
        long interval = Math.max(1L, this.configuration.announcementIntervalTicks());
        this.announcementTask = this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, this::announceNext, interval, interval);
        this.enabled = true;
    }

    public void disable() {
        if (this.announcementTask != null) {
            this.announcementTask.cancel();
            this.announcementTask = null;
        }
        this.queue.clear();
    }

    public boolean enqueue(AuctionListing listing, UUID sellerId, String sellerName) {
        if (!this.configuration.enabled() || listing == null) {
            return false;
        }
        String resolvedName = this.resolveSellerName(sellerId, sellerName);
        LiveAuctionEntry entry = new LiveAuctionEntry(listing, sellerId, resolvedName);
        if (!this.configuration.queueEnabled()) {
            this.announce(entry);
            return true;
        }
        this.queue.offer(entry);
        if (this.announcementTask == null && this.configuration.displayInChat()) {
            this.announceNext();
        }
        return true;
    }

    public List<LiveAuctionEntry> snapshotQueue() {
        if (this.queue.isEmpty()) {
            return List.of();
        }
        return List.copyOf(new ArrayList<LiveAuctionEntry>(this.queue));
    }

    public boolean isFeatureEnabled() {
        return this.configuration.enabled();
    }

    public boolean isQueueEnabled() {
        return this.configuration.queueEnabled();
    }

    public boolean displayInChat() {
        return this.configuration.displayInChat();
    }

    public LiveAuctionEntry poll() {
        return this.queue.poll();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private void announceNext() {
        LiveAuctionEntry entry = this.poll();
        if (entry == null) {
            return;
        }
        this.announce(entry);
    }

    private void announce(LiveAuctionEntry entry) {
        if (!this.configuration.displayInChat()) {
            return;
        }
        AuctionListing listing = entry.listing();
        ItemStack item = listing.item();
        String itemDescription = this.describeItem(item);
        String price = this.transactionService.formatCurrency(listing.price());
        String message = this.formatMessage(this.messages.broadcast(), "seller", entry.sellerName(), "item", itemDescription, "price", price);
        Bukkit.broadcastMessage((String)message);
    }

    private String resolveSellerName(UUID sellerId, String fallback) {
        if (fallback != null && !fallback.isEmpty()) {
            return fallback;
        }
        if (sellerId != null) {
            Player online = Bukkit.getPlayer((UUID)sellerId);
            if (online != null) {
                return online.getName();
            }
            OfflinePlayer offline = Bukkit.getOfflinePlayer((UUID)sellerId);
            if (offline != null && offline.getName() != null) {
                return offline.getName();
            }
        }
        return this.fallbackMessages.unknownName();
    }

    private String describeItem(ItemStack item) {
        String name;
        if (item == null) {
            return this.fallbackMessages.unknownItem();
        }
        int amount = Math.max(1, item.getAmount());
        ItemMeta meta = item.getItemMeta();
        if (meta != null && meta.hasDisplayName()) {
            String displayName = meta.getDisplayName();
            String stripped = displayName != null ? ChatColor.stripColor((String)displayName) : "";
            name = stripped != null && !stripped.isEmpty() ? stripped : displayName;
        } else {
            name = this.friendlyMaterialName(item.getType());
        }
        if (name == null || name.isEmpty()) {
            name = this.fallbackMessages.unknownItem();
        }
        return amount + "x " + name;
    }

    private String friendlyMaterialName(Material material) {
        if (material == null) {
            return this.fallbackMessages.unknownMaterial();
        }
        String lowercase = material.name().toLowerCase(Locale.ENGLISH).replace('_', ' ');
        if (lowercase.isEmpty()) {
            return this.fallbackMessages.unknownMaterial();
        }
        return Character.toUpperCase(lowercase.charAt(0)) + lowercase.substring(1);
    }

    private String formatMessage(String template, String ... replacements) {
        if (template == null || template.isEmpty()) {
            return "";
        }
        String formatted = template;
        int i = 0;
        while (i + 1 < replacements.length) {
            String key = replacements[i];
            String value = replacements[i + 1];
            formatted = formatted.replace("{" + key + "}", value != null ? value : "");
            i += 2;
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)formatted);
    }
}

