/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.live;

import com.skyblockexp.ezauction.AuctionListing;
import com.skyblockexp.ezauction.AuctionManager;
import com.skyblockexp.ezauction.AuctionOperationResult;
import com.skyblockexp.ezauction.config.AuctionBackendMessages;
import com.skyblockexp.ezauction.config.AuctionListingRules;
import com.skyblockexp.ezauction.config.LiveAuctionConfiguration;
import com.skyblockexp.ezauction.live.LiveAuctionService;
import com.skyblockexp.ezauction.transaction.AuctionTransactionService;
import com.skyblockexp.ezauction.util.EconomyUtils;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.java.JavaPlugin;

public final class LiveAuctionManager {
    private final JavaPlugin plugin;
    private final AuctionTransactionService transactionService;
    private final AuctionListingRules listingRules;
    private final LiveAuctionService liveAuctionService;
    private final LiveAuctionConfiguration liveConfig;
    private final AuctionBackendMessages backendMessages;
    private final AuctionManager auctionManager;

    public LiveAuctionManager(JavaPlugin plugin, AuctionTransactionService transactionService, AuctionListingRules listingRules, LiveAuctionService liveAuctionService, LiveAuctionConfiguration liveConfig, AuctionBackendMessages backendMessages, AuctionManager auctionManager) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
        this.transactionService = Objects.requireNonNull(transactionService, "transactionService");
        this.listingRules = Objects.requireNonNull(listingRules, "listingRules");
        this.liveAuctionService = Objects.requireNonNull(liveAuctionService, "liveAuctionService");
        this.liveConfig = liveConfig != null ? liveConfig : LiveAuctionConfiguration.defaults();
        this.backendMessages = backendMessages != null ? backendMessages : AuctionBackendMessages.defaults();
        this.auctionManager = auctionManager;
    }

    public AuctionOperationResult createLiveListing(Player seller, ItemStack item, double price, Duration duration) {
        AuctionOperationResult result;
        AuctionOperationResult depositResult;
        ItemStack listingItem;
        PlayerInventory inv;
        AuctionBackendMessages.ListingMessages.CreationMessages creation = this.backendMessages.listing().creation();
        if (seller == null) {
            return AuctionOperationResult.failure(this.colorize(creation.playersOnly()));
        }
        if (item == null || item.getType() == Material.AIR || item.getAmount() <= 0) {
            return AuctionOperationResult.failure(this.colorize(creation.itemRequired()));
        }
        Duration sanitizedDuration = this.listingRules.clampDuration(duration);
        if (sanitizedDuration == null || sanitizedDuration.isZero() || sanitizedDuration.isNegative()) {
            return AuctionOperationResult.failure(this.colorize(creation.durationPositive()));
        }
        double normalizedPrice = EconomyUtils.normalizeCurrency(price);
        if (normalizedPrice <= 0.0) {
            return AuctionOperationResult.failure(this.colorize(creation.pricePositive()));
        }
        double minimumPrice = this.listingRules.minimumPrice();
        if (normalizedPrice < minimumPrice) {
            return AuctionOperationResult.failure(this.format(creation.priceMinimum(), "minimum", this.transactionService.formatCurrency(minimumPrice)));
        }
        double normalizedDeposit = EconomyUtils.normalizeCurrency(this.listingRules.depositAmount(normalizedPrice));
        if (normalizedDeposit < 0.0) {
            normalizedDeposit = 0.0;
        }
        if (!(inv = seller.getInventory()).containsAtLeast(listingItem = item.clone(), listingItem.getAmount())) {
            return AuctionOperationResult.failure(this.colorize(creation.inventoryMissing()));
        }
        if (normalizedDeposit > 0.0 && !(depositResult = this.transactionService.chargeListingDeposit(seller, normalizedDeposit)).success()) {
            return depositResult;
        }
        HashMap leftover = inv.removeItem(new ItemStack[]{listingItem});
        if (!leftover.isEmpty()) {
            if (normalizedDeposit > 0.0) {
                this.transactionService.refundListingDeposit(seller.getUniqueId(), normalizedDeposit);
            }
            return AuctionOperationResult.failure(this.colorize(creation.removalFailed()));
        }
        String id = UUID.randomUUID().toString();
        long expiry = System.currentTimeMillis() + sanitizedDuration.toMillis();
        AuctionListing listing = new AuctionListing(id, seller.getUniqueId(), normalizedPrice, expiry, listingItem, normalizedDeposit);
        this.liveAuctionService.enqueue(listing, seller.getUniqueId(), seller.getName());
        if (this.auctionManager != null && !(result = this.auctionManager.createListing(seller, listingItem, normalizedPrice, sanitizedDuration)).success()) {
            inv.addItem(new ItemStack[]{listingItem.clone()});
            if (normalizedDeposit > 0.0) {
                this.transactionService.refundListingDeposit(seller.getUniqueId(), normalizedDeposit);
            }
            return result;
        }
        boolean durationClamped = duration == null || !sanitizedDuration.equals(duration);
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(this.format(creation.success(), "item", this.describeItem(listingItem), "price", this.transactionService.formatCurrency(normalizedPrice)));
        if (normalizedDeposit > 0.0) {
            double depositPercent = this.listingRules.depositPercent();
            String percentText = depositPercent > 0.0 ? " (" + String.format(Locale.ENGLISH, "%.1f%%", depositPercent) + ")" : "";
            parts.add(this.format(creation.depositCharged(), "amount", this.transactionService.formatCurrency(normalizedDeposit), "percent", percentText));
        }
        if (durationClamped) {
            parts.add(this.format(creation.durationClamped(), "duration", this.formatDuration(sanitizedDuration)));
        }
        return AuctionOperationResult.success(String.join((CharSequence)" ", parts).trim());
    }

    private String describeItem(ItemStack item) {
        if (item == null) {
            return this.backendMessages.fallback().unknownItem();
        }
        ItemMeta meta = item.getItemMeta();
        if (meta != null && meta.hasDisplayName()) {
            String stripped = ChatColor.stripColor((String)meta.getDisplayName());
            if (stripped != null && !stripped.isEmpty()) {
                return item.getAmount() + "x " + stripped;
            }
            return item.getAmount() + "x " + meta.getDisplayName();
        }
        Object mat = item.getType().name().toLowerCase(Locale.ENGLISH).replace('_', ' ');
        if (((String)mat).isEmpty()) {
            mat = this.backendMessages.fallback().unknownMaterial();
        }
        mat = Character.toUpperCase(((String)mat).charAt(0)) + ((String)mat).substring(1);
        return item.getAmount() + "x " + (String)mat;
    }

    private String formatDuration(Duration duration) {
        long totalMinutes = duration.toMinutes();
        long days = totalMinutes / 1440L;
        long hours = (totalMinutes %= 1440L) / 60L;
        long minutes = totalMinutes % 60L;
        ArrayList<Object> parts = new ArrayList<Object>();
        if (days > 0L) {
            parts.add(days + "d");
        }
        if (hours > 0L) {
            parts.add(hours + "h");
        }
        if (minutes > 0L && days == 0L) {
            parts.add(minutes + "m");
        }
        if (parts.isEmpty()) {
            parts.add("0m");
        }
        return String.join((CharSequence)" ", parts);
    }

    private String colorize(String s) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)(s == null ? "" : s));
    }

    private String format(String template, String ... kv) {
        if (template == null || template.isEmpty()) {
            return "";
        }
        String out = template;
        int i = 0;
        while (i + 1 < kv.length) {
            out = out.replace("{" + kv[i] + "}", kv[i + 1] == null ? "" : kv[i + 1]);
            i += 2;
        }
        return this.colorize(out);
    }
}

