/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.hologram;

import com.skyblockexp.ezauction.AuctionListing;
import com.skyblockexp.ezauction.AuctionManager;
import com.skyblockexp.ezauction.AuctionOrder;
import com.skyblockexp.ezauction.transaction.AuctionTransactionService;
import java.time.Duration;
import java.util.Locale;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum AuctionHologramType {
    ACTIVE_LISTINGS("Active Listings", new String[]{"listings"}){

        @Override
        Component render(AuctionManager manager, AuctionTransactionService transactionService) {
            long count = manager.countActiveListings();
            String noun = count == 1L ? "listing" : "listings";
            return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(AuctionHologramType.title("Active Listings"))).append((Component)Component.newline())).append((Component)Component.text(String.format(Locale.US, "%d %s", count, noun), (TextColor)NamedTextColor.GREEN))).build();
        }
    }
    ,
    ACTIVE_ORDERS("Active Orders", new String[]{"orders"}){

        @Override
        Component render(AuctionManager manager, AuctionTransactionService transactionService) {
            long count = manager.countActiveOrders();
            String noun = count == 1L ? "order" : "orders";
            return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(AuctionHologramType.title("Active Orders"))).append((Component)Component.newline())).append((Component)Component.text(String.format(Locale.US, "%d %s", count, noun), (TextColor)NamedTextColor.GREEN))).build();
        }
    }
    ,
    HIGHEST_LISTING("Top Listing", new String[]{"top", "listing"}){

        @Override
        Component render(AuctionManager manager, AuctionTransactionService transactionService) {
            AuctionListing listing = manager.findHighestPricedListing();
            TextComponent.Builder builder = (TextComponent.Builder)Component.text().append(AuctionHologramType.title("Top Listing"));
            if (listing == null) {
                ((TextComponent.Builder)builder.append((Component)Component.newline())).append((Component)Component.text("No active listings", (TextColor)NamedTextColor.GRAY));
                return builder.build();
            }
            ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)builder.append((Component)Component.newline())).append((Component)Component.text(AuctionHologramType.describeItem(listing.item()), (TextColor)NamedTextColor.AQUA))).append((Component)Component.newline())).append((Component)Component.text(transactionService.formatCurrency(listing.price()), (TextColor)NamedTextColor.GOLD));
            return builder.build();
        }
    }
    ,
    BEST_BUY_ORDER("Best Buy Order", new String[]{"buy", "order"}){

        @Override
        Component render(AuctionManager manager, AuctionTransactionService transactionService) {
            AuctionOrder order = manager.findHighestPricedOrder();
            TextComponent.Builder builder = (TextComponent.Builder)Component.text().append(AuctionHologramType.title("Best Buy Order"));
            if (order == null) {
                ((TextComponent.Builder)builder.append((Component)Component.newline())).append((Component)Component.text("No active orders", (TextColor)NamedTextColor.GRAY));
                return builder.build();
            }
            ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)builder.append((Component)Component.newline())).append((Component)Component.text(AuctionHologramType.describeItem(order.requestedItem()), (TextColor)NamedTextColor.AQUA))).append((Component)Component.newline())).append((Component)Component.text(transactionService.formatCurrency(order.offeredPrice()), (TextColor)NamedTextColor.GOLD));
            return builder.build();
        }
    }
    ,
    NEXT_EXPIRING("Next Expiring", new String[]{"expiring", "expires"}){

        @Override
        Component render(AuctionManager manager, AuctionTransactionService transactionService) {
            AuctionListing listing = manager.findNextExpiringListing();
            TextComponent.Builder builder = (TextComponent.Builder)Component.text().append(AuctionHologramType.title("Next Expiring"));
            if (listing == null) {
                ((TextComponent.Builder)builder.append((Component)Component.newline())).append((Component)Component.text("No active listings", (TextColor)NamedTextColor.GRAY));
                return builder.build();
            }
            long remainingMillis = listing.expiryEpochMillis() - System.currentTimeMillis();
            Duration remaining = remainingMillis > 0L ? Duration.ofMillis(remainingMillis) : Duration.ZERO;
            ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)builder.append((Component)Component.newline())).append((Component)Component.text(AuctionHologramType.describeItem(listing.item()), (TextColor)NamedTextColor.AQUA))).append((Component)Component.newline())).append((Component)Component.text("Ends in " + AuctionHologramType.formatDuration(remaining), (TextColor)NamedTextColor.YELLOW));
            return builder.build();
        }
    };

    private static final PlainTextComponentSerializer PLAIN_SERIALIZER;
    private final String displayName;
    private final String[] aliases;

    private AuctionHologramType(String displayName, String ... aliases) {
        this.displayName = displayName;
        this.aliases = aliases != null ? (String[])aliases.clone() : new String[]{};
    }

    public String displayName() {
        return this.displayName;
    }

    public String[] aliases() {
        return (String[])this.aliases.clone();
    }

    abstract Component render(AuctionManager var1, AuctionTransactionService var2);

    public static AuctionHologramType fromName(String input) {
        if (input == null || input.isBlank()) {
            return null;
        }
        String normalized = input.trim().toUpperCase(Locale.ENGLISH).replace('-', '_').replace(' ', '_');
        for (AuctionHologramType type : AuctionHologramType.values()) {
            if (type.name().equals(normalized)) {
                return type;
            }
            for (String alias : type.aliases) {
                if (alias.equalsIgnoreCase(input)) {
                    return type;
                }
                if (!alias.equalsIgnoreCase(normalized)) continue;
                return type;
            }
        }
        return null;
    }

    private static Component title(String value) {
        return Component.text(value, (TextColor)NamedTextColor.GOLD, TextDecoration.BOLD);
    }

    private static String describeItem(ItemStack item) {
        ItemMeta meta;
        if (item == null) {
            return "Unknown item";
        }
        int amount = Math.max(1, item.getAmount());
        String baseName = AuctionHologramType.friendlyMaterialName(item);
        if (item.hasItemMeta() && (meta = item.getItemMeta()) != null) {
            String plain;
            Component component;
            String legacyName;
            if (meta.hasDisplayName() && (legacyName = meta.getDisplayName()) != null && !legacyName.isBlank()) {
                baseName = legacyName;
            }
            if ((component = meta.displayName()) != null && !(plain = PLAIN_SERIALIZER.serialize(component).trim()).isEmpty()) {
                baseName = plain;
            }
        }
        return amount + "x " + baseName;
    }

    private static String friendlyMaterialName(ItemStack item) {
        if (item == null || item.getType() == null) {
            return "Unknown";
        }
        String name = item.getType().name().toLowerCase(Locale.ENGLISH).replace('_', ' ');
        if (name.isEmpty()) {
            return "Unknown";
        }
        return Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    private static String formatDuration(Duration duration) {
        if (duration == null || duration.isNegative() || duration.isZero()) {
            return "now";
        }
        long seconds = duration.getSeconds();
        long days = seconds / 86400L;
        long hours = seconds % 86400L / 3600L;
        long minutes = seconds % 3600L / 60L;
        if (days > 0L) {
            return String.format(Locale.US, "%dd %dh", days, hours);
        }
        if (hours > 0L) {
            return String.format(Locale.US, "%dh %dm", hours, minutes);
        }
        if (minutes > 0L) {
            return String.format(Locale.US, "%dm", minutes);
        }
        return String.format(Locale.US, "%ds", Math.max(1L, seconds % 60L));
    }

    static {
        PLAIN_SERIALIZER = PlainTextComponentSerializer.plainText();
    }
}

