/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.gui;

import com.skyblockexp.ezauction.AuctionManager;
import com.skyblockexp.ezauction.AuctionOperationResult;
import com.skyblockexp.ezauction.compat.ItemTagStorage;
import com.skyblockexp.ezauction.config.AuctionListingRules;
import com.skyblockexp.ezauction.config.AuctionMenuInteractionConfiguration;
import com.skyblockexp.ezauction.config.AuctionMessageConfiguration;
import com.skyblockexp.ezauction.gui.SellMenuHolder;
import com.skyblockexp.ezauction.gui.SellMenuState;
import com.skyblockexp.ezauction.live.LiveAuctionManager;
import com.skyblockexp.ezauction.transaction.AuctionTransactionService;
import com.skyblockexp.ezauction.util.EconomyUtils;
import com.skyblockexp.ezauction.util.ItemValueProvider;
import com.skyblockexp.ezauction.util.NumberShortcutParser;
import java.lang.invoke.CallSite;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class AuctionSellMenu {
    private static final String ACTION_PRICE_ADJUST = "price_adjust";
    private static final String ACTION_PRICE_CUSTOM = "price_custom";
    private static final String ACTION_DURATION_NEXT = "duration_next";
    private static final String ACTION_CONFIRM = "confirm";
    private static final String ACTION_CANCEL = "cancel";
    private final JavaPlugin plugin;
    private final AuctionManager auctionManager;
    private final AuctionTransactionService transactionService;
    private final AuctionListingRules listingRules;
    private final ItemValueProvider itemValueProvider;
    private final String actionKey;
    private final String priceAdjustKey;
    private final ItemTagStorage itemTagStorage;
    private final AuctionMenuInteractionConfiguration.SellMenuLayoutConfiguration layout;
    private final ItemStack fillerPane;
    private final ConcurrentMap<UUID, SellMenuState> pendingPriceInputs;
    private final ConcurrentMap<UUID, SellMenuHolder.Target> pendingTargets = new ConcurrentHashMap<UUID, SellMenuHolder.Target>();
    private final Duration[] durationOptions;
    private final int defaultDurationIndex;
    private final double minimumPrice;
    private final Duration longestDurationOption;
    private final double defaultPrice;
    private final double[] priceAdjustments;
    private final AuctionMessageConfiguration.SellMessages messages;
    private LiveAuctionManager liveAuctionManager;

    public AuctionSellMenu(JavaPlugin plugin, AuctionManager auctionManager, AuctionTransactionService transactionService, AuctionListingRules listingRules, List<Duration> configuredDurationOptions, AuctionMenuInteractionConfiguration.SellMenuInteractionConfiguration sellConfiguration, ItemValueProvider itemValueProvider, AuctionMessageConfiguration.SellMessages messages, ItemTagStorage itemTagStorage) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
        this.auctionManager = Objects.requireNonNull(auctionManager, "auctionManager");
        this.transactionService = Objects.requireNonNull(transactionService, "transactionService");
        this.listingRules = Objects.requireNonNull(listingRules, "listingRules");
        this.itemValueProvider = itemValueProvider != null ? itemValueProvider : ItemValueProvider.none();
        this.messages = messages != null ? messages : AuctionMessageConfiguration.SellMessages.defaults();
        this.actionKey = "auction_sell_action";
        this.priceAdjustKey = "auction_sell_adjust";
        this.itemTagStorage = Objects.requireNonNull(itemTagStorage, "itemTagStorage");
        this.pendingPriceInputs = new ConcurrentHashMap<UUID, SellMenuState>();
        this.durationOptions = this.buildDurationOptions(listingRules, configuredDurationOptions);
        this.defaultDurationIndex = this.resolveDefaultDurationIndex(this.durationOptions, listingRules.defaultDuration());
        this.minimumPrice = Math.max(0.0, listingRules.minimumPrice());
        this.longestDurationOption = this.resolveLongestDuration(this.durationOptions, listingRules);
        AuctionMenuInteractionConfiguration.SellMenuInteractionConfiguration interactions = sellConfiguration != null ? sellConfiguration : AuctionMenuInteractionConfiguration.defaults().sellMenu();
        this.layout = interactions.layout();
        this.fillerPane = this.createBaseItem(this.layout.filler());
        this.defaultPrice = Math.max(0.0, interactions.defaultPrice());
        List<Double> adjustments = interactions.priceAdjustments();
        this.priceAdjustments = new double[adjustments.size()];
        for (int i = 0; i < adjustments.size(); ++i) {
            Double value = adjustments.get(i);
            this.priceAdjustments[i] = value != null ? value : 0.0;
        }
        this.liveAuctionManager = null;
    }

    public AuctionSellMenu(JavaPlugin plugin, AuctionManager auctionManager, LiveAuctionManager liveAuctionManager, AuctionTransactionService transactionService, AuctionListingRules listingRules, List<Duration> configuredDurationOptions, AuctionMenuInteractionConfiguration.SellMenuInteractionConfiguration sellConfiguration, ItemValueProvider itemValueProvider, AuctionMessageConfiguration.SellMessages messages, ItemTagStorage itemTagStorage) {
        this(plugin, auctionManager, transactionService, listingRules, configuredDurationOptions, sellConfiguration, itemValueProvider, messages, itemTagStorage);
        this.liveAuctionManager = liveAuctionManager;
    }

    public void openSellMenu(Player player, SellMenuHolder.Target target) {
        double normalized;
        if (player == null) {
            return;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || item.getType() == Material.AIR) {
            this.sendMessage(player, this.messages.itemRequired());
            return;
        }
        double startingPrice = Math.max(this.minimumPrice, this.defaultPrice);
        Double recommendedPrice = null;
        OptionalDouble estimate = this.itemValueProvider.estimate(item);
        if (estimate.isPresent() && estimate.getAsDouble() > 0.0 && (normalized = EconomyUtils.normalizeCurrency(Math.max(this.minimumPrice, estimate.getAsDouble()))) > 0.0) {
            recommendedPrice = normalized;
            startingPrice = normalized;
        }
        SellMenuState state = new SellMenuState(item.clone(), startingPrice, this.defaultDurationIndex, recommendedPrice, this.durationOptions, this.listingRules);
        this.openSellMenu(player, state, target);
    }

    private void openSellMenu(Player player, SellMenuState state, SellMenuHolder.Target target) {
        if (player == null || state == null) {
            return;
        }
        SellMenuHolder holder = new SellMenuHolder(player.getUniqueId(), state);
        holder.setTarget(target);
        Inventory inventory = Bukkit.createInventory((InventoryHolder)holder, (int)this.layout.size(), (String)this.colorize(this.layout.title()));
        holder.setInventory(inventory);
        this.refreshMenu(holder);
        player.openInventory(inventory);
    }

    private void refreshMenu(SellMenuHolder holder) {
        Inventory inventory = holder.getInventory();
        if (inventory == null) {
            return;
        }
        inventory.clear();
        this.applyFiller(inventory);
        this.placePriceAdjustmentButtons(inventory);
        ItemStack listingItem = holder.state().item();
        ItemMeta meta = listingItem.getItemMeta();
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(String.valueOf(ChatColor.GRAY) + "Listing Price: " + String.valueOf(ChatColor.GOLD) + this.formatPrice(holder.state().price()));
        Double recommended = holder.state().recommendedPrice();
        if (recommended != null) {
            lore.add(String.valueOf(ChatColor.GRAY) + "Recommended Price: " + String.valueOf(ChatColor.GOLD) + this.formatPrice(recommended));
        }
        lore.add(String.valueOf(ChatColor.GRAY) + "Duration: " + String.valueOf(ChatColor.YELLOW) + this.formatDuration(holder.state().duration()));
        lore.add(" ");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Confirm below to create the listing.");
        if (meta != null) {
            List existingLore = meta.hasLore() ? meta.getLore() : List.of();
            ArrayList<Object> combined = new ArrayList<Object>(existingLore);
            if (!combined.isEmpty()) {
                combined.add(" ");
            }
            combined.addAll(lore);
            meta.setLore(combined);
            listingItem.setItemMeta(meta);
        }
        inventory.setItem(this.layout.listingSlot(), listingItem);
        ItemStack priceDisplay = this.createPriceDisplay(holder);
        inventory.setItem(this.layout.priceDisplay().slot(), priceDisplay);
        ItemStack durationDisplay = this.createDurationDisplay(holder);
        this.setPersistent(durationDisplay, this.actionKey, ACTION_DURATION_NEXT);
        inventory.setItem(this.layout.durationDisplay().slot(), durationDisplay);
        ItemStack customPrice = this.createCustomPriceButton();
        this.setPersistent(customPrice, this.actionKey, ACTION_PRICE_CUSTOM);
        inventory.setItem(this.layout.customPrice().slot(), customPrice);
        ItemStack confirm = this.createConfirmButton(holder);
        this.setPersistent(confirm, this.actionKey, ACTION_CONFIRM);
        inventory.setItem(this.layout.confirmButton().slot(), confirm);
        ItemStack cancel = this.createCancelButton();
        this.setPersistent(cancel, this.actionKey, ACTION_CANCEL);
        inventory.setItem(this.layout.cancelButton().slot(), cancel);
    }

    private void placePriceAdjustmentButtons(Inventory inventory) {
        double[] adjustments = this.priceAdjustments;
        int[] slots = this.layout.priceAdjustmentSlots();
        for (int i = 0; i < adjustments.length && i < slots.length; ++i) {
            double amount = adjustments[i];
            if (amount == 0.0) continue;
            ItemStack button = this.createPriceAdjustButton(amount);
            this.setPersistent(button, this.actionKey, ACTION_PRICE_ADJUST);
            this.setPersistent(button, this.priceAdjustKey, amount);
            inventory.setItem(slots[i], button);
        }
    }

    private ItemStack createBaseItem(AuctionMenuInteractionConfiguration.MenuButtonDefinition definition) {
        ItemMeta meta;
        ItemStack item;
        Material material = Material.GRAY_STAINED_GLASS_PANE;
        String displayName = null;
        if (definition != null) {
            Material configured = definition.material();
            if (configured != null) {
                material = configured;
            }
            displayName = definition.displayName();
        }
        ItemStack itemStack = item = material != null ? new ItemStack(material) : null;
        if (item == null) {
            item = new ItemStack(Material.STONE);
        }
        if ((meta = item.getItemMeta()) != null) {
            if (displayName != null && !displayName.isEmpty()) {
                meta.setDisplayName(this.colorize(displayName));
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createPriceDisplay(SellMenuHolder holder) {
        AuctionMenuInteractionConfiguration.ButtonLayoutConfiguration definition = this.layout.priceDisplay();
        ItemStack item = this.createBaseItem(definition.button());
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            double depositPercent;
            String displayName = definition.button().displayName();
            if (displayName != null && !displayName.isEmpty()) {
                meta.setDisplayName(this.colorize(displayName));
            }
            ArrayList<CallSite> lore = new ArrayList<CallSite>();
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Current Price: " + String.valueOf(ChatColor.GOLD) + this.formatPrice(holder.state().price()))));
            Double recommended = holder.state().recommendedPrice();
            if (recommended != null) {
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Recommended Price: " + String.valueOf(ChatColor.GOLD) + this.formatPrice(recommended))));
            }
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Use the buttons above to adjust.")));
            if (this.minimumPrice > 0.0) {
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Minimum Price: " + String.valueOf(ChatColor.GOLD) + this.formatPrice(this.minimumPrice))));
            }
            if ((depositPercent = this.listingRules.depositPercent()) > 0.0) {
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Deposit: " + String.valueOf(ChatColor.GOLD) + String.format(Locale.ENGLISH, "%.1f%%", depositPercent))));
            }
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createDurationDisplay(SellMenuHolder holder) {
        AuctionMenuInteractionConfiguration.ButtonLayoutConfiguration definition = this.layout.durationDisplay();
        ItemStack item = this.createBaseItem(definition.button());
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            String displayName = definition.button().displayName();
            if (displayName != null && !displayName.isEmpty()) {
                meta.setDisplayName(this.colorize(displayName));
            }
            ArrayList<CallSite> lore = new ArrayList<CallSite>();
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Current Duration: " + String.valueOf(ChatColor.YELLOW) + this.formatDuration(holder.state().duration()))));
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Click to cycle through available durations.")));
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Longest Option: " + String.valueOf(ChatColor.YELLOW) + this.formatDuration(this.longestDurationOption))));
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createCustomPriceButton() {
        AuctionMenuInteractionConfiguration.ButtonLayoutConfiguration definition = this.layout.customPrice();
        ItemStack item = this.createBaseItem(definition.button());
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            String displayName = definition.button().displayName();
            if (displayName != null && !displayName.isEmpty()) {
                meta.setDisplayName(this.colorize(displayName));
            }
            ArrayList<CallSite> lore = new ArrayList<CallSite>();
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Enter a custom price in chat.")));
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.DARK_GRAY) + "Type 'cancel' to abort.")));
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createConfirmButton(SellMenuHolder holder) {
        AuctionMenuInteractionConfiguration.ButtonLayoutConfiguration definition = this.layout.confirmButton();
        ItemStack item = this.createBaseItem(definition.button());
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            String displayName = definition.button().displayName();
            if (displayName != null && !displayName.isEmpty()) {
                meta.setDisplayName(this.colorize(displayName));
            }
            ArrayList<Object> lore = new ArrayList<Object>();
            lore.add(String.valueOf(ChatColor.GRAY) + "Item: " + String.valueOf(ChatColor.AQUA) + this.describeItem(holder.state().item()));
            lore.add(String.valueOf(ChatColor.GRAY) + "Price: " + String.valueOf(ChatColor.GOLD) + this.formatPrice(holder.state().price()));
            Double recommended = holder.state().recommendedPrice();
            if (recommended != null) {
                lore.add(String.valueOf(ChatColor.GRAY) + "Recommended Price: " + String.valueOf(ChatColor.GOLD) + this.formatPrice(recommended));
            }
            lore.add(String.valueOf(ChatColor.GRAY) + "Duration: " + String.valueOf(ChatColor.YELLOW) + this.formatDuration(holder.state().duration()));
            double depositAmount = EconomyUtils.normalizeCurrency(this.listingRules.depositAmount(holder.state().price()));
            if (depositAmount > 0.0) {
                lore.add(String.valueOf(ChatColor.GRAY) + "Deposit Charged: " + String.valueOf(ChatColor.GOLD) + this.formatPrice(depositAmount) + String.valueOf(ChatColor.GRAY) + " (" + String.format(Locale.ENGLISH, "%.1f%%", this.listingRules.depositPercent()) + ")");
            }
            lore.add(" ");
            lore.add(String.valueOf(ChatColor.GREEN) + "Click to list this item on the auction house.");
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createCancelButton() {
        AuctionMenuInteractionConfiguration.ButtonLayoutConfiguration definition = this.layout.cancelButton();
        ItemStack item = this.createBaseItem(definition.button());
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            String displayName = definition.button().displayName();
            if (displayName != null && !displayName.isEmpty()) {
                meta.setDisplayName(this.colorize(displayName));
            }
            meta.setLore(List.of(String.valueOf(ChatColor.GRAY) + "Return to the previous menu."));
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createPriceAdjustButton(double amount) {
        ItemMeta meta;
        ItemStack item;
        boolean positive = amount > 0.0;
        double displayAmount = Math.abs(amount);
        Material material = displayAmount >= 1000.0 ? (positive ? Material.DIAMOND_BLOCK : Material.REDSTONE_BLOCK) : (displayAmount >= 100.0 ? (positive ? Material.DIAMOND : Material.REDSTONE) : (displayAmount >= 10.0 ? (positive ? Material.EMERALD_BLOCK : Material.REDSTONE_TORCH) : (positive ? Material.EMERALD : Material.COAL)));
        String prefix = positive ? String.valueOf(ChatColor.GREEN) + "+" : String.valueOf(ChatColor.RED) + "-";
        String display = prefix + this.formatNumber(displayAmount);
        ItemStack itemStack = item = material != null ? new ItemStack(material) : null;
        if (item == null) {
            item = new ItemStack(Material.STONE);
        }
        if ((meta = item.getItemMeta()) != null) {
            meta.setDisplayName(display + String.valueOf(ChatColor.GOLD) + " coins");
            ArrayList<CallSite> lore = new ArrayList<CallSite>();
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Adjust the price by this amount.")));
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    private String formatNumber(double amount) {
        if (amount >= 1000.0 && amount % 1000.0 == 0.0) {
            return String.format(Locale.ENGLISH, "%.0fk", amount / 1000.0);
        }
        if (amount % 1.0 == 0.0) {
            return String.format(Locale.ENGLISH, "%.0f", amount);
        }
        return String.format(Locale.ENGLISH, "%.2f", amount);
    }

    private void applyFiller(Inventory inventory) {
        if (this.fillerPane == null) {
            return;
        }
        for (int slot = 0; slot < inventory.getSize(); ++slot) {
            ItemStack current = inventory.getItem(slot);
            if (current != null && current.getType() != Material.AIR) continue;
            inventory.setItem(slot, this.fillerPane.clone());
        }
    }

    private String colorize(String input) {
        if (input == null) {
            return "";
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)input);
    }

    private void sendMessage(Player player, String message) {
        if (player == null || message == null || message.isEmpty()) {
            return;
        }
        player.sendMessage(this.colorize(message));
    }

    private void setPersistent(ItemStack item, String key, String value) {
        if (item == null || key == null || value == null) {
            return;
        }
        this.itemTagStorage.setString(item, key, value);
    }

    private void setPersistent(ItemStack item, String key, double value) {
        if (item == null || key == null) {
            return;
        }
        this.itemTagStorage.setDouble(item, key, value);
    }

    private String formatPrice(double price) {
        return this.transactionService.formatCurrency(price);
    }

    private String formatDuration(Duration duration) {
        long totalMinutes = duration.toMinutes();
        long days = totalMinutes / 1440L;
        long hours = (totalMinutes %= 1440L) / 60L;
        long minutes = totalMinutes % 60L;
        ArrayList<Object> parts = new ArrayList<Object>();
        if (days > 0L) {
            parts.add(days + "d");
        }
        if (hours > 0L) {
            parts.add(hours + "h");
        }
        if (minutes > 0L && days == 0L) {
            parts.add(minutes + "m");
        }
        if (parts.isEmpty()) {
            parts.add("0m");
        }
        return String.join((CharSequence)" ", parts);
    }

    private String describeItem(ItemStack item) {
        if (item == null) {
            return "Unknown";
        }
        ItemMeta meta = item.getItemMeta();
        if (meta != null && meta.hasDisplayName()) {
            return ChatColor.stripColor((String)meta.getDisplayName());
        }
        return this.formatMaterialName(item.getType());
    }

    private String formatMaterialName(Material material) {
        if (material == null) {
            return "Unknown";
        }
        String[] parts = material.name().toLowerCase(Locale.ENGLISH).split("_");
        StringBuilder builder = new StringBuilder();
        for (String part : parts) {
            if (part.isEmpty()) continue;
            builder.append(Character.toUpperCase(part.charAt(0))).append(part.substring(1)).append(' ');
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    public void handleInventoryDrag(InventoryDragEvent event) {
        Inventory topInventory = event.getView().getTopInventory();
        InventoryHolder inventoryHolder = topInventory.getHolder();
        if (!(inventoryHolder instanceof SellMenuHolder)) {
            return;
        }
        SellMenuHolder holder = (SellMenuHolder)inventoryHolder;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!holder.owner().equals(player.getUniqueId())) {
            return;
        }
        int topSize = topInventory.getSize();
        boolean affectsTop = event.getRawSlots().stream().anyMatch(slot -> slot < topSize);
        if (affectsTop) {
            event.setCancelled(true);
        }
    }

    public void handleInventoryClick(InventoryClickEvent event) {
        InventoryHolder inventoryHolder = event.getView().getTopInventory().getHolder();
        if (!(inventoryHolder instanceof SellMenuHolder)) {
            return;
        }
        SellMenuHolder holder = (SellMenuHolder)inventoryHolder;
        event.setCancelled(true);
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!holder.owner().equals(player.getUniqueId())) {
            return;
        }
        if (event.getClickedInventory() == null || event.getClickedInventory().getHolder() != holder) {
            return;
        }
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        String action = this.itemTagStorage.getString(clicked, this.actionKey);
        if (action == null) {
            return;
        }
        switch (action) {
            case "price_adjust": {
                this.handlePriceAdjust(player, holder, clicked);
                break;
            }
            case "price_custom": {
                this.startCustomPriceInput(player, holder);
                break;
            }
            case "duration_next": {
                holder.state().cycleDuration();
                this.refreshMenu(holder);
                break;
            }
            case "confirm": {
                this.handleConfirm(player, holder);
                break;
            }
            case "cancel": {
                player.closeInventory();
                break;
            }
        }
    }

    public void handleAsyncPlayerChat(AsyncPlayerChatEvent event) {
        UUID playerId = event.getPlayer().getUniqueId();
        SellMenuState state = (SellMenuState)this.pendingPriceInputs.get(playerId);
        if (state == null) {
            return;
        }
        event.setCancelled(true);
        this.pendingPriceInputs.remove(playerId);
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.handleCustomPriceInput(event.getPlayer(), state, event.getMessage()));
    }

    public void handlePlayerQuit(PlayerQuitEvent event) {
        this.pendingPriceInputs.remove(event.getPlayer().getUniqueId());
    }

    private void handlePriceAdjust(Player player, SellMenuHolder holder, ItemStack clicked) {
        Double amount = this.itemTagStorage.getDouble(clicked, this.priceAdjustKey);
        if (amount == null) {
            return;
        }
        double newPrice = EconomyUtils.normalizeCurrency(holder.state().price() + amount);
        if (newPrice < this.minimumPrice) {
            newPrice = this.minimumPrice;
        }
        holder.state().setPrice(newPrice);
        this.refreshMenu(holder);
    }

    private void handleConfirm(Player player, SellMenuHolder holder) {
        SellMenuState state = holder.state();
        if (state.price() < this.minimumPrice) {
            this.sendMessage(player, this.messages.priceMinimum().replace("{minimum}", this.formatPrice(this.minimumPrice)));
            this.refreshMenu(holder);
            return;
        }
        AuctionOperationResult result = holder.target() == SellMenuHolder.Target.LIVE && this.liveAuctionManager != null ? this.liveAuctionManager.createLiveListing(player, state.item(), state.price(), state.duration()) : this.auctionManager.createListing(player, state.item(), state.price(), state.duration());
        if (result.message() != null && !result.message().isEmpty()) {
            player.sendMessage(result.message());
        }
        if (result.success()) {
            player.closeInventory();
        } else {
            this.refreshMenu(holder);
        }
    }

    private void startCustomPriceInput(Player player, SellMenuHolder holder) {
        this.pendingPriceInputs.put(player.getUniqueId(), holder.state());
        this.pendingTargets.put(player.getUniqueId(), holder.target());
        player.closeInventory();
        this.sendMessage(player, this.messages.pricePrompt());
    }

    private void handleCustomPriceInput(Player player, SellMenuState state, String message) {
        double value;
        String input;
        if (player == null || state == null) {
            return;
        }
        SellMenuHolder.Target target = this.pendingTargets.getOrDefault(player.getUniqueId(), SellMenuHolder.Target.NORMAL);
        this.pendingTargets.remove(player.getUniqueId());
        String string = input = message == null ? "" : message.trim();
        if (input.equalsIgnoreCase(ACTION_CANCEL)) {
            this.sendMessage(player, this.messages.priceEntryCancelled());
            this.openSellMenu(player, state, target);
            return;
        }
        try {
            value = NumberShortcutParser.parse(input);
        }
        catch (IllegalArgumentException ex) {
            this.sendMessage(player, this.messages.priceInvalidNumber());
            this.openSellMenu(player, state, target);
            return;
        }
        if (value <= 0.0) {
            this.sendMessage(player, this.messages.priceMustBePositive());
            this.openSellMenu(player, state, target);
            return;
        }
        double normalized = EconomyUtils.normalizeCurrency(value);
        if (normalized < this.minimumPrice) {
            normalized = this.minimumPrice;
        }
        state.setPrice(normalized);
        this.sendMessage(player, this.messages.priceUpdated().replace("{price}", this.formatPrice(normalized)));
        this.openSellMenu(player, state, target);
    }

    private Duration[] buildDurationOptions(AuctionListingRules rules, List<Duration> configuredOptions) {
        Objects.requireNonNull(rules, "rules");
        TreeSet<Long> minutes = new TreeSet<Long>();
        boolean usedConfigured = false;
        if (configuredOptions != null) {
            for (Duration duration : configuredOptions) {
                Duration sanitized;
                if (duration == null || duration.isNegative() || duration.isZero() || (sanitized = rules.clampDuration(duration)) == null || sanitized.isNegative() || sanitized.isZero()) continue;
                minutes.add(Math.max(1L, sanitized.toMinutes()));
                usedConfigured = true;
            }
        }
        if (!usedConfigured) {
            Duration maxDuration;
            Duration[] defaults;
            for (Duration candidate : defaults = new Duration[]{Duration.ofHours(6L), Duration.ofHours(12L), Duration.ofHours(24L), Duration.ofHours(48L)}) {
                Duration sanitized = rules.clampDuration(candidate);
                if (sanitized == null || sanitized.isNegative() || sanitized.isZero()) continue;
                minutes.add(Math.max(1L, sanitized.toMinutes()));
            }
            Duration duration = rules.clampDuration(rules.defaultDuration());
            if (duration != null && !duration.isNegative() && !duration.isZero()) {
                minutes.add(Math.max(1L, duration.toMinutes()));
            }
            if ((maxDuration = rules.maxDuration()) != null && !maxDuration.isNegative() && !maxDuration.isZero()) {
                minutes.add(Math.max(1L, maxDuration.toMinutes()));
            }
        }
        if (minutes.isEmpty()) {
            minutes.add(Math.max(1L, Duration.ofHours(24L).toMinutes()));
        }
        Duration[] options = new Duration[minutes.size()];
        boolean bl = false;
        for (Long minute : minutes) {
            options[++var6_11] = Duration.ofMinutes(Math.max(1L, minute));
        }
        return options;
    }

    private Duration resolveLongestDuration(Duration[] options, AuctionListingRules rules) {
        Duration fallback;
        if (options != null && options.length > 0) {
            return options[options.length - 1];
        }
        Duration duration = fallback = rules != null ? rules.maxDuration() : null;
        if (fallback == null || fallback.isNegative() || fallback.isZero()) {
            Duration duration2 = fallback = rules != null ? rules.defaultDuration() : null;
        }
        if (fallback == null || fallback.isNegative() || fallback.isZero()) {
            fallback = Duration.ofHours(24L);
        }
        return fallback;
    }

    private int resolveDefaultDurationIndex(Duration[] options, Duration defaultDuration) {
        if (options == null || options.length == 0 || defaultDuration == null) {
            return 0;
        }
        long targetMinutes = Math.max(1L, defaultDuration.toMinutes());
        for (int i = 0; i < options.length; ++i) {
            if (options[i] == null || Math.max(1L, options[i].toMinutes()) != targetMinutes) continue;
            return i;
        }
        return 0;
    }
}

