/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.config;

import com.skyblockexp.ezauction.util.NumberShortcutParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;

public final class AuctionMenuInteractionConfiguration {
    private static final SellMenuInteractionConfiguration DEFAULT_SELL = SellMenuInteractionConfiguration.defaults();
    private static final OrderMenuInteractionConfiguration DEFAULT_ORDERS = OrderMenuInteractionConfiguration.defaults();
    private final SellMenuInteractionConfiguration sellMenu;
    private final OrderMenuInteractionConfiguration orderMenu;

    public AuctionMenuInteractionConfiguration(SellMenuInteractionConfiguration sellMenu, OrderMenuInteractionConfiguration orderMenu) {
        this.sellMenu = sellMenu != null ? sellMenu : DEFAULT_SELL;
        this.orderMenu = orderMenu != null ? orderMenu : DEFAULT_ORDERS;
    }

    public SellMenuInteractionConfiguration sellMenu() {
        return this.sellMenu;
    }

    public OrderMenuInteractionConfiguration orderMenu() {
        return this.orderMenu;
    }

    public static AuctionMenuInteractionConfiguration defaults() {
        return new AuctionMenuInteractionConfiguration(DEFAULT_SELL, DEFAULT_ORDERS);
    }

    public static AuctionMenuInteractionConfiguration from(ConfigurationSection section) {
        if (section == null) {
            return AuctionMenuInteractionConfiguration.defaults();
        }
        SellMenuInteractionConfiguration sell = SellMenuInteractionConfiguration.from(section.getConfigurationSection("sell"));
        OrderMenuInteractionConfiguration orders = OrderMenuInteractionConfiguration.from(section.getConfigurationSection("orders"));
        return new AuctionMenuInteractionConfiguration(sell, orders);
    }

    public String toString() {
        return "AuctionMenuInteractionConfiguration{sellMenu=" + String.valueOf(this.sellMenu) + ", orderMenu=" + String.valueOf(this.orderMenu) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuctionMenuInteractionConfiguration)) {
            return false;
        }
        AuctionMenuInteractionConfiguration that = (AuctionMenuInteractionConfiguration)o;
        return Objects.equals(this.sellMenu, that.sellMenu) && Objects.equals(this.orderMenu, that.orderMenu);
    }

    public int hashCode() {
        return Objects.hash(this.sellMenu, this.orderMenu);
    }

    private static Double parseDouble(Object value) {
        if (value instanceof Number) {
            Number number = (Number)value;
            double parsed = number.doubleValue();
            if (Double.isFinite(parsed)) {
                return parsed;
            }
            return null;
        }
        if (value instanceof String) {
            String text = (String)value;
            String trimmed = text.trim();
            if (trimmed.isEmpty()) {
                return null;
            }
            try {
                double parsed = NumberShortcutParser.parse(trimmed);
                if (Double.isFinite(parsed)) {
                    return parsed;
                }
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
        }
        return null;
    }

    private static Integer parseInteger(Object value) {
        if (value instanceof Number) {
            Number number = (Number)value;
            double parsed = number.doubleValue();
            if (!Double.isFinite(parsed)) {
                return null;
            }
            if (Math.floor(parsed) != parsed) {
                return null;
            }
            if (parsed < -2.147483648E9 || parsed > 2.147483647E9) {
                return null;
            }
            return (int)parsed;
        }
        if (value instanceof String) {
            String text = (String)value;
            String trimmed = text.trim();
            if (trimmed.isEmpty()) {
                return null;
            }
            try {
                double parsed = NumberShortcutParser.parse(trimmed);
                if (!Double.isFinite(parsed) || Math.floor(parsed) != parsed) {
                    return null;
                }
                if (parsed < -2.147483648E9 || parsed > 2.147483647E9) {
                    return null;
                }
                return (int)parsed;
            }
            catch (IllegalArgumentException ignored) {
                return null;
            }
        }
        return null;
    }

    private static Material parseMaterial(String value, Material fallback) {
        if (value == null || value.trim().isEmpty()) {
            return fallback;
        }
        String normalized = value.trim().replace(' ', '_');
        try {
            return Material.valueOf((String)normalized.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException ex) {
            return fallback;
        }
    }

    private static int sanitizeInventorySize(int requested, int fallback) {
        int size = requested;
        if (size <= 0 || size % 9 != 0) {
            size = fallback;
        }
        if (size > 54) {
            size = 54;
        }
        return size;
    }

    private static int sanitizeSlot(int value, int size, int fallback) {
        if (value < 0 || value >= size) {
            return fallback;
        }
        return value;
    }

    private static int[] sanitizeSlots(List<?> rawValues, int size, int[] fallback) {
        if (rawValues == null || rawValues.isEmpty()) {
            return fallback != null ? (int[])fallback.clone() : new int[]{};
        }
        ArrayList<Integer> parsed = new ArrayList<Integer>();
        for (Object rawValue : rawValues) {
            int slot;
            Integer parsedValue = AuctionMenuInteractionConfiguration.parseInteger(rawValue);
            if (parsedValue == null || (slot = parsedValue.intValue()) < 0 || slot >= size || parsed.contains(slot)) continue;
            parsed.add(slot);
        }
        if (parsed.isEmpty()) {
            return fallback != null ? (int[])fallback.clone() : new int[]{};
        }
        int[] result = new int[parsed.size()];
        for (int i = 0; i < parsed.size(); ++i) {
            result[i] = (Integer)parsed.get(i);
        }
        return result;
    }

    private static int[] sanitizeSlotsArray(int[] values, int size, int[] fallback) {
        if (values == null || values.length == 0) {
            return fallback != null ? (int[])fallback.clone() : new int[]{};
        }
        ArrayList<Integer> raw = new ArrayList<Integer>(values.length);
        for (int value : values) {
            raw.add(value);
        }
        return AuctionMenuInteractionConfiguration.sanitizeSlots(raw, size, fallback);
    }

    public static final class SellMenuInteractionConfiguration {
        private static final double DEFAULT_PRICE = 100.0;
        private static final List<Double> DEFAULT_ADJUSTMENTS = List.of(Double.valueOf(-1000.0), Double.valueOf(-100.0), Double.valueOf(-10.0), Double.valueOf(-1.0), Double.valueOf(1.0), Double.valueOf(10.0), Double.valueOf(100.0), Double.valueOf(1000.0));
        private final double defaultPrice;
        private final List<Double> priceAdjustments;
        private final SellMenuLayoutConfiguration layout;

        private SellMenuInteractionConfiguration(double defaultPrice, List<Double> priceAdjustments, SellMenuLayoutConfiguration layout) {
            this.defaultPrice = defaultPrice;
            this.priceAdjustments = priceAdjustments;
            this.layout = layout != null ? layout : SellMenuLayoutConfiguration.defaults();
        }

        public double defaultPrice() {
            return this.defaultPrice;
        }

        public List<Double> priceAdjustments() {
            return this.priceAdjustments;
        }

        public SellMenuLayoutConfiguration layout() {
            return this.layout;
        }

        private static SellMenuInteractionConfiguration from(ConfigurationSection section) {
            double candidate;
            if (section == null) {
                return SellMenuInteractionConfiguration.defaults();
            }
            double defaultPrice = 100.0;
            if (section.isSet("default-price") && Double.isFinite(candidate = section.getDouble("default-price", 100.0)) && candidate > 0.0) {
                defaultPrice = candidate;
            }
            List<Double> adjustments = SellMenuInteractionConfiguration.sanitizePriceAdjustments(section.getList("price-adjustments"));
            SellMenuLayoutConfiguration layout = SellMenuLayoutConfiguration.from(section.getConfigurationSection("layout"));
            return new SellMenuInteractionConfiguration(defaultPrice, adjustments, layout);
        }

        private static List<Double> sanitizePriceAdjustments(List<?> rawValues) {
            if (rawValues == null || rawValues.isEmpty()) {
                return DEFAULT_ADJUSTMENTS;
            }
            ArrayList<Double> parsed = new ArrayList<Double>();
            for (Object rawValue : rawValues) {
                Double parsedValue = AuctionMenuInteractionConfiguration.parseDouble(rawValue);
                if (parsedValue == null) continue;
                parsed.add(parsedValue);
            }
            if (parsed.isEmpty()) {
                return DEFAULT_ADJUSTMENTS;
            }
            return List.copyOf(parsed);
        }

        private static SellMenuInteractionConfiguration defaults() {
            return new SellMenuInteractionConfiguration(100.0, DEFAULT_ADJUSTMENTS, SellMenuLayoutConfiguration.defaults());
        }

        public String toString() {
            return "SellMenuInteractionConfiguration{defaultPrice=" + this.defaultPrice + ", priceAdjustments=" + String.valueOf(this.priceAdjustments) + ", layout=" + String.valueOf(this.layout) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SellMenuInteractionConfiguration)) {
                return false;
            }
            SellMenuInteractionConfiguration that = (SellMenuInteractionConfiguration)o;
            return Double.compare(that.defaultPrice, this.defaultPrice) == 0 && Objects.equals(this.priceAdjustments, that.priceAdjustments) && Objects.equals(this.layout, that.layout);
        }

        public int hashCode() {
            return Objects.hash(this.defaultPrice, this.priceAdjustments, this.layout);
        }
    }

    public static final class OrderMenuInteractionConfiguration {
        private static final double DEFAULT_PRICE = 100.0;
        private static final List<Double> DEFAULT_PRICE_ADJUSTMENTS = List.of(Double.valueOf(-1000.0), Double.valueOf(-100.0), Double.valueOf(-10.0), Double.valueOf(-1.0), Double.valueOf(1.0), Double.valueOf(10.0), Double.valueOf(100.0), Double.valueOf(1000.0));
        private static final List<Integer> DEFAULT_QUANTITY_ADJUSTMENTS = List.of(Integer.valueOf(-16), Integer.valueOf(-8), Integer.valueOf(-1), Integer.valueOf(1), Integer.valueOf(8), Integer.valueOf(16));
        private final double defaultPricePerItem;
        private final List<Double> priceAdjustments;
        private final List<Integer> quantityAdjustments;
        private final OrderMenuLayoutConfiguration layout;

        private OrderMenuInteractionConfiguration(double defaultPricePerItem, List<Double> priceAdjustments, List<Integer> quantityAdjustments, OrderMenuLayoutConfiguration layout) {
            this.defaultPricePerItem = defaultPricePerItem;
            this.priceAdjustments = priceAdjustments;
            this.quantityAdjustments = quantityAdjustments;
            this.layout = layout != null ? layout : OrderMenuLayoutConfiguration.defaults();
        }

        public double defaultPricePerItem() {
            return this.defaultPricePerItem;
        }

        public List<Double> priceAdjustments() {
            return this.priceAdjustments;
        }

        public List<Integer> quantityAdjustments() {
            return this.quantityAdjustments;
        }

        public OrderMenuLayoutConfiguration layout() {
            return this.layout;
        }

        private static OrderMenuInteractionConfiguration from(ConfigurationSection section) {
            double candidate;
            if (section == null) {
                return OrderMenuInteractionConfiguration.defaults();
            }
            double defaultPrice = 100.0;
            if (section.isSet("default-price") && Double.isFinite(candidate = section.getDouble("default-price", 100.0)) && candidate > 0.0) {
                defaultPrice = candidate;
            }
            List<Double> priceAdjustments = OrderMenuInteractionConfiguration.sanitizePriceAdjustments(section.getList("price-adjustments"));
            List<Integer> quantityAdjustments = OrderMenuInteractionConfiguration.sanitizeQuantityAdjustments(section.getList("quantity-adjustments"));
            OrderMenuLayoutConfiguration layout = OrderMenuLayoutConfiguration.from(section.getConfigurationSection("layout"));
            return new OrderMenuInteractionConfiguration(defaultPrice, priceAdjustments, quantityAdjustments, layout);
        }

        private static List<Double> sanitizePriceAdjustments(List<?> rawValues) {
            if (rawValues == null || rawValues.isEmpty()) {
                return DEFAULT_PRICE_ADJUSTMENTS;
            }
            ArrayList<Double> parsed = new ArrayList<Double>();
            for (Object rawValue : rawValues) {
                Double parsedValue = AuctionMenuInteractionConfiguration.parseDouble(rawValue);
                if (parsedValue == null) continue;
                parsed.add(parsedValue);
            }
            if (parsed.isEmpty()) {
                return DEFAULT_PRICE_ADJUSTMENTS;
            }
            return List.copyOf(parsed);
        }

        private static List<Integer> sanitizeQuantityAdjustments(List<?> rawValues) {
            if (rawValues == null || rawValues.isEmpty()) {
                return DEFAULT_QUANTITY_ADJUSTMENTS;
            }
            ArrayList<Integer> parsed = new ArrayList<Integer>();
            for (Object rawValue : rawValues) {
                Integer parsedValue = AuctionMenuInteractionConfiguration.parseInteger(rawValue);
                if (parsedValue == null || parsedValue == 0) continue;
                parsed.add(parsedValue);
            }
            if (parsed.isEmpty()) {
                return DEFAULT_QUANTITY_ADJUSTMENTS;
            }
            return List.copyOf(parsed);
        }

        private static OrderMenuInteractionConfiguration defaults() {
            return new OrderMenuInteractionConfiguration(100.0, DEFAULT_PRICE_ADJUSTMENTS, DEFAULT_QUANTITY_ADJUSTMENTS, OrderMenuLayoutConfiguration.defaults());
        }

        public String toString() {
            return "OrderMenuInteractionConfiguration{defaultPricePerItem=" + this.defaultPricePerItem + ", priceAdjustments=" + String.valueOf(this.priceAdjustments) + ", quantityAdjustments=" + String.valueOf(this.quantityAdjustments) + ", layout=" + String.valueOf(this.layout) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof OrderMenuInteractionConfiguration)) {
                return false;
            }
            OrderMenuInteractionConfiguration that = (OrderMenuInteractionConfiguration)o;
            return Double.compare(that.defaultPricePerItem, this.defaultPricePerItem) == 0 && Objects.equals(this.priceAdjustments, that.priceAdjustments) && Objects.equals(this.quantityAdjustments, that.quantityAdjustments) && Objects.equals(this.layout, that.layout);
        }

        public int hashCode() {
            return Objects.hash(this.defaultPricePerItem, this.priceAdjustments, this.quantityAdjustments, this.layout);
        }
    }

    public static final class OrderMenuLayoutConfiguration {
        private static final String DEFAULT_TITLE = "&2Create Buy Order";
        private static final int DEFAULT_SIZE = 27;
        private static final MenuButtonDefinition DEFAULT_FILLER = MenuButtonDefinition.of(Material.GRAY_STAINED_GLASS_PANE, "&8 ");
        private static final int DEFAULT_ITEM_SLOT = 11;
        private static final ButtonLayoutConfiguration DEFAULT_PRICE_DISPLAY = ButtonLayoutConfiguration.of(13, MenuButtonDefinition.of(Material.SUNFLOWER, "&6Offer Price"));
        private static final ButtonLayoutConfiguration DEFAULT_QUANTITY_DISPLAY = ButtonLayoutConfiguration.of(14, MenuButtonDefinition.of(Material.WRITABLE_BOOK, "&bRequested Quantity"));
        private static final ButtonLayoutConfiguration DEFAULT_DURATION_DISPLAY = ButtonLayoutConfiguration.of(15, MenuButtonDefinition.of(Material.CLOCK, "&eOrder Duration"));
        private static final ButtonLayoutConfiguration DEFAULT_CUSTOM_PRICE = ButtonLayoutConfiguration.of(16, MenuButtonDefinition.of(Material.PAPER, "&bCustom Price"));
        private static final ButtonLayoutConfiguration DEFAULT_CONFIRM_BUTTON = ButtonLayoutConfiguration.of(22, MenuButtonDefinition.of(Material.LIME_CONCRETE, "&aConfirm Order"));
        private static final ButtonLayoutConfiguration DEFAULT_CANCEL_BUTTON = ButtonLayoutConfiguration.of(24, MenuButtonDefinition.of(Material.RED_CONCRETE, "&cCancel"));
        private static final int[] DEFAULT_PRICE_ADJUST_SLOTS = new int[]{0, 1, 2, 3, 5, 6, 7, 8};
        private static final int[] DEFAULT_QUANTITY_ADJUST_SLOTS = new int[]{9, 10, 12, 18, 19, 20};
        private static final OrderMenuLayoutConfiguration DEFAULT = new OrderMenuLayoutConfiguration("&2Create Buy Order", 27, DEFAULT_FILLER, 11, DEFAULT_PRICE_DISPLAY, DEFAULT_QUANTITY_DISPLAY, DEFAULT_DURATION_DISPLAY, DEFAULT_CUSTOM_PRICE, DEFAULT_CONFIRM_BUTTON, DEFAULT_CANCEL_BUTTON, DEFAULT_PRICE_ADJUST_SLOTS, DEFAULT_QUANTITY_ADJUST_SLOTS);
        private final String title;
        private final int size;
        private final MenuButtonDefinition filler;
        private final int itemSlot;
        private final ButtonLayoutConfiguration priceDisplay;
        private final ButtonLayoutConfiguration quantityDisplay;
        private final ButtonLayoutConfiguration durationDisplay;
        private final ButtonLayoutConfiguration customPrice;
        private final ButtonLayoutConfiguration confirmButton;
        private final ButtonLayoutConfiguration cancelButton;
        private final int[] priceAdjustmentSlots;
        private final int[] quantityAdjustmentSlots;

        private OrderMenuLayoutConfiguration(String title, int size, MenuButtonDefinition filler, int itemSlot, ButtonLayoutConfiguration priceDisplay, ButtonLayoutConfiguration quantityDisplay, ButtonLayoutConfiguration durationDisplay, ButtonLayoutConfiguration customPrice, ButtonLayoutConfiguration confirmButton, ButtonLayoutConfiguration cancelButton, int[] priceAdjustmentSlots, int[] quantityAdjustmentSlots) {
            int sanitizedSize;
            this.title = title != null ? title : DEFAULT_TITLE;
            this.size = sanitizedSize = AuctionMenuInteractionConfiguration.sanitizeInventorySize(size, 27);
            this.filler = MenuButtonDefinition.normalize(filler, DEFAULT_FILLER);
            this.itemSlot = AuctionMenuInteractionConfiguration.sanitizeSlot(itemSlot, sanitizedSize, 11);
            this.priceDisplay = ButtonLayoutConfiguration.normalize(priceDisplay, DEFAULT_PRICE_DISPLAY, sanitizedSize);
            this.quantityDisplay = ButtonLayoutConfiguration.normalize(quantityDisplay, DEFAULT_QUANTITY_DISPLAY, sanitizedSize);
            this.durationDisplay = ButtonLayoutConfiguration.normalize(durationDisplay, DEFAULT_DURATION_DISPLAY, sanitizedSize);
            this.customPrice = ButtonLayoutConfiguration.normalize(customPrice, DEFAULT_CUSTOM_PRICE, sanitizedSize);
            this.confirmButton = ButtonLayoutConfiguration.normalize(confirmButton, DEFAULT_CONFIRM_BUTTON, sanitizedSize);
            this.cancelButton = ButtonLayoutConfiguration.normalize(cancelButton, DEFAULT_CANCEL_BUTTON, sanitizedSize);
            this.priceAdjustmentSlots = AuctionMenuInteractionConfiguration.sanitizeSlotsArray(priceAdjustmentSlots, sanitizedSize, DEFAULT_PRICE_ADJUST_SLOTS);
            this.quantityAdjustmentSlots = AuctionMenuInteractionConfiguration.sanitizeSlotsArray(quantityAdjustmentSlots, sanitizedSize, DEFAULT_QUANTITY_ADJUST_SLOTS);
        }

        public static OrderMenuLayoutConfiguration defaults() {
            return DEFAULT;
        }

        public static OrderMenuLayoutConfiguration from(ConfigurationSection section) {
            if (section == null) {
                return DEFAULT;
            }
            int requestedSize = section.getInt("size", 27);
            int size = AuctionMenuInteractionConfiguration.sanitizeInventorySize(requestedSize, 27);
            String title = section.getString("title", DEFAULT_TITLE);
            MenuButtonDefinition filler = MenuButtonDefinition.from(section.getConfigurationSection("filler"), DEFAULT_FILLER);
            int itemSlot = AuctionMenuInteractionConfiguration.sanitizeSlot(section.getInt("item-slot", 11), size, 11);
            ButtonLayoutConfiguration priceDisplay = ButtonLayoutConfiguration.from(section.getConfigurationSection("price-display"), DEFAULT_PRICE_DISPLAY, size);
            ButtonLayoutConfiguration quantityDisplay = ButtonLayoutConfiguration.from(section.getConfigurationSection("quantity-display"), DEFAULT_QUANTITY_DISPLAY, size);
            ButtonLayoutConfiguration durationDisplay = ButtonLayoutConfiguration.from(section.getConfigurationSection("duration-display"), DEFAULT_DURATION_DISPLAY, size);
            ButtonLayoutConfiguration customPrice = ButtonLayoutConfiguration.from(section.getConfigurationSection("custom-price"), DEFAULT_CUSTOM_PRICE, size);
            ButtonLayoutConfiguration confirm = ButtonLayoutConfiguration.from(section.getConfigurationSection("confirm"), DEFAULT_CONFIRM_BUTTON, size);
            ButtonLayoutConfiguration cancel = ButtonLayoutConfiguration.from(section.getConfigurationSection("cancel"), DEFAULT_CANCEL_BUTTON, size);
            int[] priceSlots = AuctionMenuInteractionConfiguration.sanitizeSlots(section.getList("price-adjust.slots"), size, DEFAULT_PRICE_ADJUST_SLOTS);
            int[] quantitySlots = AuctionMenuInteractionConfiguration.sanitizeSlots(section.getList("quantity-adjust.slots"), size, DEFAULT_QUANTITY_ADJUST_SLOTS);
            return new OrderMenuLayoutConfiguration(title, size, filler, itemSlot, priceDisplay, quantityDisplay, durationDisplay, customPrice, confirm, cancel, priceSlots, quantitySlots);
        }

        public String title() {
            return this.title;
        }

        public int size() {
            return this.size;
        }

        public MenuButtonDefinition filler() {
            return this.filler;
        }

        public int itemSlot() {
            return this.itemSlot;
        }

        public ButtonLayoutConfiguration priceDisplay() {
            return this.priceDisplay;
        }

        public ButtonLayoutConfiguration quantityDisplay() {
            return this.quantityDisplay;
        }

        public ButtonLayoutConfiguration durationDisplay() {
            return this.durationDisplay;
        }

        public ButtonLayoutConfiguration customPrice() {
            return this.customPrice;
        }

        public ButtonLayoutConfiguration confirmButton() {
            return this.confirmButton;
        }

        public ButtonLayoutConfiguration cancelButton() {
            return this.cancelButton;
        }

        public int[] priceAdjustmentSlots() {
            return (int[])this.priceAdjustmentSlots.clone();
        }

        public int[] quantityAdjustmentSlots() {
            return (int[])this.quantityAdjustmentSlots.clone();
        }

        public String toString() {
            return "OrderMenuLayoutConfiguration{title='" + this.title + "', size=" + this.size + ", filler=" + String.valueOf(this.filler) + ", itemSlot=" + this.itemSlot + ", priceDisplay=" + String.valueOf(this.priceDisplay) + ", quantityDisplay=" + String.valueOf(this.quantityDisplay) + ", durationDisplay=" + String.valueOf(this.durationDisplay) + ", customPrice=" + String.valueOf(this.customPrice) + ", confirmButton=" + String.valueOf(this.confirmButton) + ", cancelButton=" + String.valueOf(this.cancelButton) + ", priceAdjustmentSlots=" + Arrays.toString(this.priceAdjustmentSlots) + ", quantityAdjustmentSlots=" + Arrays.toString(this.quantityAdjustmentSlots) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof OrderMenuLayoutConfiguration)) {
                return false;
            }
            OrderMenuLayoutConfiguration that = (OrderMenuLayoutConfiguration)o;
            return this.size == that.size && this.itemSlot == that.itemSlot && Objects.equals(this.title, that.title) && Objects.equals(this.filler, that.filler) && Objects.equals(this.priceDisplay, that.priceDisplay) && Objects.equals(this.quantityDisplay, that.quantityDisplay) && Objects.equals(this.durationDisplay, that.durationDisplay) && Objects.equals(this.customPrice, that.customPrice) && Objects.equals(this.confirmButton, that.confirmButton) && Objects.equals(this.cancelButton, that.cancelButton) && Arrays.equals(this.priceAdjustmentSlots, that.priceAdjustmentSlots) && Arrays.equals(this.quantityAdjustmentSlots, that.quantityAdjustmentSlots);
        }

        public int hashCode() {
            int result = Objects.hash(this.title, this.size, this.filler, this.itemSlot, this.priceDisplay, this.quantityDisplay, this.durationDisplay, this.customPrice, this.confirmButton, this.cancelButton);
            result = 31 * result + Arrays.hashCode(this.priceAdjustmentSlots);
            result = 31 * result + Arrays.hashCode(this.quantityAdjustmentSlots);
            return result;
        }
    }

    public static final class SellMenuLayoutConfiguration {
        private static final String DEFAULT_TITLE = "&2Create Auction Listing";
        private static final int DEFAULT_SIZE = 27;
        private static final MenuButtonDefinition DEFAULT_FILLER = MenuButtonDefinition.of(Material.GRAY_STAINED_GLASS_PANE, "&8 ");
        private static final int DEFAULT_LISTING_SLOT = 11;
        private static final ButtonLayoutConfiguration DEFAULT_PRICE_DISPLAY = ButtonLayoutConfiguration.of(13, MenuButtonDefinition.of(Material.SUNFLOWER, "&6Listing Price"));
        private static final ButtonLayoutConfiguration DEFAULT_DURATION_DISPLAY = ButtonLayoutConfiguration.of(15, MenuButtonDefinition.of(Material.CLOCK, "&eListing Duration"));
        private static final ButtonLayoutConfiguration DEFAULT_CUSTOM_PRICE = ButtonLayoutConfiguration.of(16, MenuButtonDefinition.of(Material.WRITABLE_BOOK, "&bCustom Price"));
        private static final ButtonLayoutConfiguration DEFAULT_CONFIRM_BUTTON = ButtonLayoutConfiguration.of(22, MenuButtonDefinition.of(Material.LIME_CONCRETE, "&aCreate Listing"));
        private static final ButtonLayoutConfiguration DEFAULT_CANCEL_BUTTON = ButtonLayoutConfiguration.of(24, MenuButtonDefinition.of(Material.RED_CONCRETE, "&cCancel"));
        private static final int[] DEFAULT_PRICE_ADJUST_SLOTS = new int[]{0, 1, 2, 3, 5, 6, 7, 8};
        private static final SellMenuLayoutConfiguration DEFAULT = new SellMenuLayoutConfiguration("&2Create Auction Listing", 27, DEFAULT_FILLER, 11, DEFAULT_PRICE_DISPLAY, DEFAULT_DURATION_DISPLAY, DEFAULT_CUSTOM_PRICE, DEFAULT_CONFIRM_BUTTON, DEFAULT_CANCEL_BUTTON, DEFAULT_PRICE_ADJUST_SLOTS);
        private final String title;
        private final int size;
        private final MenuButtonDefinition filler;
        private final int listingSlot;
        private final ButtonLayoutConfiguration priceDisplay;
        private final ButtonLayoutConfiguration durationDisplay;
        private final ButtonLayoutConfiguration customPrice;
        private final ButtonLayoutConfiguration confirmButton;
        private final ButtonLayoutConfiguration cancelButton;
        private final int[] priceAdjustmentSlots;

        private SellMenuLayoutConfiguration(String title, int size, MenuButtonDefinition filler, int listingSlot, ButtonLayoutConfiguration priceDisplay, ButtonLayoutConfiguration durationDisplay, ButtonLayoutConfiguration customPrice, ButtonLayoutConfiguration confirmButton, ButtonLayoutConfiguration cancelButton, int[] priceAdjustmentSlots) {
            int sanitizedSize;
            this.title = title != null ? title : DEFAULT_TITLE;
            this.size = sanitizedSize = AuctionMenuInteractionConfiguration.sanitizeInventorySize(size, 27);
            this.filler = MenuButtonDefinition.normalize(filler, DEFAULT_FILLER);
            this.listingSlot = AuctionMenuInteractionConfiguration.sanitizeSlot(listingSlot, sanitizedSize, 11);
            this.priceDisplay = ButtonLayoutConfiguration.normalize(priceDisplay, DEFAULT_PRICE_DISPLAY, sanitizedSize);
            this.durationDisplay = ButtonLayoutConfiguration.normalize(durationDisplay, DEFAULT_DURATION_DISPLAY, sanitizedSize);
            this.customPrice = ButtonLayoutConfiguration.normalize(customPrice, DEFAULT_CUSTOM_PRICE, sanitizedSize);
            this.confirmButton = ButtonLayoutConfiguration.normalize(confirmButton, DEFAULT_CONFIRM_BUTTON, sanitizedSize);
            this.cancelButton = ButtonLayoutConfiguration.normalize(cancelButton, DEFAULT_CANCEL_BUTTON, sanitizedSize);
            this.priceAdjustmentSlots = AuctionMenuInteractionConfiguration.sanitizeSlotsArray(priceAdjustmentSlots, sanitizedSize, DEFAULT_PRICE_ADJUST_SLOTS);
        }

        public static SellMenuLayoutConfiguration defaults() {
            return DEFAULT;
        }

        public static SellMenuLayoutConfiguration from(ConfigurationSection section) {
            if (section == null) {
                return DEFAULT;
            }
            int requestedSize = section.getInt("size", 27);
            int size = AuctionMenuInteractionConfiguration.sanitizeInventorySize(requestedSize, 27);
            String title = section.getString("title", DEFAULT_TITLE);
            MenuButtonDefinition filler = MenuButtonDefinition.from(section.getConfigurationSection("filler"), DEFAULT_FILLER);
            int listingSlot = AuctionMenuInteractionConfiguration.sanitizeSlot(section.getInt("listing-slot", 11), size, 11);
            ButtonLayoutConfiguration priceDisplay = ButtonLayoutConfiguration.from(section.getConfigurationSection("price-display"), DEFAULT_PRICE_DISPLAY, size);
            ButtonLayoutConfiguration durationDisplay = ButtonLayoutConfiguration.from(section.getConfigurationSection("duration-display"), DEFAULT_DURATION_DISPLAY, size);
            ButtonLayoutConfiguration customPrice = ButtonLayoutConfiguration.from(section.getConfigurationSection("custom-price"), DEFAULT_CUSTOM_PRICE, size);
            ButtonLayoutConfiguration confirm = ButtonLayoutConfiguration.from(section.getConfigurationSection("confirm"), DEFAULT_CONFIRM_BUTTON, size);
            ButtonLayoutConfiguration cancel = ButtonLayoutConfiguration.from(section.getConfigurationSection("cancel"), DEFAULT_CANCEL_BUTTON, size);
            int[] priceAdjustSlots = AuctionMenuInteractionConfiguration.sanitizeSlots(section.getList("price-adjust.slots"), size, DEFAULT_PRICE_ADJUST_SLOTS);
            return new SellMenuLayoutConfiguration(title, size, filler, listingSlot, priceDisplay, durationDisplay, customPrice, confirm, cancel, priceAdjustSlots);
        }

        public String title() {
            return this.title;
        }

        public int size() {
            return this.size;
        }

        public MenuButtonDefinition filler() {
            return this.filler;
        }

        public int listingSlot() {
            return this.listingSlot;
        }

        public ButtonLayoutConfiguration priceDisplay() {
            return this.priceDisplay;
        }

        public ButtonLayoutConfiguration durationDisplay() {
            return this.durationDisplay;
        }

        public ButtonLayoutConfiguration customPrice() {
            return this.customPrice;
        }

        public ButtonLayoutConfiguration confirmButton() {
            return this.confirmButton;
        }

        public ButtonLayoutConfiguration cancelButton() {
            return this.cancelButton;
        }

        public int[] priceAdjustmentSlots() {
            return (int[])this.priceAdjustmentSlots.clone();
        }

        public String toString() {
            return "SellMenuLayoutConfiguration{title='" + this.title + "', size=" + this.size + ", filler=" + String.valueOf(this.filler) + ", listingSlot=" + this.listingSlot + ", priceDisplay=" + String.valueOf(this.priceDisplay) + ", durationDisplay=" + String.valueOf(this.durationDisplay) + ", customPrice=" + String.valueOf(this.customPrice) + ", confirmButton=" + String.valueOf(this.confirmButton) + ", cancelButton=" + String.valueOf(this.cancelButton) + ", priceAdjustmentSlots=" + Arrays.toString(this.priceAdjustmentSlots) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SellMenuLayoutConfiguration)) {
                return false;
            }
            SellMenuLayoutConfiguration that = (SellMenuLayoutConfiguration)o;
            return this.size == that.size && this.listingSlot == that.listingSlot && Objects.equals(this.title, that.title) && Objects.equals(this.filler, that.filler) && Objects.equals(this.priceDisplay, that.priceDisplay) && Objects.equals(this.durationDisplay, that.durationDisplay) && Objects.equals(this.customPrice, that.customPrice) && Objects.equals(this.confirmButton, that.confirmButton) && Objects.equals(this.cancelButton, that.cancelButton) && Arrays.equals(this.priceAdjustmentSlots, that.priceAdjustmentSlots);
        }

        public int hashCode() {
            int result = Objects.hash(this.title, this.size, this.filler, this.listingSlot, this.priceDisplay, this.durationDisplay, this.customPrice, this.confirmButton, this.cancelButton);
            result = 31 * result + Arrays.hashCode(this.priceAdjustmentSlots);
            return result;
        }
    }

    public static final class ButtonLayoutConfiguration {
        private final int slot;
        private final MenuButtonDefinition button;

        private ButtonLayoutConfiguration(int slot, MenuButtonDefinition button) {
            this.slot = slot;
            this.button = button != null ? button : MenuButtonDefinition.of(Material.GRAY_STAINED_GLASS_PANE, "");
        }

        public static ButtonLayoutConfiguration of(int slot, MenuButtonDefinition button) {
            return new ButtonLayoutConfiguration(slot, button);
        }

        public static ButtonLayoutConfiguration from(ConfigurationSection section, ButtonLayoutConfiguration fallback, int size) {
            if (section == null) {
                return fallback;
            }
            ButtonLayoutConfiguration effectiveFallback = fallback != null ? fallback : ButtonLayoutConfiguration.of(0, MenuButtonDefinition.of(Material.GRAY_STAINED_GLASS_PANE, ""));
            int slot = AuctionMenuInteractionConfiguration.sanitizeSlot(section.getInt("slot", effectiveFallback.slot), size, effectiveFallback.slot);
            MenuButtonDefinition button = MenuButtonDefinition.from(section, effectiveFallback.button);
            return new ButtonLayoutConfiguration(slot, button);
        }

        private static ButtonLayoutConfiguration normalize(ButtonLayoutConfiguration candidate, ButtonLayoutConfiguration fallback, int size) {
            if (candidate == null) {
                return fallback;
            }
            ButtonLayoutConfiguration effectiveFallback = fallback != null ? fallback : ButtonLayoutConfiguration.of(0, MenuButtonDefinition.of(Material.GRAY_STAINED_GLASS_PANE, ""));
            int slot = AuctionMenuInteractionConfiguration.sanitizeSlot(candidate.slot, size, effectiveFallback.slot);
            MenuButtonDefinition button = MenuButtonDefinition.normalize(candidate.button, effectiveFallback.button);
            return new ButtonLayoutConfiguration(slot, button);
        }

        public int slot() {
            return this.slot;
        }

        public MenuButtonDefinition button() {
            return this.button;
        }

        public String toString() {
            return "ButtonLayoutConfiguration{slot=" + this.slot + ", button=" + String.valueOf(this.button) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ButtonLayoutConfiguration)) {
                return false;
            }
            ButtonLayoutConfiguration that = (ButtonLayoutConfiguration)o;
            return this.slot == that.slot && Objects.equals(this.button, that.button);
        }

        public int hashCode() {
            return Objects.hash(this.slot, this.button);
        }
    }

    public static final class MenuButtonDefinition {
        private final Material material;
        private final String displayName;

        private MenuButtonDefinition(Material material, String displayName) {
            this.material = material != null ? material : Material.GRAY_STAINED_GLASS_PANE;
            this.displayName = displayName != null ? displayName : "";
        }

        public static MenuButtonDefinition of(Material material, String displayName) {
            return new MenuButtonDefinition(material != null ? material : Material.GRAY_STAINED_GLASS_PANE, displayName);
        }

        public static MenuButtonDefinition from(ConfigurationSection section, MenuButtonDefinition fallback) {
            if (section == null) {
                return fallback != null ? fallback : new MenuButtonDefinition(null, null);
            }
            MenuButtonDefinition effectiveFallback = fallback != null ? fallback : new MenuButtonDefinition(null, null);
            Material material = AuctionMenuInteractionConfiguration.parseMaterial(section.getString("material"), effectiveFallback.material);
            String displayName = section.getString("display-name", effectiveFallback.displayName);
            return new MenuButtonDefinition(material, displayName);
        }

        private static MenuButtonDefinition normalize(MenuButtonDefinition candidate, MenuButtonDefinition fallback) {
            if (candidate == null) {
                return fallback != null ? fallback : new MenuButtonDefinition(null, null);
            }
            MenuButtonDefinition effectiveFallback = fallback != null ? fallback : new MenuButtonDefinition(null, null);
            Material material = candidate.material != null ? candidate.material : effectiveFallback.material;
            String displayName = candidate.displayName != null ? candidate.displayName : effectiveFallback.displayName;
            return new MenuButtonDefinition(material, displayName);
        }

        public Material material() {
            return this.material;
        }

        public String displayName() {
            return this.displayName;
        }

        public String toString() {
            return "MenuButtonDefinition{material=" + String.valueOf(this.material) + ", displayName='" + this.displayName + "'}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MenuButtonDefinition)) {
                return false;
            }
            MenuButtonDefinition that = (MenuButtonDefinition)o;
            return this.material == that.material && Objects.equals(this.displayName, that.displayName);
        }

        public int hashCode() {
            return Objects.hash(this.material, this.displayName);
        }
    }
}

