/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;

public final class AuctionMenuConfiguration {
    private static final String DEFAULT_BROWSER_TITLE = "&2Auction House &7({page}/{total_pages})";
    private static final int DEFAULT_BROWSER_SIZE = 54;
    private static final MenuButtonConfiguration DEFAULT_BROWSER_FILLER_BUTTON = new MenuButtonConfiguration(Material.GRAY_STAINED_GLASS_PANE, "&8 ");
    private static final int DEFAULT_BROWSER_PREVIOUS_SLOT = 45;
    private static final int DEFAULT_BROWSER_CLOSE_SLOT = 49;
    private static final int DEFAULT_BROWSER_NEXT_SLOT = 53;
    private static final int DEFAULT_BROWSER_EMPTY_LISTING_SLOT = 22;
    private static final int DEFAULT_BROWSER_LISTINGS_TOGGLE_SLOT = 46;
    private static final int DEFAULT_BROWSER_ORDERS_TOGGLE_SLOT = 52;
    private static final ToggleButtonConfiguration DEFAULT_BROWSER_LISTINGS_TOGGLE = new ToggleButtonConfiguration(46, new MenuButtonConfiguration(Material.CHEST, "&aListings", List.of("&7Browse player sell listings.")));
    private static final ToggleButtonConfiguration DEFAULT_BROWSER_ORDERS_TOGGLE = new ToggleButtonConfiguration(52, new MenuButtonConfiguration(Material.PAPER, "&aBuy Orders", List.of("&7Browse active buy orders.")));
    private static final BrowserMenuConfiguration.SearchButtonConfiguration DEFAULT_BROWSER_SEARCH_BUTTON = new BrowserMenuConfiguration.SearchButtonConfiguration(48, new MenuButtonConfiguration(Material.COMPASS, "&bSearch", List.of("&7Find items by name.")));
    private static final BrowserMenuConfiguration.SortButtonConfiguration DEFAULT_BROWSER_SORT_BUTTON = new BrowserMenuConfiguration.SortButtonConfiguration(50, new MenuButtonConfiguration(Material.HOPPER, "&bSort", List.of("&7Change how listings are ordered.")));
    private static final String DEFAULT_CONFIRM_TITLE = "&2Confirm Purchase";
    private static final int DEFAULT_CONFIRM_SIZE = 27;
    private static final MenuButtonConfiguration DEFAULT_CONFIRM_FILLER_BUTTON = new MenuButtonConfiguration(Material.GRAY_STAINED_GLASS_PANE, "&8 ");
    private static final ConfirmMenuConfiguration.ButtonConfiguration DEFAULT_CONFIRM_BUTTON = new ConfirmMenuConfiguration.ButtonConfiguration(11, new MenuButtonConfiguration(Material.LIME_CONCRETE, "&aConfirm", List.of()));
    private static final int DEFAULT_LISTING_SLOT = 13;
    private static final ConfirmMenuConfiguration.ButtonConfiguration DEFAULT_CANCEL_BUTTON = new ConfirmMenuConfiguration.ButtonConfiguration(15, new MenuButtonConfiguration(Material.RED_CONCRETE, "&cCancel", List.of()));
    private static final BrowserMenuConfiguration DEFAULT_BROWSER = new BrowserMenuConfiguration("&2Auction House &7({page}/{total_pages})", 54, DEFAULT_BROWSER_FILLER_BUTTON, 45, 49, 53, 22, DEFAULT_BROWSER_LISTINGS_TOGGLE, DEFAULT_BROWSER_ORDERS_TOGGLE, DEFAULT_BROWSER_SEARCH_BUTTON, DEFAULT_BROWSER_SORT_BUTTON);
    private static final ConfirmMenuConfiguration DEFAULT_CONFIRM = new ConfirmMenuConfiguration("&2Confirm Purchase", 27, DEFAULT_CONFIRM_FILLER_BUTTON, DEFAULT_CONFIRM_BUTTON, 13, DEFAULT_CANCEL_BUTTON);
    private final BrowserMenuConfiguration browser;
    private final ConfirmMenuConfiguration confirm;

    public AuctionMenuConfiguration(BrowserMenuConfiguration browser, ConfirmMenuConfiguration confirm) {
        this.browser = browser != null ? browser : DEFAULT_BROWSER;
        this.confirm = confirm != null ? confirm : DEFAULT_CONFIRM;
    }

    public BrowserMenuConfiguration browser() {
        return this.browser;
    }

    public ConfirmMenuConfiguration confirm() {
        return this.confirm;
    }

    public static AuctionMenuConfiguration defaults() {
        return new AuctionMenuConfiguration(DEFAULT_BROWSER, DEFAULT_CONFIRM);
    }

    public static AuctionMenuConfiguration from(ConfigurationSection section) {
        if (section == null) {
            return AuctionMenuConfiguration.defaults();
        }
        BrowserMenuConfiguration browserConfiguration = BrowserMenuConfiguration.from(section.getConfigurationSection("browser"));
        ConfirmMenuConfiguration confirmConfiguration = ConfirmMenuConfiguration.from(section.getConfigurationSection("confirm"));
        return new AuctionMenuConfiguration(browserConfiguration, confirmConfiguration);
    }

    public String toString() {
        return "AuctionMenuConfiguration{browser=" + String.valueOf(this.browser) + ", confirm=" + String.valueOf(this.confirm) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuctionMenuConfiguration)) {
            return false;
        }
        AuctionMenuConfiguration that = (AuctionMenuConfiguration)o;
        return Objects.equals(this.browser, that.browser) && Objects.equals(this.confirm, that.confirm);
    }

    public int hashCode() {
        return Objects.hash(this.browser, this.confirm);
    }

    private static int sanitizeInventorySize(int requested, int fallback) {
        int size = requested;
        if (size <= 0 || size % 9 != 0) {
            size = fallback;
        }
        if (size > 54) {
            size = 54;
        }
        return size;
    }

    private static int sanitizeSlot(int value, int size, int fallback) {
        int sanitizedFallback = fallback;
        if (sanitizedFallback < 0 || sanitizedFallback >= size) {
            int n = sanitizedFallback = size > 0 ? Math.max(0, Math.min(size - 1, sanitizedFallback)) : 0;
        }
        if (value < 0 || value >= size) {
            return sanitizedFallback;
        }
        return value;
    }

    private static Material parseMaterial(String value, Material fallback) {
        if (value == null || value.trim().isEmpty()) {
            return fallback;
        }
        String normalized = value.trim().replace(' ', '_');
        try {
            return Material.valueOf((String)normalized.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException ex) {
            return fallback;
        }
    }

    private static MenuButtonConfiguration parseMenuButton(ConfigurationSection section, MenuButtonConfiguration fallback) {
        if (section == null) {
            return fallback;
        }
        Material material = AuctionMenuConfiguration.parseMaterial(section.getString("material"), fallback.material());
        String displayName = section.getString("display-name", fallback.displayName());
        List<String> lore = AuctionMenuConfiguration.parseLore(section, "lore", fallback.lore());
        return new MenuButtonConfiguration(material, displayName, lore);
    }

    private static List<String> parseLore(ConfigurationSection section, String path, List<String> fallback) {
        if (section == null) {
            return fallback;
        }
        if (!section.contains(path)) {
            return fallback;
        }
        if (section.isList(path)) {
            return AuctionMenuConfiguration.sanitizeLore(section.getStringList(path));
        }
        if (section.isString(path)) {
            String value = section.getString(path);
            if (value == null) {
                return List.of();
            }
            return List.of(value);
        }
        return fallback;
    }

    private static List<String> sanitizeLore(List<String> lore) {
        if (lore == null || lore.isEmpty()) {
            return List.of();
        }
        ArrayList<String> sanitized = new ArrayList<String>(lore.size());
        for (String line : lore) {
            if (line == null) continue;
            sanitized.add(line);
        }
        return sanitized.isEmpty() ? List.of() : List.copyOf(sanitized);
    }

    private static ToggleButtonConfiguration sanitizeToggle(ToggleButtonConfiguration configuration, int size, ToggleButtonConfiguration fallback) {
        ToggleButtonConfiguration fallbackConfig = Objects.requireNonNull(fallback, "fallbackToggle");
        ToggleButtonConfiguration effective = configuration != null ? configuration : fallbackConfig;
        int sanitizedSlot = AuctionMenuConfiguration.sanitizeSlot(effective.slot, size, fallbackConfig.slot);
        MenuButtonConfiguration button = effective.button != null ? effective.button : fallbackConfig.button;
        return new ToggleButtonConfiguration(sanitizedSlot, button);
    }

    private static BrowserMenuConfiguration.SearchButtonConfiguration sanitizeSearchButton(BrowserMenuConfiguration.SearchButtonConfiguration configuration, int size, BrowserMenuConfiguration.SearchButtonConfiguration fallback) {
        BrowserMenuConfiguration.SearchButtonConfiguration fallbackConfig = Objects.requireNonNull(fallback, "fallbackSearch");
        BrowserMenuConfiguration.SearchButtonConfiguration effective = configuration != null ? configuration : fallbackConfig;
        int sanitizedSlot = AuctionMenuConfiguration.sanitizeSlot(effective.slot(), size, fallbackConfig.slot());
        MenuButtonConfiguration button = effective.button() != null ? effective.button() : fallbackConfig.button();
        return new BrowserMenuConfiguration.SearchButtonConfiguration(sanitizedSlot, button);
    }

    private static BrowserMenuConfiguration.SortButtonConfiguration sanitizeSortButton(BrowserMenuConfiguration.SortButtonConfiguration configuration, int size, BrowserMenuConfiguration.SortButtonConfiguration fallback) {
        BrowserMenuConfiguration.SortButtonConfiguration fallbackConfig = Objects.requireNonNull(fallback, "fallbackSort");
        BrowserMenuConfiguration.SortButtonConfiguration effective = configuration != null ? configuration : fallbackConfig;
        int sanitizedSlot = AuctionMenuConfiguration.sanitizeSlot(effective.slot(), size, fallbackConfig.slot());
        MenuButtonConfiguration button = effective.button() != null ? effective.button() : fallbackConfig.button();
        return new BrowserMenuConfiguration.SortButtonConfiguration(sanitizedSlot, button);
    }

    private static ConfirmMenuConfiguration.ButtonConfiguration sanitizeButton(ConfirmMenuConfiguration.ButtonConfiguration configuration, int size, ConfirmMenuConfiguration.ButtonConfiguration fallback) {
        ConfirmMenuConfiguration.ButtonConfiguration fallbackConfig = Objects.requireNonNull(fallback, "fallbackButton");
        ConfirmMenuConfiguration.ButtonConfiguration effective = configuration != null ? configuration : fallbackConfig;
        int sanitizedSlot = AuctionMenuConfiguration.sanitizeSlot(effective.slot, size, fallbackConfig.slot);
        MenuButtonConfiguration button = effective.button != null ? effective.button : fallbackConfig.button;
        return new ConfirmMenuConfiguration.ButtonConfiguration(sanitizedSlot, button);
    }

    public static final class BrowserMenuConfiguration {
        private final String title;
        private final int size;
        private final MenuButtonConfiguration filler;
        private final int previousSlot;
        private final int closeSlot;
        private final int nextSlot;
        private final int emptyListingSlot;
        private final ToggleButtonConfiguration listingsToggle;
        private final ToggleButtonConfiguration ordersToggle;
        private final SearchButtonConfiguration searchButton;
        private final SortButtonConfiguration sortButton;

        private BrowserMenuConfiguration(String title, int size, MenuButtonConfiguration filler, int previousSlot, int closeSlot, int nextSlot, int emptyListingSlot, ToggleButtonConfiguration listingsToggle, ToggleButtonConfiguration ordersToggle, SearchButtonConfiguration searchButton, SortButtonConfiguration sortButton) {
            int sanitizedSize;
            this.title = title != null ? title : AuctionMenuConfiguration.DEFAULT_BROWSER_TITLE;
            this.size = sanitizedSize = AuctionMenuConfiguration.sanitizeInventorySize(size, 54);
            this.filler = filler != null ? filler : DEFAULT_BROWSER_FILLER_BUTTON;
            this.previousSlot = AuctionMenuConfiguration.sanitizeSlot(previousSlot, sanitizedSize, 45);
            this.closeSlot = AuctionMenuConfiguration.sanitizeSlot(closeSlot, sanitizedSize, 49);
            this.nextSlot = AuctionMenuConfiguration.sanitizeSlot(nextSlot, sanitizedSize, 53);
            this.emptyListingSlot = AuctionMenuConfiguration.sanitizeSlot(emptyListingSlot, sanitizedSize, 22);
            this.listingsToggle = AuctionMenuConfiguration.sanitizeToggle(listingsToggle, sanitizedSize, DEFAULT_BROWSER_LISTINGS_TOGGLE);
            this.ordersToggle = AuctionMenuConfiguration.sanitizeToggle(ordersToggle, sanitizedSize, DEFAULT_BROWSER_ORDERS_TOGGLE);
            this.searchButton = AuctionMenuConfiguration.sanitizeSearchButton(searchButton, sanitizedSize, DEFAULT_BROWSER_SEARCH_BUTTON);
            this.sortButton = AuctionMenuConfiguration.sanitizeSortButton(sortButton, sanitizedSize, DEFAULT_BROWSER_SORT_BUTTON);
        }

        public static BrowserMenuConfiguration from(ConfigurationSection section) {
            if (section == null) {
                return DEFAULT_BROWSER;
            }
            String title = section.getString("title", AuctionMenuConfiguration.DEFAULT_BROWSER.title);
            int requestedSize = section.getInt("size", AuctionMenuConfiguration.DEFAULT_BROWSER.size);
            int size = AuctionMenuConfiguration.sanitizeInventorySize(requestedSize, AuctionMenuConfiguration.DEFAULT_BROWSER.size);
            MenuButtonConfiguration filler = AuctionMenuConfiguration.parseMenuButton(section.getConfigurationSection("filler"), AuctionMenuConfiguration.DEFAULT_BROWSER.filler);
            int previous = AuctionMenuConfiguration.sanitizeSlot(section.getInt("navigation.previous-slot", AuctionMenuConfiguration.DEFAULT_BROWSER.previousSlot), size, AuctionMenuConfiguration.DEFAULT_BROWSER.previousSlot);
            int close = AuctionMenuConfiguration.sanitizeSlot(section.getInt("navigation.close-slot", AuctionMenuConfiguration.DEFAULT_BROWSER.closeSlot), size, AuctionMenuConfiguration.DEFAULT_BROWSER.closeSlot);
            int next = AuctionMenuConfiguration.sanitizeSlot(section.getInt("navigation.next-slot", AuctionMenuConfiguration.DEFAULT_BROWSER.nextSlot), size, AuctionMenuConfiguration.DEFAULT_BROWSER.nextSlot);
            int emptySlot = AuctionMenuConfiguration.sanitizeSlot(section.getInt("empty-listing-slot", AuctionMenuConfiguration.DEFAULT_BROWSER.emptyListingSlot), size, AuctionMenuConfiguration.DEFAULT_BROWSER.emptyListingSlot);
            ToggleButtonConfiguration listingsToggle = ToggleButtonConfiguration.from(section.getConfigurationSection("toggles.listings"), size, AuctionMenuConfiguration.DEFAULT_BROWSER.listingsToggle);
            ToggleButtonConfiguration ordersToggle = ToggleButtonConfiguration.from(section.getConfigurationSection("toggles.orders"), size, AuctionMenuConfiguration.DEFAULT_BROWSER.ordersToggle);
            SearchButtonConfiguration searchButton = SearchButtonConfiguration.from(section.getConfigurationSection("search"), size, AuctionMenuConfiguration.DEFAULT_BROWSER.searchButton);
            SortButtonConfiguration sortButton = SortButtonConfiguration.from(section.getConfigurationSection("sort"), size, AuctionMenuConfiguration.DEFAULT_BROWSER.sortButton);
            return new BrowserMenuConfiguration(title, size, filler, previous, close, next, emptySlot, listingsToggle, ordersToggle, searchButton, sortButton);
        }

        public String title() {
            return this.title;
        }

        public int size() {
            return this.size;
        }

        public MenuButtonConfiguration filler() {
            return this.filler;
        }

        public int previousSlot() {
            return this.previousSlot;
        }

        public int closeSlot() {
            return this.closeSlot;
        }

        public int nextSlot() {
            return this.nextSlot;
        }

        public int emptyListingSlot() {
            return this.emptyListingSlot;
        }

        public ToggleButtonConfiguration listingsToggle() {
            return this.listingsToggle;
        }

        public ToggleButtonConfiguration ordersToggle() {
            return this.ordersToggle;
        }

        public SearchButtonConfiguration searchButton() {
            return this.searchButton;
        }

        public SortButtonConfiguration sortButton() {
            return this.sortButton;
        }

        public String toString() {
            return "BrowserMenuConfiguration{title='" + this.title + "', size=" + this.size + ", filler=" + String.valueOf(this.filler) + ", previousSlot=" + this.previousSlot + ", closeSlot=" + this.closeSlot + ", nextSlot=" + this.nextSlot + ", emptyListingSlot=" + this.emptyListingSlot + ", listingsToggle=" + String.valueOf(this.listingsToggle) + ", ordersToggle=" + String.valueOf(this.ordersToggle) + ", searchButton=" + String.valueOf(this.searchButton) + ", sortButton=" + String.valueOf(this.sortButton) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BrowserMenuConfiguration)) {
                return false;
            }
            BrowserMenuConfiguration that = (BrowserMenuConfiguration)o;
            return this.size == that.size && this.previousSlot == that.previousSlot && this.closeSlot == that.closeSlot && this.nextSlot == that.nextSlot && this.emptyListingSlot == that.emptyListingSlot && Objects.equals(this.title, that.title) && Objects.equals(this.filler, that.filler) && Objects.equals(this.listingsToggle, that.listingsToggle) && Objects.equals(this.ordersToggle, that.ordersToggle) && Objects.equals(this.searchButton, that.searchButton) && Objects.equals(this.sortButton, that.sortButton);
        }

        public int hashCode() {
            return Objects.hash(this.title, this.size, this.filler, this.previousSlot, this.closeSlot, this.nextSlot, this.emptyListingSlot, this.listingsToggle, this.ordersToggle, this.searchButton, this.sortButton);
        }

        public static final class SearchButtonConfiguration {
            private final int slot;
            private final MenuButtonConfiguration button;

            private SearchButtonConfiguration(int slot, MenuButtonConfiguration button) {
                this.slot = slot;
                this.button = button != null ? button : DEFAULT_BROWSER_FILLER_BUTTON;
            }

            public static SearchButtonConfiguration from(ConfigurationSection section, int inventorySize, SearchButtonConfiguration fallback) {
                SearchButtonConfiguration fallbackConfig;
                SearchButtonConfiguration searchButtonConfiguration = fallbackConfig = fallback != null ? fallback : DEFAULT_BROWSER_SEARCH_BUTTON;
                if (section == null) {
                    return AuctionMenuConfiguration.sanitizeSearchButton(fallbackConfig, inventorySize, fallbackConfig);
                }
                int slot = AuctionMenuConfiguration.sanitizeSlot(section.getInt("slot", fallbackConfig.slot), inventorySize, fallbackConfig.slot);
                MenuButtonConfiguration button = AuctionMenuConfiguration.parseMenuButton(section, fallbackConfig.button);
                return new SearchButtonConfiguration(slot, button);
            }

            public int slot() {
                return this.slot;
            }

            public MenuButtonConfiguration button() {
                return this.button;
            }

            public String toString() {
                return "SearchButtonConfiguration{slot=" + this.slot + ", button=" + String.valueOf(this.button) + "}";
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof SearchButtonConfiguration)) {
                    return false;
                }
                SearchButtonConfiguration that = (SearchButtonConfiguration)o;
                return this.slot == that.slot && Objects.equals(this.button, that.button);
            }

            public int hashCode() {
                return Objects.hash(this.slot, this.button);
            }
        }

        public static final class SortButtonConfiguration {
            private final int slot;
            private final MenuButtonConfiguration button;

            private SortButtonConfiguration(int slot, MenuButtonConfiguration button) {
                this.slot = slot;
                this.button = button != null ? button : DEFAULT_BROWSER_FILLER_BUTTON;
            }

            public static SortButtonConfiguration from(ConfigurationSection section, int inventorySize, SortButtonConfiguration fallback) {
                SortButtonConfiguration fallbackConfig;
                SortButtonConfiguration sortButtonConfiguration = fallbackConfig = fallback != null ? fallback : DEFAULT_BROWSER_SORT_BUTTON;
                if (section == null) {
                    return AuctionMenuConfiguration.sanitizeSortButton(fallbackConfig, inventorySize, fallbackConfig);
                }
                int slot = AuctionMenuConfiguration.sanitizeSlot(section.getInt("slot", fallbackConfig.slot), inventorySize, fallbackConfig.slot);
                MenuButtonConfiguration button = AuctionMenuConfiguration.parseMenuButton(section, fallbackConfig.button);
                return new SortButtonConfiguration(slot, button);
            }

            public int slot() {
                return this.slot;
            }

            public MenuButtonConfiguration button() {
                return this.button;
            }

            public String toString() {
                return "SortButtonConfiguration{slot=" + this.slot + ", button=" + String.valueOf(this.button) + "}";
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof SortButtonConfiguration)) {
                    return false;
                }
                SortButtonConfiguration that = (SortButtonConfiguration)o;
                return this.slot == that.slot && Objects.equals(this.button, that.button);
            }

            public int hashCode() {
                return Objects.hash(this.slot, this.button);
            }
        }
    }

    public static final class ConfirmMenuConfiguration {
        private final String title;
        private final int size;
        private final MenuButtonConfiguration filler;
        private final ButtonConfiguration confirmButton;
        private final int listingSlot;
        private final ButtonConfiguration cancelButton;

        private ConfirmMenuConfiguration(String title, int size, MenuButtonConfiguration filler, ButtonConfiguration confirmButton, int listingSlot, ButtonConfiguration cancelButton) {
            int sanitizedSize;
            this.title = title != null ? title : AuctionMenuConfiguration.DEFAULT_CONFIRM_TITLE;
            this.size = sanitizedSize = AuctionMenuConfiguration.sanitizeInventorySize(size, 27);
            this.filler = filler != null ? filler : DEFAULT_CONFIRM_FILLER_BUTTON;
            this.confirmButton = AuctionMenuConfiguration.sanitizeButton(confirmButton, sanitizedSize, DEFAULT_CONFIRM_BUTTON);
            this.listingSlot = AuctionMenuConfiguration.sanitizeSlot(listingSlot, sanitizedSize, 13);
            this.cancelButton = AuctionMenuConfiguration.sanitizeButton(cancelButton, sanitizedSize, DEFAULT_CANCEL_BUTTON);
        }

        public static ConfirmMenuConfiguration from(ConfigurationSection section) {
            if (section == null) {
                return DEFAULT_CONFIRM;
            }
            String title = section.getString("title", AuctionMenuConfiguration.DEFAULT_CONFIRM.title);
            int requestedSize = section.getInt("size", AuctionMenuConfiguration.DEFAULT_CONFIRM.size);
            int size = AuctionMenuConfiguration.sanitizeInventorySize(requestedSize, AuctionMenuConfiguration.DEFAULT_CONFIRM.size);
            MenuButtonConfiguration filler = AuctionMenuConfiguration.parseMenuButton(section.getConfigurationSection("filler"), AuctionMenuConfiguration.DEFAULT_CONFIRM.filler);
            ConfigurationSection buttonsSection = section.getConfigurationSection("buttons");
            ConfigurationSection confirmSection = buttonsSection != null ? buttonsSection.getConfigurationSection("confirm") : null;
            ButtonConfiguration confirmButton = ButtonConfiguration.from(confirmSection, size, AuctionMenuConfiguration.DEFAULT_CONFIRM.confirmButton);
            int listingSlot = AuctionMenuConfiguration.sanitizeSlot(section.getInt("listing-slot", AuctionMenuConfiguration.DEFAULT_CONFIRM.listingSlot), size, AuctionMenuConfiguration.DEFAULT_CONFIRM.listingSlot);
            ConfigurationSection cancelSection = buttonsSection != null ? buttonsSection.getConfigurationSection("cancel") : null;
            ButtonConfiguration cancelButton = ButtonConfiguration.from(cancelSection, size, AuctionMenuConfiguration.DEFAULT_CONFIRM.cancelButton);
            if (confirmSection == null && section.contains("confirm-slot")) {
                confirmButton = confirmButton.withSlot(section.getInt("confirm-slot", confirmButton.slot()), size);
            }
            if (cancelSection == null && section.contains("cancel-slot")) {
                cancelButton = cancelButton.withSlot(section.getInt("cancel-slot", cancelButton.slot()), size);
            }
            return new ConfirmMenuConfiguration(title, size, filler, confirmButton, listingSlot, cancelButton);
        }

        public String title() {
            return this.title;
        }

        public int size() {
            return this.size;
        }

        public MenuButtonConfiguration filler() {
            return this.filler;
        }

        public ButtonConfiguration confirmButton() {
            return this.confirmButton;
        }

        public int listingSlot() {
            return this.listingSlot;
        }

        public ButtonConfiguration cancelButton() {
            return this.cancelButton;
        }

        public String toString() {
            return "ConfirmMenuConfiguration{title='" + this.title + "', size=" + this.size + ", filler=" + String.valueOf(this.filler) + ", confirmButton=" + String.valueOf(this.confirmButton) + ", listingSlot=" + this.listingSlot + ", cancelButton=" + String.valueOf(this.cancelButton) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConfirmMenuConfiguration)) {
                return false;
            }
            ConfirmMenuConfiguration that = (ConfirmMenuConfiguration)o;
            return this.size == that.size && this.listingSlot == that.listingSlot && Objects.equals(this.title, that.title) && Objects.equals(this.filler, that.filler) && Objects.equals(this.confirmButton, that.confirmButton) && Objects.equals(this.cancelButton, that.cancelButton);
        }

        public int hashCode() {
            return Objects.hash(this.title, this.size, this.filler, this.confirmButton, this.listingSlot, this.cancelButton);
        }

        public static final class ButtonConfiguration {
            private final int slot;
            private final MenuButtonConfiguration button;

            private ButtonConfiguration(int slot, MenuButtonConfiguration button) {
                this.slot = slot;
                this.button = button != null ? button : DEFAULT_CONFIRM_FILLER_BUTTON;
            }

            public static ButtonConfiguration from(ConfigurationSection section, int size, ButtonConfiguration fallback) {
                ButtonConfiguration fallbackConfig;
                ButtonConfiguration buttonConfiguration = fallbackConfig = fallback != null ? fallback : DEFAULT_CONFIRM_BUTTON;
                if (section == null) {
                    return AuctionMenuConfiguration.sanitizeButton(fallbackConfig, size, fallbackConfig);
                }
                int slot = AuctionMenuConfiguration.sanitizeSlot(section.getInt("slot", fallbackConfig.slot), size, fallbackConfig.slot);
                MenuButtonConfiguration button = AuctionMenuConfiguration.parseMenuButton(section, fallbackConfig.button);
                return new ButtonConfiguration(slot, button);
            }

            private ButtonConfiguration withSlot(int newSlot, int size) {
                int sanitizedSlot = AuctionMenuConfiguration.sanitizeSlot(newSlot, size, this.slot);
                return new ButtonConfiguration(sanitizedSlot, this.button);
            }

            public int slot() {
                return this.slot;
            }

            public MenuButtonConfiguration button() {
                return this.button;
            }

            public String toString() {
                return "ButtonConfiguration{slot=" + this.slot + ", button=" + String.valueOf(this.button) + "}";
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof ButtonConfiguration)) {
                    return false;
                }
                ButtonConfiguration that = (ButtonConfiguration)o;
                return this.slot == that.slot && Objects.equals(this.button, that.button);
            }

            public int hashCode() {
                return Objects.hash(this.slot, this.button);
            }
        }
    }

    public static final class MenuButtonConfiguration {
        private final Material material;
        private final String displayName;
        private final List<String> lore;

        private MenuButtonConfiguration(Material material, String displayName) {
            this(material, displayName, List.of());
        }

        private MenuButtonConfiguration(Material material, String displayName, List<String> lore) {
            this.material = material != null ? material : Material.GRAY_STAINED_GLASS_PANE;
            this.displayName = displayName != null ? displayName : "";
            this.lore = lore != null ? List.copyOf(lore) : List.of();
        }

        public Material material() {
            return this.material;
        }

        public String displayName() {
            return this.displayName;
        }

        public List<String> lore() {
            return this.lore;
        }

        public String toString() {
            return "MenuButtonConfiguration{material=" + String.valueOf(this.material) + ", displayName='" + this.displayName + "', lore=" + String.valueOf(this.lore) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MenuButtonConfiguration)) {
                return false;
            }
            MenuButtonConfiguration that = (MenuButtonConfiguration)o;
            return this.material == that.material && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.lore, that.lore);
        }

        public int hashCode() {
            return Objects.hash(this.material, this.displayName, this.lore);
        }
    }

    public static final class ToggleButtonConfiguration {
        private final int slot;
        private final MenuButtonConfiguration button;

        private ToggleButtonConfiguration(int slot, MenuButtonConfiguration button) {
            this.slot = slot;
            this.button = button != null ? button : DEFAULT_BROWSER_FILLER_BUTTON;
        }

        public static ToggleButtonConfiguration from(ConfigurationSection section, int inventorySize, ToggleButtonConfiguration fallback) {
            ToggleButtonConfiguration fallbackConfig;
            ToggleButtonConfiguration toggleButtonConfiguration = fallbackConfig = fallback != null ? fallback : DEFAULT_BROWSER_LISTINGS_TOGGLE;
            if (section == null) {
                return AuctionMenuConfiguration.sanitizeToggle(fallbackConfig, inventorySize, fallbackConfig);
            }
            int slot = AuctionMenuConfiguration.sanitizeSlot(section.getInt("slot", fallbackConfig.slot), inventorySize, fallbackConfig.slot);
            MenuButtonConfiguration button = AuctionMenuConfiguration.parseMenuButton(section, fallbackConfig.button);
            return new ToggleButtonConfiguration(slot, button);
        }

        public int slot() {
            return this.slot;
        }

        public MenuButtonConfiguration button() {
            return this.button;
        }

        public String toString() {
            return "ToggleButtonConfiguration{slot=" + this.slot + ", button=" + String.valueOf(this.button) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ToggleButtonConfiguration)) {
                return false;
            }
            ToggleButtonConfiguration that = (ToggleButtonConfiguration)o;
            return this.slot == that.slot && Objects.equals(this.button, that.button);
        }

        public int hashCode() {
            return Objects.hash(this.slot, this.button);
        }
    }
}

