/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.config;

import java.time.Duration;
import java.util.Objects;
import org.bukkit.configuration.ConfigurationSection;

public final class AuctionListingRules {
    private static final Duration DEFAULT_DEFAULT_DURATION = Duration.ofHours(24L);
    private static final Duration DEFAULT_MAX_DURATION = Duration.ofHours(72L);
    private static final double DEFAULT_MINIMUM_PRICE = 0.01;
    private static final double DEFAULT_DEPOSIT_PERCENT = 0.0;
    private final Duration defaultDuration;
    private final Duration maxDuration;
    private final double minimumPrice;
    private final double depositPercent;

    public AuctionListingRules(Duration defaultDuration, Duration maxDuration, double minimumPrice, double depositPercent) {
        Duration resolvedDefault = AuctionListingRules.sanitizeDuration(defaultDuration, DEFAULT_DEFAULT_DURATION);
        Duration resolvedMax = AuctionListingRules.sanitizeDuration(maxDuration, DEFAULT_MAX_DURATION);
        if (resolvedDefault.compareTo(resolvedMax) > 0) {
            resolvedDefault = resolvedMax;
        }
        this.defaultDuration = resolvedDefault;
        this.maxDuration = resolvedMax;
        this.minimumPrice = Math.max(0.0, minimumPrice);
        this.depositPercent = AuctionListingRules.clampPercent(depositPercent);
    }

    private static Duration sanitizeDuration(Duration duration, Duration fallback) {
        if (duration == null || duration.isNegative() || duration.isZero()) {
            return fallback;
        }
        return duration;
    }

    private static double clampPercent(double percent) {
        if (Double.isNaN(percent) || Double.isInfinite(percent)) {
            return 0.0;
        }
        if (percent < 0.0) {
            return 0.0;
        }
        if (percent > 100.0) {
            return 100.0;
        }
        return percent;
    }

    public Duration defaultDuration() {
        return this.defaultDuration;
    }

    public Duration maxDuration() {
        return this.maxDuration;
    }

    public double minimumPrice() {
        return this.minimumPrice;
    }

    public double depositPercent() {
        return this.depositPercent;
    }

    public double depositFraction() {
        return this.depositPercent / 100.0;
    }

    public double depositAmount(double price) {
        double normalizedPrice = Math.max(0.0, price);
        return normalizedPrice * this.depositFraction();
    }

    public Duration clampDuration(Duration requested) {
        Duration sanitized = requested;
        if (sanitized == null || sanitized.isNegative() || sanitized.isZero()) {
            sanitized = this.defaultDuration;
        }
        if (sanitized.compareTo(this.maxDuration) > 0) {
            sanitized = this.maxDuration;
        }
        return sanitized;
    }

    public static AuctionListingRules defaults() {
        return new AuctionListingRules(DEFAULT_DEFAULT_DURATION, DEFAULT_MAX_DURATION, 0.01, 0.0);
    }

    public static AuctionListingRules from(ConfigurationSection section) {
        if (section == null) {
            return AuctionListingRules.defaults();
        }
        Duration defaultDuration = AuctionListingRules.hoursToDuration(section.getDouble("default-duration-hours", (double)DEFAULT_DEFAULT_DURATION.toMinutes() / 60.0), DEFAULT_DEFAULT_DURATION);
        Duration maxDuration = AuctionListingRules.hoursToDuration(section.getDouble("max-duration-hours", (double)DEFAULT_MAX_DURATION.toMinutes() / 60.0), DEFAULT_MAX_DURATION);
        double minimumPrice = section.getDouble("minimum-price", 0.01);
        double depositPercent = section.getDouble("listing-deposit-percent", 0.0);
        return new AuctionListingRules(defaultDuration, maxDuration, minimumPrice, depositPercent);
    }

    private static Duration hoursToDuration(double hours, Duration fallback) {
        double sanitized;
        double d = sanitized = Double.isFinite(hours) ? hours : (double)fallback.toMinutes() / 60.0;
        if (sanitized <= 0.0) {
            return fallback;
        }
        long minutes = Math.max(1L, Math.round(sanitized * 60.0));
        try {
            return Duration.ofMinutes(minutes);
        }
        catch (ArithmeticException ex) {
            return fallback;
        }
    }

    public String toString() {
        return "AuctionListingRules{defaultDuration=" + String.valueOf(this.defaultDuration) + ", maxDuration=" + String.valueOf(this.maxDuration) + ", minimumPrice=" + this.minimumPrice + ", depositPercent=" + this.depositPercent + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuctionListingRules)) {
            return false;
        }
        AuctionListingRules that = (AuctionListingRules)o;
        return Double.compare(that.minimumPrice, this.minimumPrice) == 0 && Double.compare(that.depositPercent, this.depositPercent) == 0 && Objects.equals(this.defaultDuration, that.defaultDuration) && Objects.equals(this.maxDuration, that.maxDuration);
    }

    public int hashCode() {
        return Objects.hash(this.defaultDuration, this.maxDuration, this.minimumPrice, this.depositPercent);
    }
}

