/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.config;

import java.util.Objects;
import org.bukkit.configuration.ConfigurationSection;

public final class AuctionHologramConfiguration {
    private static final boolean DEFAULT_ENABLED = true;
    private static final long DEFAULT_UPDATE_INTERVAL_TICKS = 100L;
    private static final double DEFAULT_SEARCH_RADIUS = 2.5;
    private static final double DEFAULT_HEIGHT_OFFSET = 1.75;
    private final boolean enabled;
    private final long updateIntervalTicks;
    private final double searchRadius;
    private final double heightOffset;
    private static final boolean DEFAULT_REQUIRE_PERMISSION = false;
    private static final String DEFAULT_VIEW_PERMISSION = "ezauction.hologram.view";
    private static final boolean DEFAULT_PROXIMITY_LIMIT = false;
    private static final double DEFAULT_PROXIMITY_DISTANCE = 32.0;
    private static final int DEFAULT_MAX_HOLOGRAMS = 100;
    private static final boolean DEFAULT_BATCH_UPDATE = true;
    private final int maxHolograms;
    private final boolean batchUpdate;
    private final boolean requirePermission;
    private final String viewPermission;
    private final boolean proximityLimit;
    private final double proximityDistance;

    public AuctionHologramConfiguration(boolean enabled, long updateIntervalTicks, double searchRadius, double heightOffset) {
        this.enabled = enabled;
        this.updateIntervalTicks = AuctionHologramConfiguration.sanitizeInterval(updateIntervalTicks);
        this.searchRadius = AuctionHologramConfiguration.sanitizeSearchRadius(searchRadius);
        this.heightOffset = AuctionHologramConfiguration.sanitizeHeightOffset(heightOffset);
        this.maxHolograms = 100;
        this.batchUpdate = true;
        this.requirePermission = false;
        this.viewPermission = DEFAULT_VIEW_PERMISSION;
        this.proximityLimit = false;
        this.proximityDistance = 32.0;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public long updateIntervalTicks() {
        return this.updateIntervalTicks;
    }

    public double searchRadius() {
        return this.searchRadius;
    }

    public double heightOffset() {
        return this.heightOffset;
    }

    public int maxHolograms() {
        return this.maxHolograms;
    }

    public boolean batchUpdate() {
        return this.batchUpdate;
    }

    public boolean requirePermission() {
        return this.requirePermission;
    }

    public String viewPermission() {
        return this.viewPermission;
    }

    public boolean proximityLimit() {
        return this.proximityLimit;
    }

    public double proximityDistance() {
        return this.proximityDistance;
    }

    public AuctionHologramConfiguration(boolean enabled, long updateIntervalTicks, double searchRadius, double heightOffset, int maxHolograms, boolean batchUpdate, boolean requirePermission, String viewPermission, boolean proximityLimit, double proximityDistance) {
        this.enabled = enabled;
        this.updateIntervalTicks = AuctionHologramConfiguration.sanitizeInterval(updateIntervalTicks);
        this.searchRadius = AuctionHologramConfiguration.sanitizeSearchRadius(searchRadius);
        this.heightOffset = AuctionHologramConfiguration.sanitizeHeightOffset(heightOffset);
        this.maxHolograms = maxHolograms > 0 ? maxHolograms : 100;
        this.batchUpdate = batchUpdate;
        this.requirePermission = requirePermission;
        this.viewPermission = viewPermission != null ? viewPermission : DEFAULT_VIEW_PERMISSION;
        this.proximityLimit = proximityLimit;
        this.proximityDistance = proximityDistance > 0.0 ? proximityDistance : 32.0;
    }

    public static AuctionHologramConfiguration defaults() {
        return new AuctionHologramConfiguration(true, 100L, 2.5, 1.75, 100, true, false, DEFAULT_VIEW_PERMISSION, false, 32.0);
    }

    public static AuctionHologramConfiguration from(ConfigurationSection section) {
        double seconds;
        if (section == null) {
            return AuctionHologramConfiguration.defaults();
        }
        boolean enabled = section.getBoolean("enabled", true);
        long updateInterval = section.getLong("update-interval-ticks", 100L);
        if (updateInterval <= 0L && Double.isFinite(seconds = section.getDouble("update-interval-seconds", -1.0)) && seconds > 0.0) {
            updateInterval = Math.round(seconds * 20.0);
        }
        double searchRadius = section.getDouble("search-radius", 2.5);
        double heightOffset = section.getDouble("height-offset", 1.75);
        int maxHolograms = section.getInt("max-holograms", 100);
        boolean batchUpdate = section.getBoolean("batch-update", true);
        boolean requirePermission = section.getBoolean("require-permission", false);
        String viewPermission = section.getString("view-permission", DEFAULT_VIEW_PERMISSION);
        boolean proximityLimit = section.getBoolean("proximity-limit", false);
        double proximityDistance = section.getDouble("proximity-distance", 32.0);
        return new AuctionHologramConfiguration(enabled, updateInterval, searchRadius, heightOffset, maxHolograms, batchUpdate, requirePermission, viewPermission, proximityLimit, proximityDistance);
    }

    public String toString() {
        return "AuctionHologramConfiguration{enabled=" + this.enabled + ", updateIntervalTicks=" + this.updateIntervalTicks + ", searchRadius=" + this.searchRadius + ", heightOffset=" + this.heightOffset + ", maxHolograms=" + this.maxHolograms + ", batchUpdate=" + this.batchUpdate + ", requirePermission=" + this.requirePermission + ", viewPermission='" + this.viewPermission + "', proximityLimit=" + this.proximityLimit + ", proximityDistance=" + this.proximityDistance + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuctionHologramConfiguration)) {
            return false;
        }
        AuctionHologramConfiguration that = (AuctionHologramConfiguration)o;
        return this.enabled == that.enabled && this.updateIntervalTicks == that.updateIntervalTicks && Double.compare(that.searchRadius, this.searchRadius) == 0 && Double.compare(that.heightOffset, this.heightOffset) == 0 && this.maxHolograms == that.maxHolograms && this.batchUpdate == that.batchUpdate && this.requirePermission == that.requirePermission && Objects.equals(this.viewPermission, that.viewPermission) && this.proximityLimit == that.proximityLimit && Double.compare(that.proximityDistance, this.proximityDistance) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.updateIntervalTicks, this.searchRadius, this.heightOffset, this.maxHolograms, this.batchUpdate, this.requirePermission, this.viewPermission, this.proximityLimit, this.proximityDistance);
    }

    private static long sanitizeInterval(long intervalTicks) {
        if (intervalTicks < 20L) {
            return 100L;
        }
        return intervalTicks;
    }

    private static double sanitizeSearchRadius(double radius) {
        if (!Double.isFinite(radius) || radius <= 0.0) {
            return 2.5;
        }
        return radius;
    }

    private static double sanitizeHeightOffset(double offset) {
        if (!Double.isFinite(offset)) {
            return 1.75;
        }
        if (offset < 0.25) {
            return 0.25;
        }
        return offset;
    }
}

