/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.command;

import com.skyblockexp.ezauction.config.AuctionCommandMessageConfiguration;
import com.skyblockexp.ezauction.hologram.AuctionHologramManager;
import com.skyblockexp.ezauction.hologram.AuctionHologramType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public final class AuctionHologramCommand
implements CommandExecutor,
TabCompleter {
    private static final int TARGET_RANGE = 6;
    private final AuctionHologramManager hologramManager;
    private final AuctionCommandMessageConfiguration.HologramMessages messages;

    public AuctionHologramCommand(AuctionHologramManager hologramManager, AuctionCommandMessageConfiguration.HologramMessages messages) {
        this.hologramManager = hologramManager;
        this.messages = messages != null ? messages : AuctionCommandMessageConfiguration.HologramMessages.defaults();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            this.sendMessage(sender, this.messages.playersOnly());
            return true;
        }
        Player player = (Player)sender;
        if (this.hologramManager == null) {
            this.sendMessage(sender, this.messages.disabled());
            return true;
        }
        if (args.length == 0) {
            this.sendUsage((CommandSender)player, label);
            return true;
        }
        String subcommand = args[0];
        if ("clear".equalsIgnoreCase(subcommand) || "remove".equalsIgnoreCase(subcommand)) {
            return this.handleClear(player);
        }
        AuctionHologramType type = AuctionHologramType.fromName(subcommand);
        if (type == null) {
            this.sendMessage((CommandSender)player, this.messages.unknownType().replace("{type}", subcommand));
            this.sendTypeList((CommandSender)player);
            return true;
        }
        Location placement = AuctionHologramCommand.resolvePlacementLocation(player);
        if (placement == null) {
            this.sendMessage((CommandSender)player, this.messages.placementRange().replace("{range}", String.valueOf(6)));
            return true;
        }
        if (!this.hologramManager.ensureHologram(placement, type)) {
            this.sendMessage((CommandSender)player, this.messages.placementFailed());
            return true;
        }
        this.sendMessage((CommandSender)player, this.messages.placementSuccess().replace("{display}", type.displayName()).replace("{type}", type.name().toLowerCase(Locale.ENGLISH)));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 0) {
            return List.of();
        }
        if (args.length == 1) {
            ArrayList<String> suggestions = new ArrayList<String>();
            suggestions.add("clear");
            for (AuctionHologramType type : AuctionHologramType.values()) {
                suggestions.add(type.name().toLowerCase(Locale.ENGLISH));
                suggestions.addAll(Arrays.stream(type.aliases()).map(value -> value.toLowerCase(Locale.ENGLISH)).collect(Collectors.toList()));
            }
            String prefix = args[0].toLowerCase(Locale.ENGLISH);
            return suggestions.stream().filter(value -> value.startsWith(prefix)).distinct().collect(Collectors.toList());
        }
        return List.of();
    }

    private boolean handleClear(Player player) {
        Location location = player.getLocation();
        if (this.hologramManager.removeNearest(location)) {
            this.sendMessage((CommandSender)player, this.messages.cleared());
        } else {
            this.sendMessage((CommandSender)player, this.messages.noneFound());
        }
        return true;
    }

    private static Location resolvePlacementLocation(Player player) {
        Block target = player.getTargetBlockExact(6);
        Location base = target != null ? target.getLocation().add(0.0, 1.0, 0.0) : player.getLocation().add(0.0, 1.0, 0.0);
        return base;
    }

    private void sendUsage(CommandSender sender, String label) {
        this.sendMessage(sender, this.messages.usage().replace("{label}", label));
        this.sendTypeList(sender);
    }

    private void sendTypeList(CommandSender sender) {
        if (this.hologramManager == null) {
            return;
        }
        this.sendMessage(sender, this.messages.typesHeading());
        for (AuctionHologramType type : AuctionHologramType.values()) {
            String message = this.messages.typesEntry().replace("{name}", type.name().toLowerCase(Locale.ENGLISH)).replace("{display}", type.displayName());
            this.sendMessage(sender, message);
        }
    }

    private void sendMessage(CommandSender sender, String message) {
        if (sender == null || message == null || message.isEmpty()) {
            return;
        }
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
    }
}

