/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.bootstrap;

import com.skyblockexp.ezauction.AuctionListing;
import com.skyblockexp.ezauction.AuctionManager;
import com.skyblockexp.ezauction.AuctionOrder;
import com.skyblockexp.ezauction.AuctionReturnListener;
import com.skyblockexp.ezauction.EzAuctionPlugin;
import com.skyblockexp.ezauction.api.AuctionListingLimitResolver;
import com.skyblockexp.ezauction.claim.AuctionClaimService;
import com.skyblockexp.ezauction.command.AuctionCommand;
import com.skyblockexp.ezauction.command.AuctionHologramCommand;
import com.skyblockexp.ezauction.command.LiveAuctionCommand;
import com.skyblockexp.ezauction.compat.CompatibilityFacade;
import com.skyblockexp.ezauction.compat.HologramPlatform;
import com.skyblockexp.ezauction.compat.ItemTagStorage;
import com.skyblockexp.ezauction.config.AuctionBackendMessages;
import com.skyblockexp.ezauction.config.AuctionCommandMessageConfiguration;
import com.skyblockexp.ezauction.config.AuctionConfiguration;
import com.skyblockexp.ezauction.config.AuctionConfigurationLoader;
import com.skyblockexp.ezauction.config.AuctionHologramConfiguration;
import com.skyblockexp.ezauction.config.AuctionMenuInteractionConfiguration;
import com.skyblockexp.ezauction.config.AuctionMessageConfiguration;
import com.skyblockexp.ezauction.config.AuctionValueConfiguration;
import com.skyblockexp.ezauction.gui.AuctionMenu;
import com.skyblockexp.ezauction.gui.AuctionOrderMenu;
import com.skyblockexp.ezauction.gui.AuctionSellMenu;
import com.skyblockexp.ezauction.gui.AuctionSellMenuListener;
import com.skyblockexp.ezauction.gui.LiveAuctionMenu;
import com.skyblockexp.ezauction.history.AuctionTransactionHistoryService;
import com.skyblockexp.ezauction.hologram.AuctionHologramListener;
import com.skyblockexp.ezauction.hologram.AuctionHologramManager;
import com.skyblockexp.ezauction.libs.org.bstats.bukkit.Metrics;
import com.skyblockexp.ezauction.live.LiveAuctionEnqueueListener;
import com.skyblockexp.ezauction.live.LiveAuctionService;
import com.skyblockexp.ezauction.notification.AuctionNotificationService;
import com.skyblockexp.ezauction.persistence.AuctionPersistenceManager;
import com.skyblockexp.ezauction.placeholder.EzAuctionPlaceholderExpansion;
import com.skyblockexp.ezauction.service.AuctionExpiryService;
import com.skyblockexp.ezauction.service.AuctionListingService;
import com.skyblockexp.ezauction.service.AuctionOrderService;
import com.skyblockexp.ezauction.service.AuctionQueryService;
import com.skyblockexp.ezauction.service.AuctionReturnService;
import com.skyblockexp.ezauction.storage.AuctionHistoryStorage;
import com.skyblockexp.ezauction.storage.AuctionStorage;
import com.skyblockexp.ezauction.storage.AuctionStorageBundle;
import com.skyblockexp.ezauction.storage.AuctionStorageFactory;
import com.skyblockexp.ezauction.storage.AuctionStorageSnapshot;
import com.skyblockexp.ezauction.storage.DistributedAuctionListingStorage;
import com.skyblockexp.ezauction.transaction.AuctionTransactionHistory;
import com.skyblockexp.ezauction.transaction.AuctionTransactionService;
import com.skyblockexp.ezauction.update.SpigotUpdateChecker;
import com.skyblockexp.ezauction.util.ConfiguredItemValueProvider;
import com.skyblockexp.ezauction.util.EzShopsItemValueProvider;
import com.skyblockexp.ezauction.util.ItemValueProvider;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.ServicesManager;

public class PluginRegistry {
    private final EzAuctionPlugin plugin;
    public final Economy economy;
    public final AuctionTransactionService transactionService;
    public final AuctionTransactionHistory transactionHistory;
    public final AuctionManager auctionManager;
    public final AuctionStorage listingStorage;
    public final AuctionHistoryStorage historyStorage;
    public final AuctionConfiguration configuration;
    public final AuctionMenu auctionMenu;
    public final ItemValueProvider itemValueProvider;
    public final ItemValueProvider shopPriceValueProvider;
    public final AuctionOrderMenu auctionOrderMenu;
    public final AuctionSellMenu auctionSellMenu;
    public final AuctionCommand auctionCommand;
    public final LiveAuctionMenu liveAuctionMenu;
    public final AuctionHologramManager hologramManager;
    public final AuctionHologramCommand hologramCommand;
    public final CompatibilityFacade compatibilityFacade;
    public final EzAuctionPlaceholderExpansion placeholderExpansion;
    public final Metrics metrics;
    public final LiveAuctionService liveAuctionService;

    public PluginRegistry(EzAuctionPlugin plugin) {
        DistributedAuctionListingStorage d;
        this.plugin = plugin;
        Economy tempEconomy = null;
        if (plugin.getServer().getPluginManager().getPlugin("Vault") == null) {
            plugin.getLogger().severe("Vault plugin not found. EzAuction requires Vault and an economy provider to process currency.");
            plugin.getServer().getPluginManager().disablePlugin((Plugin)plugin);
        } else {
            RegisteredServiceProvider registration = plugin.getServer().getServicesManager().getRegistration(Economy.class);
            if (registration == null) {
                plugin.getLogger().severe("No Vault economy provider found. EzAuction cannot function without an economy bridge.");
                plugin.getServer().getPluginManager().disablePlugin((Plugin)plugin);
            } else {
                tempEconomy = (Economy)registration.getProvider();
                if (tempEconomy == null) {
                    plugin.getLogger().severe("Unable to acquire a Vault economy provider. EzAuction cannot function without an economy bridge.");
                    plugin.getServer().getPluginManager().disablePlugin((Plugin)plugin);
                }
            }
        }
        this.economy = tempEconomy;
        this.compatibilityFacade = CompatibilityFacade.create(plugin);
        ItemTagStorage itemTagStorage = this.compatibilityFacade.itemTagStorage();
        HologramPlatform hologramPlatform = this.compatibilityFacade.hologramPlatform();
        this.configuration = AuctionConfigurationLoader.load(plugin);
        boolean hologramSupportAvailable = hologramPlatform.isSupported();
        if (!hologramSupportAvailable && this.configuration.hologramConfiguration().enabled()) {
            plugin.getLogger().warning("TextDisplay entities are unavailable on this server version. EzAuction holograms will be disabled.");
        }
        AuctionStorageBundle storageBundle = AuctionStorageFactory.create(plugin, this.configuration);
        this.listingStorage = storageBundle.listingStorage();
        this.historyStorage = storageBundle.historyStorage();
        AuctionBackendMessages backendMessages = this.configuration.backendMessages();
        this.transactionService = new AuctionTransactionService(plugin, this.economy, backendMessages.economy(), backendMessages.fallback());
        this.transactionHistory = new AuctionTransactionHistory(plugin, this.historyStorage);
        this.transactionHistory.enable();
        RegisteredServiceProvider limitProvider = plugin.getServer().getServicesManager().getRegistration(AuctionListingLimitResolver.class);
        AuctionListingLimitResolver listingLimitResolver = limitProvider != null && limitProvider.getProvider() != null ? (AuctionListingLimitResolver)limitProvider.getProvider() : AuctionListingLimitResolver.useBaseLimit();
        this.liveAuctionService = new LiveAuctionService(plugin, this.transactionService, this.configuration.liveAuctionConfiguration(), backendMessages.live(), backendMessages.fallback());
        ConcurrentHashMap<String, AuctionListing> listings = new ConcurrentHashMap<String, AuctionListing>();
        ConcurrentHashMap<String, AuctionOrder> orders = new ConcurrentHashMap<String, AuctionOrder>();
        ConcurrentHashMap<UUID, List<ItemStack>> pendingReturns = new ConcurrentHashMap<UUID, List<ItemStack>>();
        AuctionStorage auctionStorage = this.listingStorage;
        AuctionPersistenceManager persistenceManager = new AuctionPersistenceManager(this.listingStorage, auctionStorage instanceof DistributedAuctionListingStorage ? (d = (DistributedAuctionListingStorage)((Object)auctionStorage)) : null, Executors.newSingleThreadExecutor(r -> {
            Thread t = new Thread(r, "EzAuction-Persistence");
            t.setDaemon(true);
            return t;
        }));
        persistenceManager.setStorageReady(true);
        AuctionStorageSnapshot snapshot = persistenceManager.loadFromStorage();
        if (snapshot != null) {
            listings.putAll(snapshot.listings());
            orders.putAll(snapshot.orders());
            if (snapshot.pendingReturns() != null) {
                pendingReturns.putAll(snapshot.pendingReturns());
            }
        }
        AuctionBackendMessages finalMessages = backendMessages != null ? backendMessages : AuctionBackendMessages.defaults();
        AuctionNotificationService notificationService = new AuctionNotificationService(finalMessages, this.transactionService);
        AuctionClaimService claimService = new AuctionClaimService(pendingReturns, finalMessages);
        AuctionTransactionHistoryService transactionHistoryService = new AuctionTransactionHistoryService(this.transactionHistory, plugin, finalMessages.fallback());
        AuctionListingService listingService = new AuctionListingService(this.transactionService, listingLimitResolver, this.configuration, this.configuration.listingRules(), this.liveAuctionService, persistenceManager, notificationService, claimService, transactionHistoryService, pendingReturns, listings, orders);
        AuctionOrderService orderService = new AuctionOrderService(this.transactionService, this.configuration.listingRules(), persistenceManager, notificationService, transactionHistoryService, claimService, pendingReturns, listings);
        AuctionReturnService returnService = new AuctionReturnService(persistenceManager);
        AuctionExpiryService expiryService = new AuctionExpiryService(plugin, listings, orders, persistenceManager, notificationService, transactionHistoryService, claimService, this.transactionService, pendingReturns);
        AuctionQueryService queryService = new AuctionQueryService(listings, orders, this.liveAuctionService, this.configuration);
        this.auctionManager = new AuctionManager(plugin, listingService, orderService, returnService, expiryService, queryService, this.configuration, listingLimitResolver);
        this.auctionManager.enable();
        if (this.liveAuctionService != null) {
            this.liveAuctionService.enable();
        }
        AuctionValueConfiguration valueConfiguration = this.configuration.valueConfiguration();
        AuctionMessageConfiguration messageConfiguration = this.configuration.messageConfiguration();
        AuctionCommandMessageConfiguration commandMessageConfiguration = this.configuration.commandMessageConfiguration();
        AuctionValueConfiguration.ShopPriceConfiguration shopPriceConfiguration = valueConfiguration != null ? valueConfiguration.shopPriceConfiguration() : null;
        this.itemValueProvider = this.resolveItemValueProvider(plugin, valueConfiguration);
        boolean shopPriceOverlayEnabled = this.shouldEnableShopPriceOverlay(plugin, shopPriceConfiguration);
        ItemValueProvider itemValueProvider = this.shopPriceValueProvider = shopPriceOverlayEnabled ? this.resolveShopPriceValueProvider(plugin, shopPriceConfiguration) : ItemValueProvider.none();
        if (shopPriceOverlayEnabled && this.shopPriceValueProvider == ItemValueProvider.none()) {
            shopPriceOverlayEnabled = false;
        }
        ItemValueProvider recommendationProvider = this.itemValueProvider;
        if ((valueConfiguration == null || !valueConfiguration.enabled()) && shopPriceOverlayEnabled) {
            recommendationProvider = this.shopPriceValueProvider;
        }
        this.auctionMenu = new AuctionMenu(plugin, this.auctionManager, this.transactionService, this.configuration.menuConfiguration(), messageConfiguration.browser(), valueConfiguration, this.itemValueProvider, this.shopPriceValueProvider, shopPriceOverlayEnabled, itemTagStorage);
        this.liveAuctionMenu = new LiveAuctionMenu(plugin, this.auctionManager, this.transactionService, this.auctionMenu, this.liveAuctionService, messageConfiguration.live(), valueConfiguration, this.shopPriceValueProvider, shopPriceOverlayEnabled, itemTagStorage);
        AuctionMenuInteractionConfiguration menuInteractions = this.configuration.menuInteractionConfiguration();
        this.auctionOrderMenu = new AuctionOrderMenu(plugin, this.auctionManager, this.transactionService, this.configuration.listingRules(), this.configuration.durationOptions(), menuInteractions.orderMenu(), recommendationProvider, messageConfiguration.order(), itemTagStorage);
        this.auctionSellMenu = new AuctionSellMenu(plugin, this.auctionManager, this.transactionService, this.configuration.listingRules(), this.configuration.durationOptions(), menuInteractions.sellMenu(), recommendationProvider, messageConfiguration.sell(), itemTagStorage);
        this.auctionCommand = new AuctionCommand(this.auctionManager, this.auctionMenu, this.auctionSellMenu, this.auctionOrderMenu, this.transactionHistory, this.transactionService, this.configuration.listingRules(), this.liveAuctionMenu, commandMessageConfiguration);
        AuctionHologramConfiguration hologramConfiguration = this.configuration.hologramConfiguration();
        if (hologramConfiguration != null && hologramConfiguration.enabled() && hologramSupportAvailable) {
            this.hologramManager = new AuctionHologramManager(plugin, this.auctionManager, this.transactionService, hologramConfiguration, hologramPlatform);
            this.hologramManager.enable();
            this.hologramCommand = new AuctionHologramCommand(this.hologramManager, commandMessageConfiguration.holograms());
        } else {
            this.hologramManager = null;
            this.hologramCommand = null;
            if (hologramConfiguration != null && hologramConfiguration.enabled()) {
                plugin.getLogger().warning("Auction holograms requested but unavailable on this platform; feature will remain disabled.");
            }
        }
        Plugin placeholderApi = plugin.getServer().getPluginManager().getPlugin("PlaceholderAPI");
        EzAuctionPlaceholderExpansion tempExpansion = null;
        if (placeholderApi != null && placeholderApi.isEnabled() && !(tempExpansion = new EzAuctionPlaceholderExpansion(this.auctionManager, plugin.getDescription())).register()) {
            plugin.getLogger().warning("Failed to register PlaceholderAPI placeholders for EzAuction.");
            tempExpansion = null;
        }
        this.placeholderExpansion = tempExpansion;
        Metrics tempMetrics = null;
        try {
            tempMetrics = new Metrics(plugin, 27737);
        }
        catch (Throwable throwable) {
            plugin.getLogger().warning("Failed to start bStats metrics: " + throwable.getMessage());
        }
        this.metrics = tempMetrics;
    }

    public void enableAll() {
        PluginCommand command;
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this.auctionMenu, (Plugin)this.plugin);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this.liveAuctionMenu, (Plugin)this.plugin);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this.auctionOrderMenu, (Plugin)this.plugin);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)new AuctionReturnListener(this.auctionManager), (Plugin)this.plugin);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)new AuctionSellMenuListener(this.auctionSellMenu), (Plugin)this.plugin);
        if (this.liveAuctionService != null && this.liveAuctionService.isEnabled()) {
            this.plugin.getServer().getPluginManager().registerEvents((Listener)new LiveAuctionEnqueueListener(this.liveAuctionService), (Plugin)this.plugin);
            LiveAuctionCommand liveCmd = new LiveAuctionCommand(this.auctionManager, this.liveAuctionMenu, this.auctionSellMenu, this.configuration.commandMessageConfiguration());
            this.plugin.getCommand("liveauction").setExecutor((CommandExecutor)liveCmd);
            this.plugin.getCommand("liveauction").setTabCompleter((TabCompleter)liveCmd);
        }
        if ((command = this.plugin.getCommand("auction")) != null) {
            command.setExecutor((CommandExecutor)this.auctionCommand);
            command.setTabCompleter((TabCompleter)this.auctionCommand);
        } else {
            this.plugin.getLogger().severe("Plugin command 'auction' is not defined in plugin.yml; the auction house will be unusable.");
        }
        if (this.hologramManager != null && this.hologramCommand != null) {
            PluginCommand hologramPluginCommand = this.plugin.getCommand("auctionhologram");
            if (hologramPluginCommand != null) {
                hologramPluginCommand.setExecutor((CommandExecutor)this.hologramCommand);
                hologramPluginCommand.setTabCompleter((TabCompleter)this.hologramCommand);
            } else {
                this.plugin.getLogger().warning("Plugin command 'auctionhologram' is not defined; hologram placement will be unavailable.");
            }
            this.plugin.getServer().getPluginManager().registerEvents((Listener)new AuctionHologramListener(this.hologramManager), (Plugin)this.plugin);
        }
        new SpigotUpdateChecker(this.plugin, 129779).checkForUpdates();
    }

    public void disableAll() {
        if (this.auctionManager != null) {
            this.auctionManager.disable();
        }
        if (this.liveAuctionService != null) {
            this.liveAuctionService.disable();
        }
        if (this.transactionHistory != null) {
            this.transactionHistory.disable();
        }
        if (this.hologramManager != null) {
            this.hologramManager.disable();
        }
        if (this.placeholderExpansion != null) {
            this.placeholderExpansion.unregister();
        }
        try {
            if (this.listingStorage != null) {
                this.listingStorage.close();
            }
        }
        catch (Exception ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to close EzAuction listing storage.", ex);
        }
        try {
            if (this.historyStorage != null && this.historyStorage != this.listingStorage) {
                this.historyStorage.close();
            }
        }
        catch (Exception ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to close EzAuction history storage.", ex);
        }
    }

    private ItemValueProvider resolveItemValueProvider(EzAuctionPlugin plugin, AuctionValueConfiguration valueConfiguration) {
        ServicesManager servicesManager = plugin.getServer().getServicesManager();
        RegisteredServiceProvider registration = servicesManager.getRegistration(ItemValueProvider.class);
        if (registration != null && registration.getProvider() != null) {
            return (ItemValueProvider)registration.getProvider();
        }
        if (valueConfiguration != null && valueConfiguration.enabled()) {
            AuctionValueConfiguration.Mode mode = valueConfiguration.mode();
            if (mode == AuctionValueConfiguration.Mode.EZSHOPS_BUY || mode == AuctionValueConfiguration.Mode.EZSHOPS_SELL) {
                ItemValueProvider provider = EzShopsItemValueProvider.create(plugin, mode);
                if (provider != null) {
                    return provider;
                }
                plugin.getLogger().warning("EzShops price service unavailable; disabling shop value display.");
                return ItemValueProvider.none();
            }
            return new ConfiguredItemValueProvider(valueConfiguration);
        }
        return ItemValueProvider.none();
    }

    private ItemValueProvider resolveShopPriceValueProvider(EzAuctionPlugin plugin, AuctionValueConfiguration.ShopPriceConfiguration shopPriceConfiguration) {
        if (shopPriceConfiguration == null) {
            return ItemValueProvider.none();
        }
        ItemValueProvider provider = EzShopsItemValueProvider.create(plugin, shopPriceConfiguration.mode());
        if (provider != null) {
            return provider;
        }
        plugin.getLogger().warning("EzShops price service unavailable; disabling shop price display.");
        return ItemValueProvider.none();
    }

    private boolean shouldEnableShopPriceOverlay(EzAuctionPlugin plugin, AuctionValueConfiguration.ShopPriceConfiguration shopPriceConfiguration) {
        if (shopPriceConfiguration == null) {
            return false;
        }
        if (shopPriceConfiguration.autoDetect()) {
            Plugin ezShops = plugin.getServer().getPluginManager().getPlugin("EzShops");
            return ezShops != null && ezShops.isEnabled();
        }
        return shopPriceConfiguration.enabled();
    }
}

