/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction;

import com.skyblockexp.ezauction.storage.AuctionHistoryStorage;
import com.skyblockexp.ezauction.transaction.AuctionTransactionHistoryEntry;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.bukkit.plugin.java.JavaPlugin;

public final class HistorySaveDispatcher
implements AutoCloseable {
    private static final int DEFAULT_BATCH_SIZE = 25;
    private final JavaPlugin plugin;
    private final AuctionHistoryStorage storage;
    private final ExecutorService executor;
    private final ConcurrentHashMap<UUID, Deque<AuctionTransactionHistoryEntry>> pendingUpdates = new ConcurrentHashMap();
    private final ConcurrentLinkedQueue<UUID> queue = new ConcurrentLinkedQueue();
    private final Set<UUID> enqueued = ConcurrentHashMap.newKeySet();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicBoolean draining = new AtomicBoolean();
    private final int batchSize;

    public HistorySaveDispatcher(JavaPlugin plugin, AuctionHistoryStorage storage) {
        this(plugin, storage, 25);
    }

    public HistorySaveDispatcher(JavaPlugin plugin, AuctionHistoryStorage storage, int batchSize) {
        this.plugin = plugin;
        this.storage = storage;
        this.batchSize = Math.max(1, batchSize);
        this.executor = Executors.newSingleThreadExecutor(runnable -> {
            Thread thread = new Thread(runnable, "EzAuction-HistorySave");
            thread.setDaemon(true);
            return thread;
        });
    }

    public void enqueue(UUID playerId, Deque<AuctionTransactionHistoryEntry> snapshot) {
        if (playerId == null || snapshot == null || this.closed.get()) {
            return;
        }
        this.pendingUpdates.put(playerId, new ArrayDeque<AuctionTransactionHistoryEntry>(snapshot));
        if (this.enqueued.add(playerId)) {
            this.queue.offer(playerId);
        }
        this.triggerDrain();
    }

    private void triggerDrain() {
        if (this.closed.get()) {
            return;
        }
        if (this.draining.compareAndSet(false, true)) {
            try {
                this.executor.execute(this::drainQueue);
            }
            catch (RejectedExecutionException ex) {
                this.draining.set(false);
                this.plugin.getLogger().log(Level.SEVERE, "Unable to schedule auction history persistence task.", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drainQueue() {
        try {
            UUID playerId;
            int processed = 0;
            while (!this.closed.get() && (playerId = this.queue.poll()) != null) {
                this.enqueued.remove(playerId);
                Deque<AuctionTransactionHistoryEntry> snapshot = this.pendingUpdates.remove(playerId);
                if (snapshot == null || snapshot.isEmpty()) continue;
                try {
                    this.storage.savePlayerHistory(playerId, snapshot);
                }
                catch (RuntimeException ex) {
                    this.plugin.getLogger().log(Level.SEVERE, "Failed to persist auction history for player " + String.valueOf(playerId) + ".", ex);
                    this.pendingUpdates.put(playerId, snapshot);
                    if (this.enqueued.add(playerId)) {
                        this.queue.offer(playerId);
                    }
                    break;
                }
                if (++processed < this.batchSize) continue;
                break;
            }
        }
        finally {
            this.draining.set(false);
            if (!this.closed.get() && !this.queue.isEmpty()) {
                this.triggerDrain();
            }
        }
    }

    public void flushAndShutdown() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        ArrayList remaining = new ArrayList(this.pendingUpdates.keySet());
        for (UUID playerId : remaining) {
            Deque<AuctionTransactionHistoryEntry> snapshot = this.pendingUpdates.remove(playerId);
            if (snapshot == null || snapshot.isEmpty()) continue;
            try {
                this.storage.savePlayerHistory(playerId, snapshot);
            }
            catch (RuntimeException ex) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to persist auction history for player " + String.valueOf(playerId) + " during shutdown.", ex);
            }
        }
        this.queue.clear();
        this.enqueued.clear();
    }

    @Override
    public void close() {
        this.flushAndShutdown();
    }
}

