/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.util;

import java.math.BigDecimal;
import java.math.RoundingMode;

public final class EconomyUtils {
    private static final int MAX_DECIMALS = 2;

    private EconomyUtils() {
    }

    public static double normalizeCurrency(double amount) {
        if (Double.isNaN(amount) || Double.isInfinite(amount)) {
            return 0.0;
        }
        BigDecimal decimal = BigDecimal.valueOf(amount);
        decimal = decimal.setScale(2, RoundingMode.HALF_UP);
        return decimal.doubleValue();
    }
}

