/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.util;

import com.skyblockexp.ezauction.api.AuctionListingLimitResolver;
import com.skyblockexp.ezauction.config.AuctionConfiguration;
import java.util.List;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class AuctionValidationUtils {
    public static int countItemAmount(List<ItemStack> items) {
        if (items == null || items.isEmpty()) {
            return 0;
        }
        int total = 0;
        for (ItemStack stack : items) {
            if (stack == null || stack.getType() == Material.AIR) continue;
            total += Math.max(0, stack.getAmount());
        }
        return total;
    }

    public static int resolveListingLimit(UUID sellerId, AuctionConfiguration config, AuctionListingLimitResolver resolver) {
        int baseListingLimit;
        int n = baseListingLimit = config != null ? Math.max(0, config.baseListingLimit()) : 0;
        if (sellerId == null) {
            return baseListingLimit;
        }
        if (resolver == null) {
            return baseListingLimit;
        }
        int resolvedLimit = resolver.resolveLimit(sellerId, baseListingLimit);
        return Math.max(0, resolvedLimit);
    }
}

