/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.storage.yaml;

import com.skyblockexp.ezauction.storage.AuctionHistoryStorage;
import com.skyblockexp.ezauction.transaction.AuctionTransactionHistoryEntry;
import com.skyblockexp.ezauction.transaction.AuctionTransactionType;
import com.skyblockexp.ezauction.util.EconomyUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public final class YamlAuctionHistoryStorage
implements AuctionHistoryStorage {
    private final JavaPlugin plugin;
    private File historyFile;
    private final Lock historyLock = new ReentrantLock(true);

    public YamlAuctionHistoryStorage(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean initialize() {
        if (this.plugin == null) {
            return false;
        }
        File dataFolder = this.plugin.getDataFolder();
        if (!dataFolder.exists() && !dataFolder.mkdirs()) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to create EzAuction data folder at {0}.", dataFolder);
        }
        this.historyFile = new File(dataFolder, "auction-history.yml");
        if (this.historyFile.exists()) {
            return true;
        }
        try {
            File parent = this.historyFile.getParentFile();
            if (parent != null && !parent.exists() && !parent.mkdirs()) {
                this.plugin.getLogger().log(Level.WARNING, "Failed to create directory for {0}.", this.historyFile);
            }
            if (!this.historyFile.exists() && !this.historyFile.createNewFile()) {
                throw new IOException("Unable to create file " + String.valueOf(this.historyFile));
            }
        }
        catch (IOException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to initialize auction history YAML storage.", ex);
            return false;
        }
        return true;
    }

    @Override
    public Map<UUID, Deque<AuctionTransactionHistoryEntry>> loadAll() {
        this.historyLock.lock();
        try {
            Map<UUID, Deque<AuctionTransactionHistoryEntry>> map = this.loadAllUnlocked();
            return map;
        }
        finally {
            this.historyLock.unlock();
        }
    }

    @Override
    public void saveAll(Map<UUID, Deque<AuctionTransactionHistoryEntry>> history) {
        if (this.historyFile == null) {
            return;
        }
        this.historyLock.lock();
        try {
            this.writeAllLocked(history);
        }
        catch (IOException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to save auction history YAML file.", ex);
        }
        finally {
            this.historyLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void savePlayerHistory(UUID playerId, Deque<AuctionTransactionHistoryEntry> history) {
        if (playerId == null || this.historyFile == null) {
            return;
        }
        this.historyLock.lock();
        try {
            Map<UUID, Deque<AuctionTransactionHistoryEntry>> existing = this.loadAllUnlocked();
            ArrayDeque<AuctionTransactionHistoryEntry> copy = history != null ? new ArrayDeque<AuctionTransactionHistoryEntry>(history) : new ArrayDeque();
            existing.put(playerId, copy);
            this.writeAllLocked(existing);
        }
        catch (IOException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to save auction history YAML file for player " + String.valueOf(playerId) + ".", ex);
        }
        finally {
            this.historyLock.unlock();
        }
    }

    @Override
    public void close() {
    }

    private Map<UUID, Deque<AuctionTransactionHistoryEntry>> loadAllUnlocked() {
        HashMap<UUID, Deque<AuctionTransactionHistoryEntry>> entries = new HashMap<UUID, Deque<AuctionTransactionHistoryEntry>>();
        if (this.historyFile == null || !this.historyFile.exists()) {
            return entries;
        }
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)this.historyFile);
        ConfigurationSection historySection = configuration.getConfigurationSection("history");
        if (historySection == null) {
            return entries;
        }
        Set playerKeys = historySection.getKeys(false);
        for (String playerKey : playerKeys) {
            UUID ownerId;
            try {
                ownerId = UUID.fromString(playerKey);
            }
            catch (IllegalArgumentException ex) {
                this.plugin.getLogger().log(Level.WARNING, "Ignoring auction history entry for invalid player id " + playerKey, ex);
                continue;
            }
            ConfigurationSection playerSection = historySection.getConfigurationSection(playerKey);
            if (playerSection == null) continue;
            ArrayList<AuctionTransactionHistoryEntry> playerEntries = new ArrayList<AuctionTransactionHistoryEntry>();
            for (String entryKey : playerSection.getKeys(false)) {
                AuctionTransactionHistoryEntry entry;
                ConfigurationSection entrySection = playerSection.getConfigurationSection(entryKey);
                if (entrySection == null || (entry = this.loadEntry(entrySection)) == null) continue;
                playerEntries.add(entry);
            }
            if (playerEntries.isEmpty()) continue;
            playerEntries.sort(Comparator.comparingLong(AuctionTransactionHistoryEntry::timestamp).reversed());
            ArrayDeque deque = new ArrayDeque(playerEntries);
            entries.put(ownerId, deque);
        }
        return entries;
    }

    private void writeAllLocked(Map<UUID, Deque<AuctionTransactionHistoryEntry>> history) throws IOException {
        YamlConfiguration configuration = new YamlConfiguration();
        ConfigurationSection historySection = configuration.createSection("history");
        for (Map.Entry<UUID, Deque<AuctionTransactionHistoryEntry>> entry : history.entrySet()) {
            ConfigurationSection playerSection = historySection.createSection(entry.getKey().toString());
            Deque<AuctionTransactionHistoryEntry> deque = entry.getValue();
            if (deque == null || deque.isEmpty()) continue;
            int index = 0;
            for (AuctionTransactionHistoryEntry historyEntry : deque) {
                ConfigurationSection entrySection = playerSection.createSection(Integer.toString(index++));
                this.writeEntry(historyEntry, entrySection);
            }
        }
        configuration.save(this.historyFile);
    }

    private AuctionTransactionHistoryEntry loadEntry(ConfigurationSection section) {
        String typeName = section.getString("type");
        AuctionTransactionType type = this.parseType(typeName);
        if (type == null) {
            return null;
        }
        long timestamp = section.getLong("timestamp", 0L);
        double price = EconomyUtils.normalizeCurrency(section.getDouble("price", 0.0));
        String counterpartIdRaw = section.getString("counterpart-id");
        UUID counterpartId = null;
        if (counterpartIdRaw != null && !counterpartIdRaw.isEmpty()) {
            try {
                counterpartId = UUID.fromString(counterpartIdRaw);
            }
            catch (IllegalArgumentException ex) {
                this.plugin.getLogger().log(Level.WARNING, "Ignoring invalid counterpart id in auction history entry.", ex);
            }
        }
        String counterpartName = section.getString("counterpart-name");
        ItemStack item = section.getItemStack("item");
        if (item != null) {
            item = item.clone();
        }
        return new AuctionTransactionHistoryEntry(type, counterpartId, counterpartName, price, timestamp, item);
    }

    private void writeEntry(AuctionTransactionHistoryEntry entry, ConfigurationSection section) {
        section.set("type", (Object)entry.type().name());
        section.set("timestamp", (Object)entry.timestamp());
        section.set("price", (Object)entry.price());
        if (entry.counterpartId() != null) {
            section.set("counterpart-id", (Object)entry.counterpartId().toString());
        }
        if (entry.counterpartName() != null && !entry.counterpartName().isEmpty()) {
            section.set("counterpart-name", (Object)entry.counterpartName());
        }
        if (entry.item() != null) {
            section.set("item", (Object)entry.item());
        }
    }

    private AuctionTransactionType parseType(String typeName) {
        if (typeName == null || typeName.isEmpty()) {
            return null;
        }
        String normalized = typeName.trim().toUpperCase(Locale.ENGLISH);
        for (AuctionTransactionType type : AuctionTransactionType.values()) {
            if (!type.name().equals(normalized)) continue;
            return type;
        }
        return null;
    }
}

