/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.service;

import com.skyblockexp.ezauction.AuctionOperationResult;
import com.skyblockexp.ezauction.persistence.AuctionPersistenceManager;
import com.skyblockexp.ezauction.util.AuctionValidationUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class AuctionReturnService {
    private final Map<UUID, List<ItemStack>> pendingReturns = new ConcurrentHashMap<UUID, List<ItemStack>>();
    private final AuctionPersistenceManager persistenceManager;

    public AuctionReturnService(AuctionPersistenceManager persistenceManager) {
        this.persistenceManager = persistenceManager;
    }

    public int countPendingReturnItems(UUID playerId) {
        if (playerId == null) {
            return 0;
        }
        List<ItemStack> stored = this.pendingReturns.get(playerId);
        return AuctionValidationUtils.countItemAmount(stored);
    }

    public void handlePlayerLogin(Player player) {
        if (player == null) {
            return;
        }
        UUID playerId = player.getUniqueId();
        List<ItemStack> stored = this.pendingReturns.get(playerId);
        if (stored == null || stored.isEmpty()) {
            return;
        }
        int totalItems = AuctionValidationUtils.countItemAmount(stored);
        if (totalItems <= 0) {
            this.pendingReturns.remove(playerId);
            this.persistenceManager.saveReturns(this.pendingReturns);
            return;
        }
        player.sendMessage("You have " + totalItems + " item(s) to claim from expired/cancelled auctions. Use /auction claim.");
    }

    public AuctionOperationResult claimReturnItems(Player player) {
        if (player == null) {
            return AuctionOperationResult.failure("Only players can claim return items.");
        }
        UUID playerId = player.getUniqueId();
        List<ItemStack> stored = this.pendingReturns.get(playerId);
        if (stored == null || stored.isEmpty()) {
            return AuctionOperationResult.failure("You have no items to claim.");
        }
        ArrayList<ItemStack> remaining = new ArrayList<ItemStack>();
        int claimedAmount = 0;
        int availableAmount = 0;
        for (ItemStack storedItem : stored) {
            if (storedItem == null || storedItem.getType() == Material.AIR || storedItem.getAmount() <= 0) continue;
            ItemStack toGive = storedItem.clone();
            availableAmount += toGive.getAmount();
            HashMap leftover = player.getInventory().addItem(new ItemStack[]{toGive});
            if (leftover.isEmpty()) {
                claimedAmount += toGive.getAmount();
                continue;
            }
            int leftoverAmount = 0;
            for (ItemStack remainder : leftover.values()) {
                if (remainder == null || remainder.getType() == Material.AIR || remainder.getAmount() <= 0) continue;
                leftoverAmount += remainder.getAmount();
                remaining.add(remainder.clone());
            }
            claimedAmount += Math.max(0, toGive.getAmount() - leftoverAmount);
        }
        if (availableAmount <= 0) {
            this.pendingReturns.remove(playerId);
            this.persistenceManager.saveReturns(this.pendingReturns);
            return AuctionOperationResult.failure("You have no items to claim.");
        }
        if (remaining.isEmpty()) {
            this.pendingReturns.remove(playerId);
        } else {
            this.pendingReturns.put(playerId, remaining);
        }
        this.persistenceManager.saveReturns(this.pendingReturns);
        if (claimedAmount <= 0) {
            return AuctionOperationResult.failure("Your inventory is full.");
        }
        int remainingAmount = AuctionValidationUtils.countItemAmount(remaining);
        if (remainingAmount > 0) {
            return AuctionOperationResult.success("Claimed some items, but not all. " + claimedAmount + " claimed, " + remainingAmount + " remaining.");
        }
        return AuctionOperationResult.success("Successfully claimed all items (" + claimedAmount + ").");
    }

    public Map<UUID, List<ItemStack>> getPendingReturns() {
        return this.pendingReturns;
    }
}

