/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.placeholder;

import com.skyblockexp.ezauction.AuctionManager;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.PluginDescriptionFile;

public final class EzAuctionPlaceholderExpansion
extends PlaceholderExpansion {
    private final AuctionManager auctionManager;
    private final PluginDescriptionFile description;

    public EzAuctionPlaceholderExpansion(AuctionManager auctionManager, PluginDescriptionFile description) {
        this.auctionManager = Objects.requireNonNull(auctionManager, "auctionManager");
        this.description = Objects.requireNonNull(description, "description");
    }

    public String getIdentifier() {
        return "EzAuction".toLowerCase(Locale.ENGLISH);
    }

    public String getAuthor() {
        List authors = this.description.getAuthors();
        if (authors == null || authors.isEmpty()) {
            return this.description.getName();
        }
        return String.join((CharSequence)", ", authors);
    }

    public String getVersion() {
        return this.description.getVersion();
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    public String onRequest(OfflinePlayer offlinePlayer, String params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        String normalized = params.toLowerCase(Locale.ENGLISH);
        UUID playerId = offlinePlayer != null ? offlinePlayer.getUniqueId() : null;
        switch (normalized) {
            case "active_listings": 
            case "listings_active": 
            case "listings_count": {
                return Long.toString(this.auctionManager.countActiveListings(playerId));
            }
            case "active_orders": 
            case "orders_active": 
            case "orders_count": {
                return Long.toString(this.auctionManager.countActiveOrders(playerId));
            }
            case "listing_limit": 
            case "listings_limit": 
            case "limit": {
                return this.formatLimit(this.auctionManager.resolveListingLimit(playerId));
            }
            case "listing_space": 
            case "listings_remaining": 
            case "listings_slots": {
                return this.formatRemainingSlots(playerId);
            }
            case "returns_items": 
            case "returns_count": 
            case "returns_pending": {
                return Integer.toString(this.auctionManager.countPendingReturnItems(playerId));
            }
            case "global_active_listings": 
            case "global_listings": 
            case "listings_global": {
                return Long.toString(this.auctionManager.countAllActiveListings());
            }
            case "global_active_orders": 
            case "global_orders": 
            case "orders_global": {
                return Long.toString(this.auctionManager.countAllActiveOrders());
            }
        }
        return "";
    }

    private String formatRemainingSlots(UUID playerId) {
        int limit = this.auctionManager.resolveListingLimit(playerId);
        if (limit <= 0) {
            return "-1";
        }
        long activeListings = this.auctionManager.countActiveListings(playerId);
        long remaining = Math.max(0L, (long)limit - activeListings);
        return Long.toString(remaining);
    }

    private String formatLimit(int limit) {
        if (limit <= 0) {
            return "-1";
        }
        return Integer.toString(limit);
    }
}

