/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.notification;

import com.skyblockexp.ezauction.AuctionListing;
import com.skyblockexp.ezauction.AuctionOrder;
import com.skyblockexp.ezauction.config.AuctionBackendMessages;
import com.skyblockexp.ezauction.transaction.AuctionTransactionService;
import java.util.ArrayList;
import java.util.Locale;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AuctionNotificationService {
    private final AuctionBackendMessages backendMessages;
    private final AuctionTransactionService transactionService;
    private final AuctionBackendMessages.FallbackMessages fallbackMessages;

    public AuctionNotificationService(AuctionBackendMessages backendMessages, AuctionTransactionService transactionService) {
        this.backendMessages = backendMessages;
        this.transactionService = transactionService;
        this.fallbackMessages = backendMessages.fallback();
    }

    public void notifySellerSale(AuctionListing listing) {
        Player seller = Bukkit.getPlayer((UUID)listing.sellerId());
        if (seller == null || !seller.isOnline()) {
            return;
        }
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(this.formatMessage(this.backendMessages.notifications().sellerSold(), "item", this.describeItem(listing.item()), "price", this.transactionService.formatCurrency(listing.price())));
        if (listing.deposit() > 0.0) {
            parts.add(this.formatMessage(this.backendMessages.notifications().sellerDepositRefunded(), "amount", this.transactionService.formatCurrency(listing.deposit())));
        }
        seller.sendMessage(String.join((CharSequence)" ", parts).trim());
    }

    public void notifySellerExpiry(AuctionListing listing) {
        Player seller = Bukkit.getPlayer((UUID)listing.sellerId());
        if (seller == null || !seller.isOnline()) {
            return;
        }
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(this.formatMessage(this.backendMessages.notifications().sellerExpired(), "item", this.describeItem(listing.item())));
        if (listing.deposit() > 0.0) {
            parts.add(this.formatMessage(this.backendMessages.notifications().sellerDepositRefunded(), "amount", this.transactionService.formatCurrency(listing.deposit())));
        }
        seller.sendMessage(String.join((CharSequence)" ", parts).trim());
    }

    public void notifySellerCancelled(AuctionListing listing) {
        Player seller = Bukkit.getPlayer((UUID)listing.sellerId());
        if (seller == null || !seller.isOnline()) {
            return;
        }
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(this.formatMessage(this.backendMessages.notifications().sellerReturned(), "item", this.describeItem(listing.item())));
        if (listing.deposit() > 0.0) {
            parts.add(this.formatMessage(this.backendMessages.notifications().sellerDepositRefunded(), "amount", this.transactionService.formatCurrency(listing.deposit())));
        }
        seller.sendMessage(String.join((CharSequence)" ", parts).trim());
    }

    public void notifyOrderCreated(AuctionOrder order, Player buyer) {
        if (buyer == null || !buyer.isOnline()) {
            return;
        }
        buyer.sendMessage(this.formatMessage(this.backendMessages.notifications().buyerFulfilled(), "item", this.describeItem(order.requestedItem()), "price", this.transactionService.formatCurrency(order.offeredPrice())));
    }

    public void notifyOrderFulfilled(AuctionOrder order, Player seller) {
        if (seller == null || !seller.isOnline()) {
            return;
        }
        seller.sendMessage(this.formatMessage(this.backendMessages.notifications().sellerSold(), "item", this.describeItem(order.requestedItem()), "price", this.transactionService.formatCurrency(order.offeredPrice())));
    }

    public void notifyOrderCancelled(AuctionOrder order) {
        Player buyer = Bukkit.getPlayer((UUID)order.buyerId());
        if (buyer == null || !buyer.isOnline()) {
            return;
        }
        buyer.sendMessage(this.formatMessage(this.backendMessages.notifications().buyerItemsStored(), "item", this.describeItem(order.requestedItem()), "amount", this.transactionService.formatCurrency(order.reservedAmount())));
    }

    public void notifyOrderExpiry(AuctionOrder order) {
        if (order == null) {
            return;
        }
        Player buyer = Bukkit.getPlayer((UUID)order.buyerId());
        if (buyer == null || !buyer.isOnline()) {
            return;
        }
        buyer.sendMessage(this.formatMessage(this.backendMessages.notifications().buyerExpired(), "item", this.describeItem(order.requestedItem())));
    }

    private String formatMessage(String template, String ... replacements) {
        if (template == null || template.isEmpty()) {
            return "";
        }
        String formatted = template;
        int i = 0;
        while (i + 1 < replacements.length) {
            String key = replacements[i];
            String value = replacements[i + 1];
            formatted = formatted.replace("{" + key + "}", value != null ? value : "");
            i += 2;
        }
        return this.colorize(formatted);
    }

    private String colorize(String message) {
        if (message == null || message.isEmpty()) {
            return "";
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    private String describeItem(ItemStack item) {
        String name;
        if (item == null) {
            return this.fallbackMessages.unknownItem();
        }
        int amount = Math.max(1, item.getAmount());
        ItemMeta meta = item.getItemMeta();
        if (meta != null && meta.hasDisplayName()) {
            String displayName = meta.getDisplayName();
            String stripped = displayName != null ? ChatColor.stripColor((String)displayName) : "";
            name = stripped != null && !stripped.isEmpty() ? stripped : displayName;
        } else {
            name = this.friendlyMaterialName(item.getType());
        }
        if (name == null || name.isEmpty()) {
            name = this.fallbackMessages.unknownItem();
        }
        return amount + "x " + name;
    }

    private String friendlyMaterialName(Material material) {
        if (material == null) {
            return this.fallbackMessages.unknownMaterial();
        }
        String lowercase = material.name().toLowerCase(Locale.ENGLISH).replace('_', ' ');
        if (lowercase.isEmpty()) {
            return this.fallbackMessages.unknownMaterial();
        }
        return Character.toUpperCase(lowercase.charAt(0)) + lowercase.substring(1);
    }
}

