/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.history;

import com.skyblockexp.ezauction.AuctionListing;
import com.skyblockexp.ezauction.AuctionOrder;
import com.skyblockexp.ezauction.config.AuctionBackendMessages;
import com.skyblockexp.ezauction.transaction.AuctionTransactionHistory;
import com.skyblockexp.ezauction.transaction.AuctionTransactionType;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class AuctionTransactionHistoryService {
    private final AuctionTransactionHistory transactionHistory;
    private final JavaPlugin plugin;
    private final AuctionBackendMessages.FallbackMessages fallbackMessages;

    public AuctionTransactionHistoryService(AuctionTransactionHistory transactionHistory, JavaPlugin plugin, AuctionBackendMessages.FallbackMessages fallbackMessages) {
        this.transactionHistory = transactionHistory;
        this.plugin = plugin;
        this.fallbackMessages = fallbackMessages;
    }

    public void recordListingTransactionHistory(AuctionListing listing, Object buyer) {
        String buyerName;
        UUID buyerId;
        if (listing == null || buyer == null) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        ItemStack item = listing.item();
        if (buyer instanceof Player) {
            buyerId = ((Player)buyer).getUniqueId();
            buyerName = ((Player)buyer).getName();
        } else if (buyer instanceof UUID) {
            buyerId = (UUID)buyer;
            OfflinePlayer offlineBuyer = this.plugin.getServer().getOfflinePlayer(buyerId);
            buyerName = offlineBuyer != null && offlineBuyer.getName() != null ? offlineBuyer.getName() : this.fallbackMessages.unknownName();
        } else {
            return;
        }
        OfflinePlayer seller = this.plugin.getServer().getOfflinePlayer(listing.sellerId());
        String sellerName = seller != null && seller.getName() != null ? seller.getName() : this.fallbackMessages.unknownName();
        this.transactionHistory.recordTransaction(AuctionTransactionType.SELL, listing.sellerId(), buyerId, buyerName, listing.price(), item, timestamp);
        this.transactionHistory.recordTransaction(AuctionTransactionType.BUY, buyerId, listing.sellerId(), sellerName, listing.price(), item, timestamp);
    }

    public void recordOrderTransactionHistory(AuctionOrder order, UUID sellerId, String sellerName, ItemStack deliveredItem) {
        if (order == null || sellerId == null) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        OfflinePlayer buyer = this.plugin.getServer().getOfflinePlayer(order.buyerId());
        String buyerName = buyer != null && buyer.getName() != null ? buyer.getName() : this.fallbackMessages.unknownName();
        String normalizedSellerName = sellerName != null && !sellerName.isEmpty() ? sellerName : this.fallbackMessages.unknownName();
        this.transactionHistory.recordOrderFulfillment(order.buyerId(), sellerId, normalizedSellerName, buyerName, order.offeredPrice(), deliveredItem, timestamp);
    }
}

