/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.gui;

import com.skyblockexp.ezauction.config.AuctionListingRules;
import java.time.Duration;
import java.util.Objects;
import org.bukkit.inventory.ItemStack;

public final class SellMenuState {
    private final ItemStack item;
    private double price;
    private int durationIndex;
    private final Double recommendedPrice;
    private final Duration[] durationOptions;
    private final AuctionListingRules listingRules;
    private final int defaultDurationIndex;

    public SellMenuState(ItemStack item, double price, int defaultDurationIndex, Double recommendedPrice, Duration[] durationOptions, AuctionListingRules listingRules) {
        this.item = Objects.requireNonNull(item, "item").clone();
        this.price = price;
        this.durationOptions = durationOptions != null ? durationOptions : new Duration[]{};
        this.listingRules = Objects.requireNonNull(listingRules, "listingRules");
        this.defaultDurationIndex = Math.max(0, defaultDurationIndex);
        this.durationIndex = this.normalizeIndex(defaultDurationIndex);
        this.recommendedPrice = recommendedPrice;
    }

    public ItemStack item() {
        return this.item.clone();
    }

    public double price() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public Double recommendedPrice() {
        return this.recommendedPrice;
    }

    public Duration duration() {
        if (this.durationOptions.length == 0) {
            return this.listingRules.defaultDuration();
        }
        return this.durationOptions[this.durationIndex];
    }

    public int durationIndex() {
        return this.durationIndex;
    }

    public void cycleDuration() {
        if (this.durationOptions.length == 0) {
            return;
        }
        this.durationIndex = (this.durationIndex + 1) % this.durationOptions.length;
    }

    private int normalizeIndex(int requested) {
        if (this.durationOptions.length == 0) {
            return 0;
        }
        if (requested < 0 || requested >= this.durationOptions.length) {
            return Math.min(this.defaultDurationIndex, this.durationOptions.length - 1);
        }
        return requested;
    }
}

