/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.gui;

import com.skyblockexp.ezauction.AuctionListing;
import com.skyblockexp.ezauction.AuctionManager;
import com.skyblockexp.ezauction.compat.ItemTagStorage;
import com.skyblockexp.ezauction.config.AuctionMessageConfiguration;
import com.skyblockexp.ezauction.config.AuctionValueConfiguration;
import com.skyblockexp.ezauction.gui.AuctionMenu;
import com.skyblockexp.ezauction.live.LiveAuctionEntry;
import com.skyblockexp.ezauction.live.LiveAuctionService;
import com.skyblockexp.ezauction.transaction.AuctionTransactionService;
import com.skyblockexp.ezauction.util.ItemValueProvider;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class LiveAuctionMenu
implements Listener {
    private static final String ACTION_CLOSE = "close";
    private static final String ACTION_REFRESH = "refresh";
    private static final String ACTION_BROWSE = "browse";
    private static final int INVENTORY_SIZE = 45;
    private static final String INVENTORY_TITLE = String.valueOf(ChatColor.GOLD) + "Live Auctions";
    private static final int INFO_SLOT = 4;
    private static final int CLOSE_SLOT = 40;
    private static final int REFRESH_SLOT = 42;
    private static final int BROWSE_SLOT = 38;
    private static final int EMPTY_SLOT = 22;
    private static final int[] QUEUE_SLOTS = new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34};
    private final JavaPlugin plugin;
    private final AuctionManager auctionManager;
    private final AuctionTransactionService transactionService;
    private final AuctionMenu auctionMenu;
    private final LiveAuctionService liveAuctionService;
    private final AuctionMessageConfiguration.LiveMessages messages;
    private final ItemValueProvider shopPriceProvider;
    private final boolean shopPriceDisplayEnabled;
    private final String shopPriceFormat;
    private final String actionKey;
    private final ItemTagStorage itemTagStorage;
    private final ItemStack fillerButton;
    private final ItemStack closeButton;
    private final ItemStack refreshButton;
    private final ItemStack browseButton;
    private final ItemStack infoButton;

    public LiveAuctionMenu(JavaPlugin plugin, AuctionManager auctionManager, AuctionTransactionService transactionService, AuctionMenu auctionMenu, LiveAuctionService liveAuctionService, AuctionMessageConfiguration.LiveMessages messages, AuctionValueConfiguration valueConfiguration, ItemValueProvider shopPriceProvider, boolean shopPriceDisplayEnabled, ItemTagStorage itemTagStorage) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
        this.auctionManager = Objects.requireNonNull(auctionManager, "auctionManager");
        this.transactionService = Objects.requireNonNull(transactionService, "transactionService");
        this.auctionMenu = Objects.requireNonNull(auctionMenu, "auctionMenu");
        this.liveAuctionService = Objects.requireNonNull(liveAuctionService, "liveAuctionService");
        this.messages = messages != null ? messages : AuctionMessageConfiguration.LiveMessages.defaults();
        AuctionValueConfiguration.ShopPriceConfiguration shopPriceConfiguration = valueConfiguration != null ? valueConfiguration.shopPriceConfiguration() : null;
        this.shopPriceProvider = shopPriceProvider != null ? shopPriceProvider : ItemValueProvider.none();
        this.shopPriceDisplayEnabled = shopPriceDisplayEnabled;
        this.shopPriceFormat = shopPriceConfiguration != null ? shopPriceConfiguration.format() : null;
        this.actionKey = "live_auction_action";
        this.itemTagStorage = Objects.requireNonNull(itemTagStorage, "itemTagStorage");
        this.fillerButton = this.createButton(Material.GRAY_STAINED_GLASS_PANE, String.valueOf(ChatColor.DARK_GRAY) + " ", List.of());
        this.closeButton = this.createButton(Material.BARRIER, String.valueOf(ChatColor.RED) + "Close", List.of(String.valueOf(ChatColor.GRAY) + "Exit the menu."));
        this.refreshButton = this.createButton(Material.SUNFLOWER, String.valueOf(ChatColor.GOLD) + "Refresh", List.of(String.valueOf(ChatColor.GRAY) + "Update the live auction queue."));
        this.browseButton = this.createButton(Material.CHEST, String.valueOf(ChatColor.GREEN) + "Browse Auctions", List.of(String.valueOf(ChatColor.GRAY) + "Open the main auction house."));
        this.infoButton = this.createButton(Material.WRITABLE_BOOK, String.valueOf(ChatColor.AQUA) + "Live Auction Queue", List.of(String.valueOf(ChatColor.GRAY) + "View upcoming live announcements.", String.valueOf(ChatColor.GRAY) + "Listings are broadcast from first to last.", String.valueOf(ChatColor.DARK_GRAY) + "Showing up to " + QUEUE_SLOTS.length + " auctions."));
    }

    public void open(Player player) {
        if (player == null) {
            return;
        }
        if (!this.liveAuctionService.isFeatureEnabled()) {
            this.sendMessage(player, this.messages.disabled());
            return;
        }
        if (!this.liveAuctionService.isQueueEnabled()) {
            this.sendMessage(player, this.messages.queueInstant());
            return;
        }
        LiveAuctionMenuHolder holder = new LiveAuctionMenuHolder(player.getUniqueId());
        Inventory inventory = Bukkit.createInventory((InventoryHolder)holder, (int)45, (String)INVENTORY_TITLE);
        holder.setInventory(inventory);
        this.populateInventory(inventory);
        player.openInventory(inventory);
    }

    private void populateInventory(Inventory inventory) {
        this.applyFiller(inventory);
        ItemStack info = this.infoButton.clone();
        inventory.setItem(4, info);
        ItemStack close = this.closeButton.clone();
        this.setAction(close, ACTION_CLOSE);
        inventory.setItem(40, close);
        ItemStack refresh = this.refreshButton.clone();
        this.setAction(refresh, ACTION_REFRESH);
        inventory.setItem(42, refresh);
        ItemStack browse = this.browseButton.clone();
        this.setAction(browse, ACTION_BROWSE);
        inventory.setItem(38, browse);
        ArrayList<LiveAuctionEntry> queue = new ArrayList<LiveAuctionEntry>(this.auctionManager.listQueuedLiveAuctions());
        if (queue.isEmpty()) {
            ItemStack empty = this.createButton(Material.BARRIER, String.valueOf(ChatColor.RED) + "No Queued Auctions", List.of(String.valueOf(ChatColor.GRAY) + "The live auction queue is currently empty."));
            inventory.setItem(22, empty);
            return;
        }
        long now = System.currentTimeMillis();
        for (int index = 0; index < QUEUE_SLOTS.length && index < queue.size(); ++index) {
            LiveAuctionEntry entry = (LiveAuctionEntry)queue.get(index);
            ItemStack icon = this.createQueueIcon(entry, index, now);
            int slot = QUEUE_SLOTS[index];
            if (slot < 0 || slot >= inventory.getSize()) continue;
            inventory.setItem(slot, icon);
        }
    }

    private ItemStack createQueueIcon(LiveAuctionEntry entry, int position, long now) {
        ItemMeta meta;
        ItemStack icon;
        AuctionListing listing = entry.listing();
        ItemStack baseItem = listing != null ? listing.item() : null;
        ItemStack itemStack = icon = baseItem != null ? baseItem.clone() : new ItemStack(Material.CHEST);
        if (icon.getType() == Material.AIR) {
            icon.setType(Material.CHEST);
        }
        if ((meta = icon.getItemMeta()) == null) {
            meta = Bukkit.getItemFactory().getItemMeta(icon.getType());
        }
        String queueName = String.valueOf(ChatColor.YELLOW) + this.describeItem(icon);
        if (meta != null) {
            if (!meta.hasDisplayName() || meta.getDisplayName() == null || meta.getDisplayName().isEmpty()) {
                meta.setDisplayName(queueName);
            }
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(String.valueOf(ChatColor.DARK_GRAY) + "Queue Position #" + (position + 1));
            if (position == 0) {
                lore.add(String.valueOf(ChatColor.GREEN) + "Up next for announcement!");
            }
            lore.add(String.valueOf(ChatColor.GRAY) + "Seller: " + String.valueOf(ChatColor.AQUA) + entry.sellerName());
            lore.add(String.valueOf(ChatColor.GRAY) + "Price: " + String.valueOf(ChatColor.GOLD) + this.transactionService.formatCurrency(listing.price()));
            this.appendShopPrice(baseItem != null ? baseItem : icon, lore);
            long expiryMillis = listing.expiryEpochMillis();
            if (expiryMillis > now) {
                Duration remaining = Duration.ofMillis(expiryMillis - now);
                lore.add(String.valueOf(ChatColor.GRAY) + "Ends in: " + String.valueOf(ChatColor.YELLOW) + this.formatDuration(remaining));
            } else {
                lore.add(String.valueOf(ChatColor.RED) + "This listing is expiring soon.");
            }
            if (listing.deposit() > 0.0) {
                lore.add(String.valueOf(ChatColor.GRAY) + "Deposit: " + String.valueOf(ChatColor.GOLD) + this.transactionService.formatCurrency(listing.deposit()));
            }
            lore.add(String.valueOf(ChatColor.DARK_GRAY) + "ID: " + listing.id());
            meta.setLore(lore);
            if (position == 0) {
                meta.addEnchant(Enchantment.BINDING_CURSE, 1, true);
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            icon.setItemMeta(meta);
        }
        return icon;
    }

    private void appendShopPrice(ItemStack item, List<String> lore) {
        OptionalDouble shopPrice;
        if (!this.shopPriceDisplayEnabled || item == null || lore == null) {
            return;
        }
        OptionalDouble optionalDouble = shopPrice = this.shopPriceProvider != null ? this.shopPriceProvider.estimate(item) : OptionalDouble.empty();
        if (shopPrice.isEmpty()) {
            return;
        }
        String format = this.shopPriceFormat != null && !this.shopPriceFormat.isEmpty() ? this.shopPriceFormat : "&7Shop Price: &6{value}";
        String formatted = format.replace("{value}", this.transactionService.formatCurrency(shopPrice.getAsDouble()));
        lore.add(this.colorize(formatted));
    }

    private void applyFiller(Inventory inventory) {
        for (int slot = 0; slot < inventory.getSize(); ++slot) {
            inventory.setItem(slot, this.fillerButton.clone());
        }
    }

    private ItemStack createButton(Material material, String displayName, List<String> lore) {
        ItemStack item = material != null ? new ItemStack(material) : new ItemStack(Material.STONE);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            if (displayName != null) {
                meta.setDisplayName(displayName);
            }
            if (lore != null && !lore.isEmpty()) {
                meta.setLore(lore);
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    private void setAction(ItemStack item, String action) {
        if (item == null || action == null || action.isEmpty()) {
            return;
        }
        this.itemTagStorage.setString(item, this.actionKey, action);
    }

    private void sendMessage(Player player, String message) {
        if (player == null || message == null || message.isEmpty()) {
            return;
        }
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
    }

    private String getAction(ItemStack item) {
        if (item == null) {
            return null;
        }
        return this.itemTagStorage.getString(item, this.actionKey);
    }

    private String describeItem(ItemStack item) {
        if (item == null) {
            return "Unknown Item";
        }
        ItemMeta meta = item.getItemMeta();
        if (meta != null && meta.hasDisplayName() && meta.getDisplayName() != null && !ChatColor.stripColor((String)meta.getDisplayName()).isEmpty()) {
            return ChatColor.stripColor((String)meta.getDisplayName());
        }
        String materialName = item.getType().name().toLowerCase(Locale.ENGLISH).replace('_', ' ');
        if (materialName.isEmpty()) {
            return "Item";
        }
        return Character.toUpperCase(materialName.charAt(0)) + materialName.substring(1);
    }

    private String formatDuration(Duration duration) {
        if (duration == null || duration.isZero() || duration.isNegative()) {
            return "Expired";
        }
        long totalSeconds = duration.getSeconds();
        long days = totalSeconds / 86400L;
        long hours = totalSeconds % 86400L / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        if (days > 0L) {
            if (hours > 0L) {
                return days + "d " + hours + "h";
            }
            return days + "d";
        }
        if (hours > 0L) {
            if (minutes > 0L) {
                return hours + "h " + minutes + "m";
            }
            return hours + "h";
        }
        if (minutes > 0L) {
            return minutes + "m";
        }
        long seconds = Math.max(1L, totalSeconds % 60L);
        return seconds + "s";
    }

    private String colorize(String value) {
        if (value == null || value.isEmpty()) {
            return "";
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)value);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (!(inventoryHolder instanceof LiveAuctionMenuHolder)) {
            return;
        }
        LiveAuctionMenuHolder holder = (LiveAuctionMenuHolder)inventoryHolder;
        event.setCancelled(true);
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!holder.owner().equals(player.getUniqueId())) {
            return;
        }
        ItemStack clicked = event.getCurrentItem();
        String action = this.getAction(clicked);
        if (action == null) {
            return;
        }
        switch (action) {
            case "close": {
                player.closeInventory();
                break;
            }
            case "refresh": {
                this.reopenAsync(player);
                break;
            }
            case "browse": {
                player.closeInventory();
                this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.auctionMenu.openBrowser(player));
                break;
            }
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (event.getInventory().getHolder() instanceof LiveAuctionMenuHolder) {
            event.setCancelled(true);
        }
    }

    private void reopenAsync(final Player player) {
        new BukkitRunnable(){

            public void run() {
                LiveAuctionMenu.this.open(player);
            }
        }.runTask((Plugin)this.plugin);
    }

    private static final class LiveAuctionMenuHolder
    implements InventoryHolder {
        private final UUID owner;
        private Inventory inventory;

        private LiveAuctionMenuHolder(UUID owner) {
            this.owner = owner;
        }

        public UUID owner() {
            return this.owner;
        }

        public void setInventory(Inventory inventory) {
            this.inventory = inventory;
        }

        public Inventory getInventory() {
            return this.inventory;
        }
    }
}

