/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.gui;

import com.skyblockexp.ezauction.AuctionListing;
import com.skyblockexp.ezauction.AuctionManager;
import com.skyblockexp.ezauction.AuctionOperationResult;
import com.skyblockexp.ezauction.AuctionOrder;
import com.skyblockexp.ezauction.compat.ItemTagStorage;
import com.skyblockexp.ezauction.config.AuctionMenuConfiguration;
import com.skyblockexp.ezauction.config.AuctionMessageConfiguration;
import com.skyblockexp.ezauction.config.AuctionValueConfiguration;
import com.skyblockexp.ezauction.transaction.AuctionTransactionService;
import com.skyblockexp.ezauction.util.ItemValueProvider;
import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class AuctionMenu
implements Listener {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("MMM d, h:mm a").withLocale(Locale.ENGLISH);
    private static final String ACTION_LISTING = "listing";
    private static final String ACTION_ORDER = "order";
    private static final String ACTION_PREVIOUS = "previous";
    private static final String ACTION_NEXT = "next";
    private static final String ACTION_CANCEL = "cancel";
    private static final String ACTION_CONFIRM = "confirm";
    private static final String ACTION_CLOSE = "close";
    private static final String ACTION_TOGGLE_LISTINGS = "toggle_listings";
    private static final String ACTION_TOGGLE_ORDERS = "toggle_orders";
    private static final String ACTION_SEARCH = "search";
    private static final String ACTION_SORT = "sort";
    private static final int MAX_SEARCH_LENGTH = 48;
    private final JavaPlugin plugin;
    private final AuctionManager auctionManager;
    private final AuctionTransactionService transactionService;
    private final AuctionMenuConfiguration menuConfiguration;
    private final AuctionMenuConfiguration.BrowserMenuConfiguration browserConfig;
    private final AuctionMessageConfiguration.BrowserMessages messages;
    private final AuctionMenuConfiguration.ConfirmMenuConfiguration confirmConfig;
    private final AuctionMenuConfiguration.ToggleButtonConfiguration listingsToggleConfig;
    private final AuctionMenuConfiguration.ToggleButtonConfiguration ordersToggleConfig;
    private final AuctionMenuConfiguration.BrowserMenuConfiguration.SearchButtonConfiguration searchButtonConfig;
    private final AuctionMenuConfiguration.BrowserMenuConfiguration.SortButtonConfiguration sortButtonConfig;
    private final AuctionMenuConfiguration.ConfirmMenuConfiguration.ButtonConfiguration confirmButtonConfig;
    private final AuctionMenuConfiguration.ConfirmMenuConfiguration.ButtonConfiguration cancelButtonConfig;
    private final AuctionValueConfiguration valueConfiguration;
    private final ItemValueProvider itemValueProvider;
    private final ItemValueProvider shopPriceProvider;
    private final boolean valueDisplayEnabled;
    private final String valueDisplayFormat;
    private final boolean shopPriceDisplayEnabled;
    private final String shopPriceFormat;
    private final String actionKey;
    private final String listingKey;
    private final String actionTypeKey;
    private final ItemTagStorage itemTagStorage;
    private final ItemStack browserFiller;
    private final ItemStack confirmFiller;
    private final int listingsPerPage;
    private final ConcurrentMap<UUID, String> activeSearchQueries;
    private final ConcurrentMap<UUID, SearchPrompt> pendingSearchInputs;
    private final ConcurrentMap<UUID, ListingSort> activeListingSorts;
    private final ConcurrentMap<UUID, OrderSort> activeOrderSorts;

    public AuctionMenu(JavaPlugin plugin, AuctionManager auctionManager, AuctionTransactionService transactionService, AuctionMenuConfiguration menuConfiguration, AuctionMessageConfiguration.BrowserMessages messages, AuctionValueConfiguration valueConfiguration, ItemValueProvider itemValueProvider, ItemValueProvider shopPriceProvider, boolean shopPriceDisplayEnabled, ItemTagStorage itemTagStorage) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
        this.auctionManager = Objects.requireNonNull(auctionManager, "auctionManager");
        this.transactionService = Objects.requireNonNull(transactionService, "transactionService");
        this.menuConfiguration = Objects.requireNonNull(menuConfiguration, "menuConfiguration");
        this.browserConfig = Objects.requireNonNull(menuConfiguration.browser(), "browserConfig");
        this.messages = messages != null ? messages : AuctionMessageConfiguration.BrowserMessages.defaults();
        this.confirmConfig = Objects.requireNonNull(menuConfiguration.confirm(), "confirmConfig");
        this.listingsToggleConfig = this.browserConfig.listingsToggle();
        this.ordersToggleConfig = this.browserConfig.ordersToggle();
        this.searchButtonConfig = this.browserConfig.searchButton();
        this.sortButtonConfig = this.browserConfig.sortButton();
        this.confirmButtonConfig = this.confirmConfig.confirmButton();
        this.cancelButtonConfig = this.confirmConfig.cancelButton();
        this.valueConfiguration = valueConfiguration != null ? valueConfiguration : AuctionValueConfiguration.defaults();
        this.itemValueProvider = itemValueProvider != null ? itemValueProvider : ItemValueProvider.none();
        this.shopPriceProvider = shopPriceProvider != null ? shopPriceProvider : ItemValueProvider.none();
        this.valueDisplayEnabled = this.valueConfiguration.enabled();
        this.valueDisplayFormat = this.valueConfiguration.format();
        AuctionValueConfiguration.ShopPriceConfiguration shopPriceConfiguration = this.valueConfiguration.shopPriceConfiguration();
        this.shopPriceDisplayEnabled = shopPriceDisplayEnabled;
        this.shopPriceFormat = shopPriceConfiguration != null ? shopPriceConfiguration.format() : null;
        this.actionKey = "auction_action";
        this.listingKey = "auction_listing";
        this.actionTypeKey = "auction_action_type";
        this.itemTagStorage = Objects.requireNonNull(itemTagStorage, "itemTagStorage");
        this.browserFiller = this.createConfiguredFiller(this.browserConfig.filler());
        this.confirmFiller = this.createConfiguredFiller(this.confirmConfig.filler());
        this.listingsPerPage = Math.max(1, Math.min(this.browserConfig.size(), this.browserConfig.size() - 9));
        this.activeSearchQueries = new ConcurrentHashMap<UUID, String>();
        this.pendingSearchInputs = new ConcurrentHashMap<UUID, SearchPrompt>();
        this.activeListingSorts = new ConcurrentHashMap<UUID, ListingSort>();
        this.activeOrderSorts = new ConcurrentHashMap<UUID, OrderSort>();
    }

    public void openBrowser(Player player) {
        this.openBrowser(player, BrowserView.LISTINGS, 0);
    }

    private void openBrowser(Player player, BrowserView view, int page) {
        int ordersToggleSlot;
        int listingsToggleSlot;
        ArrayList<AuctionOrder> orders;
        ArrayList<AuctionListing> listings;
        UUID playerId = player.getUniqueId();
        String searchQuery = this.getSearchQuery(playerId);
        String normalizedQuery = searchQuery != null ? searchQuery.toLowerCase(Locale.ENGLISH) : null;
        ArrayList<AuctionListing> arrayList = listings = view == BrowserView.LISTINGS ? new ArrayList<AuctionListing>(this.auctionManager.listActiveListings()) : Collections.emptyList();
        if (view == BrowserView.LISTINGS) {
            System.out.println("[EzAuction][DEBUG] AuctionMenu.openBrowser: listings.size() = " + listings.size() + ", listings = " + String.valueOf(listings));
        }
        if (view == BrowserView.LISTINGS) {
            this.filterListings(listings, normalizedQuery);
        }
        ArrayList<AuctionOrder> arrayList2 = orders = view == BrowserView.ORDERS ? new ArrayList<AuctionOrder>(this.auctionManager.listActiveOrders()) : Collections.emptyList();
        if (view == BrowserView.ORDERS) {
            this.filterOrders(orders, normalizedQuery);
        }
        ListingSort listingSort = this.getListingSort(playerId);
        OrderSort orderSort = this.getOrderSort(playerId);
        if (view == BrowserView.LISTINGS) {
            listingSort.sort(listings);
        }
        if (view == BrowserView.ORDERS) {
            orderSort.sort(orders);
        }
        int totalEntries = view == BrowserView.LISTINGS ? listings.size() : orders.size();
        int entriesPerPage = Math.max(1, this.listingsPerPage);
        int totalPages = Math.max(1, (int)Math.ceil((double)totalEntries / (double)entriesPerPage));
        int currentPage = Math.max(0, Math.min(page, totalPages - 1));
        BrowserMenuHolder holder = new BrowserMenuHolder(playerId, currentPage, view);
        String title = this.formatBrowserTitle(view, currentPage, totalPages);
        Inventory inventory = Bukkit.createInventory((InventoryHolder)holder, (int)this.browserConfig.size(), (String)title);
        holder.setInventory(inventory);
        this.applyFiller(inventory, this.browserFiller);
        int startIndex = currentPage * entriesPerPage;
        int endIndex = Math.min(startIndex + entriesPerPage, totalEntries);
        if (startIndex >= endIndex) {
            List<CallSite> lore;
            String emptyTitle;
            boolean searching;
            boolean bl = searching = normalizedQuery != null;
            if (searching) {
                emptyTitle = String.valueOf(ChatColor.RED) + "No Matches";
                ArrayList<CallSite> tempLore = new ArrayList<CallSite>();
                tempLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "No " + (view == BrowserView.LISTINGS ? "listings" : "orders") + " matched \"" + String.valueOf(ChatColor.AQUA) + this.formatSearchQueryForLore(searchQuery) + String.valueOf(ChatColor.GRAY) + "\".")));
                tempLore.add((CallSite)((Object)(String.valueOf(ChatColor.YELLOW) + "Right-click the search button to clear.")));
                lore = tempLore;
            } else {
                emptyTitle = view == BrowserView.LISTINGS ? String.valueOf(ChatColor.RED) + "No Listings" : String.valueOf(ChatColor.RED) + "No Orders";
                lore = view == BrowserView.LISTINGS ? List.of(String.valueOf(ChatColor.GRAY) + "No items are currently listed.") : List.of(String.valueOf(ChatColor.GRAY) + "No buy orders are currently active.");
            }
            int emptySlot = this.browserConfig.emptyListingSlot();
            if (emptySlot >= 0 && emptySlot < inventory.getSize()) {
                inventory.setItem(emptySlot, this.createButton(Material.BARRIER, emptyTitle, lore));
            }
        } else {
            int slot = 0;
            for (int index = startIndex; index < endIndex; ++index) {
                ItemStack icon;
                if (view == BrowserView.LISTINGS) {
                    AuctionListing listing = (AuctionListing)listings.get(index);
                    icon = this.decorateListing(listing, playerId);
                    if (icon == null) continue;
                    this.setPersistent(icon, this.actionKey, ACTION_LISTING);
                    this.setPersistent(icon, this.actionTypeKey, BrowserView.LISTINGS.name());
                    this.setPersistent(icon, this.listingKey, listing.id());
                    if (slot < inventory.getSize()) {
                        inventory.setItem(slot, icon);
                    }
                    ++slot;
                    continue;
                }
                AuctionOrder order = (AuctionOrder)orders.get(index);
                icon = this.decorateOrder(order, playerId);
                if (icon == null) continue;
                this.setPersistent(icon, this.actionKey, ACTION_ORDER);
                this.setPersistent(icon, this.actionTypeKey, BrowserView.ORDERS.name());
                this.setPersistent(icon, this.listingKey, order.id());
                if (slot < inventory.getSize()) {
                    inventory.setItem(slot, icon);
                }
                ++slot;
            }
        }
        if (currentPage > 0) {
            ItemStack previous = this.createButton(Material.ARROW, String.valueOf(ChatColor.YELLOW) + "Previous Page", List.of(String.valueOf(ChatColor.GRAY) + "View earlier listings."));
            this.setPersistent(previous, this.actionKey, ACTION_PREVIOUS);
            int slot = this.browserConfig.previousSlot();
            if (slot >= 0 && slot < inventory.getSize()) {
                inventory.setItem(slot, previous);
            }
        }
        ItemStack close = this.createButton(Material.BARRIER, String.valueOf(ChatColor.RED) + "Close", List.of(String.valueOf(ChatColor.GRAY) + "Exit the auction."));
        this.setPersistent(close, this.actionKey, ACTION_CLOSE);
        int closeSlot = this.browserConfig.closeSlot();
        if (closeSlot >= 0 && closeSlot < inventory.getSize()) {
            inventory.setItem(closeSlot, close);
        }
        if (currentPage < totalPages - 1) {
            ItemStack next = this.createButton(Material.ARROW, String.valueOf(ChatColor.YELLOW) + "Next Page", List.of(String.valueOf(ChatColor.GRAY) + "View more listings."));
            this.setPersistent(next, this.actionKey, ACTION_NEXT);
            int slot = this.browserConfig.nextSlot();
            if (slot >= 0 && slot < inventory.getSize()) {
                inventory.setItem(slot, next);
            }
        }
        ItemStack listingsToggle = this.createToggleButton(view == BrowserView.LISTINGS, this.listingsToggleConfig, String.valueOf(ChatColor.YELLOW) + "Currently viewing listings.", String.valueOf(ChatColor.GREEN) + "Click to view listings.");
        this.setPersistent(listingsToggle, this.actionKey, ACTION_TOGGLE_LISTINGS);
        int n = listingsToggleSlot = this.listingsToggleConfig != null ? this.listingsToggleConfig.slot() : 46;
        if (listingsToggleSlot >= 0 && listingsToggleSlot < inventory.getSize()) {
            inventory.setItem(listingsToggleSlot, listingsToggle);
        }
        ItemStack ordersToggle = this.createToggleButton(view == BrowserView.ORDERS, this.ordersToggleConfig, String.valueOf(ChatColor.YELLOW) + "Currently viewing orders.", String.valueOf(ChatColor.GREEN) + "Click to view orders.");
        this.setPersistent(ordersToggle, this.actionKey, ACTION_TOGGLE_ORDERS);
        int n2 = ordersToggleSlot = this.ordersToggleConfig != null ? this.ordersToggleConfig.slot() : 52;
        if (ordersToggleSlot >= 0 && ordersToggleSlot < inventory.getSize()) {
            inventory.setItem(ordersToggleSlot, ordersToggle);
        }
        if (this.searchButtonConfig != null) {
            ItemStack searchButton = this.createSearchButton(view, searchQuery);
            this.setPersistent(searchButton, this.actionKey, ACTION_SEARCH);
            int searchSlot = this.searchButtonConfig.slot();
            if (searchSlot >= 0 && searchSlot < inventory.getSize()) {
                inventory.setItem(searchSlot, searchButton);
            }
        }
        if (this.sortButtonConfig != null) {
            ItemStack sortButton = this.createSortButton(view, listingSort, orderSort);
            this.setPersistent(sortButton, this.actionKey, ACTION_SORT);
            int sortSlot = this.sortButtonConfig.slot();
            if (sortSlot >= 0 && sortSlot < inventory.getSize()) {
                inventory.setItem(sortSlot, sortButton);
            }
        }
        player.openInventory(inventory);
    }

    private void openListingConfirmMenu(Player player, BrowserMenuHolder previousHolder, String listingId) {
        int cancelSlot;
        ItemStack icon;
        int confirmSlot;
        AuctionListing listing = this.findListing(listingId);
        if (listing == null) {
            this.sendMessage(player, this.messages.listingUnavailable());
            this.runSync(() -> this.openBrowser(player, previousHolder.view(), previousHolder.page()));
            return;
        }
        ConfirmMenuHolder holder = new ConfirmMenuHolder(player.getUniqueId(), previousHolder.page(), previousHolder.view(), ConfirmAction.PURCHASE_LISTING);
        Inventory inventory = Bukkit.createInventory((InventoryHolder)holder, (int)this.confirmConfig.size(), (String)this.colorize(this.confirmConfig.title()));
        holder.setInventory(inventory);
        this.applyFiller(inventory, this.confirmFiller);
        ItemStack confirm = this.createConfiguredButton(this.confirmButtonConfig != null ? this.confirmButtonConfig.button() : null, List.of(String.valueOf(ChatColor.GRAY) + "Buy for " + String.valueOf(ChatColor.GOLD) + this.transactionService.formatCurrency(listing.price())));
        this.setPersistent(confirm, this.actionKey, ACTION_CONFIRM);
        this.setPersistent(confirm, this.listingKey, listing.id());
        this.setPersistent(confirm, this.actionTypeKey, BrowserView.LISTINGS.name());
        int n = confirmSlot = this.confirmButtonConfig != null ? this.confirmButtonConfig.slot() : this.confirmConfig.confirmButton().slot();
        if (confirmSlot >= 0 && confirmSlot < inventory.getSize()) {
            inventory.setItem(confirmSlot, confirm);
        }
        if ((icon = this.decorateListing(listing, player.getUniqueId())) != null) {
            this.setPersistent(icon, this.actionKey, ACTION_LISTING);
            this.setPersistent(icon, this.listingKey, listing.id());
            this.setPersistent(icon, this.actionTypeKey, BrowserView.LISTINGS.name());
            int listingSlot = this.confirmConfig.listingSlot();
            if (listingSlot >= 0 && listingSlot < inventory.getSize()) {
                inventory.setItem(listingSlot, icon);
            }
        }
        ItemStack cancel = this.createConfiguredButton(this.cancelButtonConfig != null ? this.cancelButtonConfig.button() : null, List.of(String.valueOf(ChatColor.GRAY) + "Return to the listings."));
        this.setPersistent(cancel, this.actionKey, ACTION_CANCEL);
        int n2 = cancelSlot = this.cancelButtonConfig != null ? this.cancelButtonConfig.slot() : this.confirmConfig.cancelButton().slot();
        if (cancelSlot >= 0 && cancelSlot < inventory.getSize()) {
            inventory.setItem(cancelSlot, cancel);
        }
        player.openInventory(inventory);
    }

    private void openOrderConfirmMenu(Player player, BrowserMenuHolder previousHolder, String orderId) {
        int cancelSlot;
        ItemStack icon;
        int confirmSlot;
        AuctionOrder order = this.findOrder(orderId);
        if (order == null) {
            this.sendMessage(player, this.messages.orderUnavailable());
            this.runSync(() -> this.openBrowser(player, previousHolder.view(), previousHolder.page()));
            return;
        }
        ConfirmMenuHolder holder = new ConfirmMenuHolder(player.getUniqueId(), previousHolder.page(), previousHolder.view(), ConfirmAction.FULFILL_ORDER);
        Inventory inventory = Bukkit.createInventory((InventoryHolder)holder, (int)this.confirmConfig.size(), (String)this.colorize(this.confirmConfig.title()));
        holder.setInventory(inventory);
        this.applyFiller(inventory, this.confirmFiller);
        ItemStack confirm = this.createConfiguredButton(this.confirmButtonConfig != null ? this.confirmButtonConfig.button() : null, List.of(String.valueOf(ChatColor.GRAY) + "Receive " + String.valueOf(ChatColor.GOLD) + this.transactionService.formatCurrency(order.offeredPrice())));
        this.setPersistent(confirm, this.actionKey, ACTION_CONFIRM);
        this.setPersistent(confirm, this.listingKey, order.id());
        this.setPersistent(confirm, this.actionTypeKey, BrowserView.ORDERS.name());
        int n = confirmSlot = this.confirmButtonConfig != null ? this.confirmButtonConfig.slot() : this.confirmConfig.confirmButton().slot();
        if (confirmSlot >= 0 && confirmSlot < inventory.getSize()) {
            inventory.setItem(confirmSlot, confirm);
        }
        if ((icon = this.decorateOrder(order, player.getUniqueId())) != null) {
            this.setPersistent(icon, this.actionKey, ACTION_ORDER);
            this.setPersistent(icon, this.listingKey, order.id());
            this.setPersistent(icon, this.actionTypeKey, BrowserView.ORDERS.name());
            int listingSlot = this.confirmConfig.listingSlot();
            if (listingSlot >= 0 && listingSlot < inventory.getSize()) {
                inventory.setItem(listingSlot, icon);
            }
        }
        ItemStack cancel = this.createConfiguredButton(this.cancelButtonConfig != null ? this.cancelButtonConfig.button() : null, List.of(String.valueOf(ChatColor.GRAY) + "Return to the browser."));
        this.setPersistent(cancel, this.actionKey, ACTION_CANCEL);
        int n2 = cancelSlot = this.cancelButtonConfig != null ? this.cancelButtonConfig.slot() : this.confirmConfig.cancelButton().slot();
        if (cancelSlot >= 0 && cancelSlot < inventory.getSize()) {
            inventory.setItem(cancelSlot, cancel);
        }
        player.openInventory(inventory);
    }

    private void applyFiller(Inventory inventory, ItemStack filler) {
        if (inventory == null || filler == null) {
            return;
        }
        for (int slot = 0; slot < inventory.getSize(); ++slot) {
            ItemStack current = inventory.getItem(slot);
            if (current != null && current.getType() != Material.AIR) continue;
            inventory.setItem(slot, filler.clone());
        }
    }

    private void appendEstimatedValue(ItemStack item, List<String> lore) {
        OptionalDouble estimate;
        if (!this.valueDisplayEnabled || item == null || lore == null) {
            return;
        }
        OptionalDouble optionalDouble = estimate = this.itemValueProvider != null ? this.itemValueProvider.estimate(item) : OptionalDouble.empty();
        if (estimate.isEmpty()) {
            return;
        }
        String format = this.valueDisplayFormat != null && !this.valueDisplayFormat.isEmpty() ? this.valueDisplayFormat : "&7Value: &6{value}";
        String formatted = format.replace("{value}", this.transactionService.formatCurrency(estimate.getAsDouble()));
        lore.add(this.colorize(formatted));
    }

    private void appendShopPrice(ItemStack item, List<String> lore) {
        OptionalDouble shopPrice;
        if (!this.shopPriceDisplayEnabled || item == null || lore == null) {
            return;
        }
        OptionalDouble optionalDouble = shopPrice = this.shopPriceProvider != null ? this.shopPriceProvider.estimate(item) : OptionalDouble.empty();
        if (shopPrice.isEmpty()) {
            return;
        }
        String format = this.shopPriceFormat != null && !this.shopPriceFormat.isEmpty() ? this.shopPriceFormat : "&7Shop Price: &6{value}";
        String formatted = format.replace("{value}", this.transactionService.formatCurrency(shopPrice.getAsDouble()));
        lore.add(this.colorize(formatted));
    }

    private ItemStack decorateListing(AuctionListing listing, UUID viewer) {
        OfflinePlayer seller;
        ArrayList<String> lore;
        ItemStack display = listing.item();
        if (display == null || display.getType() == Material.AIR) {
            return null;
        }
        ItemStack icon = display.clone();
        ItemMeta meta = icon.getItemMeta();
        if (meta == null) {
            return icon;
        }
        ArrayList<String> arrayList = lore = meta.hasLore() ? new ArrayList<String>(meta.getLore()) : new ArrayList();
        if (!lore.isEmpty()) {
            lore.add(" ");
        }
        String sellerName = (seller = this.plugin.getServer().getOfflinePlayer(listing.sellerId())) != null && seller.getName() != null ? seller.getName() : "Unknown";
        lore.add(String.valueOf(ChatColor.GRAY) + "Seller: " + String.valueOf(ChatColor.AQUA) + sellerName + (String)(listing.sellerId().equals(viewer) ? String.valueOf(ChatColor.GRAY) + " (You)" : ""));
        lore.add(String.valueOf(ChatColor.GRAY) + "Price: " + String.valueOf(ChatColor.GOLD) + this.transactionService.formatCurrency(listing.price()));
        this.appendEstimatedValue(display, lore);
        this.appendShopPrice(display, lore);
        lore.add(String.valueOf(ChatColor.GRAY) + "Expires: " + String.valueOf(ChatColor.YELLOW) + this.formatExpiry(listing.expiryEpochMillis()));
        lore.add(" ");
        if (this.isShulkerBox(display)) {
            lore.add(this.colorize(this.messages.shulkerPreviewHint()));
        }
        if (listing.sellerId().equals(viewer)) {
            lore.add(String.valueOf(ChatColor.YELLOW) + "Right-click to cancel this listing.");
        } else {
            lore.add(String.valueOf(ChatColor.GREEN) + "Left-click to buy this item.");
        }
        meta.setLore(lore);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        icon.setItemMeta(meta);
        return icon;
    }

    private ItemStack decorateOrder(AuctionOrder order, UUID viewer) {
        ItemStack requested = order.requestedItem();
        if (requested == null || requested.getType() == Material.AIR) {
            return null;
        }
        ItemStack icon = requested.clone();
        ItemMeta meta = icon.getItemMeta();
        if (meta == null) {
            return icon;
        }
        OfflinePlayer buyer = this.plugin.getServer().getOfflinePlayer(order.buyerId());
        String buyerName = buyer != null && buyer.getName() != null ? buyer.getName() : "Unknown";
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(String.valueOf(ChatColor.GRAY) + "Buyer: " + String.valueOf(ChatColor.AQUA) + buyerName + (String)(order.buyerId().equals(viewer) ? String.valueOf(ChatColor.GRAY) + " (You)" : ""));
        lore.add(String.valueOf(ChatColor.GRAY) + "Offer: " + String.valueOf(ChatColor.GOLD) + this.transactionService.formatCurrency(order.offeredPrice()));
        this.appendEstimatedValue(requested, lore);
        this.appendShopPrice(requested, lore);
        lore.add(String.valueOf(ChatColor.GRAY) + "Expires: " + String.valueOf(ChatColor.YELLOW) + this.formatExpiry(order.expiryEpochMillis()));
        lore.add(" ");
        if (this.isShulkerBox(requested)) {
            lore.add(this.colorize(this.messages.shulkerPreviewHint()));
        }
        if (order.buyerId().equals(viewer)) {
            lore.add(String.valueOf(ChatColor.YELLOW) + "Right-click to cancel this order.");
        } else {
            lore.add(String.valueOf(ChatColor.GREEN) + "Left-click to fulfill this order.");
        }
        meta.setLore(lore);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        icon.setItemMeta(meta);
        return icon;
    }

    private String formatExpiry(long expiryEpochMillis) {
        long now = System.currentTimeMillis();
        if (expiryEpochMillis <= now) {
            return "Expired";
        }
        Duration remaining = Duration.ofMillis(expiryEpochMillis - now);
        long days = remaining.toDays();
        remaining = remaining.minusDays(days);
        long hours = remaining.toHours();
        remaining = remaining.minusHours(hours);
        long minutes = remaining.toMinutes();
        StringBuilder builder = new StringBuilder();
        if (days > 0L) {
            builder.append(days).append("d ");
        }
        if (hours > 0L || days > 0L) {
            builder.append(hours).append("h ");
        }
        builder.append(minutes).append("m");
        builder.append(ChatColor.GRAY).append(" (").append(DATE_FORMAT.format(Instant.ofEpochMilli(expiryEpochMillis).atZone(ZoneId.systemDefault()))).append(")");
        return builder.toString();
    }

    private AuctionListing findListing(String listingId) {
        if (listingId == null || listingId.isEmpty()) {
            return null;
        }
        for (AuctionListing listing : this.auctionManager.listActiveListings()) {
            if (!listing.id().equalsIgnoreCase(listingId)) continue;
            return listing;
        }
        return null;
    }

    private AuctionOrder findOrder(String orderId) {
        if (orderId == null || orderId.isEmpty()) {
            return null;
        }
        for (AuctionOrder order : this.auctionManager.listActiveOrders()) {
            if (!order.id().equalsIgnoreCase(orderId)) continue;
            return order;
        }
        return null;
    }

    private ItemStack createConfiguredFiller(AuctionMenuConfiguration.MenuButtonConfiguration configuration) {
        if (configuration == null) {
            return this.createButton(Material.GRAY_STAINED_GLASS_PANE, "&8 ", List.of());
        }
        return this.createButton(configuration.material(), configuration.displayName(), configuration.lore());
    }

    private ItemStack createConfiguredButton(AuctionMenuConfiguration.MenuButtonConfiguration configuration, List<String> additionalLore) {
        ArrayList<String> lore = new ArrayList<String>();
        if (configuration != null && configuration.lore() != null) {
            lore.addAll(configuration.lore());
        }
        if (additionalLore != null && !additionalLore.isEmpty()) {
            lore.addAll(additionalLore);
        }
        if (configuration == null) {
            return this.createButton(Material.STONE_BUTTON, "&7Button", lore);
        }
        return this.createButton(configuration.material(), configuration.displayName(), lore);
    }

    private String formatBrowserTitle(BrowserView view, int page, int totalPages) {
        String formatted;
        String rawTitle = this.browserConfig.title();
        if (rawTitle == null || rawTitle.isEmpty()) {
            rawTitle = "&2Auction House &7({page}/{total_pages})";
        }
        if ((formatted = rawTitle.replace("{page}", String.valueOf(page + 1)).replace("{total_pages}", String.valueOf(Math.max(1, totalPages)))).contains("{view}")) {
            formatted = formatted.replace("{view}", view == BrowserView.ORDERS ? "Orders" : "Listings");
        }
        return this.colorize(formatted);
    }

    private String colorize(String value) {
        if (value == null) {
            return "";
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)value);
    }

    private boolean isShulkerBox(ItemStack item) {
        if (item == null) {
            return false;
        }
        Material type = item.getType();
        if (type == null) {
            return false;
        }
        String name = type.name();
        return name != null && name.endsWith("SHULKER_BOX");
    }

    private List<String> colorizeList(List<String> lore) {
        if (lore == null || lore.isEmpty()) {
            return null;
        }
        ArrayList<String> colored = new ArrayList<String>(lore.size());
        for (String line : lore) {
            colored.add(this.colorize(line));
        }
        return colored;
    }

    private void sendMessage(Player player, String message) {
        if (player == null || message == null || message.isEmpty()) {
            return;
        }
        player.sendMessage(this.colorize(message));
    }

    private ItemStack createButton(Material material, String name, List<String> lore) {
        ItemStack item = material != null ? new ItemStack(material) : new ItemStack(Material.STONE);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(this.colorize(name));
            List<String> coloredLore = this.colorizeList(lore);
            if (coloredLore != null && !coloredLore.isEmpty()) {
                meta.setLore(coloredLore);
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    private void setPersistent(ItemStack item, String key, String value) {
        if (item == null || key == null || value == null) {
            return;
        }
        this.itemTagStorage.setString(item, key, value);
    }

    private void runSync(Runnable runnable) {
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, runnable);
    }

    @EventHandler
    public void onAsyncPlayerChat(AsyncPlayerChatEvent event) {
        UUID playerId = event.getPlayer().getUniqueId();
        SearchPrompt prompt = (SearchPrompt)this.pendingSearchInputs.get(playerId);
        if (prompt == null) {
            return;
        }
        event.setCancelled(true);
        this.pendingSearchInputs.remove(playerId);
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.handleSearchInput(event.getPlayer(), prompt, event.getMessage()));
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        UUID playerId = event.getPlayer().getUniqueId();
        this.pendingSearchInputs.remove(playerId);
        this.activeSearchQueries.remove(playerId);
        this.activeListingSorts.remove(playerId);
        this.activeOrderSorts.remove(playerId);
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        Inventory topInventory = event.getView().getTopInventory();
        InventoryHolder inventoryHolder = topInventory.getHolder();
        if (!(inventoryHolder instanceof AbstractAuctionHolder)) {
            return;
        }
        AbstractAuctionHolder holder = (AbstractAuctionHolder)inventoryHolder;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!holder.owner().equals(player.getUniqueId())) {
            return;
        }
        int topSize = topInventory.getSize();
        boolean affectsTop = event.getRawSlots().stream().anyMatch(slot -> slot < topSize);
        if (affectsTop) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        Inventory topInventory = event.getInventory();
        InventoryHolder inventoryHolder = topInventory.getHolder();
        if (!(inventoryHolder instanceof PreviewMenuHolder)) {
            return;
        }
        PreviewMenuHolder holder = (PreviewMenuHolder)inventoryHolder;
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!holder.owner().equals(player.getUniqueId())) {
            return;
        }
        if (!player.isOnline()) {
            return;
        }
        this.runSync(() -> this.reopenPreviewOrigin(player, holder));
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Inventory topInventory = event.getView().getTopInventory();
        InventoryHolder inventoryHolder = topInventory.getHolder();
        if (!(inventoryHolder instanceof AbstractAuctionHolder)) {
            return;
        }
        AbstractAuctionHolder holder = (AbstractAuctionHolder)inventoryHolder;
        event.setCancelled(true);
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!holder.owner().equals(player.getUniqueId())) {
            return;
        }
        if (event.getClickedInventory() == null || event.getClickedInventory().getHolder() != holder) {
            return;
        }
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        String action = this.itemTagStorage.getString(clicked, this.actionKey);
        if (holder instanceof BrowserMenuHolder) {
            BrowserMenuHolder browserHolder = (BrowserMenuHolder)holder;
            this.handleBrowserClick(player, browserHolder, action, clicked, event);
        } else if (holder instanceof ConfirmMenuHolder) {
            ConfirmMenuHolder confirmHolder = (ConfirmMenuHolder)holder;
            if (ACTION_LISTING.equalsIgnoreCase(action) || ACTION_ORDER.equalsIgnoreCase(action)) {
                this.handlePreviewClick(player, confirmHolder, action, clicked, event);
            } else {
                this.handleConfirmClick(player, confirmHolder, action, clicked);
            }
        }
    }

    private void handleBrowserClick(Player player, BrowserMenuHolder holder, String action, ItemStack clicked, InventoryClickEvent event) {
        if (ACTION_PREVIOUS.equalsIgnoreCase(action)) {
            this.runSync(() -> this.openBrowser(player, holder.view(), holder.page() - 1));
            return;
        }
        if (ACTION_NEXT.equalsIgnoreCase(action)) {
            this.runSync(() -> this.openBrowser(player, holder.view(), holder.page() + 1));
            return;
        }
        if (action == null) {
            return;
        }
        if (ACTION_CLOSE.equalsIgnoreCase(action)) {
            player.closeInventory();
            return;
        }
        if (ACTION_TOGGLE_LISTINGS.equalsIgnoreCase(action)) {
            this.runSync(() -> this.openBrowser(player, BrowserView.LISTINGS, 0));
            return;
        }
        if (ACTION_TOGGLE_ORDERS.equalsIgnoreCase(action)) {
            this.runSync(() -> this.openBrowser(player, BrowserView.ORDERS, 0));
            return;
        }
        if (ACTION_SEARCH.equalsIgnoreCase(action)) {
            this.handleSearchClick(player, holder, event);
            return;
        }
        if (ACTION_SORT.equalsIgnoreCase(action)) {
            this.handleSortClick(player, holder, event);
            return;
        }
        if (!ACTION_LISTING.equalsIgnoreCase(action)) {
            if (!ACTION_ORDER.equalsIgnoreCase(action)) {
                return;
            }
            this.handleOrderSelection(player, holder, clicked, event);
            return;
        }
        String listingId = this.itemTagStorage.getString(clicked, this.listingKey);
        if (listingId == null) {
            this.sendMessage(player, this.messages.listingNotFound());
            this.runSync(() -> this.openBrowser(player, holder.view(), holder.page()));
            return;
        }
        AuctionListing listing = this.findListing(listingId);
        if (listing == null) {
            this.sendMessage(player, this.messages.listingUnavailable());
            this.runSync(() -> this.openBrowser(player, holder.view(), holder.page()));
            return;
        }
        if (event.isShiftClick() && event.isLeftClick() && this.tryOpenShulkerPreview(player, listing.item(), holder.view(), holder.page(), null, null)) {
            return;
        }
        if (event.isRightClick()) {
            if (!player.hasPermission("ezauction.auction.sell")) {
                this.sendMessage(player, this.messages.cancelListingNoPermission());
                return;
            }
            AuctionOperationResult result = this.auctionManager.cancelListing(player.getUniqueId(), listingId);
            if (result.message() != null && !result.message().isEmpty()) {
                player.sendMessage(result.message());
            }
            this.runSync(() -> this.openBrowser(player, holder.view(), holder.page()));
            return;
        }
        if (!player.hasPermission("ezauction.auction.buy")) {
            this.sendMessage(player, this.messages.buyNoPermission());
            return;
        }
        if (listing.sellerId().equals(player.getUniqueId())) {
            this.sendMessage(player, this.messages.ownListingPurchase());
            return;
        }
        this.runSync(() -> this.openListingConfirmMenu(player, holder, listingId));
    }

    private void handleConfirmClick(Player player, ConfirmMenuHolder holder, String action, ItemStack clicked) {
        if (ACTION_CANCEL.equalsIgnoreCase(action)) {
            this.runSync(() -> this.openBrowser(player, holder.view(), holder.previousPage()));
            return;
        }
        if (!ACTION_CONFIRM.equalsIgnoreCase(action)) {
            return;
        }
        if (holder.action() == ConfirmAction.PURCHASE_LISTING) {
            this.handleListingConfirm(player, holder, clicked);
        } else if (holder.action() == ConfirmAction.FULFILL_ORDER) {
            this.handleOrderConfirm(player, holder, clicked);
        }
    }

    private void handlePreviewClick(Player player, ConfirmMenuHolder holder, String action, ItemStack clicked, InventoryClickEvent event) {
        if (!event.isShiftClick() || !event.isLeftClick()) {
            return;
        }
        String targetId = this.itemTagStorage.getString(clicked, this.listingKey);
        if (targetId == null) {
            return;
        }
        if (ACTION_LISTING.equalsIgnoreCase(action)) {
            AuctionListing listing = this.findListing(targetId);
            if (listing == null) {
                this.sendMessage(player, this.messages.listingUnavailable());
                this.runSync(() -> this.openBrowser(player, holder.view(), holder.previousPage()));
                return;
            }
            if (this.tryOpenShulkerPreview(player, listing.item(), holder.view(), holder.previousPage(), holder.action(), targetId)) {
                return;
            }
        } else if (ACTION_ORDER.equalsIgnoreCase(action)) {
            AuctionOrder order = this.findOrder(targetId);
            if (order == null) {
                this.sendMessage(player, this.messages.orderUnavailable());
                this.runSync(() -> this.openBrowser(player, holder.view(), holder.previousPage()));
                return;
            }
            if (this.tryOpenShulkerPreview(player, order.requestedItem(), holder.view(), holder.previousPage(), holder.action(), targetId)) {
                return;
            }
        }
    }

    private void handleSearchClick(Player player, BrowserMenuHolder holder, InventoryClickEvent event) {
        UUID playerId = player.getUniqueId();
        if (event.isRightClick()) {
            if (this.activeSearchQueries.remove(playerId) != null) {
                this.sendMessage(player, this.messages.searchCleared());
            } else {
                this.sendMessage(player, this.messages.searchAlreadyClear());
            }
            this.runSync(() -> this.openBrowser(player, holder.view(), 0));
            return;
        }
        this.pendingSearchInputs.put(playerId, new SearchPrompt(holder.view(), holder.page()));
        player.closeInventory();
        this.sendMessage(player, this.messages.searchPrompt());
        this.sendMessage(player, this.messages.searchClearPrompt());
    }

    private void handleSortClick(Player player, BrowserMenuHolder holder, InventoryClickEvent event) {
        UUID playerId = player.getUniqueId();
        boolean backwards = event.isRightClick();
        if (holder.view() == BrowserView.LISTINGS) {
            ListingSort current = this.getListingSort(playerId);
            ListingSort updated = backwards ? current.previous() : current.next();
            this.activeListingSorts.put(playerId, updated);
            this.sendMessage(player, this.messages.sortListings().replace("{sort}", updated.label()));
        } else {
            OrderSort current = this.getOrderSort(playerId);
            OrderSort updated = backwards ? current.previous() : current.next();
            this.activeOrderSorts.put(playerId, updated);
            this.sendMessage(player, this.messages.sortOrders().replace("{sort}", updated.label()));
        }
        this.runSync(() -> this.openBrowser(player, holder.view(), holder.page()));
    }

    private boolean tryOpenShulkerPreview(Player player, ItemStack item, BrowserView view, int page, ConfirmAction confirmAction, String targetId) {
        if (player == null || item == null || item.getType() == Material.AIR) {
            return false;
        }
        if (!this.isShulkerBox(item)) {
            return false;
        }
        ItemStack source = item.clone();
        this.runSync(() -> this.openShulkerPreview(player, source, view, page, confirmAction, targetId));
        return true;
    }

    private void openShulkerPreview(Player player, ItemStack shulker, BrowserView view, int page, ConfirmAction confirmAction, String targetId) {
        if (player == null || shulker == null) {
            return;
        }
        ItemStack[] contents = this.readShulkerContents(shulker);
        int size = contents.length > 0 ? contents.length : 27;
        int normalizedSize = Math.max(9, Math.min(54, (size + 8) / 9 * 9));
        PreviewMenuHolder holder = new PreviewMenuHolder(player.getUniqueId(), view, page, confirmAction, targetId);
        Object title = this.colorize(this.messages.shulkerPreviewTitle());
        if (title == null || ((String)title).isEmpty()) {
            title = String.valueOf(ChatColor.DARK_PURPLE) + "Shulker Contents";
        }
        Inventory preview = Bukkit.createInventory((InventoryHolder)holder, (int)normalizedSize, (String)title);
        holder.setInventory(preview);
        if (contents != null) {
            for (int i = 0; i < Math.min(contents.length, preview.getSize()); ++i) {
                ItemStack content = contents[i];
                if (content == null || content.getType() == Material.AIR || content.getAmount() <= 0) continue;
                preview.setItem(i, content);
            }
        }
        player.openInventory(preview);
    }

    private ItemStack[] readShulkerContents(ItemStack shulker) {
        if (shulker == null) {
            return new ItemStack[0];
        }
        ItemMeta meta = shulker.getItemMeta();
        if (meta == null) {
            return new ItemStack[0];
        }
        try {
            Class<?> blockStateMetaClass = Class.forName("org.bukkit.inventory.meta.BlockStateMeta");
            if (!blockStateMetaClass.isInstance(meta)) {
                return new ItemStack[0];
            }
            Method hasBlockState = blockStateMetaClass.getMethod("hasBlockState", new Class[0]);
            if (!Boolean.TRUE.equals(hasBlockState.invoke((Object)meta, new Object[0]))) {
                return new ItemStack[0];
            }
            Method getBlockState = blockStateMetaClass.getMethod("getBlockState", new Class[0]);
            Object blockState = getBlockState.invoke((Object)meta, new Object[0]);
            if (blockState == null) {
                return new ItemStack[0];
            }
            Class<?> shulkerClass = Class.forName("org.bukkit.block.ShulkerBox");
            if (!shulkerClass.isInstance(blockState)) {
                return new ItemStack[0];
            }
            Method getInventory = shulkerClass.getMethod("getInventory", new Class[0]);
            Object inventory = getInventory.invoke(blockState, new Object[0]);
            if (!(inventory instanceof Inventory)) {
                return new ItemStack[0];
            }
            Inventory snapshot = (Inventory)inventory;
            int size = snapshot.getSize();
            ItemStack[] contents = new ItemStack[size];
            ItemStack[] original = snapshot.getContents();
            for (int i = 0; i < size; ++i) {
                ItemStack content = original != null && i < original.length ? original[i] : null;
                contents[i] = content == null || content.getType() == Material.AIR || content.getAmount() <= 0 ? null : content.clone();
            }
            return contents;
        }
        catch (ReflectiveOperationException ex) {
            return new ItemStack[0];
        }
    }

    private void reopenPreviewOrigin(Player player, PreviewMenuHolder holder) {
        if (player == null || holder == null) {
            return;
        }
        if (holder.confirmAction() == null || holder.targetId() == null) {
            this.openBrowser(player, holder.originView(), holder.originPage());
            return;
        }
        BrowserMenuHolder previousHolder = new BrowserMenuHolder(player.getUniqueId(), holder.originPage(), holder.originView());
        if (holder.confirmAction() == ConfirmAction.PURCHASE_LISTING) {
            this.openListingConfirmMenu(player, previousHolder, holder.targetId());
        } else if (holder.confirmAction() == ConfirmAction.FULFILL_ORDER) {
            this.openOrderConfirmMenu(player, previousHolder, holder.targetId());
        } else {
            this.openBrowser(player, holder.originView(), holder.originPage());
        }
    }

    private ListingSort getListingSort(UUID playerId) {
        return this.activeListingSorts.computeIfAbsent(playerId, id -> ListingSort.ENDING_SOON);
    }

    private OrderSort getOrderSort(UUID playerId) {
        return this.activeOrderSorts.computeIfAbsent(playerId, id -> OrderSort.ENDING_SOON);
    }

    private void handleOrderSelection(Player player, BrowserMenuHolder holder, ItemStack clicked, InventoryClickEvent event) {
        String orderId = this.itemTagStorage.getString(clicked, this.listingKey);
        if (orderId == null) {
            this.sendMessage(player, this.messages.orderNotFound());
            this.runSync(() -> this.openBrowser(player, holder.view(), holder.page()));
            return;
        }
        AuctionOrder order = this.findOrder(orderId);
        if (order == null) {
            this.sendMessage(player, this.messages.orderUnavailable());
            this.runSync(() -> this.openBrowser(player, holder.view(), holder.page()));
            return;
        }
        if (event.isShiftClick() && event.isLeftClick() && this.tryOpenShulkerPreview(player, order.requestedItem(), holder.view(), holder.page(), null, null)) {
            return;
        }
        if (event.isRightClick()) {
            if (!order.buyerId().equals(player.getUniqueId())) {
                return;
            }
            AuctionOperationResult result = this.auctionManager.cancelOrder(player.getUniqueId(), orderId);
            if (result.message() != null && !result.message().isEmpty()) {
                player.sendMessage(result.message());
            }
            this.runSync(() -> this.openBrowser(player, holder.view(), holder.page()));
            return;
        }
        if (!player.hasPermission("ezauction.auction.fulfill")) {
            this.sendMessage(player, this.messages.fulfillNoPermission());
            return;
        }
        if (order.buyerId().equals(player.getUniqueId())) {
            this.sendMessage(player, this.messages.fulfillOwnOrder());
            return;
        }
        if (!player.getInventory().containsAtLeast(order.requestedItem(), order.requestedItem().getAmount())) {
            this.sendMessage(player, this.messages.fulfillInsufficientItems());
            return;
        }
        this.runSync(() -> this.openOrderConfirmMenu(player, holder, orderId));
    }

    private void handleListingConfirm(Player player, ConfirmMenuHolder holder, ItemStack clicked) {
        if (!player.hasPermission("ezauction.auction.buy")) {
            this.sendMessage(player, this.messages.buyNoPermission());
            this.runSync(() -> this.openBrowser(player, holder.view(), holder.previousPage()));
            return;
        }
        String listingId = this.itemTagStorage.getString(clicked, this.listingKey);
        if (listingId == null) {
            this.sendMessage(player, this.messages.listingNotFound());
            this.runSync(() -> this.openBrowser(player, holder.view(), holder.previousPage()));
            return;
        }
        AuctionOperationResult result = this.auctionManager.purchaseListing(player, listingId);
        if (result.message() != null && !result.message().isEmpty()) {
            player.sendMessage(result.message());
        }
        this.runSync(() -> this.openBrowser(player, holder.view(), holder.previousPage()));
    }

    private void handleOrderConfirm(Player player, ConfirmMenuHolder holder, ItemStack clicked) {
        if (!player.hasPermission("ezauction.auction.fulfill")) {
            this.sendMessage(player, this.messages.fulfillNoPermission());
            this.runSync(() -> this.openBrowser(player, holder.view(), holder.previousPage()));
            return;
        }
        String orderId = this.itemTagStorage.getString(clicked, this.listingKey);
        if (orderId == null) {
            this.sendMessage(player, this.messages.orderNotFound());
            this.runSync(() -> this.openBrowser(player, holder.view(), holder.previousPage()));
            return;
        }
        AuctionOrder order = this.findOrder(orderId);
        if (order == null) {
            this.sendMessage(player, this.messages.orderUnavailable());
            this.runSync(() -> this.openBrowser(player, holder.view(), holder.previousPage()));
            return;
        }
        if (!player.getInventory().containsAtLeast(order.requestedItem(), order.requestedItem().getAmount())) {
            this.sendMessage(player, this.messages.fulfillInsufficientItems());
            this.runSync(() -> this.openBrowser(player, holder.view(), holder.previousPage()));
            return;
        }
        AuctionOperationResult result = this.auctionManager.fulfillOrder(player, orderId);
        if (result.message() != null && !result.message().isEmpty()) {
            player.sendMessage(result.message());
        }
        this.runSync(() -> this.openBrowser(player, holder.view(), holder.previousPage()));
    }

    private void handleSearchInput(Player player, SearchPrompt prompt, String message) {
        String input;
        if (player == null || prompt == null) {
            return;
        }
        UUID playerId = player.getUniqueId();
        String string = input = message != null ? message.trim() : "";
        if (input.equalsIgnoreCase(ACTION_CANCEL)) {
            this.sendMessage(player, this.messages.searchCancelled());
            this.openBrowser(player, prompt.view(), prompt.page());
            return;
        }
        if (input.equalsIgnoreCase("clear") || input.isEmpty()) {
            boolean removed;
            boolean bl = removed = this.activeSearchQueries.remove(playerId) != null;
            if (removed) {
                this.sendMessage(player, this.messages.searchCleared());
            } else {
                this.sendMessage(player, this.messages.searchAlreadyClear());
            }
            this.openBrowser(player, prompt.view(), 0);
            return;
        }
        String sanitized = this.sanitizeSearchInput(input);
        if (sanitized == null) {
            this.sendMessage(player, this.messages.searchInvalid());
            this.openBrowser(player, prompt.view(), prompt.page());
            return;
        }
        this.activeSearchQueries.put(playerId, sanitized);
        this.sendMessage(player, this.messages.searchApplied().replace("{query}", sanitized));
        this.openBrowser(player, prompt.view(), 0);
    }

    private String sanitizeSearchInput(String input) {
        String trimmed;
        if (input == null) {
            return null;
        }
        String stripped = ChatColor.stripColor((String)input);
        if (stripped == null) {
            stripped = input;
        }
        if ((trimmed = stripped.trim()).isEmpty()) {
            return null;
        }
        if (trimmed.length() > 48) {
            trimmed = trimmed.substring(0, 48);
        }
        return trimmed;
    }

    private String getSearchQuery(UUID playerId) {
        String query = (String)this.activeSearchQueries.get(playerId);
        if (query == null) {
            return null;
        }
        String trimmed = query.trim();
        if (trimmed.isEmpty()) {
            this.activeSearchQueries.remove(playerId);
            return null;
        }
        return trimmed;
    }

    private void filterListings(List<AuctionListing> listings, String normalizedQuery) {
        if (listings == null || listings.isEmpty() || normalizedQuery == null || normalizedQuery.isEmpty()) {
            return;
        }
        listings.removeIf(listing -> listing == null || !this.itemMatchesQuery(listing.item(), normalizedQuery));
    }

    private void filterOrders(List<AuctionOrder> orders, String normalizedQuery) {
        if (orders == null || orders.isEmpty() || normalizedQuery == null || normalizedQuery.isEmpty()) {
            return;
        }
        orders.removeIf(order -> order == null || !this.itemMatchesQuery(order.requestedItem(), normalizedQuery));
    }

    private boolean itemMatchesQuery(ItemStack item, String normalizedQuery) {
        if (item == null || item.getType() == Material.AIR || normalizedQuery == null || normalizedQuery.isEmpty()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            String displayName;
            String string = displayName = meta.hasDisplayName() ? AuctionMenu.normalizeText(meta.getDisplayName()) : null;
            if (displayName != null && displayName.contains(normalizedQuery)) {
                return true;
            }
            String localized = AuctionMenu.normalizeText(AuctionMenu.resolveLocalizedName(meta));
            if (localized != null && localized.contains(normalizedQuery)) {
                return true;
            }
            if (this.enchantmentsMatch(meta, normalizedQuery)) {
                return true;
            }
        }
        if (!item.getEnchantments().isEmpty() && this.enchantmentMatches(item.getEnchantments(), normalizedQuery)) {
            return true;
        }
        String materialName = AuctionMenu.normalizeMaterialName(item.getType());
        return materialName.contains(normalizedQuery);
    }

    private boolean enchantmentsMatch(ItemMeta meta, String normalizedQuery) {
        EnchantmentStorageMeta storage;
        if (meta == null || normalizedQuery == null || normalizedQuery.isEmpty()) {
            return false;
        }
        if (meta.hasEnchants() && this.enchantmentMatches(meta.getEnchants(), normalizedQuery)) {
            return true;
        }
        return meta instanceof EnchantmentStorageMeta && (storage = (EnchantmentStorageMeta)meta).hasStoredEnchants() && this.enchantmentMatches(storage.getStoredEnchants(), normalizedQuery);
    }

    private boolean enchantmentMatches(Map<Enchantment, Integer> enchantments, String normalizedQuery) {
        if (enchantments == null || enchantments.isEmpty() || normalizedQuery == null || normalizedQuery.isEmpty()) {
            return false;
        }
        for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
            if (!this.enchantmentMatches(entry.getKey(), entry.getValue(), normalizedQuery)) continue;
            return true;
        }
        return false;
    }

    private boolean enchantmentMatches(Enchantment enchantment, int level, String normalizedQuery) {
        if (enchantment == null || normalizedQuery == null || normalizedQuery.isEmpty()) {
            return false;
        }
        String keyName = this.resolveEnchantmentKey(enchantment);
        if (this.matchesEnchantmentNameVariant(keyName, level, normalizedQuery)) {
            return true;
        }
        return this.matchesEnchantmentNameVariant(keyName != null ? keyName.replace('_', ' ') : null, level, normalizedQuery);
    }

    private String resolveEnchantmentKey(Enchantment enchantment) {
        if (enchantment == null) {
            return null;
        }
        try {
            Method getKey = Enchantment.class.getMethod("getKey", new Class[0]);
            Object key = getKey.invoke((Object)enchantment, new Object[0]);
            return key != null ? key.toString() : null;
        }
        catch (NoSuchMethodException getKey) {
        }
        catch (Exception ex) {
            return null;
        }
        try {
            Method getName = Enchantment.class.getMethod("getName", new Class[0]);
            Object name = getName.invoke((Object)enchantment, new Object[0]);
            return name != null ? name.toString() : null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static String resolveLocalizedName(ItemMeta meta) {
        if (meta == null) {
            return null;
        }
        try {
            Method hasLocalizedName = meta.getClass().getMethod("hasLocalizedName", new Class[0]);
            Object has = hasLocalizedName.invoke((Object)meta, new Object[0]);
            if (!(has instanceof Boolean) || !((Boolean)has).booleanValue()) {
                return null;
            }
            Method getLocalizedName = meta.getClass().getMethod("getLocalizedName", new Class[0]);
            Object name = getLocalizedName.invoke((Object)meta, new Object[0]);
            return name != null ? name.toString() : null;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private boolean matchesEnchantmentNameVariant(String name, int level, String normalizedQuery) {
        if (name == null || normalizedQuery == null || normalizedQuery.isEmpty()) {
            return false;
        }
        String normalizedName = name.toLowerCase(Locale.ENGLISH).trim();
        if (normalizedName.isEmpty()) {
            return false;
        }
        if (normalizedName.contains(normalizedQuery)) {
            return true;
        }
        if (level > 0) {
            String romanTerm;
            String numeric = normalizedName + " " + level;
            if (numeric.contains(normalizedQuery)) {
                return true;
            }
            String roman = AuctionMenu.toRomanNumeral(level);
            if (!roman.isEmpty() && (romanTerm = normalizedName + " " + roman.toLowerCase(Locale.ENGLISH)).contains(normalizedQuery)) {
                return true;
            }
        }
        return false;
    }

    private static String toRomanNumeral(int number) {
        if (number <= 0) {
            return "";
        }
        int[] values = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
        String[] numerals = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
        int remaining = number;
        StringBuilder builder = new StringBuilder();
        for (int index = 0; index < values.length && remaining > 0; ++index) {
            while (remaining >= values[index]) {
                builder.append(numerals[index]);
                remaining -= values[index];
            }
        }
        return builder.toString();
    }

    private static String normalizeText(String value) {
        String trimmed;
        if (value == null) {
            return null;
        }
        String stripped = ChatColor.stripColor((String)value);
        if (stripped == null) {
            stripped = value;
        }
        if ((trimmed = stripped.trim()).isEmpty()) {
            return null;
        }
        return trimmed.toLowerCase(Locale.ENGLISH);
    }

    private static String normalizeMaterialName(Material material) {
        if (material == null) {
            return "";
        }
        return material.name().replace('_', ' ').toLowerCase(Locale.ENGLISH);
    }

    private static String listingItemSortKey(AuctionListing listing) {
        return listing == null ? "" : AuctionMenu.itemSortKey(listing.item());
    }

    private static String orderItemSortKey(AuctionOrder order) {
        return order == null ? "" : AuctionMenu.itemSortKey(order.requestedItem());
    }

    private static int listingQuantity(AuctionListing listing) {
        if (listing == null) {
            return 0;
        }
        ItemStack item = listing.item();
        return item != null ? item.getAmount() : 0;
    }

    private static int orderQuantity(AuctionOrder order) {
        if (order == null) {
            return 0;
        }
        ItemStack item = order.requestedItem();
        return item != null ? item.getAmount() : 0;
    }

    private static String itemSortKey(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return "";
        }
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            String normalized;
            String normalized2;
            if (meta.hasDisplayName() && (normalized2 = AuctionMenu.normalizeText(meta.getDisplayName())) != null) {
                return normalized2;
            }
            String localizedName = AuctionMenu.resolveLocalizedName(meta);
            if (localizedName != null && (normalized = AuctionMenu.normalizeText(localizedName)) != null) {
                return normalized;
            }
        }
        return AuctionMenu.normalizeMaterialName(item.getType());
    }

    private String formatSearchQueryForLore(String query) {
        if (query == null) {
            return "";
        }
        if (query.length() <= 32) {
            return query;
        }
        return query.substring(0, 29) + "...";
    }

    private ItemStack createSearchButton(BrowserView view, String activeQuery) {
        String target;
        AuctionMenuConfiguration.MenuButtonConfiguration configuration = this.searchButtonConfig != null ? this.searchButtonConfig.button() : null;
        Material material = configuration != null ? configuration.material() : Material.COMPASS;
        String displayName = configuration != null ? configuration.displayName() : "&bSearch";
        ArrayList<String> lore = new ArrayList<String>();
        if (configuration != null && configuration.lore() != null) {
            lore.addAll(configuration.lore());
        }
        String string = target = view == BrowserView.ORDERS ? "orders" : "listings";
        if (activeQuery != null && !activeQuery.isEmpty()) {
            if (!lore.isEmpty()) {
                lore.add(" ");
            }
            lore.add(String.valueOf(ChatColor.GRAY) + "Searching: " + String.valueOf(ChatColor.AQUA) + this.formatSearchQueryForLore(activeQuery));
            lore.add(String.valueOf(ChatColor.YELLOW) + "Left-click to update search.");
            lore.add(String.valueOf(ChatColor.RED) + "Right-click to clear search.");
        } else {
            if (!lore.isEmpty()) {
                lore.add(" ");
            }
            lore.add(String.valueOf(ChatColor.YELLOW) + "Left-click to search " + target + ".");
        }
        return this.createButton(material, displayName, lore);
    }

    private ItemStack createSortButton(BrowserView view, ListingSort listingSort, OrderSort orderSort) {
        AuctionMenuConfiguration.MenuButtonConfiguration buttonConfiguration = this.sortButtonConfig != null ? this.sortButtonConfig.button() : null;
        ArrayList<String> lore = new ArrayList<String>();
        String label = view == BrowserView.ORDERS ? orderSort.label() : listingSort.label();
        lore.add("&7Current: &e" + label);
        lore.add(" ");
        lore.add("&7Sort Options:");
        if (view == BrowserView.ORDERS) {
            for (Enum enum_ : OrderSort.values()) {
                current = enum_ == orderSort;
                String color = current ? "&a" : "&7";
                String prefix = current ? "&a\u27a4 " : "&7\u2022 ";
                lore.add(prefix + color + ((OrderSort)enum_).label());
            }
        } else {
            for (Enum enum_ : ListingSort.values()) {
                current = enum_ == listingSort;
                String color = current ? "&a" : "&7";
                String prefix = current ? "&a\u27a4 " : "&7\u2022 ";
                lore.add(prefix + color + ((ListingSort)enum_).label());
            }
        }
        lore.add(" ");
        lore.add("&aLeft-click to cycle forward.");
        lore.add("&cRight-click to cycle backward.");
        ItemStack button = this.createConfiguredButton(buttonConfiguration, lore);
        ItemMeta meta = button.getItemMeta();
        if (meta != null) {
            String baseName = buttonConfiguration != null && buttonConfiguration.displayName() != null ? buttonConfiguration.displayName() : "&bSort";
            String string = "&e" + label + "&7";
            Object displayName = baseName.contains("{sort}") ? baseName.replace("{sort}", string) : baseName + " &7(" + string + ")";
            meta.setDisplayName(this.colorize((String)displayName));
            button.setItemMeta(meta);
        }
        return button;
    }

    private ItemStack createToggleButton(boolean active, AuctionMenuConfiguration.ToggleButtonConfiguration configuration, String activeStatusLine, String inactiveStatusLine) {
        ItemMeta meta;
        AuctionMenuConfiguration.MenuButtonConfiguration buttonConfiguration = configuration != null ? configuration.button() : null;
        Material material = buttonConfiguration != null ? buttonConfiguration.material() : Material.STONE_BUTTON;
        String displayName = buttonConfiguration != null ? buttonConfiguration.displayName() : "&aToggle";
        List<Object> baseLore = buttonConfiguration != null ? buttonConfiguration.lore() : List.of();
        ArrayList<String> lore = new ArrayList<String>(baseLore);
        if (active) {
            if (activeStatusLine != null && !activeStatusLine.isEmpty()) {
                lore.add(activeStatusLine);
            }
        } else if (inactiveStatusLine != null && !inactiveStatusLine.isEmpty()) {
            lore.add(inactiveStatusLine);
        }
        ItemStack button = this.createButton(material, displayName, lore);
        if (!active && (meta = button.getItemMeta()) != null) {
            String coloredName = this.colorize(displayName);
            meta.setDisplayName(String.valueOf(ChatColor.GRAY) + ChatColor.stripColor((String)coloredName));
            button.setItemMeta(meta);
        }
        return button;
    }

    private static enum BrowserView {
        LISTINGS,
        ORDERS;

    }

    private static enum ListingSort {
        ENDING_SOON("Ending Soon", Comparator.comparingLong(AuctionListing::expiryEpochMillis).thenComparingDouble(AuctionListing::price).thenComparing(AuctionMenu::listingItemSortKey, String.CASE_INSENSITIVE_ORDER).thenComparing(AuctionListing::id, String.CASE_INSENSITIVE_ORDER)),
        NEWLY_LISTED("Newly Listed", Comparator.comparingLong(AuctionListing::expiryEpochMillis).reversed().thenComparing(AuctionMenu::listingItemSortKey, String.CASE_INSENSITIVE_ORDER).thenComparingDouble(AuctionListing::price).thenComparing(AuctionListing::id, String.CASE_INSENSITIVE_ORDER)),
        PRICE_LOW_HIGH("Lowest Price", Comparator.comparingDouble(AuctionListing::price).thenComparing(AuctionMenu::listingItemSortKey, String.CASE_INSENSITIVE_ORDER).thenComparingLong(AuctionListing::expiryEpochMillis).thenComparing(AuctionListing::id, String.CASE_INSENSITIVE_ORDER)),
        PRICE_HIGH_LOW("Highest Price", Comparator.comparingDouble(AuctionListing::price).reversed().thenComparing(AuctionMenu::listingItemSortKey, String.CASE_INSENSITIVE_ORDER).thenComparingLong(AuctionListing::expiryEpochMillis).thenComparing(AuctionListing::id, String.CASE_INSENSITIVE_ORDER)),
        QUANTITY_HIGH_LOW("Quantity (High-Low)", Comparator.comparingInt(AuctionMenu::listingQuantity).reversed().thenComparing(AuctionMenu::listingItemSortKey, String.CASE_INSENSITIVE_ORDER).thenComparingDouble(AuctionListing::price).thenComparing(AuctionListing::id, String.CASE_INSENSITIVE_ORDER)),
        QUANTITY_LOW_HIGH("Quantity (Low-High)", Comparator.comparingInt(AuctionMenu::listingQuantity).thenComparing(AuctionMenu::listingItemSortKey, String.CASE_INSENSITIVE_ORDER).thenComparingDouble(AuctionListing::price).thenComparingLong(AuctionListing::expiryEpochMillis).thenComparing(AuctionListing::id, String.CASE_INSENSITIVE_ORDER)),
        ITEM_A_Z("Item Name (A-Z)", Comparator.comparing(AuctionMenu::listingItemSortKey, String.CASE_INSENSITIVE_ORDER).thenComparingDouble(AuctionListing::price).thenComparingLong(AuctionListing::expiryEpochMillis).thenComparing(AuctionListing::id, String.CASE_INSENSITIVE_ORDER)),
        ITEM_Z_A("Item Name (Z-A)", Comparator.comparing(AuctionMenu::listingItemSortKey, String.CASE_INSENSITIVE_ORDER).reversed().thenComparingDouble(AuctionListing::price).thenComparingLong(AuctionListing::expiryEpochMillis).thenComparing(AuctionListing::id, String.CASE_INSENSITIVE_ORDER));

        private static final ListingSort[] VALUES;
        private final String label;
        private final Comparator<AuctionListing> comparator;

        private ListingSort(String label, Comparator<AuctionListing> comparator) {
            this.label = label;
            this.comparator = comparator;
        }

        public String label() {
            return this.label;
        }

        public void sort(List<AuctionListing> listings) {
            if (listings == null || listings.size() <= 1) {
                return;
            }
            listings.sort(this.comparator);
        }

        public ListingSort next() {
            return VALUES[(this.ordinal() + 1) % VALUES.length];
        }

        public ListingSort previous() {
            return VALUES[(this.ordinal() + VALUES.length - 1) % VALUES.length];
        }

        static {
            VALUES = ListingSort.values();
        }
    }

    private static enum OrderSort {
        ENDING_SOON("Ending Soon", Comparator.comparingLong(AuctionOrder::expiryEpochMillis).thenComparingDouble(AuctionOrder::offeredPrice).thenComparing(AuctionMenu::orderItemSortKey, String.CASE_INSENSITIVE_ORDER).thenComparing(AuctionOrder::id, String.CASE_INSENSITIVE_ORDER)),
        NEWLY_POSTED("Newly Posted", Comparator.comparingLong(AuctionOrder::expiryEpochMillis).reversed().thenComparing(AuctionMenu::orderItemSortKey, String.CASE_INSENSITIVE_ORDER).thenComparingDouble(AuctionOrder::offeredPrice).thenComparing(AuctionOrder::id, String.CASE_INSENSITIVE_ORDER)),
        PRICE_HIGH_LOW("Highest Offer", Comparator.comparingDouble(AuctionOrder::offeredPrice).reversed().thenComparing(AuctionMenu::orderItemSortKey, String.CASE_INSENSITIVE_ORDER).thenComparingLong(AuctionOrder::expiryEpochMillis).thenComparing(AuctionOrder::id, String.CASE_INSENSITIVE_ORDER)),
        PRICE_LOW_HIGH("Lowest Offer", Comparator.comparingDouble(AuctionOrder::offeredPrice).thenComparing(AuctionMenu::orderItemSortKey, String.CASE_INSENSITIVE_ORDER).thenComparingLong(AuctionOrder::expiryEpochMillis).thenComparing(AuctionOrder::id, String.CASE_INSENSITIVE_ORDER)),
        QUANTITY_HIGH_LOW("Quantity (High-Low)", Comparator.comparingInt(AuctionMenu::orderQuantity).reversed().thenComparing(AuctionMenu::orderItemSortKey, String.CASE_INSENSITIVE_ORDER).thenComparingDouble(AuctionOrder::offeredPrice).thenComparing(AuctionOrder::id, String.CASE_INSENSITIVE_ORDER)),
        QUANTITY_LOW_HIGH("Quantity (Low-High)", Comparator.comparingInt(AuctionMenu::orderQuantity).thenComparing(AuctionMenu::orderItemSortKey, String.CASE_INSENSITIVE_ORDER).thenComparingDouble(AuctionOrder::offeredPrice).thenComparingLong(AuctionOrder::expiryEpochMillis).thenComparing(AuctionOrder::id, String.CASE_INSENSITIVE_ORDER)),
        ITEM_A_Z("Item Name (A-Z)", Comparator.comparing(AuctionMenu::orderItemSortKey, String.CASE_INSENSITIVE_ORDER).thenComparingDouble(AuctionOrder::offeredPrice).thenComparingLong(AuctionOrder::expiryEpochMillis).thenComparing(AuctionOrder::id, String.CASE_INSENSITIVE_ORDER)),
        ITEM_Z_A("Item Name (Z-A)", Comparator.comparing(AuctionMenu::orderItemSortKey, String.CASE_INSENSITIVE_ORDER).reversed().thenComparingDouble(AuctionOrder::offeredPrice).thenComparingLong(AuctionOrder::expiryEpochMillis).thenComparing(AuctionOrder::id, String.CASE_INSENSITIVE_ORDER));

        private static final OrderSort[] VALUES;
        private final String label;
        private final Comparator<AuctionOrder> comparator;

        private OrderSort(String label, Comparator<AuctionOrder> comparator) {
            this.label = label;
            this.comparator = comparator;
        }

        public String label() {
            return this.label;
        }

        public void sort(List<AuctionOrder> orders) {
            if (orders == null || orders.size() <= 1) {
                return;
            }
            orders.sort(this.comparator);
        }

        public OrderSort next() {
            return VALUES[(this.ordinal() + 1) % VALUES.length];
        }

        public OrderSort previous() {
            return VALUES[(this.ordinal() + VALUES.length - 1) % VALUES.length];
        }

        static {
            VALUES = OrderSort.values();
        }
    }

    private static final class BrowserMenuHolder
    extends AbstractAuctionHolder {
        private final int page;
        private final BrowserView view;

        private BrowserMenuHolder(UUID owner, int page, BrowserView view) {
            super(owner);
            this.page = page;
            this.view = view;
        }

        public int page() {
            return this.page;
        }

        public BrowserView view() {
            return this.view;
        }
    }

    private static final class ConfirmMenuHolder
    extends AbstractAuctionHolder {
        private final int previousPage;
        private final BrowserView view;
        private final ConfirmAction action;

        private ConfirmMenuHolder(UUID owner, int previousPage, BrowserView view, ConfirmAction action) {
            super(owner);
            this.previousPage = previousPage;
            this.view = view;
            this.action = action;
        }

        public int previousPage() {
            return this.previousPage;
        }

        public BrowserView view() {
            return this.view;
        }

        public ConfirmAction action() {
            return this.action;
        }
    }

    private static enum ConfirmAction {
        PURCHASE_LISTING,
        FULFILL_ORDER;

    }

    private static final class SearchPrompt {
        private final BrowserView view;
        private final int page;

        private SearchPrompt(BrowserView view, int page) {
            this.view = view;
            this.page = page;
        }

        public BrowserView view() {
            return this.view;
        }

        public int page() {
            return this.page;
        }
    }

    private static abstract class AbstractAuctionHolder
    implements InventoryHolder {
        private final UUID owner;
        private Inventory inventory;

        protected AbstractAuctionHolder(UUID owner) {
            this.owner = owner;
        }

        public UUID owner() {
            return this.owner;
        }

        public void setInventory(Inventory inventory) {
            this.inventory = inventory;
        }

        public Inventory getInventory() {
            return this.inventory;
        }
    }

    private static final class PreviewMenuHolder
    extends AbstractAuctionHolder {
        private final BrowserView originView;
        private final int originPage;
        private final ConfirmAction confirmAction;
        private final String targetId;

        private PreviewMenuHolder(UUID owner, BrowserView originView, int originPage, ConfirmAction confirmAction, String targetId) {
            super(owner);
            this.originView = originView;
            this.originPage = originPage;
            this.confirmAction = confirmAction;
            this.targetId = targetId;
        }

        public BrowserView originView() {
            return this.originView;
        }

        public int originPage() {
            return this.originPage;
        }

        public ConfirmAction confirmAction() {
            return this.confirmAction;
        }

        public String targetId() {
            return this.targetId;
        }
    }
}

