/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.config;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalDouble;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public final class AuctionValueConfiguration {
    private static final boolean DEFAULT_ENABLED = false;
    private static final String DEFAULT_FORMAT = "&7Value: &6{value}";
    private static final Mode DEFAULT_MODE = Mode.CONFIGURED;
    private static final ShopPriceConfiguration.EnabledState DEFAULT_SHOP_PRICE_STATE = ShopPriceConfiguration.EnabledState.AUTO;
    private static final String DEFAULT_SHOP_PRICE_FORMAT = "&7Shop Price: &6{value}";
    private static final Mode DEFAULT_SHOP_PRICE_MODE = Mode.EZSHOPS_BUY;
    private final boolean enabled;
    private final String format;
    private final Map<String, Double> materialValues;
    private final Mode mode;
    private final ShopPriceConfiguration shopPriceConfiguration;

    public AuctionValueConfiguration(boolean enabled, String format, Map<String, Double> materialValues, Mode mode, ShopPriceConfiguration shopPriceConfiguration) {
        this.enabled = enabled;
        this.format = format != null ? format : DEFAULT_FORMAT;
        this.materialValues = materialValues == null || materialValues.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<String, Double>(materialValues));
        this.mode = mode != null ? mode : DEFAULT_MODE;
        this.shopPriceConfiguration = shopPriceConfiguration != null ? shopPriceConfiguration : ShopPriceConfiguration.defaults();
    }

    public boolean enabled() {
        return this.enabled;
    }

    public String format() {
        return this.format;
    }

    public Map<String, Double> materialValues() {
        return this.materialValues;
    }

    public Mode mode() {
        return this.mode;
    }

    public ShopPriceConfiguration shopPriceConfiguration() {
        return this.shopPriceConfiguration;
    }

    public OptionalDouble estimate(ItemStack item) {
        if (!this.enabled || item == null || this.mode != Mode.CONFIGURED) {
            return OptionalDouble.empty();
        }
        Material type = item.getType();
        if (type == null || type == Material.AIR) {
            return OptionalDouble.empty();
        }
        Double value = null;
        String materialKey = AuctionValueConfiguration.resolveMaterialKey(type);
        if (materialKey != null) {
            value = this.materialValues.get(AuctionValueConfiguration.normalizeKey(materialKey));
        }
        if (value == null) {
            value = this.materialValues.get(AuctionValueConfiguration.normalizeKey(type.name()));
        }
        if (value == null) {
            return OptionalDouble.empty();
        }
        double normalized = value;
        if (Double.isNaN(normalized) || Double.isInfinite(normalized)) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(Math.max(0.0, normalized));
    }

    public static AuctionValueConfiguration defaults() {
        return new AuctionValueConfiguration(false, DEFAULT_FORMAT, Collections.emptyMap(), DEFAULT_MODE, ShopPriceConfiguration.defaults());
    }

    public static AuctionValueConfiguration from(ConfigurationSection section) {
        if (section == null) {
            return AuctionValueConfiguration.defaults();
        }
        boolean enabled = section.getBoolean("enabled", false);
        String format = section.getString("format", DEFAULT_FORMAT);
        HashMap<String, Double> values = new HashMap<String, Double>();
        ConfigurationSection materials = section.getConfigurationSection("materials");
        if (materials != null) {
            for (String key : materials.getKeys(false)) {
                double raw;
                if (key == null || key.trim().isEmpty() || Double.isNaN(raw = materials.getDouble(key)) || Double.isInfinite(raw)) continue;
                values.put(AuctionValueConfiguration.normalizeKey(key), raw);
            }
        }
        Mode mode = AuctionValueConfiguration.parseMode(section.getString("mode"));
        ShopPriceConfiguration shopPriceConfiguration = ShopPriceConfiguration.from(section.getConfigurationSection("shop-price"));
        return new AuctionValueConfiguration(enabled, format, values, mode, shopPriceConfiguration);
    }

    public String toString() {
        return "AuctionValueConfiguration{enabled=" + this.enabled + ", format='" + this.format + "', materialValues=" + String.valueOf(this.materialValues) + ", mode=" + String.valueOf((Object)this.mode) + ", shopPriceConfiguration=" + String.valueOf(this.shopPriceConfiguration) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuctionValueConfiguration)) {
            return false;
        }
        AuctionValueConfiguration that = (AuctionValueConfiguration)o;
        return this.enabled == that.enabled && Objects.equals(this.format, that.format) && Objects.equals(this.materialValues, that.materialValues) && this.mode == that.mode && Objects.equals(this.shopPriceConfiguration, that.shopPriceConfiguration);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.enabled, this.format, this.materialValues, this.mode, this.shopPriceConfiguration});
    }

    private static String normalizeKey(String key) {
        return key == null ? null : key.trim().toLowerCase(Locale.ENGLISH);
    }

    private static String resolveMaterialKey(Material material) {
        if (material == null) {
            return null;
        }
        try {
            Method getKey = Material.class.getMethod("getKey", new Class[0]);
            Object key = getKey.invoke((Object)material, new Object[0]);
            return key != null ? key.toString() : null;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static Mode parseMode(String value) {
        String normalized;
        if (value == null || value.trim().isEmpty()) {
            return DEFAULT_MODE;
        }
        switch (normalized = value.trim().toUpperCase(Locale.ENGLISH).replace('-', '_').replace(' ', '_')) {
            case "EZSHOPS_BUY": 
            case "SHOP_BUY": 
            case "EZSHOPSBUY": {
                return Mode.EZSHOPS_BUY;
            }
            case "EZSHOPS_SELL": 
            case "SHOP_SELL": 
            case "EZSHOPSSELL": {
                return Mode.EZSHOPS_SELL;
            }
        }
        return DEFAULT_MODE;
    }

    private static Mode parseShopPriceMode(String value) {
        Mode parsed = AuctionValueConfiguration.parseMode(value);
        if (parsed == Mode.CONFIGURED) {
            return DEFAULT_SHOP_PRICE_MODE;
        }
        return parsed;
    }

    public static enum Mode {
        CONFIGURED,
        EZSHOPS_BUY,
        EZSHOPS_SELL;

    }

    public static final class ShopPriceConfiguration {
        private final EnabledState enabledState;
        private final String format;
        private final Mode mode;

        private ShopPriceConfiguration(EnabledState enabledState, String format, Mode mode) {
            this.enabledState = enabledState != null ? enabledState : DEFAULT_SHOP_PRICE_STATE;
            this.format = format != null ? format : AuctionValueConfiguration.DEFAULT_SHOP_PRICE_FORMAT;
            this.mode = mode != null ? mode : DEFAULT_SHOP_PRICE_MODE;
        }

        public boolean enabled() {
            return this.enabledState == EnabledState.ENABLED;
        }

        public boolean autoDetect() {
            return this.enabledState == EnabledState.AUTO;
        }

        public EnabledState enabledState() {
            return this.enabledState;
        }

        public String format() {
            return this.format;
        }

        public Mode mode() {
            return this.mode;
        }

        public static ShopPriceConfiguration defaults() {
            return new ShopPriceConfiguration(DEFAULT_SHOP_PRICE_STATE, AuctionValueConfiguration.DEFAULT_SHOP_PRICE_FORMAT, DEFAULT_SHOP_PRICE_MODE);
        }

        public static ShopPriceConfiguration from(ConfigurationSection section) {
            if (section == null) {
                return ShopPriceConfiguration.defaults();
            }
            EnabledState enabledState = DEFAULT_SHOP_PRICE_STATE;
            if (section.contains("enabled")) {
                enabledState = section.getBoolean("enabled") ? EnabledState.ENABLED : EnabledState.DISABLED;
            }
            String format = section.getString("format", AuctionValueConfiguration.DEFAULT_SHOP_PRICE_FORMAT);
            Mode mode = AuctionValueConfiguration.parseShopPriceMode(section.getString("mode"));
            return new ShopPriceConfiguration(enabledState, format, mode);
        }

        public String toString() {
            return "ShopPriceConfiguration{enabledState=" + String.valueOf((Object)this.enabledState) + ", format='" + this.format + "', mode=" + String.valueOf((Object)this.mode) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ShopPriceConfiguration)) {
                return false;
            }
            ShopPriceConfiguration that = (ShopPriceConfiguration)o;
            return this.enabledState == that.enabledState && Objects.equals(this.format, that.format) && this.mode == that.mode;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.enabledState, this.format, this.mode});
        }

        public static enum EnabledState {
            AUTO,
            ENABLED,
            DISABLED;

        }
    }
}

