/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.config;

import com.skyblockexp.ezauction.config.AuctionBackendMessages;
import com.skyblockexp.ezauction.config.AuctionCommandMessageConfiguration;
import com.skyblockexp.ezauction.config.AuctionConfiguration;
import com.skyblockexp.ezauction.config.AuctionHologramConfiguration;
import com.skyblockexp.ezauction.config.AuctionListingRules;
import com.skyblockexp.ezauction.config.AuctionMenuConfiguration;
import com.skyblockexp.ezauction.config.AuctionMenuInteractionConfiguration;
import com.skyblockexp.ezauction.config.AuctionMessageConfiguration;
import com.skyblockexp.ezauction.config.AuctionStorageConfiguration;
import com.skyblockexp.ezauction.config.AuctionValueConfiguration;
import com.skyblockexp.ezauction.config.LiveAuctionConfiguration;
import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public final class AuctionConfigurationLoader {
    private AuctionConfigurationLoader() {
    }

    public static AuctionConfiguration load(JavaPlugin plugin) {
        if (plugin == null) {
            return AuctionConfiguration.defaultConfiguration();
        }
        File dataFolder = plugin.getDataFolder();
        YamlConfiguration baseConfiguration = AuctionConfigurationLoader.loadConfiguration(dataFolder, "auction.yml");
        String languageCode = AuctionConfigurationLoader.normalizeLanguage(baseConfiguration != null ? baseConfiguration.getString("language") : null);
        YamlConfiguration storageConfigurationFile = AuctionConfigurationLoader.loadConfiguration(dataFolder, "auction-storage.yml");
        YamlConfiguration menuConfigurationFile = AuctionConfigurationLoader.loadLocalizedConfiguration(plugin, dataFolder, "messages/menu-layout", languageCode);
        YamlConfiguration menuInteractionConfigurationFile = AuctionConfigurationLoader.loadLocalizedConfiguration(plugin, dataFolder, "messages/menu-interactions", languageCode);
        YamlConfiguration valueConfigurationFile = AuctionConfigurationLoader.loadConfiguration(dataFolder, "auction-values.yml");
        YamlConfiguration messageConfigurationFile = AuctionConfigurationLoader.loadLocalizedConfiguration(plugin, dataFolder, "messages/gui-messages", languageCode);
        YamlConfiguration commandMessageConfigurationFile = AuctionConfigurationLoader.firstNonNull(AuctionConfigurationLoader.loadLocalizedConfiguration(plugin, dataFolder, "messages/messages", languageCode), AuctionConfigurationLoader.loadConfiguration(dataFolder, "messages.yml"));
        if (baseConfiguration == null && storageConfigurationFile == null && menuConfigurationFile == null && menuInteractionConfigurationFile == null && valueConfigurationFile == null && messageConfigurationFile == null && commandMessageConfigurationFile == null) {
            return AuctionConfiguration.defaultConfiguration();
        }
        ConfigurationSection listingsSection = AuctionConfigurationLoader.getSection(baseConfiguration, "listings");
        int baseLimit = Math.max(0, AuctionConfigurationLoader.getInt(baseConfiguration, "listings.max-listings-per-player", 0));
        AuctionListingRules listingRules = AuctionListingRules.from(listingsSection);
        List<Duration> durationOptions = AuctionConfigurationLoader.parseDurationOptions(listingsSection);
        ConfigurationSection storageSection = AuctionConfigurationLoader.firstNonNull(storageConfigurationFile, AuctionConfigurationLoader.getSection(baseConfiguration, "storage"));
        AuctionStorageConfiguration storageConfiguration = AuctionStorageConfiguration.from(storageSection);
        ConfigurationSection menuSection = AuctionConfigurationLoader.firstNonNull(menuConfigurationFile, AuctionConfigurationLoader.getSection(baseConfiguration, "menu"));
        AuctionMenuConfiguration menuConfiguration = AuctionMenuConfiguration.from(menuSection);
        ConfigurationSection menusSection = AuctionConfigurationLoader.firstNonNull(menuInteractionConfigurationFile, AuctionConfigurationLoader.getSection(baseConfiguration, "menus"));
        AuctionMenuInteractionConfiguration menuInteractionConfiguration = AuctionMenuInteractionConfiguration.from(menusSection);
        ConfigurationSection valuesSection = AuctionConfigurationLoader.firstNonNull(valueConfigurationFile, AuctionConfigurationLoader.getSection(baseConfiguration, "values"));
        AuctionValueConfiguration valueConfiguration = AuctionValueConfiguration.from(valuesSection);
        ConfigurationSection messageSection = AuctionConfigurationLoader.firstNonNull(messageConfigurationFile, AuctionConfigurationLoader.getSection(baseConfiguration, "gui-messages"));
        AuctionMessageConfiguration messageConfiguration = AuctionMessageConfiguration.from(messageSection);
        ConfigurationSection commandMessageSection = AuctionConfigurationLoader.firstNonNull(commandMessageConfigurationFile, AuctionConfigurationLoader.getSection(baseConfiguration, "messages"));
        AuctionCommandMessageConfiguration commandMessageConfiguration = AuctionCommandMessageConfiguration.from(commandMessageSection);
        ConfigurationSection backendMessageSection = commandMessageSection != null ? commandMessageSection.getConfigurationSection("backend") : null;
        AuctionBackendMessages backendMessages = AuctionBackendMessages.from(backendMessageSection);
        ConfigurationSection hologramSection = AuctionConfigurationLoader.getSection(baseConfiguration, "holograms");
        AuctionHologramConfiguration hologramConfiguration = AuctionHologramConfiguration.from(hologramSection);
        ConfigurationSection liveAuctionSection = AuctionConfigurationLoader.getSection(baseConfiguration, "live-auctions");
        LiveAuctionConfiguration liveAuctionConfiguration = LiveAuctionConfiguration.from(liveAuctionSection);
        AuctionConfiguration result = new AuctionConfiguration(baseLimit, storageConfiguration, listingRules, menuConfiguration, menuInteractionConfiguration, valueConfiguration, messageConfiguration, backendMessages, commandMessageConfiguration, hologramConfiguration, liveAuctionConfiguration, durationOptions, baseConfiguration != null && baseConfiguration.isBoolean("debug") ? baseConfiguration.getBoolean("debug") : false);
        plugin.getLogger().log(Level.CONFIG, "Loaded auction configuration: {0}", result);
        return result;
    }

    private static YamlConfiguration loadConfiguration(File dataFolder, String fileName) {
        if (dataFolder == null || fileName == null || fileName.isEmpty()) {
            return null;
        }
        File file = new File(dataFolder, fileName);
        if (!file.exists()) {
            return null;
        }
        return YamlConfiguration.loadConfiguration((File)file);
    }

    private static YamlConfiguration loadLocalizedConfiguration(JavaPlugin plugin, File dataFolder, String baseName, String languageCode) {
        if (baseName == null || baseName.isEmpty() || languageCode == null || languageCode.isEmpty()) {
            return null;
        }
        String fileName = baseName + "_" + languageCode + ".yml";
        YamlConfiguration localized = AuctionConfigurationLoader.loadConfiguration(dataFolder, fileName);
        if (localized != null) {
            return localized;
        }
        if (!"en".equals(languageCode)) {
            if (plugin != null) {
                plugin.getLogger().log(Level.WARNING, "Localized configuration \"{0}\" was not found; falling back to English.", fileName);
            }
            return AuctionConfigurationLoader.loadConfiguration(dataFolder, baseName + "_en.yml");
        }
        return null;
    }

    private static ConfigurationSection getSection(YamlConfiguration configuration, String path) {
        if (configuration == null || path == null || path.isEmpty()) {
            return null;
        }
        return configuration.getConfigurationSection(path);
    }

    private static <T> T firstNonNull(T primary, T fallback) {
        return primary != null ? primary : fallback;
    }

    private static int getInt(YamlConfiguration configuration, String path, int fallback) {
        if (configuration == null || path == null || path.isEmpty()) {
            return fallback;
        }
        return configuration.getInt(path, fallback);
    }

    private static String normalizeLanguage(String raw) {
        if (raw == null || raw.isBlank()) {
            return "en";
        }
        String normalized = raw.trim().toLowerCase(Locale.ROOT).replace('-', '_');
        String sanitized = normalized.replaceAll("[^a-z0-9_]", "");
        if (sanitized.isEmpty()) {
            return "en";
        }
        return sanitized;
    }

    private static List<Duration> parseDurationOptions(ConfigurationSection listingsSection) {
        if (listingsSection == null) {
            return List.of();
        }
        List rawValues = listingsSection.getList("duration-options");
        if (rawValues == null || rawValues.isEmpty()) {
            return List.of();
        }
        ArrayList<Duration> parsed = new ArrayList<Duration>();
        for (Object value : rawValues) {
            Duration duration = AuctionConfigurationLoader.parseDurationValue(value);
            if (duration == null) continue;
            parsed.add(duration);
        }
        if (parsed.isEmpty()) {
            return List.of();
        }
        return List.copyOf(parsed);
    }

    private static Duration parseDurationValue(Object value) {
        if (value instanceof Duration) {
            Duration duration = (Duration)value;
            if (!duration.isNegative() && !duration.isZero()) {
                return duration;
            }
            return null;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            double minutes = number.doubleValue();
            if (!Double.isFinite(minutes)) {
                return null;
            }
            long rounded = Math.round(minutes);
            if (rounded <= 0L) {
                return null;
            }
            try {
                return Duration.ofMinutes(rounded);
            }
            catch (ArithmeticException ex) {
                return null;
            }
        }
        if (value instanceof String) {
            String text = (String)value;
            String normalized = text.trim();
            if (normalized.isEmpty()) {
                return null;
            }
            return AuctionConfigurationLoader.parseDurationString(normalized);
        }
        return null;
    }

    private static Duration parseDurationString(String input) {
        double amount;
        String normalized = input.trim().toLowerCase(Locale.ENGLISH);
        if (normalized.isEmpty()) {
            return null;
        }
        double multiplier = 1.0;
        String numericPortion = normalized;
        if (normalized.endsWith("minutes")) {
            numericPortion = normalized.substring(0, normalized.length() - "minutes".length());
        } else if (normalized.endsWith("minute")) {
            numericPortion = normalized.substring(0, normalized.length() - "minute".length());
        } else if (normalized.endsWith("mins")) {
            numericPortion = normalized.substring(0, normalized.length() - "mins".length());
        } else if (normalized.endsWith("min")) {
            numericPortion = normalized.substring(0, normalized.length() - "min".length());
        } else if (normalized.endsWith("m")) {
            numericPortion = normalized.substring(0, normalized.length() - 1);
        } else if (normalized.endsWith("hours")) {
            multiplier = 60.0;
            numericPortion = normalized.substring(0, normalized.length() - "hours".length());
        } else if (normalized.endsWith("hour")) {
            multiplier = 60.0;
            numericPortion = normalized.substring(0, normalized.length() - "hour".length());
        } else if (normalized.endsWith("hrs")) {
            multiplier = 60.0;
            numericPortion = normalized.substring(0, normalized.length() - "hrs".length());
        } else if (normalized.endsWith("hr")) {
            multiplier = 60.0;
            numericPortion = normalized.substring(0, normalized.length() - "hr".length());
        } else if (normalized.endsWith("h")) {
            multiplier = 60.0;
            numericPortion = normalized.substring(0, normalized.length() - 1);
        }
        try {
            amount = Double.parseDouble(numericPortion.trim());
        }
        catch (NumberFormatException ex) {
            return null;
        }
        double minutes = amount * multiplier;
        if (!Double.isFinite(minutes) || minutes <= 0.0) {
            return null;
        }
        long rounded = Math.max(1L, Math.round(minutes));
        try {
            return Duration.ofMinutes(rounded);
        }
        catch (ArithmeticException ex) {
            return null;
        }
    }
}

