/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.compat;

import com.skyblockexp.ezauction.compat.HologramDisplay;
import com.skyblockexp.ezauction.compat.HologramPlatform;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.TextDisplay;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class TextDisplayHologramPlatform
implements HologramPlatform {
    private final JavaPlugin plugin;

    public TextDisplayHologramPlatform(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public HologramDisplay spawn(Location location) {
        if (location == null) {
            return null;
        }
        World world = location.getWorld();
        if (world == null) {
            return null;
        }
        TextDisplay display = (TextDisplay)world.spawn(location, TextDisplay.class);
        return new TextDisplayWrapper(display);
    }

    @Override
    public Collection<HologramDisplay> findDisplays(World world) {
        if (world == null) {
            return List.of();
        }
        return world.getEntitiesByClass(TextDisplay.class).stream().map(TextDisplayWrapper::new).map(HologramDisplay.class::cast).toList();
    }

    @Override
    public Collection<HologramDisplay> findNearby(Location location, double radius) {
        if (location == null) {
            return List.of();
        }
        World world = location.getWorld();
        if (world == null) {
            return List.of();
        }
        return world.getNearbyEntities(location, radius, radius, radius, entity -> entity instanceof TextDisplay).stream().map(entity -> (TextDisplay)entity).map(TextDisplayWrapper::new).map(HologramDisplay.class::cast).toList();
    }

    @Override
    public boolean isDisplayEntity(Entity entity) {
        return entity instanceof TextDisplay;
    }

    @Override
    public HologramDisplay wrap(Entity entity) {
        if (entity instanceof TextDisplay) {
            TextDisplay display = (TextDisplay)entity;
            return new TextDisplayWrapper(display);
        }
        return null;
    }

    @Override
    public void configureBase(HologramDisplay display) {
        if (!(display instanceof TextDisplayWrapper)) {
            return;
        }
        TextDisplayWrapper wrapper = (TextDisplayWrapper)display;
        TextDisplay handle = wrapper.handle();
        if (handle == null) {
            return;
        }
        handle.setBillboard(Display.Billboard.CENTER);
        handle.setPersistent(true);
        handle.setShadowed(false);
        handle.setSeeThrough(true);
        handle.setAlignment(TextDisplay.TextAlignment.CENTER);
        handle.setViewRange(48.0f);
        handle.setLineWidth(160);
        handle.setBackgroundColor(Color.fromARGB((int)0, (int)0, (int)0, (int)0));
    }

    @Override
    public void setMarker(HologramDisplay display, String key, String value) {
        TextDisplayWrapper wrapper;
        block5: {
            block4: {
                if (!(display instanceof TextDisplayWrapper)) break block4;
                wrapper = (TextDisplayWrapper)display;
                if (key != null && value != null) break block5;
            }
            return;
        }
        TextDisplay handle = wrapper.handle();
        if (handle == null) {
            return;
        }
        PersistentDataContainer container = handle.getPersistentDataContainer();
        container.set(new NamespacedKey((Plugin)this.plugin, key), PersistentDataType.STRING, (Object)value);
    }

    @Override
    public String getMarker(HologramDisplay display, String key) {
        TextDisplayWrapper wrapper;
        block5: {
            block4: {
                if (!(display instanceof TextDisplayWrapper)) break block4;
                wrapper = (TextDisplayWrapper)display;
                if (key != null) break block5;
            }
            return null;
        }
        TextDisplay handle = wrapper.handle();
        if (handle == null) {
            return null;
        }
        PersistentDataContainer container = handle.getPersistentDataContainer();
        return (String)container.get(new NamespacedKey((Plugin)this.plugin, key), PersistentDataType.STRING);
    }

    private static final class TextDisplayWrapper
    implements HologramDisplay {
        private final TextDisplay display;

        private TextDisplayWrapper(TextDisplay display) {
            this.display = display;
        }

        private TextDisplay handle() {
            return this.display;
        }

        @Override
        public UUID uniqueId() {
            return this.display.getUniqueId();
        }

        @Override
        public Location location() {
            return this.display.getLocation();
        }

        @Override
        public boolean isValid() {
            return this.display.isValid() && !this.display.isDead();
        }

        @Override
        public void remove() {
            this.display.remove();
        }

        @Override
        public void setText(Component text) {
            if (text == null) {
                return;
            }
            try {
                Method textMethod = this.display.getClass().getMethod("text", Component.class);
                textMethod.invoke((Object)this.display, text);
            }
            catch (NoSuchMethodException ex) {
                try {
                    Method setTextMethod = this.display.getClass().getMethod("setText", String.class);
                    String legacy = LegacyComponentSerializer.legacySection().serialize(text);
                    setTextMethod.invoke((Object)this.display, legacy);
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

