/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.command;

import com.skyblockexp.ezauction.AuctionListing;
import com.skyblockexp.ezauction.AuctionManager;
import com.skyblockexp.ezauction.AuctionOperationResult;
import com.skyblockexp.ezauction.AuctionOrder;
import com.skyblockexp.ezauction.config.AuctionCommandMessageConfiguration;
import com.skyblockexp.ezauction.config.AuctionListingRules;
import com.skyblockexp.ezauction.gui.AuctionMenu;
import com.skyblockexp.ezauction.gui.AuctionOrderMenu;
import com.skyblockexp.ezauction.gui.AuctionSellMenu;
import com.skyblockexp.ezauction.gui.LiveAuctionMenu;
import com.skyblockexp.ezauction.gui.SellMenuHolder;
import com.skyblockexp.ezauction.transaction.AuctionTransactionHistory;
import com.skyblockexp.ezauction.transaction.AuctionTransactionHistoryEntry;
import com.skyblockexp.ezauction.transaction.AuctionTransactionService;
import com.skyblockexp.ezauction.transaction.AuctionTransactionType;
import java.lang.reflect.Field;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AuctionCommand
implements CommandExecutor,
TabCompleter {
    private static final int HISTORY_DISPLAY_LIMIT = 10;
    private static final DateTimeFormatter HISTORY_DATE_FORMAT = DateTimeFormatter.ofPattern("MMM d, h:mm a").withLocale(Locale.ENGLISH);
    private final AuctionManager auctionManager;
    private final AuctionMenu auctionMenu;
    private final AuctionOrderMenu auctionOrderMenu;
    private final AuctionSellMenu auctionSellMenu;
    private final AuctionTransactionHistory transactionHistory;
    private final AuctionTransactionService transactionService;
    private final AuctionListingRules listingRules;
    private final LiveAuctionMenu liveAuctionMenu;
    private final AuctionCommandMessageConfiguration messages;
    private static final int SEARCH_PAGE_SIZE = 10;

    public AuctionCommand(AuctionManager auctionManager, AuctionMenu auctionMenu, AuctionSellMenu auctionSellMenu, AuctionOrderMenu auctionOrderMenu, AuctionTransactionHistory transactionHistory, AuctionTransactionService transactionService, AuctionListingRules listingRules, LiveAuctionMenu liveAuctionMenu, AuctionCommandMessageConfiguration messages) {
        this.auctionManager = Objects.requireNonNull(auctionManager, "auctionManager");
        this.auctionMenu = Objects.requireNonNull(auctionMenu, "auctionMenu");
        this.auctionSellMenu = Objects.requireNonNull(auctionSellMenu, "auctionSellMenu");
        this.auctionOrderMenu = Objects.requireNonNull(auctionOrderMenu, "auctionOrderMenu");
        this.transactionHistory = Objects.requireNonNull(transactionHistory, "transactionHistory");
        this.transactionService = Objects.requireNonNull(transactionService, "transactionService");
        this.listingRules = Objects.requireNonNull(listingRules, "listingRules");
        this.liveAuctionMenu = Objects.requireNonNull(liveAuctionMenu, "liveAuctionMenu");
        this.messages = messages != null ? messages : AuctionCommandMessageConfiguration.defaults();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            this.sendMessage(sender, this.messages.general().consoleOnly());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("ezauction.auction")) {
            this.sendMessage((CommandSender)player, this.messages.general().auctionNoPermission());
            return true;
        }
        if (args.length == 0 || args.length == 1 && args[0].trim().isEmpty()) {
            this.auctionMenu.openBrowser(player);
            return true;
        }
        String subcommand = args[0].toLowerCase(Locale.ENGLISH);
        if (subcommand.equals("sell")) {
            this.handleSell(player, label, args);
            return true;
        }
        if (subcommand.equals("live")) {
            this.handleLive(player);
            return true;
        }
        if (subcommand.equals("order")) {
            this.handleOrder(player, label, args);
            return true;
        }
        if (subcommand.equals("cancel")) {
            this.handleCancel(player, args);
            return true;
        }
        if (subcommand.equals("history")) {
            this.handleHistory(player, args);
            return true;
        }
        if (subcommand.equals("claim")) {
            this.handleClaim(player);
            return true;
        }
        if (subcommand.equals("search")) {
            this.handleSearch(player, args);
            return true;
        }
        this.sendUsage(player, label);
        return true;
    }

    private void handleSearch(Player player, String[] args) {
        if (!player.hasPermission("ezauction.auction.search")) {
            this.sendMessage((CommandSender)player, String.valueOf(ChatColor.RED) + "You do not have permission to search auctions.");
            return;
        }
        if (args.length < 2) {
            this.sendMessage((CommandSender)player, String.valueOf(ChatColor.YELLOW) + "Usage: /auction search <query>");
            return;
        }
        String query = args[1];
        UUID playerId = player.getUniqueId();
        String sanitized = ChatColor.stripColor((String)query).trim();
        if (!sanitized.isEmpty()) {
            try {
                Field field = this.auctionMenu.getClass().getDeclaredField("activeSearchQueries");
                field.setAccessible(true);
                ConcurrentMap map = (ConcurrentMap)field.get(this.auctionMenu);
                map.put(playerId, sanitized);
            }
            catch (Exception e) {
                this.auctionMenu.openBrowser(player);
                return;
            }
        }
        this.auctionMenu.openBrowser(player);
    }

    private void handleSell(Player player, String label, String[] args) {
        AuctionOperationResult result;
        double price;
        if (!player.hasPermission("ezauction.auction.sell")) {
            this.sendMessage((CommandSender)player, this.messages.sell().noPermission());
            return;
        }
        if (args.length < 2) {
            ItemStack itemInHand = player.getInventory().getItemInMainHand();
            if (itemInHand == null || itemInHand.getType() == Material.AIR) {
                this.sendMessage((CommandSender)player, this.messages.sell().itemRequired());
                return;
            }
            this.auctionSellMenu.openSellMenu(player, SellMenuHolder.Target.NORMAL);
            return;
        }
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (itemInHand == null || itemInHand.getType() == Material.AIR) {
            this.sendMessage((CommandSender)player, this.messages.sell().itemRequired());
            return;
        }
        try {
            price = Double.parseDouble(args[1]);
        }
        catch (NumberFormatException ex) {
            this.sendMessage((CommandSender)player, this.messages.sell().invalidPrice().replace("{price}", args[1]));
            return;
        }
        if (price <= 0.0) {
            this.sendMessage((CommandSender)player, this.messages.sell().pricePositive());
            return;
        }
        double minimumPrice = this.listingRules.minimumPrice();
        if (price < minimumPrice) {
            String formattedMinimum = this.transactionService.formatCurrency(minimumPrice);
            this.sendMessage((CommandSender)player, this.messages.sell().priceMinimum().replace("{minimum}", formattedMinimum));
            return;
        }
        Duration duration = this.listingRules.defaultDuration();
        if (args.length >= 3 && !args[2].isEmpty()) {
            Duration parsed = this.parseDuration(args[2]);
            if (parsed == null) {
                this.sendMessage((CommandSender)player, this.messages.general().invalidDuration());
                return;
            }
            duration = this.listingRules.clampDuration(parsed);
        }
        if ((result = this.auctionManager.createListing(player, itemInHand, price, duration)).message() != null && !result.message().isEmpty()) {
            player.sendMessage(result.message());
        }
    }

    private void handleLive(Player player) {
        if (!player.hasPermission("ezauction.auction.live")) {
            this.sendMessage((CommandSender)player, this.messages.live().noPermission());
            return;
        }
        if (!this.auctionManager.liveAuctionsEnabled()) {
            this.sendMessage((CommandSender)player, this.messages.live().disabled());
            return;
        }
        this.liveAuctionMenu.open(player);
    }

    private void sendUsage(Player player, String label) {
        this.sendMessage((CommandSender)player, this.messages.usage().base().replace("{label}", label));
        this.sendMessage((CommandSender)player, this.messages.usage().live().replace("{label}", label));
        this.sendMessage((CommandSender)player, this.messages.usage().sell().replace("{label}", label));
        this.sendMessage((CommandSender)player, this.messages.usage().order().replace("{label}", label));
        this.sendMessage((CommandSender)player, this.messages.usage().cancel().replace("{label}", label));
        this.sendMessage((CommandSender)player, this.messages.usage().history().replace("{label}", label));
        this.sendMessage((CommandSender)player, this.messages.usage().claim().replace("{label}", label));
        this.sendMessage((CommandSender)player, this.messages.usage().search().replace("{label}", label));
    }

    private void handleClaim(Player player) {
        AuctionOperationResult result = this.auctionManager.claimReturnItems(player);
        if (result.message() != null && !result.message().isEmpty()) {
            player.sendMessage(result.message());
        }
    }

    private void handleCancel(Player player, String[] args) {
        AuctionOperationResult response;
        UUID sellerId = player.getUniqueId();
        ArrayList<AuctionListing> ownListings = new ArrayList<AuctionListing>();
        for (AuctionListing auctionListing : this.auctionManager.listActiveListings()) {
            if (!sellerId.equals(auctionListing.sellerId())) continue;
            ownListings.add(auctionListing);
        }
        ArrayList<AuctionOrder> ownOrders = new ArrayList<AuctionOrder>();
        for (AuctionOrder auctionOrder : this.auctionManager.listActiveOrders()) {
            if (!sellerId.equals(auctionOrder.buyerId())) continue;
            ownOrders.add(auctionOrder);
        }
        if (args.length < 2 || args[1].trim().isEmpty()) {
            String message;
            String expiryText;
            if (ownListings.isEmpty() && ownOrders.isEmpty()) {
                this.sendMessage((CommandSender)player, this.messages.cancel().nothingToCancel());
                return;
            }
            if (!ownListings.isEmpty()) {
                this.sendMessage((CommandSender)player, this.messages.cancel().listingsHeader());
                for (AuctionListing auctionListing : ownListings) {
                    String string = this.transactionService.formatCurrency(auctionListing.price());
                    expiryText = HISTORY_DATE_FORMAT.format(Instant.ofEpochMilli(auctionListing.expiryEpochMillis()).atZone(ZoneId.systemDefault()));
                    message = this.messages.cancel().listingEntry().replace("{id}", auctionListing.id()).replace("{item}", this.describeItem(auctionListing.item())).replace("{price}", string).replace("{expiry}", expiryText);
                    this.sendMessage((CommandSender)player, message);
                }
            }
            if (!ownOrders.isEmpty()) {
                this.sendMessage((CommandSender)player, this.messages.cancel().ordersHeader());
                for (AuctionOrder auctionOrder : ownOrders) {
                    String string = this.transactionService.formatCurrency(auctionOrder.offeredPrice());
                    expiryText = HISTORY_DATE_FORMAT.format(Instant.ofEpochMilli(auctionOrder.expiryEpochMillis()).atZone(ZoneId.systemDefault()));
                    message = this.messages.cancel().orderEntry().replace("{id}", auctionOrder.id()).replace("{item}", this.describeItem(auctionOrder.requestedItem())).replace("{price}", string).replace("{expiry}", expiryText);
                    this.sendMessage((CommandSender)player, message);
                }
            }
            this.sendMessage((CommandSender)player, this.messages.cancel().cancelHint());
            return;
        }
        String string = args[1];
        for (AuctionListing auctionListing : ownListings) {
            if (!auctionListing.id().equals(string)) continue;
            AuctionOperationResult result = this.auctionManager.cancelListing(sellerId, string);
            if (result.message() != null && !result.message().isEmpty()) {
                player.sendMessage(result.message());
            }
            return;
        }
        for (AuctionOrder auctionOrder : ownOrders) {
            if (!auctionOrder.id().equals(string)) continue;
            AuctionOperationResult result = this.auctionManager.cancelOrder(sellerId, string);
            if (result.message() != null && !result.message().isEmpty()) {
                player.sendMessage(result.message());
            }
            return;
        }
        AuctionOperationResult auctionOperationResult = this.auctionManager.cancelListing(sellerId, string);
        if (auctionOperationResult.success()) {
            if (auctionOperationResult.message() != null && !auctionOperationResult.message().isEmpty()) {
                player.sendMessage(auctionOperationResult.message());
            }
            return;
        }
        AuctionOperationResult auctionOperationResult2 = this.auctionManager.cancelOrder(sellerId, string);
        AuctionOperationResult auctionOperationResult3 = response = auctionOperationResult2.message() != null && !auctionOperationResult2.message().isEmpty() ? auctionOperationResult2 : auctionOperationResult;
        if (response.message() != null && !response.message().isEmpty()) {
            player.sendMessage(response.message());
        }
    }

    private void handleOrder(Player player, String label, String[] args) {
        int amount;
        double pricePerItem;
        if (!player.hasPermission("ezauction.auction.order")) {
            this.sendMessage((CommandSender)player, this.messages.order().noPermission());
            return;
        }
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (itemInHand == null || itemInHand.getType() == Material.AIR) {
            this.sendMessage((CommandSender)player, this.messages.order().itemRequired());
            return;
        }
        if (args.length < 3) {
            this.auctionOrderMenu.openOrderMenu(player);
            return;
        }
        try {
            pricePerItem = Double.parseDouble(args[1]);
        }
        catch (NumberFormatException ex) {
            this.sendMessage((CommandSender)player, this.messages.order().invalidPrice().replace("{price}", args[1]));
            return;
        }
        if (pricePerItem <= 0.0) {
            this.sendMessage((CommandSender)player, this.messages.order().pricePositive());
            return;
        }
        double minimumPrice = this.listingRules.minimumPrice();
        if (pricePerItem < minimumPrice) {
            String formattedMinimum = this.transactionService.formatCurrency(minimumPrice);
            this.sendMessage((CommandSender)player, this.messages.order().priceMinimum().replace("{minimum}", formattedMinimum));
            return;
        }
        try {
            amount = Integer.parseInt(args[2]);
        }
        catch (NumberFormatException ex) {
            this.sendMessage((CommandSender)player, this.messages.order().invalidAmount().replace("{amount}", args[2]));
            return;
        }
        if (amount <= 0) {
            this.sendMessage((CommandSender)player, this.messages.order().amountMinimum());
            return;
        }
        int maxStack = Math.max(1, itemInHand.getMaxStackSize());
        if (amount > maxStack) {
            this.sendMessage((CommandSender)player, this.messages.order().amountMaxStack().replace("{max}", String.valueOf(maxStack)));
            return;
        }
        Duration duration = this.listingRules.defaultDuration();
        if (args.length >= 4 && !args[3].isEmpty()) {
            Duration parsed = this.parseDuration(args[3]);
            if (parsed == null) {
                this.sendMessage((CommandSender)player, this.messages.general().invalidDuration());
                return;
            }
            duration = this.listingRules.clampDuration(parsed);
        }
        ItemStack template = itemInHand.clone();
        template.setAmount(amount);
        double total = pricePerItem * (double)amount;
        AuctionOperationResult result = this.auctionManager.createOrder(player, template, total, duration, total);
        if (result.message() != null && !result.message().isEmpty()) {
            player.sendMessage(result.message());
        }
    }

    private void handleHistory(Player player, String[] args) {
        if (!player.hasPermission("ezauction.auction.history") && !player.hasPermission("ezauction.auction")) {
            this.sendMessage((CommandSender)player, this.messages.history().noPermission());
            return;
        }
        AuctionTransactionType filter = null;
        if (args.length >= 2) {
            String filterArg = args[1].toLowerCase(Locale.ENGLISH);
            if (filterArg.equals("buy") || filterArg.equals("purchases")) {
                filter = AuctionTransactionType.BUY;
            } else if (filterArg.equals("sell") || filterArg.equals("sales")) {
                filter = AuctionTransactionType.SELL;
            } else {
                this.sendMessage((CommandSender)player, this.messages.history().unknownFilter());
                return;
            }
        }
        ArrayList<AuctionTransactionHistoryEntry> entries = new ArrayList<AuctionTransactionHistoryEntry>(this.transactionHistory.getHistory(player.getUniqueId()));
        if (filter != null) {
            AuctionTransactionType filterType = filter;
            entries.removeIf(entry -> entry.type() != filterType);
        }
        if (entries.isEmpty()) {
            if (filter == AuctionTransactionType.BUY) {
                this.sendMessage((CommandSender)player, this.messages.history().noPurchases());
            } else if (filter == AuctionTransactionType.SELL) {
                this.sendMessage((CommandSender)player, this.messages.history().noSales());
            } else {
                this.sendMessage((CommandSender)player, this.messages.history().noHistory());
            }
            return;
        }
        String heading = filter == AuctionTransactionType.BUY ? this.messages.history().headingPurchases() : (filter == AuctionTransactionType.SELL ? this.messages.history().headingSales() : this.messages.history().headingActivity());
        this.sendMessage((CommandSender)player, "&6" + heading + "&7:");
        int count = 0;
        for (AuctionTransactionHistoryEntry entry2 : entries) {
            if (count++ >= 10) break;
            String actionVerb = entry2.type() == AuctionTransactionType.BUY ? this.messages.history().actionBought() : this.messages.history().actionSold();
            String counterpartLabel = entry2.type() == AuctionTransactionType.BUY ? this.messages.history().counterpartFrom() : this.messages.history().counterpartTo();
            String counterpartName = this.resolveCounterpartName(entry2);
            String priceText = this.transactionService.formatCurrency(entry2.price());
            String dateText = HISTORY_DATE_FORMAT.format(Instant.ofEpochMilli(entry2.timestamp()).atZone(ZoneId.systemDefault()));
            String itemDescription = this.describeItem(entry2.item());
            String message = this.messages.history().entry().replace("{action}", actionVerb).replace("{item}", itemDescription).replace("{counterpart-preposition}", counterpartLabel).replace("{counterpart}", counterpartName).replace("{price}", priceText).replace("{date}", dateText);
            this.sendMessage((CommandSender)player, message);
        }
        if (entries.size() > 10) {
            String truncated = this.messages.history().truncated().replace("{displayed}", String.valueOf(10)).replace("{total}", String.valueOf(entries.size()));
            this.sendMessage((CommandSender)player, truncated);
        }
    }

    private String resolveCounterpartName(AuctionTransactionHistoryEntry entry) {
        if (entry.counterpartName() != null && !entry.counterpartName().isEmpty()) {
            return entry.counterpartName();
        }
        if (entry.counterpartId() != null) {
            return entry.counterpartId().toString();
        }
        return this.messages.general().unknownCounterpart();
    }

    private String describeItem(ItemStack item) {
        String name;
        if (item == null) {
            return this.messages.general().unknownItem();
        }
        int amount = Math.max(1, item.getAmount());
        ItemMeta meta = item.getItemMeta();
        if (meta != null && meta.hasDisplayName()) {
            String displayName = meta.getDisplayName();
            String stripped = displayName != null ? ChatColor.stripColor((String)displayName) : "";
            name = stripped != null && !stripped.isEmpty() ? stripped : displayName;
        } else {
            name = this.friendlyMaterialName(item.getType());
        }
        return amount + "x " + name;
    }

    private String friendlyMaterialName(Material material) {
        if (material == null) {
            return this.messages.general().unknownMaterial();
        }
        String lowercase = material.name().toLowerCase(Locale.ENGLISH).replace('_', ' ');
        if (lowercase.isEmpty()) {
            return this.messages.general().unknownMaterial();
        }
        return Character.toUpperCase(lowercase.charAt(0)) + lowercase.substring(1);
    }

    private void sendMessage(CommandSender sender, String message) {
        if (sender == null || message == null || message.isEmpty()) {
            return;
        }
        sender.sendMessage(this.colorize(message));
    }

    private String colorize(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    private Duration parseDuration(String input) {
        double value;
        String trimmed = input.toLowerCase(Locale.ENGLISH).trim();
        if (trimmed.isEmpty()) {
            return null;
        }
        long unitSeconds = 3600L;
        char last = trimmed.charAt(trimmed.length() - 1);
        String numericPortion = trimmed;
        switch (last) {
            case 'd': {
                unitSeconds = 86400L;
                numericPortion = trimmed.substring(0, trimmed.length() - 1);
                break;
            }
            case 'h': {
                unitSeconds = 3600L;
                numericPortion = trimmed.substring(0, trimmed.length() - 1);
                break;
            }
            case 'm': {
                unitSeconds = 60L;
                numericPortion = trimmed.substring(0, trimmed.length() - 1);
                break;
            }
            case 's': {
                unitSeconds = 1L;
                numericPortion = trimmed.substring(0, trimmed.length() - 1);
                break;
            }
            default: {
                unitSeconds = 3600L;
            }
        }
        if (numericPortion.isEmpty()) {
            return null;
        }
        try {
            value = Double.parseDouble(numericPortion);
        }
        catch (NumberFormatException ex) {
            return null;
        }
        if (value <= 0.0) {
            return null;
        }
        long seconds = Math.round(value * (double)unitSeconds);
        if (seconds <= 0L) {
            return null;
        }
        try {
            return Duration.ofSeconds(seconds);
        }
        catch (ArithmeticException ex) {
            return null;
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            return this.filter(args[0], List.of("sell", "order", "cancel", "history", "claim", "live"));
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("sell")) {
            return this.filter(args[1], List.of("1000", "2500", "5000", "10000"));
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("order")) {
            return this.filter(args[1], List.of("100", "250", "500", "1000"));
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("order")) {
            return this.filter(args[2], List.of("1", "16", "32", "64"));
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("cancel") && sender instanceof Player) {
            Player player = (Player)sender;
            UUID sellerId = player.getUniqueId();
            ArrayList<String> ids = new ArrayList<String>();
            for (AuctionListing listing : this.auctionManager.listActiveListings()) {
                if (!sellerId.equals(listing.sellerId())) continue;
                ids.add(listing.id());
            }
            for (AuctionOrder order : this.auctionManager.listActiveOrders()) {
                if (!sellerId.equals(order.buyerId())) continue;
                ids.add(order.id());
            }
            return this.filter(args[1], ids);
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("sell")) {
            return this.filter(args[2], List.of("30m", "1h", "6h", "12h", "24h", "2d"));
        }
        if (args.length == 4 && args[0].equalsIgnoreCase("order")) {
            return this.filter(args[3], List.of("30m", "1h", "6h", "12h", "24h", "2d"));
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("history")) {
            return this.filter(args[1], List.of("buy", "sell"));
        }
        return Collections.emptyList();
    }

    private List<String> filter(String current, List<String> completions) {
        if (current == null || current.isEmpty()) {
            return completions;
        }
        String lowerCurrent = current.toLowerCase(Locale.ENGLISH);
        ArrayList<String> matches = new ArrayList<String>();
        for (String completion : completions) {
            if (!completion.toLowerCase(Locale.ENGLISH).startsWith(lowerCurrent)) continue;
            matches.add(completion);
        }
        return matches;
    }
}

